/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventoryDas;
import com.yunxi.dg.base.center.inventory.dao.vo.InventoryWarehouseVo;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicInventoryDomainImpl
extends BaseDomainImpl<LogicInventoryEo>
implements ILogicInventoryDomain {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryDomainImpl.class);
    @Autowired
    ILogicInventoryDas das;

    public ICommonDas<LogicInventoryEo> commonDas() {
        return this.das;
    }

    @Override
    public List<LogicInventoryEo> queryByWarehouseCodesAndSkuCodesAndBatches(List<String> warehouseCodes, List<String> skuCodes, List<String> batches) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseCode, warehouseCodes)).in(CollectionUtil.isNotEmpty(skuCodes), LogicInventoryEo::getSkuCode, skuCodes)).in(CollectionUtil.isNotEmpty(batches), LogicInventoryEo::getBatch, batches)).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).orderByAsc(LogicInventoryEo::getBatch));
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        try {
            voList = voList.stream().sorted(Comparator.comparing(CalcUpdateInventoryDto::getInventoryId)).collect(Collectors.toList());
            this.das.updateInventory(voList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic updateInventory exception...");
            throw new WarehouseAbleException("logic updateInventory exception...", new Object[0]);
        }
    }

    @Override
    public int batchIgnoreInsert(List<LogicInventoryEo> eoList) {
        return this.das.batchIgnoreInsert(eoList);
    }

    @Override
    public List<InventoryWarehouseVo> queryQualifiedCargoInventory(InventoryWarehouseVo vo) {
        return this.das.queryQualifiedCargoInventory(vo);
    }

    @Override
    public void updateWarehouseNameByWarehouseCode(String warehouseCode, String warehouseName) {
        AssertUtils.notBlank((String)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)warehouseName, (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.das.updateWarehouseNameByWarehouseCode(warehouseCode, warehouseName);
    }
}

