/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventoryTotalDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.LogicSupplyInventoryVo;
import com.yunxi.dg.base.center.inventory.dto.response.InventoryStatisticNumVo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicInventoryTotalDomainImpl
extends BaseDomainImpl<LogicInventoryTotalEo>
implements ILogicInventoryTotalDomain {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryTotalDomainImpl.class);
    @Autowired
    ILogicInventoryTotalDas das;

    public ICommonDas<LogicInventoryTotalEo> commonDas() {
        return this.das;
    }

    @Override
    public List<LogicInventoryTotalEo> queryByWarehouseCodesAndSkuCodes(List<String> warehouseCodes, List<String> skuCodes) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryTotalEo.class).in(LogicInventoryTotalEo::getWarehouseCode, warehouseCodes)).in(CollectionUtil.isNotEmpty(skuCodes), LogicInventoryTotalEo::getSkuCode, skuCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        log.info("updateInventory-voList:{}", (Object)JSON.toJSONString(voList));
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        try {
            this.das.updateInventory(voList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic total updateInventory exception:{}", (Object)JSON.toJSONString((Object)e));
            throw new WarehouseAbleException("logic total updateInventory exception...", new Object[0]);
        }
    }

    @Override
    public int batchIgnoreInsert(List<LogicInventoryTotalEo> eoList) {
        return this.das.batchIgnoreInsert(eoList);
    }

    @Override
    public List<InventoryStatisticNumVo> queryLogicInventoryTotalBalance() {
        return this.das.queryLogicInventoryTotalBalance();
    }

    @Override
    public List<InventoryStatisticNumVo> queryInventoryTotalPreempt() {
        return this.das.queryInventoryTotalPreempt();
    }

    @Override
    public List<LogicSupplyInventoryVo> queryLogicSupplyInventory(List<String> warehouseCodes, List<String> cargoCodes) {
        return this.das.queryLogicSupplyInventory(warehouseCodes, cargoCodes);
    }

    @Override
    public void updateWarehouseNameByWarehouseCode(String warehouseCode, String warehouseName) {
        AssertUtils.notBlank((String)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)warehouseName, (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.das.updateWarehouseNameByWarehouseCode(warehouseCode, warehouseName);
    }
}

