/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.utils;

import java.util.HashMap;
import java.util.Map;

public class ThreadLocalContext {
    public static final String REQ_CLIENT_IP = "REQ_CIP";
    public static final String REQ_PATH_INFO = "REQ_PATH_INFO";
    private static final ThreadLocal<Map<String, Object>> publicLocal = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static final ThreadLocal<Map<String, Object>> privateLocal = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    private ThreadLocalContext() {
    }

    public static void setGlobalValue(String key, Object value) {
        if (null != value) {
            publicLocal.get().put(key, value);
        } else {
            publicLocal.get().remove(key);
        }
    }

    public static <T> T getGlobalValue(String key) {
        return ThreadLocalContext.getGlobalValue(key, null);
    }

    public static <T> T getGlobalValue(String key, T def) {
        Object v = publicLocal.get().get(key);
        return (T)(null == v ? def : v);
    }

    public static void clearThreadValue() {
        privateLocal.get().clear();
        privateLocal.remove();
    }

    public static void putThreadValue(String key, Object value) {
        if (null != value) {
            privateLocal.get().put(key, value);
        } else {
            privateLocal.get().remove(key);
        }
    }

    public static <T> T getThreadValue(String key) {
        return ThreadLocalContext.getThreadValue(key, null);
    }

    public static <T> T getThreadValue(String key, T def) {
        Object v = privateLocal.get().get(key);
        return (T)(null == v ? def : v);
    }
}

