/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.rest.baseorder;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.api.baseorder.IInOutResultOrderApi;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.baseorder.DeliveredOutResultInfoRespDto;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutResultOrderService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u5e93\u5b58\u4e2d\u5fc3:\u8868\u670d\u52a1:\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u8868"})
public class InOutResultOrderController
implements IInOutResultOrderApi {
    @Resource
    private IInOutResultOrderService service;
    @Autowired
    ILockService lockService;

    @PostMapping(path={"/v1/inOutResultOrder/update"})
    @ApiOperation(value="\u4fee\u6539\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e", notes="\u4fee\u6539\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e")
    public RestResponse<Integer> update(@RequestBody InOutResultOrderDto dto) {
        return this.service.update((BaseDto)dto);
    }

    @PostMapping(path={"/v1/inOutResultOrder/insert"})
    @ApiOperation(value="\u65b0\u589e\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e", notes="\u65b0\u589e\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e")
    public RestResponse<Long> insert(@RequestBody InOutResultOrderDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    @PostMapping(path={"/v1/inOutResultOrder/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e", notes="\u5206\u9875\u67e5\u8be2\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e")
    public RestResponse<PageInfo<InOutResultOrderDto>> page(@RequestBody InOutResultOrderPageReqDto dto) {
        return this.service.page((BasePageDto)dto);
    }

    @PostMapping(path={"/v1/inOutResultOrder/logicDelete/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e", notes="\u903b\u8f91\u5220\u9664\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e")
    public RestResponse<Void> logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    @PostMapping(path={"/v1/inOutResultOrder/get/{id}"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e", notes="\u6839\u636eid\u83b7\u53d6\u51fa\u5165\u8d27\u7ed3\u679c\u5355\u6570\u636e")
    public RestResponse<InOutResultOrderDto> get(@PathVariable(name="id", required=true) Long id) {
        return this.service.get(id);
    }

    @PostMapping(value={"/v1/inOutNoticeOrder/unhook"})
    @ApiOperation(value="\u89e3\u6302", notes="\u89e3\u6302")
    public RestResponse<Void> unhook(@RequestBody List<String> documentNos) {
        documentNos.forEach(arg_0 -> ((IInOutResultOrderService)this.service).unhook(arg_0));
        return RestResponse.VOID;
    }

    @PostMapping(value={"/v1/inOutResultOrder/confirm/{documentNo}"})
    @ApiOperation(value="\u786e\u8ba4\u51fa\u5e93", notes="\u786e\u8ba4\u51fa\u5e93")
    public RestResponse<Void> confirm(@PathVariable(value="documentNo") String documentNo) {
        Mutex mutex = this.lockService.lock("inOutResultOrder_confirm", documentNo, 20, 25, TimeUnit.SECONDS);
        try {
            this.service.confirm(documentNo);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.VOID;
    }

    @GetMapping(value={"/v1/inOutNoticeOrder/{preOrderNo}/queryDeliveredInfo"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2\u5df2\u53d1\u8d27\u8d27\u54c1\u6570\u91cf\u4fe1\u606f", notes="\u6839\u636e\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2\u5df2\u53d1\u8d27\u8d27\u54c1\u6570\u91cf\u4fe1\u606f")
    public RestResponse<DeliveredOutResultInfoRespDto> queryDeliveredInfo(@PathVariable(value="preOrderNo") String preOrderNo) {
        return new RestResponse((Object)this.service.queryDeliveredInfo(preOrderNo));
    }
}

