/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.rest.transfer.order;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.BatchModificationQuantityDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderAggDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderAuditReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderItemPageDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderLabelValueRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderPageDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderTypeListRespDto;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderAggService;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderService;
import com.yunxi.dg.base.center.message.TransferGoodsOrderDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u5e93\u5b58\u4e2d\u5fc3:\u8868\u670d\u52a1:\u8c03\u62e8\u5355"})
@Validated
@RequestMapping(value={"/v1/transfer/order"})
public class TransferOrderController {
    @Resource
    private ITransferOrderService service;
    @Resource
    private ITransferOrderAggService aggService;

    @PostMapping(path={"/type"})
    @ApiOperation(value="\u4e1a\u52a1\u7c7b\u578b", notes="\u4e1a\u52a1\u7c7b\u578b")
    public RestResponse<List<TransferOrderTypeListRespDto>> queryTypeList() {
        return this.service.queryTypeList();
    }

    @PostMapping(path={"/status"})
    @ApiOperation(value="\u5355\u636e\u72b6\u6001", notes="\u5355\u636e\u72b6\u6001")
    public RestResponse<List<TransferOrderLabelValueRespDto>> queryStatusList() {
        return this.service.queryStatusList();
    }

    @PostMapping(path={"/add"})
    @ApiOperation(value="\u65b0\u589e", notes="\u65b0\u589e")
    public RestResponse<Long> add(@RequestBody TransferOrderComboReqDto dto) {
        return this.service.add(dto);
    }

    @PostMapping(path={"/batchAdd"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e", notes="\u6279\u91cf\u65b0\u589e")
    public RestResponse<Void> batchAdd(@RequestBody List<TransferOrderComboReqDto> dtos) {
        this.service.batchAdd(dtos);
        return RestResponse.VOID;
    }

    @PostMapping(path={"/detail"})
    @ApiOperation(value="\u8be6\u60c5", notes="\u8be6\u60c5")
    public RestResponse<TransferOrderRespDto> detail(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.detail(keyDto);
    }

    @GetMapping(path={"/queryByTransferOrderNo/{transferOrderNo}"})
    @ApiOperation(value="\u8be6\u60c5", notes="\u8be6\u60c5")
    public RestResponse<TransferOrderRespDto> queryByTransferOrderNo(@PathVariable(name="transferOrderNo", required=true) String transferOrderNo) {
        return this.service.queryByTransferOrderNo(transferOrderNo);
    }

    @DeleteMapping(path={"/delete"})
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664 - \u4e1a\u52a1\u4e0d\u53ef\u7528\uff0c\u4ec5\u6d4b\u8bd5")
    public RestResponse<Void> logicDelete(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.testDelete(keyDto);
    }

    @PostMapping(path={"/edit"})
    @ApiOperation(value="\u66f4\u65b0\u3001\u7f16\u8f91", notes="\u66f4\u65b0\u3001\u7f16\u8f91")
    public RestResponse<Boolean> edit(@RequestBody TransferOrderComboReqDto dto) {
        return this.service.edit(dto);
    }

    @PostMapping(path={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2 - \u6309\u5355\u636e\u5c55\u793a", notes="\u5206\u9875\u67e5\u8be2 - \u6309\u5355\u636e\u5c55\u793a")
    public RestResponse<PageInfo<TransferOrderPageDto>> page(@RequestBody TransferOrderSearchDto dto) {
        return this.service.queryPage(dto);
    }

    @PostMapping(path={"/queryTransferOrderList"})
    @ApiOperation(value="\u67e5\u8be2\u8c03\u62e8\u5355\u5217\u8868", notes="\u67e5\u8be2\u8c03\u62e8\u5355\u5217\u8868")
    public RestResponse<List<TransferOrderPageDto>> queryTransferOrderList(@RequestBody TransferOrderSearchDto dto) {
        return this.service.queryTransferOrderList(dto);
    }

    @PostMapping(path={"/page-by-item"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2 - \u6309\u5546\u54c1\u660e\u7ec6\u5c55\u793a", notes="\u5206\u9875\u67e5\u8be2 - \u6309\u5546\u54c1\u660e\u7ec6\u5c55\u793a")
    public RestResponse<PageInfo<TransferOrderItemPageDto>> pageItem(@RequestBody TransferOrderSearchDto dto) {
        return this.service.pageByItem(dto);
    }

    @PostMapping(path={"/commit"})
    @ApiOperation(value="\u63d0\u4ea4", notes="\u5c06\u4e00\u4e2a\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u62e8\u5355\u63d0\u4ea4")
    public RestResponse<Boolean> commit(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.commit(keyDto);
    }

    @PostMapping(path={"/withdraw"})
    @ApiOperation(value="\u64a4\u56de", notes="\u64a4\u56de")
    public RestResponse<Boolean> withdraw(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.withdraw(keyDto);
    }

    @PostMapping(path={"/batchWithdraw"})
    @ApiOperation(value="\u8c03\u62e8\u5355\u6279\u91cf\u64a4\u56de", notes="\u8c03\u62e8\u5355\u6279\u91cf\u64a4\u56de")
    RestResponse<BatchOrderOperationMsgDto> batchWithdraw(@RequestBody List<TransferOrderKeyDto> keyDtoList) {
        return this.service.batchWithdraw(keyDtoList);
    }

    @PostMapping(path={"/audit"})
    @ApiOperation(value="\u5ba1\u6838\u3001\u6279\u91cf\u5ba1\u6838", notes="\u5ba1\u6838\u4e00\u4e2a\u8c03\u62e8\u5355\uff0c\u4e00\u7ea7\u548c\u4e8c\u7ea7\u5ba1\u6838\u90fd\u670d\u7528\u8fd9\u4e2a\u63a5\u53e3")
    public RestResponse<BatchOrderOperationMsgDto> audit(@RequestBody TransferOrderAuditReqDto dto) {
        return this.service.audit(dto);
    }

    @PostMapping(path={"/cancel"})
    @ApiOperation(value="\u53d6\u6d88", notes="\u53d6\u6d88")
    public RestResponse<Boolean> cancel(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.cancel(keyDto);
    }

    @PostMapping(path={"/batchCancel"})
    @ApiOperation(value="\u8c03\u62e8\u5355\u6279\u91cf\u53d6\u6d88", notes="\u8c03\u62e8\u5355\u6279\u91cf\u53d6\u6d88")
    RestResponse<BatchOrderOperationMsgDto> batchCancel(@RequestBody List<TransferOrderKeyDto> keyDtoList) {
        return this.service.batchCancel(keyDtoList);
    }

    @PostMapping(path={"/close"})
    @ApiOperation(value="\u5173\u95ed", notes="\u5173\u95ed")
    public RestResponse<Boolean> close(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.close(keyDto);
    }

    @PostMapping(path={"/batchClose"})
    @ApiOperation(value="\u6279\u91cf\u5173\u95ed", notes="\u5173\u95ed")
    public RestResponse<BatchOrderOperationMsgDto> batchClose(@RequestBody List<TransferOrderKeyDto> dtoList) {
        return this.service.batchClose(dtoList);
    }

    @PostMapping(path={"/complete"})
    @ApiOperation(value="\u5b8c\u7ed3", notes="\u5b8c\u7ed3")
    public RestResponse<Boolean> complete(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.complete(keyDto);
    }

    @PostMapping(path={"/statistics"})
    @ApiOperation(value="\u7edf\u8ba1", notes="\u7edf\u8ba1")
    public RestResponse<Boolean> statistics(@RequestBody TransferOrderKeyDto keyDto) {
        return this.service.statistics(keyDto);
    }

    @PostMapping(path={"/batchModificationQuantity"})
    @ApiOperation(value="\u8c03\u62e8\u5355\u6279\u91cf\u66f4\u65b0\u8ba1\u5212\u6570\u91cf", notes="\u8c03\u62e8\u5355\u6279\u91cf\u66f4\u65b0\u8ba1\u5212\u6570\u91cf")
    public RestResponse<Void> batchModificationQuantity(@RequestBody List<BatchModificationQuantityDto> batchModificationQuantityDtoList) {
        return this.service.batchModificationQuantity(batchModificationQuantityDtoList);
    }

    @PostMapping(path={"/modifyE3Status"})
    @ApiOperation(value="\u4fee\u6539\u8c03\u62e8\u5355\u63a8\u9001e3\u72b6\u6001", notes="\u4fee\u6539\u8c03\u62e8\u5355\u63a8\u9001e3\u72b6\u6001")
    RestResponse<Void> modifyE3Status(@RequestBody TransferOrderReqDto transferOrderReqDto) {
        return this.service.modifyErpStatus(transferOrderReqDto);
    }

    @PostMapping(path={"/modifyPostReferenceStatus"})
    @ApiOperation(value="\u4fee\u6539\u8c03\u62e8\u5355\u8fc7\u8d26\u72b6\u6001", notes="\u4fee\u6539\u8c03\u62e8\u5355\u8fc7\u8d26\u72b6\u6001")
    RestResponse<Void> modifyPostReferenceStatus(@RequestBody TransferOrderReqDto transferOrderReqDto) {
        return this.service.modifyPostReferenceStatus(transferOrderReqDto);
    }

    @PostMapping(path={"/delete"})
    @ApiOperation(value="\u5220\u9664\u8c03\u62e8\u5355", notes="\u5220\u9664\u8c03\u62e8\u5355")
    RestResponse<Void> delete(@RequestBody TransferOrderKeyDto transferOrderKeyDto) {
        return this.service.deleteTransferOrder(transferOrderKeyDto);
    }

    @PostMapping(path={"/automationInTask"})
    @ApiOperation(value="\u5916\u4ed3BC\u8c03\u62e8\u81ea\u52a8\u5165\u5e93", notes="\u5916\u4ed3BC\u8c03\u62e8\u81ea\u52a8\u5165\u5e93")
    RestResponse<Void> automationInTask() {
        return this.service.automationInTask();
    }

    @PostMapping(path={"/modifyExternalOrderNo"})
    @ApiOperation(value="\u4fee\u6539\u8c03\u62e8\u5355\u5916\u90e8\u5355\u53f7", notes="\u4fee\u6539\u8c03\u62e8\u5355\u5916\u90e8\u5355\u53f7")
    RestResponse<Void> modifyExternalOrderNo(@RequestBody TransferOrderReqDto transferOrderReqDto) {
        return this.service.modifyExternalOrderNo(transferOrderReqDto);
    }

    @PostMapping(path={"/processBorrowGoods"})
    @ApiOperation(value="\u501f\u8d27\u56de\u4f20\u8c03\u8bd5\u63a5\u53e3", notes="\u501f\u8d27\u56de\u4f20\u8c03\u8bd5\u63a5\u53e3")
    RestResponse<Void> processBorrowGoods(@RequestBody TransferGoodsOrderDto transferGoodsOrderDto) {
        this.service.processBorrowGoods(transferGoodsOrderDto);
        return RestResponse.VOID;
    }

    @PostMapping(path={"/autoGenerateTransferOrder"})
    @ApiOperation(value="\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355", notes="\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355")
    RestResponse<List<String>> autoGenerateTransferOrder(@RequestBody TransferOrderAggDto transferOrderAggDto) {
        return new RestResponse((Object)this.aggService.autoGenerateTransferOrder(transferOrderAggDto));
    }

    @PostMapping(path={"/commitTransferOrder"})
    @ApiOperation(value="\u81ea\u52a8\u63d0\u4ea4\u8c03\u62e8\u5355\u5e76\u521b\u5efa\u8c03\u6574\u5355", notes="\u81ea\u52a8\u63d0\u4ea4\u8c03\u62e8\u5355\u5e76\u521b\u5efa\u8c03\u6574\u5355")
    RestResponse<Void> commitTransferOrder(@RequestParam(value="transferOrderNo") String transferOrderNo) {
        this.aggService.commitTransferOrder(transferOrderNo);
        return RestResponse.VOID;
    }

    @PostMapping(path={"/generateTransferOrderNo"})
    @ApiOperation(value="\u83b7\u53d6\u8c03\u62e8\u5355\u53f7", notes="\u83b7\u53d6\u8c03\u62e8\u5355\u53f7")
    RestResponse<String> generateTransferOrderNo() {
        return this.service.generateTransferOrderNo();
    }
}

