/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder;

import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public interface BaseOrderCommonAble<CONTEXT extends BaseOrderBaseContext> {
    @Transactional(rollbackFor={Exception.class})
    public void doGenerate(CONTEXT var1);

    default public boolean generateCheck(CONTEXT context) {
        AssertUtil.isTrue((null != context ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String relevanceNo = ((BaseOrderBaseContext)context).getRelevanceNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)relevanceNo), (String)"\u5173\u8054\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)Objects.nonNull(((BaseOrderBaseContext)context).getRelevanceTableName()), (String)"\u4e1a\u52a1\u5355\u636e\u8868\u540d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String basicsOrderOperateType = ((BaseOrderBaseContext)context).getOperateTypeEnum().getCode();
        ((BaseOrderBaseContext)context).setBizDate(Optional.ofNullable(((BaseOrderBaseContext)context).getBizDate()).orElse(new Date()));
        AssertUtil.isTrue((StringUtils.isNotBlank((CharSequence)basicsOrderOperateType) && null != BasicsOrderOperateTypeEnum.getByCode((String)basicsOrderOperateType) ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u6807\u8bc6\u53c2\u6570\u6709\u8bef");
        List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList = ((BaseOrderBaseContext)context).getOrderBasicsDetailReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(orderBasicsDetailReqDtoList), (String)"\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        orderBasicsDetailReqDtoList.forEach(dto -> {
            String longCode = dto.getSkuCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)longCode), (String)"\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((boolean)Objects.nonNull(dto.getPreOrderItemId()), (String)"\u524d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = dto.getQuantity();
            AssertUtil.isTrue((boolean)BigDecimalUtils.geZero((BigDecimal)quantity), (String)"\u5546\u54c1\u6570\u91cf\u53c2\u6570\u6709\u8bef");
        });
        return true;
    }

    default public void generate(CONTEXT context) {
        if (!this.generateCheck(context)) {
            return;
        }
        this.validRepeat(context);
        this.doGenerate(context);
        ((BaseOrderBaseContext)context).cleanCallback();
    }

    default public void validRepeat(CONTEXT context) {
    }

    @Transactional(rollbackFor={Throwable.class})
    default public void close(CONTEXT context) {
        if (!this.validClose(context)) {
            return;
        }
        ((BaseOrderBaseContext)context).execBefore();
        this.doClose(context);
        ((BaseOrderBaseContext)context).execAfter();
    }

    public boolean validClose(CONTEXT var1);

    public void doClose(CONTEXT var1);

    default public void cancel(CONTEXT context) {
        if (!this.validCancel(context)) {
            return;
        }
        ((BaseOrderBaseContext)context).execBefore();
        this.doCancel(context);
        ((BaseOrderBaseContext)context).execAfter();
    }

    public boolean validCancel(CONTEXT var1);

    @Transactional(rollbackFor={Exception.class})
    public void doCancel(CONTEXT var1);

    default public boolean canNoticeInventoryProcess(BaseOrderBaseContext context) {
        return !context.isOnlyGenResult() || context.getAutoComplete() == false;
    }
}

