/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.LockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.ILockAble;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LockAbleImpl
extends BaseAble
implements ILockAble {
    private static final Logger log = LoggerFactory.getLogger(LockAbleImpl.class);

    @Override
    public void lock(LockDto dto) {
        log.info("warehouse inventory lock(\u9501\u5b9a\u5e93\u5b58), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        List details = dto.getDetails();
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.checkSku(details);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(LockDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setChangeLockInventory(pd.getNum());
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setValidNegative(dto.getValidNegative());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

