/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc;

import com.alibaba.fastjson.support.spring.FastJsonRedisSerializer;
import com.dtyunxi.cube.starter.cache.CubeCacheProperties;
import com.dtyunxi.huieryun.cache.redis.config.RedisFactoryUtils;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.yunxi.dg.base.center.inventory.service.calc.RdsCalcExecuteManager;
import com.yunxi.dg.base.center.inventory.service.commons.LuaExecutor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class InventoryCalcConfig {
    @Bean
    public RedisConnectionFactory redisConnectionFactory(CubeCacheProperties cacheRegistryVo) {
        return RedisFactoryUtils.getConnectionFactory((CacheRegistryVo)cacheRegistryVo);
    }

    @Bean
    public RedisTemplate<String, Object> calcRedisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new FastJsonRedisSerializer(Object.class));
        redisTemplate.setHashValueSerializer((RedisSerializer)new FastJsonRedisSerializer(Object.class));
        return redisTemplate;
    }

    @Bean
    public RdsCalcExecuteManager rdsCalcExecuteManager() {
        return new RdsCalcExecuteManager();
    }

    @Bean
    public LuaExecutor luaExecutor(RedisTemplate<String, Object> calcRedisTemplate) {
        return new LuaExecutor(calcRedisTemplate);
    }

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, RdsCalcExecuteManager rdsCalcExecuteManager) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisConnectionFactory);
        redisMessageListenerContainer.addMessageListener((MessageListener)rdsCalcExecuteManager, (Topic)new ChannelTopic("calcInventoryUpdate"));
        return redisMessageListenerContainer;
    }
}

