/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MyDateUtil {
    public static int[] MONTH_MAX_DAY_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static Pattern TIME_PATTERN = Pattern.compile("[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}|[0-9]{1,2}:[0-9]{1,2}");
    public static Pattern DATE_PATTERN = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))?$");
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;

    public static long getCurrentTimeMillis2Zero() {
        long timeMillis = 0L;
        LocalTime localTime = LocalTime.now();
        timeMillis += (long)localTime.getHour() * 3600000L;
        timeMillis += (long)localTime.getMinute() * 60000L;
        return timeMillis += (long)localTime.getSecond() * 1000L;
    }

    public static long getTimeMillis(String time) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return 0L;
        }
        if (TIME_PATTERN.matcher(time).matches()) {
            long timeMillis = 0L;
            String[] times = time.split(":");
            if (times.length > 0) {
                timeMillis += (long)Integer.parseInt(times[0]) * 3600000L;
            }
            if (times.length > 1) {
                timeMillis += (long)Integer.parseInt(times[1]) * 60000L;
            }
            if (times.length > 2) {
                timeMillis += (long)Integer.parseInt(times[2]) * 1000L;
            }
            return timeMillis;
        }
        return 0L;
    }

    public static int maxDayOfMonth(int year, int month) {
        int feb_day_sub = 0;
        if (month == 2 && (year % 4 == 0 && year % 100 != 0 || year % 400 == 0)) {
            feb_day_sub = -1;
        }
        return MONTH_MAX_DAY_ARRAY[month - 1] + feb_day_sub;
    }

    public static LocalDateTime getLocalDateTimeFromDate(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime lastUpdateDateTime = LocalDateTime.ofInstant(instant, zone);
        return lastUpdateDateTime;
    }

    public static LocalDate getLocalDateFromDate(Date date) {
        return MyDateUtil.getLocalDateTimeFromDate(date).toLocalDate();
    }

    public static boolean inSameWeekWithCurrentDate(Date targetDate) {
        int lastUpdateWeek;
        WeekFields weekFields;
        if (targetDate == null) {
            return false;
        }
        LocalDate targetLocalDate = MyDateUtil.getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        int currentWeek = localDate.get((weekFields = WeekFields.ISO).weekOfWeekBasedYear());
        return currentWeek == (lastUpdateWeek = targetLocalDate.get(weekFields.weekOfWeekBasedYear()));
    }

    public static boolean inSameYearWithCurrentDate(Date targetDate) {
        if (targetDate == null) {
            return false;
        }
        LocalDate targetLocalDate = MyDateUtil.getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        return targetLocalDate.getYear() == localDate.getYear();
    }

    public static boolean inSameMonthWithCurrentDate(Date targetDate) {
        if (targetDate == null) {
            return false;
        }
        LocalDate targetLocalDate = MyDateUtil.getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        return targetLocalDate.getMonth() == localDate.getMonth();
    }

    public static boolean inSameDayOfYearWithCurrentDate(Date targetDate) {
        if (targetDate == null) {
            return false;
        }
        LocalDate targetLocalDate = MyDateUtil.getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        return targetLocalDate.getDayOfYear() == localDate.getDayOfYear();
    }

    public static boolean inSameHalfYearWithCurrentDate(Date targetDate) {
        if (targetDate == null) {
            return false;
        }
        LocalDate targetLocalDate = MyDateUtil.getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        boolean upHalf1 = targetLocalDate.getMonth().getValue() <= Month.JUNE.getValue();
        boolean upHalf2 = localDate.getMonth().getValue() <= Month.JUNE.getValue();
        return upHalf1 == upHalf2;
    }

    public static boolean isDayFormat(String date) {
        return DATE_PATTERN.matcher(date).matches();
    }
}

