/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.config;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataSyncJobConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DataSyncJobConfig.class);
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Value(value="${scheduler.client.app_code:tcbj-center-report}")
    private String appCode;

    public void afterPropertiesSet() throws Exception {
    }

    private TaskQueryRespDto getTask(String taskName) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(taskName);
        String query = JSONObject.toJSON((Object)taskQueryReqDto).toString();
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)));
        if (CollectionUtils.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            return (TaskQueryRespDto)taskQueryRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private void initTask(String taskName, String taskCode, String scheduleExpression) {
        try {
            TaskQueryRespDto taskQueryRespDto = this.getTask(taskName);
            if (Objects.isNull(taskQueryRespDto)) {
                TaskAndBizCreateReqDto taskAndBizCreateReqDto = this.initCreateReqDto(taskName, taskCode, scheduleExpression);
                RestResponse response = this.taskApi.addWithBiz(taskAndBizCreateReqDto);
                log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
                this.taskApi.enableById((Long)response.getData(), "{}");
            } else {
                TaskUpdateReqDto taskUpdateReqDto = this.initUpdateReqDto(scheduleExpression, taskQueryRespDto);
                RestResponse response = this.taskApi.modifyById(taskQueryRespDto.getId(), taskUpdateReqDto);
                log.info("\u66f4\u65b0\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
                this.taskApi.enableById(taskQueryRespDto.getId(), "{}");
            }
        }
        catch (Exception e) {
            log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + "\u5f02\u5e38", (Throwable)e);
        }
    }

    private TaskAndBizCreateReqDto initCreateReqDto(String taskName, String taskCode, String scheduleExpression) {
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setTaskName(taskName);
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setAppCode(this.appCode);
        taskAndBizCreateReqDto.setBizCode(taskCode);
        taskAndBizCreateReqDto.setBizName(taskName);
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(-1L));
        return taskAndBizCreateReqDto;
    }

    private TaskUpdateReqDto initUpdateReqDto(String scheduleExpression, TaskQueryRespDto taskQueryRespDto) {
        TaskUpdateReqDto taskAndBizCreateReqDto = new TaskUpdateReqDto();
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(-1L));
        return taskAndBizCreateReqDto;
    }
}

