/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.utils;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheMap<K, V>
extends AbstractMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CacheMap.class);
    public static final long DEFAULT_SECOND_TIMEOUT = 900L;
    private static CacheMap<Object, Object> defaultInstance;
    private long _cacheTimeoutSec = 900L;
    private int _limitSize = 10000;
    private ConcurrentHashMap<K, CacheEntry> map = new ConcurrentHashMap();
    private long lastCleanCacheTime = System.currentTimeMillis();
    private long lastCacheSize = 1000L;

    public static final synchronized CacheMap<?, ?> getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new CacheMap(900L);
        }
        return defaultInstance;
    }

    public CacheMap() {
        this._cacheTimeoutSec = 900L;
    }

    public CacheMap(long timeout) {
        this._cacheTimeoutSec = timeout;
    }

    public CacheMap(long timeoutSec, int limitSize) {
        this._cacheTimeoutSec = timeoutSec;
        this._limitSize = limitSize;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<K, CacheEntry>> wrapEntrySet = this.map.entrySet();
        for (Map.Entry<K, CacheEntry> entry : wrapEntrySet) {
            entrySet.add(entry.getValue());
        }
        return entrySet;
    }

    @Override
    public V get(Object key) {
        CacheEntry entry;
        Object result = null;
        long now = System.currentTimeMillis();
        if ((long)this.map.size() > this.lastCacheSize && now - this.lastCleanCacheTime > this._cacheTimeoutSec * 1000L) {
            for (Map.Entry<K, CacheEntry> entry2 : this.map.entrySet()) {
                CacheEntry cacheEntry = entry2.getValue();
                if (now - cacheEntry.time <= this._cacheTimeoutSec * 1000L) continue;
                this.map.remove(cacheEntry.key);
            }
            this.lastCleanCacheTime = now;
            this.lastCacheSize = this.map.size() * 2;
            logger.info("\u7f13\u5b58\u6e05\u7406\u540esize\u4e3a" + this.map.size());
        }
        if ((entry = this.map.get(key)) == null) {
            result = null;
        } else if (now - entry.time < this._cacheTimeoutSec * 1000L) {
            result = entry.value;
        } else {
            this.map.remove(key);
            result = null;
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        if (this.map.size() > this._limitSize) {
            Object[] keys = ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray();
            int n = keys.length / 2;
            for (int i = 0; i < n; ++i) {
                this.map.remove(keys[i]);
            }
            logger.info("\u8d85\u8fc7\u7f13\u5b58\u6570\u91cf{}\u4e0a\u9650\u81ea\u52a8\u6e05\u7406\uff0c\u5f53\u524dsize\u4e3a{}", (Object)this._limitSize, (Object)this.map.size());
        }
        CacheEntry entry = new CacheEntry(key, value);
        this.map.put(key, entry);
        return value;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V remove(Object key) {
        return (V)this.map.remove(key);
    }

    private class CacheEntry
    implements Map.Entry<K, V> {
        long time;
        V value;
        K key;

        CacheEntry(K key, V value) {
            this.value = value;
            this.key = key;
            this.time = System.currentTimeMillis();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }
    }
}

