/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.util;

import com.dtyunxi.cube.utils.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class TimeConversionUtil {
    public static Date getStartQuarter(Date date, int cycleNum) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(date);
        startCalendar.set(2, (startCalendar.get(2) / 3 - cycleNum) * 3);
        startCalendar.set(5, 1);
        TimeConversionUtil.setMinTime(startCalendar);
        return startCalendar.getTime();
    }

    public static Date getLastQuarter(Date date, int cycleNum) {
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(date);
        int month = endCalendar.get(2);
        endCalendar.set(2, (month / 3 - cycleNum) * 3 + 3);
        endCalendar.set(5, 1);
        return new Date(endCalendar.getTime().getTime() - 1000L);
    }

    private static void setMinTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void setMaxTime(Calendar calendar) {
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, calendar.getActualMaximum(14));
    }

    public static String getStartQuarterStr(String dateStr, int cycleNum) {
        Date date = DateUtil.parseDate((String)dateStr, (String)"yyyy-MM-dd");
        return DateUtil.getDateFormat((Date)TimeConversionUtil.getStartQuarter(date, cycleNum), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getLastQuarterStr(String dateStr, int cycleNum) {
        Date date = DateUtil.parseDate((String)dateStr, (String)"yyyy-MM-dd");
        return DateUtil.getDateFormat((Date)TimeConversionUtil.getLastQuarter(date, cycleNum), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getStartMonthStr(String monthStr, int cycleNum) {
        Date monthTime = DateUtil.parseDate((String)monthStr, (String)"yyyy-MM-dd");
        Date date = DateUtil.addMonths((Date)monthTime, (int)(-cycleNum));
        return DateUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd");
    }

    public static String getEndMonthStr(String monthStr) {
        Date monthTime = DateUtil.parseDate((String)monthStr, (String)"yyyy-MM-dd");
        return DateUtil.getMonthLastDay((Date)monthTime);
    }

    public static String getWeekRangeStart(int year, int week) {
        HashMap dateMap = new HashMap(8);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int weekYear = calendar.get(1);
        calendar.setWeekDate(weekYear, week, 2);
        Date time = calendar.getTime();
        String startTime = DateUtil.getDateFormat((Date)time, (String)"yyyy-MM-dd");
        return startTime;
    }

    public static String getWeekRangeEnd(int year, int week) {
        HashMap dateMap = new HashMap(8);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int weekYear = calendar.get(1);
        calendar.setWeekDate(weekYear, week, 1);
        Date time = calendar.getTime();
        String endTime = DateUtil.getDateFormat((Date)time, (String)"yyyy-MM-dd");
        return endTime;
    }

    public static void main(String[] args) {
        String aa = "2023-01-01 00:00:00";
        Date date = DateUtil.parseDate((String)aa, (String)"yyyy-MM-dd");
        System.out.println(DateUtil.getDateFormat((Date)TimeConversionUtil.getStartQuarter(date, 1), (String)"yyyy-MM-dd HH:mm:ss"));
        System.out.println(DateUtil.getDateFormat((Date)TimeConversionUtil.getLastQuarter(date, 1), (String)"yyyy-MM-dd HH:mm:ss"));
        System.out.println(TimeConversionUtil.getWeekRangeStart(2023, -1));
        System.out.println(TimeConversionUtil.getWeekRangeEnd(2023, -1));
        String[] supplyArry = "2023-04".split("-");
        String year = supplyArry[0];
        System.out.println(year);
        String cycle = supplyArry[1];
        System.out.println(cycle);
        Integer yearInt = Integer.valueOf(year);
        System.out.println(yearInt);
        Integer cycleInt = Integer.valueOf(cycle);
        System.out.println(cycleInt);
        String monthStr = year + "-" + cycle + "-01";
        System.out.println(monthStr);
        String startMonthStr = TimeConversionUtil.getStartMonthStr(monthStr, 1);
        System.out.println("startMonthStr=" + startMonthStr);
        System.out.println("endMonthStr=" + TimeConversionUtil.getEndMonthStr(startMonthStr));
        String quarterStartStr = year + "-10-01";
        String n1StartTime = TimeConversionUtil.getStartQuarterStr(quarterStartStr, 1);
        String n1EndTime = TimeConversionUtil.getLastQuarterStr(quarterStartStr, 1);
        String n2StartTime = TimeConversionUtil.getStartQuarterStr(quarterStartStr, 2);
        String n3StartTime = TimeConversionUtil.getStartQuarterStr(quarterStartStr, 3);
        System.out.println(n1StartTime);
        System.out.println(n1EndTime);
        System.out.println(n2StartTime);
        System.out.println(n3StartTime);
    }
}

