/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.BillAccountDetailConverter;
import com.yunxi.dg.base.center.report.domain.entity.IBillAccountDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.ISaleOrderDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgBillAccountDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DgBillAccountDetailPageReqDto;
import com.yunxi.dg.base.center.report.eo.DgBillAccountDetailEo;
import com.yunxi.dg.base.center.report.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.report.service.entity.IDgBillAccountDetailService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgBillAccountDetailServiceImpl
extends BaseServiceImpl<DgBillAccountDetailDto, DgBillAccountDetailEo, IBillAccountDetailDomain>
implements IDgBillAccountDetailService {
    private static final Logger log = LoggerFactory.getLogger(DgBillAccountDetailServiceImpl.class);
    @Resource
    private ISaleOrderDomain saleOrderDomain;

    public DgBillAccountDetailServiceImpl(IBillAccountDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgBillAccountDetailDto, DgBillAccountDetailEo> converter() {
        return BillAccountDetailConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgBillAccountDetailDto>> queryPage(DgBillAccountDetailPageReqDto dto) {
        PageInfo pageInfo = new PageInfo();
        PageInfo page = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IBillAccountDetailDomain)this.domain).filter().ge((Object)"trans_dt", (Object)dto.getStartTime())).le((Object)"trans_dt", (Object)dto.getEndTime())).page(dto.getPageNum(), dto.getPageSize());
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"navigatepageNums", "list"});
            List dgBillAccountDetailDtos = this.converter().toDtoList(page.getList());
            try {
                List platformOrderNos = dgBillAccountDetailDtos.stream().map(DgBillAccountDetailDto::getPlatformOrderNo).collect(Collectors.toList());
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(DgSaleOrderEo::getPlatformOrderNo, platformOrderNos);
                List saleOrderEos = this.saleOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
                dgBillAccountDetailDtos.forEach(e -> e.setShopCode(null));
                if (CollectionUtils.isNotEmpty((Collection)saleOrderEos)) {
                    for (DgSaleOrderEo saleOrderEo : saleOrderEos) {
                        for (DgBillAccountDetailDto detailDto : dgBillAccountDetailDtos) {
                            if (!saleOrderEo.getPlatformOrderNo().equals(detailDto.getPlatformOrderNo())) continue;
                            detailDto.setShopCode(saleOrderEo.getShopCode());
                            detailDto.setShopName(saleOrderEo.getShopName());
                            detailDto.setTradeChannel(saleOrderEo.getChannelCode());
                            detailDto.setTradeChannelName(saleOrderEo.getChannelName());
                        }
                    }
                }
            }
            catch (Exception e2) {
                log.error("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u5f02\u5e38");
            }
            pageInfo.setList(dgBillAccountDetailDtos);
        }
        return new RestResponse((Object)pageInfo);
    }
}

