/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.entity.SaleOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.ISaleOrderDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgSaleOrderDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.BillShopInfoDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.SystemSaleBillDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.SystemSaleBillReqDto;
import com.yunxi.dg.base.center.report.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.report.service.entity.IDgSaleOrderService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgSaleOrderServiceImpl
extends BaseServiceImpl<DgSaleOrderDto, DgSaleOrderEo, ISaleOrderDomain>
implements IDgSaleOrderService {
    public DgSaleOrderServiceImpl(ISaleOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgSaleOrderDto, DgSaleOrderEo> converter() {
        return SaleOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<BillShopInfoDto>> queryByPlatformOrderNos(List<String> platformOrderNos) {
        List saleOrderDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(platformOrderNos)) {
            saleOrderDtos = ((ISaleOrderDomain)this.domain).queryByPlatformOrderNos(platformOrderNos);
        }
        return new RestResponse((Object)saleOrderDtos);
    }

    @Override
    public RestResponse<PageInfo<SystemSaleBillDto>> sysSaleOrderPage(SystemSaleBillReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setOrderStatus(StringUtils.isBlank((CharSequence)dto.getOrderStatus()) ? "COMPLETE" : dto.getOrderStatus());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).sysSaleOrderList(dto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SystemSaleBillDto>> sysAfterOrderPage(SystemSaleBillReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setOrderStatus(StringUtils.isBlank((CharSequence)dto.getOrderStatus()) ? "3" : dto.getOrderStatus());
        PageInfo pageInfo = new PageInfo(((ISaleOrderDomain)this.domain).sysAfterOrderPage(dto));
        return new RestResponse((Object)pageInfo);
    }
}

