/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeCodeEnum;
import com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams;
import com.dtyunxi.tcbj.api.dto.response.es.SaleOrderRespEsVo;
import com.dtyunxi.tcbj.api.query.IFinLogisticsReportQueryApi;
import com.dtyunxi.tcbj.api.query.IReInsurancePremiumQueryApi;
import com.dtyunxi.tcbj.api.query.ISortingExpenseQueryApi;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.WmsDailyDeliveryReportRespDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.enums.ExternalWmsServiceEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsReturnOrderCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpRegionQueryApi;
import com.yunxi.dg.base.center.basicdata.dto.request.PcpRegionReqDto;
import com.yunxi.dg.base.center.basicdata.dto.response.PcpRegionRespDto;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryReportDataSourceEnum;
import com.yunxi.dg.base.center.report.convert.entity.DailyDeliveryReportConverter;
import com.yunxi.dg.base.center.report.dao.das.IDailyDeliveryReportDas;
import com.yunxi.dg.base.center.report.dao.das.IDgSaleOrderDas;
import com.yunxi.dg.base.center.report.dao.das.IFilePlaceRecordDas;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportDomain;
import com.yunxi.dg.base.center.report.domain.entity.ISaleOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgConsignmentOrderDeliveryInfoDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOtherStorageOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutPlannedOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgShipmentEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgTransferOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgWarehouseAddressDomain;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailCombineDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailDtEo;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailPageNewReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailProductDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportExtraDto;
import com.yunxi.dg.base.center.report.dto.entity.SynchronousDayDataDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWarehouseAddressDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWarehouseAddressPageReqDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yunxi.dg.base.center.report.dto.report.WmsDailyDeliveryReportQueryDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportDetailEo;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportEo;
import com.yunxi.dg.base.center.report.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicWarehouseEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOtherStorageOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutPlannedOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgPhysicsWarehouseEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgShipmentEnterpriseEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgTransferOrderEo;
import com.yunxi.dg.base.center.report.service.SynchronousDayDataConfigEnum;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class DailyDeliveryReportServiceImpl
extends BaseServiceImpl<DailyDeliveryReportDto, DailyDeliveryReportEo, IDailyDeliveryReportDomain>
implements IDailyDeliveryReportService {
    private static final Logger logger = LoggerFactory.getLogger(DailyDeliveryReportServiceImpl.class);
    @Resource
    private IDailyDeliveryReportDas iDailyDeliveryReportDas;
    @Resource
    private IExternalWmsApi externalWmsApi;
    @Resource
    private IDgOutResultOrderDomain outResultOrderDomain;
    @Resource
    private IDgOutResultOrderDetailDomain outResultOrderDetailDomain;
    @Resource
    private IDailyDeliveryReportDomain dailyDeliveryReportDomain;
    @Resource
    private IDgShipmentEnterpriseDomain shipmentEnterpriseDomain;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IDgConsignmentOrderDeliveryInfoDomain dgConsignmentOrderDeliveryInfoDomain;
    @Resource
    private IDgOutPlannedOrderDomain dgOutPlannedOrderDomain;
    @Resource
    private IDgOtherStorageOrderDomain dgOtherStorageOrderDomain;
    @Resource
    private IDgTransferOrderDomain dgTransferOrderDomain;
    @Resource
    private IDgSaleOrderDas dgSaleOrderDas;
    @Resource(name="tradeEsReportQueryApiImpl")
    private TradeEsReportQueryApi tradeEsReportQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    @Resource
    private IDgPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IDailyDeliveryReportDetailDomain dailyDeliveryReportDetailDomain;
    @Resource(name="IFinLogisticsReportQueryApi")
    private IFinLogisticsReportQueryApi finLogisticsReportQueryApi;
    @Resource(name="sortingExpenseQueryApiImpl")
    private ISortingExpenseQueryApi sortingExpenseQueryApi;
    @Resource(name="reInsurancePremiumQueryApiImpl")
    private IReInsurancePremiumQueryApi reInsurancePremiumQueryApi;
    @Resource
    private IDgWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IFilePlaceRecordDas filePlaceRecordDas;
    @Resource
    private ISaleOrderDomain saleOrderDomain;
    @Value(value="${scheduler.client.app_code:ISALE_MARKETING}")
    private String appCode;
    public static final Integer QUERY_PAGE_SIZE = 1000;
    private static final int INSERT_BATCH_SIZE = 1000;
    private static final String PHYSICAL_WAREHOUSE_CODE = "ZHK";
    private static final List<String> NOT_CHARGE_TYPES = Lists.newArrayList((Object[])new String[]{"in_transit_adjustment_out", "cb_allot", "cc_allot", "inspection_qualified", "allot_lose_efficacy", "allot_in_only", "allot_logic_out", "allot_sale_bh", "in_transit_transfer", "internal_deal", "internal_deal_return", "sale_return_internal_deal", "internal_deal_ba", "sale_return_internal_deal_ba", "internal_deal_return_ba", "route_internal_deal_ba", "check_stock", "product_repair", "claim_posting", "maiyou_allot"});

    public DailyDeliveryReportServiceImpl(IDailyDeliveryReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DailyDeliveryReportDto, DailyDeliveryReportEo> converter() {
        return DailyDeliveryReportConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> addDailyDeliveryReport(DailyDeliveryReportDto dto) {
        DailyDeliveryReportEo eo = new DailyDeliveryReportEo();
        eo = (DailyDeliveryReportEo)DailyDeliveryReportConverter.INSTANCE.toEo((BaseDto)dto);
        try {
            if (eo.getTotalCartons().equals(eo.getBillingCartons()) && eo.getTotalVolume().equals(eo.getBillingVolume()) && eo.getTotalWeight().equals(eo.getBillingWeight())) {
                eo.setDifferentFlag(Integer.valueOf(0));
            } else {
                eo.setDifferentFlag(Integer.valueOf(1));
            }
        }
        catch (Exception e) {
            logger.info("\u90e8\u5206\u6570\u636e\u4e0d\u5b58\u5728");
        }
        logger.info("\u63d2\u5165\u62a5\u8868\u5bf9\u8c61:{}", (Object)eo);
        Long id = this.iDailyDeliveryReportDas.insert((BaseEo)eo);
        return new RestResponse((Object)eo.getId());
    }

    @Override
    public RestResponse<Void> modifyDailyDeliveryReport(DailyDeliveryReportDto dto) {
        CsShipmentLogisticsTypeEnum enumByName;
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)dto.getId()), (String)"\u8bf7\u6c42id\u4e0d\u80fd\u4e3a\u7a7a");
        DailyDeliveryReportEo eo = (DailyDeliveryReportEo)this.iDailyDeliveryReportDas.selectByPrimaryKey(dto.getId());
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)eo), (String)("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff1a" + dto.getId()));
        DailyDeliveryReportEo updEo = (DailyDeliveryReportEo)BeanUtil.copyProperties((Object)dto, DailyDeliveryReportEo.class, (String[])new String[0]);
        updEo.setId(eo.getId());
        updEo.setUpdatePerson(null);
        updEo.setUpdateTime(null);
        updEo.setTotalCartons(ObjectUtils.isNotEmpty((Object)dto.getTotalCartons()) ? dto.getTotalCartons() : dto.getBillingCartons());
        updEo.setTotalVolume(ObjectUtils.isNotEmpty((Object)dto.getTotalVolume()) ? dto.getTotalVolume() : dto.getBillingVolume());
        updEo.setTotalWeight(ObjectUtils.isNotEmpty((Object)dto.getTotalWeight()) ? dto.getTotalWeight() : dto.getBillingWeight());
        updEo.setBillingWeight(ObjectUtils.isNotEmpty((Object)dto.getBillingWeight()) ? dto.getBillingWeight() : eo.getBillingWeight());
        updEo.setBillingCartons(ObjectUtils.isNotEmpty((Object)dto.getBillingCartons()) ? dto.getBillingCartons() : eo.getBillingCartons());
        updEo.setBillingVolume(ObjectUtils.isNotEmpty((Object)dto.getBillingVolume()) ? dto.getBillingVolume() : eo.getBillingVolume());
        this.matchRegionCode(updEo);
        if (StringUtils.isNotBlank((CharSequence)updEo.getTransportStyle()) && ObjectUtils.isNotEmpty((Object)(enumByName = CsShipmentLogisticsTypeEnum.getEnumByName((String)updEo.getTransportStyle())))) {
            updEo.setTransportStyleCode(enumByName.getType().toString());
        }
        updEo.setDifferentFlag(Integer.valueOf(0));
        if (ObjectUtils.isEmpty((Object)updEo.getBillingCartons()) || ObjectUtils.isEmpty((Object)updEo.getBillingVolume()) || ObjectUtils.isEmpty((Object)updEo.getBillingWeight())) {
            updEo.setDifferentFlag(Integer.valueOf(1));
        }
        if (ObjectUtils.isNotEmpty((Object)updEo.getBillingCartons()) && updEo.getTotalCartons().compareTo(updEo.getBillingCartons()) != 0) {
            updEo.setDifferentFlag(Integer.valueOf(1));
        }
        if (ObjectUtils.isNotEmpty((Object)updEo.getBillingVolume()) && updEo.getBillingVolume().compareTo(updEo.getTotalVolume()) != 0) {
            updEo.setDifferentFlag(Integer.valueOf(1));
        }
        if (ObjectUtils.isNotEmpty((Object)updEo.getBillingWeight()) && updEo.getBillingWeight().compareTo(updEo.getTotalWeight()) != 0) {
            updEo.setDifferentFlag(Integer.valueOf(1));
        }
        this.iDailyDeliveryReportDas.updateSelective((BaseEo)updEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DailyDeliveryReportDto> queryById(Long id) {
        DailyDeliveryReportEo eo = this.iDailyDeliveryReportDas.selectById(id);
        DailyDeliveryReportDto dto = new DailyDeliveryReportDto();
        dto = (DailyDeliveryReportDto)DailyDeliveryReportConverter.INSTANCE.toDto((BaseEo)eo);
        return new RestResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> logicDeleteDailyDeliveryReport(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long id : ids) {
            this.iDailyDeliveryReportDas.logicDeleteById(id);
        }
        return new RestResponse(null);
    }

    @Override
    public RestResponse<PageInfo<DailyDeliveryReportDto>> queryByPage(DailyDeliveryReportListQueryDto listQueryDto, Integer pageNum, Integer pageSize) {
        List otherOutOrderNoList;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo eoPage = new PageInfo(this.iDailyDeliveryReportDas.pageQuery(listQueryDto));
        PageInfo page = new PageInfo(DailyDeliveryReportConverter.INSTANCE.toDtoList(eoPage.getList()));
        page.setTotal(eoPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            page.getList().forEach(eo -> {
                eo.setWmsMergeDocumentNo(null);
                if (StringUtils.isBlank((CharSequence)eo.getWmsOrderType()) || !"\u5408\u5355\u751f\u6210".equals(eo.getWmsOrderType())) {
                    eo.setWmsMergeDocumentNo(eo.getJoinMergeDocumentNo());
                }
                if (StringUtils.isNotBlank((CharSequence)eo.getBusinessType())) {
                    eo.setBusinessTypeName(BusinessTypeCodeEnum.getMsgByCode((String)eo.getBusinessType()));
                }
                if (StringUtils.isNotBlank((CharSequence)eo.getDataSource())) {
                    eo.setDataSourceStr(DailyDeliveryReportDataSourceEnum.getDescForCode((String)eo.getDataSource()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherOutOrderNoList = page.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getBusinessType()) && f.getBusinessType().equals("other_out") && StringUtils.isNotBlank((CharSequence)f.getRelevanceNo())).map(DailyDeliveryReportDto::getRelevanceNo).distinct().collect(Collectors.toList()))) {
            List storageOrderEoList = ((ExtQueryChainWrapper)this.dgOtherStorageOrderDomain.filter().in((Object)"storage_order_no", otherOutOrderNoList)).list();
            Map storageOrderEoMap = Optional.ofNullable(storageOrderEoList).map(m -> m.stream().collect(Collectors.toMap(DgOtherStorageOrderEo::getStorageOrderNo, DgOtherStorageOrderEo::getBusinessTypeName, (k1, k2) -> k1))).orElse(new HashMap());
            page.getList().forEach(info -> {
                if (StringUtils.isNotBlank((CharSequence)info.getBusinessType()) && info.getBusinessType().equals("other_out") && StringUtils.isNotBlank((CharSequence)info.getRelevanceNo()) && StringUtils.isNotBlank((CharSequence)((CharSequence)storageOrderEoMap.get(info.getRelevanceNo())))) {
                    String type = (String)storageOrderEoMap.get(info.getRelevanceNo());
                    info.setBusinessTypeName(info.getBusinessTypeName() + "\uff08" + type + "\uff09");
                }
            });
        }
        return new RestResponse((Object)page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updatedDateDailyDeliveryReport(Integer date) {
        AssertUtil.isTrue((boolean)Objects.nonNull(date), (String)"\u66f4\u65b0\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u65e5\u671f\u914d\u7f6e\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setBizCode("dailyDeliveryReportJob");
        String appBizQuery = JSONObject.toJSON((Object)appBizQueryReqDto).toString();
        PageInfo appBizQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.appBizQueryApi.queryByPage(appBizQuery, Integer.valueOf(1), Integer.valueOf(1)));
        Long id = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)appBizQueryRespDtoPageInfo.getList())) {
            AppBizQueryRespDto appBizQueryRespDto = (AppBizQueryRespDto)appBizQueryRespDtoPageInfo.getList().get(0);
            TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
            taskQueryReqDto.setAppBizId(appBizQueryRespDto.getId());
            String query = JSONObject.toJSON((Object)taskQueryReqDto).toString();
            PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
                id = ((TaskQueryRespDto)taskQueryRespDtoPageInfo.getList().get(0)).getId();
            }
        }
        logger.info("dailyDeliveryReportJob===>id:{}", id);
        String expression = String.format("0 0 3 %s * ?", date);
        logger.info("expression:{}", (Object)expression);
        if (Objects.isNull(id)) {
            TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
            dto.setAppCode(this.appCode);
            dto.setBizCode("dailyDeliveryReportJob");
            dto.setBizName("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u6570\u636e\u8c03\u5ea6");
            dto.setShardType("SINGLE");
            dto.setTaskName("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u6570\u636e\u8c03\u5ea6");
            dto.setTaskDesc("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u6570\u636e\u8c03\u5ea6");
            dto.setTenantId(Long.valueOf(-1L));
            dto.setInstanceId(Long.valueOf(-1L));
            dto.setScheduleExpression(expression);
            logger.info("\u65b0\u589e\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u6570\u636e\u8c03\u5ea6\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
            Long addId = (Long)com.yunxi.dg.base.commons.utils.RestResponseHelper.extractData((RestResponse)this.taskApi.addWithBiz(dto));
            this.taskApi.enableById(addId, "{}");
        } else {
            this.taskApi.disableById(id, "{}");
            TaskUpdateReqDto taskUpdateReqDto = new TaskUpdateReqDto();
            taskUpdateReqDto.setScheduleExpression(expression);
            taskUpdateReqDto.setTenantId(Long.valueOf(-1L));
            taskUpdateReqDto.setInstanceId(Long.valueOf(-1L));
            this.taskApi.modifyById(id, taskUpdateReqDto);
            this.taskApi.enableById(id, "{}");
        }
        System.out.println("\u66f4\u65b0das\u524d");
        this.iDailyDeliveryReportDas.updateDate(date);
        return new RestResponse(null);
    }

    @Override
    public RestResponse<Integer> queryDateDailyDeliveryReport() {
        return this.iDailyDeliveryReportDas.queryDate();
    }

    @Override
    public RestResponse<Void> updateWMSData(List<Long> ids) {
        return new RestResponse(null);
    }

    @Override
    public RestResponse<Void> synchronousMonthData() {
        LocalDate today = LocalDate.now();
        LocalDate firstDayOfThisMonth = today.withDayOfMonth(1);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate date = firstDayOfThisMonth;
        while (date.isBefore(today.plusDays(1L))) {
            LocalDateTime startOfDay = LocalDateTime.of(date, LocalTime.MIDNIGHT);
            String startOfDayFormatted = startOfDay.format(formatter);
            LocalDateTime endOfDay = LocalDateTime.of(date, LocalTime.MAX);
            String endOfDayFormatted = endOfDay.format(formatter);
            this.queryDailyDeliveryData(startOfDayFormatted, endOfDayFormatted);
            date = date.plusDays(1L);
        }
        return new RestResponse(null);
    }

    private void queryDailyDeliveryData(String startOfDayFormatted, String endOfDayFormatted) {
        logger.info("\u67e5\u8be2wms\u548cocs\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\uff1a{}\uff0c{}", (Object)startOfDayFormatted, (Object)endOfDayFormatted);
        WmsDailyDeliveryReportQueryDto queryDto = new WmsDailyDeliveryReportQueryDto();
        queryDto.setStartTime(startOfDayFormatted);
        queryDto.setEndTime(endOfDayFormatted);
        logger.info("\u67e5\u8be2wms\u548cocs\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        this.queryWmsDailyDeliveryReport(queryDto);
        this.saveOcsDailyDeliveryReport(startOfDayFormatted, endOfDayFormatted, null, null);
    }

    @Override
    public void queryWmsDailyDeliveryReport(WmsDailyDeliveryReportQueryDto queryDto) {
        AssertUtil.isTrue((boolean)Objects.nonNull(queryDto), (String)"\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("\u540c\u6b65wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636equeryWmsDailyDeliveryReport\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        WmsReturnOrderCreateReqDto.ExtendInfo extendInfo = new WmsReturnOrderCreateReqDto.ExtendInfo();
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getOrderNumber())) {
            extendInfo.setOrderNumber(queryDto.getOrderNumber());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getStartTime())) {
            extendInfo.setStartTime(queryDto.getStartTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getEndTime())) {
            extendInfo.setEndTime(queryDto.getEndTime());
        }
        extendInfo.setOrderType("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u67e5\u8be2");
        WmsReturnOrderCreateReqDto dto = new WmsReturnOrderCreateReqDto();
        dto.setExtendInfo(extendInfo);
        dto.setWarehouseCode(PHYSICAL_WAREHOUSE_CODE);
        dto.setSystemCode(ExternalWmsServiceEnum.WmsMappingEnum.WZ.getChannelCode());
        dto.setDocumentNo(String.valueOf(new Date().getTime()));
        logger.info("\u67e5\u8be2wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
        com.yunxi.dg.base.commons.utils.RestResponseHelper.extractData((RestResponse)this.externalWmsApi.returnOrderCreate(dto));
    }

    @Override
    public void queryWmsDailyDeliveryReportExt(WmsDailyDeliveryReportQueryDto queryDto) {
        logger.info("\u540c\u6b65wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636equeryWmsDailyDeliveryReportExt\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        WmsReturnOrderCreateReqDto.ExtendInfo extendInfo = new WmsReturnOrderCreateReqDto.ExtendInfo();
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getOrderNumber())) {
            extendInfo.setOrderNumber(queryDto.getOrderNumber());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getStartTime())) {
            extendInfo.setStartTime(queryDto.getStartTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getEndTime())) {
            extendInfo.setEndTime(queryDto.getEndTime());
        }
        extendInfo.setOrderType("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u67e5\u8be2");
        WmsReturnOrderCreateReqDto dto = new WmsReturnOrderCreateReqDto();
        dto.setExtendInfo(extendInfo);
        dto.setWarehouseCode(queryDto.getWarehouseCode());
        dto.setSystemCode(queryDto.getWmsChannelCode());
        dto.setDocumentNo(String.valueOf(new Date().getTime()));
        logger.info("\u67e5\u8be2wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
        com.yunxi.dg.base.commons.utils.RestResponseHelper.extractData((RestResponse)this.externalWmsApi.returnOrderCreate(dto));
    }

    @Override
    public RestResponse<PageInfo<DailyDeliveryReportDetailCombineDto>> queryDetailByPage(DailyDeliveryReportDetailPageNewReqDto queryDto) {
        List otherOutOrderNoList;
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        PageInfo page = new PageInfo(this.iDailyDeliveryReportDas.queryDetailByPage(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            page.getList().forEach(dto -> {
                dto.setWmsMergeDocumentNo(dto.getJoinMergeDocumentNo());
                if (StringUtils.isNotBlank((CharSequence)dto.getBusinessType())) {
                    dto.setBusinessTypeName(BusinessTypeCodeEnum.getMsgByCode((String)dto.getBusinessType()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherOutOrderNoList = page.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getBusinessType()) && f.getBusinessType().equals("other_out") && StringUtils.isNotBlank((CharSequence)f.getRelevanceNo())).map(DailyDeliveryReportDetailCombineDto::getRelevanceNo).distinct().collect(Collectors.toList()))) {
            List storageOrderEoList = ((ExtQueryChainWrapper)this.dgOtherStorageOrderDomain.filter().in((Object)"storage_order_no", otherOutOrderNoList)).list();
            Map storageOrderEoMap = Optional.ofNullable(storageOrderEoList).map(m -> m.stream().collect(Collectors.toMap(DgOtherStorageOrderEo::getStorageOrderNo, DgOtherStorageOrderEo::getBusinessTypeName, (k1, k2) -> k1))).orElse(new HashMap());
            page.getList().forEach(info -> {
                if (StringUtils.isNotBlank((CharSequence)info.getBusinessType()) && info.getBusinessType().equals("other_out") && StringUtils.isNotBlank((CharSequence)info.getRelevanceNo()) && StringUtils.isNotBlank((CharSequence)((CharSequence)storageOrderEoMap.get(info.getRelevanceNo())))) {
                    String type = (String)storageOrderEoMap.get(info.getRelevanceNo());
                    info.setBusinessTypeName(info.getBusinessTypeName() + "\uff08" + type + "\uff09");
                }
            });
        }
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\u6570\u91cf: {}", (Object)page.getTotal());
        return new RestResponse((Object)page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWmsDailyDeliveryReport(List<WmsDailyDeliveryReportRespDto> wmsDailyDeliveryReportRespDtoList) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(wmsDailyDeliveryReportRespDtoList), (String)"\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("\u4fdd\u5b58wms\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4fe1\u606f\u5165\u53c2\u6761\u6570 {} \u53d1\u8fd0\u65f6\u95f4 {}", (Object)wmsDailyDeliveryReportRespDtoList.size(), (Object)DateUtil.getDateFormat((Date)wmsDailyDeliveryReportRespDtoList.get(0).getShipDate(), (String)"yyyy-MM-dd"));
        List noticeNoList = wmsDailyDeliveryReportRespDtoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getPcpNumber()) && e.getPcpNumber().contains("PDON")).map(e -> e.getPcpNumber()).distinct().collect(Collectors.toList());
        List carrierNameList = wmsDailyDeliveryReportRespDtoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCarrierName())).map(e -> e.getCarrierName().trim()).distinct().collect(Collectors.toList());
        Map<Object, Object> shipmentEnterpriseMap = new HashMap();
        if (CollectionUtils.isNotEmpty(carrierNameList)) {
            shipmentEnterpriseMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.shipmentEnterpriseDomain.filter().in((Object)"shipment_enterprise_name", carrierNameList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgShipmentEnterpriseEo::getShipmentEnterpriseName, Function.identity(), (k1, k2) -> k1));
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 \u7269\u6d41\u5546\u67e5\u8be2\u96c6\u5408 {}", (Object)JSON.toJSONString(shipmentEnterpriseMap));
        }
        Map<Object, Object> outResultOrderMap = new HashMap();
        if (CollectionUtils.isNotEmpty(noticeNoList)) {
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 \u63a5\u6536\u5230\u901a\u77e5\u5355\u53f7\u67e5\u8be2 {}", (Object)JSON.toJSONString(noticeNoList));
            outResultOrderMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.outResultOrderDomain.filter().in((Object)"pre_order_no", noticeNoList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgOutResultOrderEo::getPreOrderNo, Function.identity(), (k1, k2) -> k1));
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 \u63a5\u6536\u5230\u901a\u77e5\u5355\u53f7\u7ed3\u679c {}", (Object)JSON.toJSONString(outResultOrderMap));
        }
        HashSet skuCodes = new HashSet();
        wmsDailyDeliveryReportRespDtoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getWmsDailyDeliveryReportDetailRespDtos())).forEach(e -> e.getWmsDailyDeliveryReportDetailRespDtos().stream().filter(detail -> StringUtils.isNotBlank((CharSequence)detail.getItemCode())).forEach(detail -> skuCodes.add(detail.getItemCode())));
        HashMap<String, DailyDeliveryReportDetailEo> itemMap = new HashMap();
        if (CollectionUtils.isNotEmpty(skuCodes)) {
            itemMap = this.dailyDeliveryReportDetailDomain.queryItemDataBySkuCodes((List)Lists.newArrayList(skuCodes));
        }
        HashSet<String> physicsWarehouseCodes = new HashSet<String>();
        HashSet logicWarehouseCodes = new HashSet();
        if (!outResultOrderMap.isEmpty()) {
            outResultOrderMap.values().stream().forEach(e -> {
                if (StringUtils.isNotEmpty((CharSequence)e.getOutPhysicsWarehouseCode())) {
                    physicsWarehouseCodes.add(e.getOutPhysicsWarehouseCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)e.getOutLogicWarehouseCode())) {
                    logicWarehouseCodes.add(e.getOutLogicWarehouseCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)e.getInLogicWarehouseCode())) {
                    logicWarehouseCodes.add(e.getInLogicWarehouseCode());
                }
            });
        }
        physicsWarehouseCodes.add(PHYSICAL_WAREHOUSE_CODE);
        DgWarehouseAddressPageReqDto dto = new DgWarehouseAddressPageReqDto();
        dto.setWarehouseCodes((List)Lists.newArrayList(physicsWarehouseCodes));
        List warehouseAddressDtos = this.warehouseAddressDomain.queryList(dto);
        Map warehouseAddressMap = ((List)Optional.ofNullable(warehouseAddressDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgWarehouseAddressDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        DgPhysicsWarehouseEo physicsWarehouseEo = (DgPhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)PHYSICAL_WAREHOUSE_CODE)).eq((Object)"warehouse_status", (Object)"enable")).last("limit 1")).one();
        Map<Object, Object> logicWarehouseEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(logicWarehouseCodes)) {
            logicWarehouseEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).eq((Object)"warehouse_status", (Object)"enable")).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgLogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<DailyDeliveryReportEo> eos = new ArrayList<DailyDeliveryReportEo>(wmsDailyDeliveryReportRespDtoList.size());
        for (WmsDailyDeliveryReportRespDto e2 : wmsDailyDeliveryReportRespDtoList) {
            DgLogicWarehouseEo inLogicWarehouseEo;
            DgLogicWarehouseEo outLogicWarehouseEo;
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5b57\u6bb5\u8f6c\u6362 {}", (Object)e2.getOrderNumber(), (Object)JSON.toJSONString((Object)e2));
            if (StringUtils.isNotEmpty((CharSequence)e2.getCarrierName())) {
                e2.setCarrierName(e2.getCarrierName().trim());
            }
            DailyDeliveryReportEo eo = new DailyDeliveryReportEo();
            eo.setDataSource(DailyDeliveryReportDataSourceEnum.WMS.getCode());
            eo.setReceivingCustomer(e2.getCustomerName());
            eo.setInventoryOrganizationName(e2.getInventoryOrgName());
            eo.setInventoryOrganizationCode(e2.getInventoryOrgCode());
            eo.setOrderCreateTime(e2.getOrderDate());
            eo.setOrderShippingTime(e2.getShipDate());
            eo.setReceivingPerson(e2.getContactName());
            eo.setReceivingAddressProvince(e2.getProvince());
            eo.setReceivingAddressCity(e2.getCity());
            eo.setReceivingAddressDistrict(e2.getCounty());
            eo.setReceivingAddress(e2.getAddress());
            eo.setReceivingPersonPhone(e2.getTelephone());
            eo.setWmsOrderType(Objects.equals("PCP", e2.getBillSource()) ? "OCS" : e2.getBillSource());
            if (e2.getPcpNumber().contains("PDON")) {
                eo.setOutNoticeNo(e2.getPcpNumber());
            } else {
                eo.setE3No(e2.getPcpNumber());
            }
            eo.setDocumentNo(e2.getOrderNumber());
            eo.setWmsOrderNo(e2.getOrderNumber());
            eo.setWmsMergeDocumentNo(e2.getEasNumber());
            eo.setJoinMergeDocumentNo(e2.getClosingOrderCode());
            eo.setPickingOrderNo(e2.getOrderNumber());
            eo.setConsignmentNo(e2.getShipmentNumber());
            eo.setTransportNo(e2.getTrackingNo());
            eo.setTotalQuantity(e2.getQuantityBU());
            eo.setTotalCartons(e2.getBoxQty());
            eo.setTotalVolume(e2.getVolume());
            eo.setTotalWeight(e2.getWeight());
            eo.setBillingCartons(eo.getTotalCartons());
            eo.setBillingVolume(eo.getTotalVolume());
            eo.setBillingWeight(eo.getTotalWeight());
            eo.setShippingCompanyName(e2.getCarrierName());
            eo.setShipmentEnterpriseName(e2.getCarrierName());
            eo.setShopName(e2.getShopName());
            eo.setCommercialOrderFlag(Integer.valueOf(Objects.equals(e2.getBeOnline(), "Y") ? 1 : 0));
            eo.setRemark(e2.getRemark());
            eo.setDifferentFlag(Integer.valueOf(0));
            eo.setCreatePerson("WMS");
            eo.setUpdatePerson(eo.getCreatePerson());
            eo.setVehicleNumber(e2.getLicensePlateNumber());
            eo.setMuchDeliveryFlag(Integer.valueOf(Objects.equals("Y", e2.getExtendStr1()) ? 1 : 0));
            CsShipmentLogisticsTypeEnum enumByName = CsShipmentLogisticsTypeEnum.getEnumByName((String)e2.getCarrierServiceName());
            if (enumByName == null) {
                logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u627f\u8fd0\u65b9\u5f0f\u6620\u5c04\u4e0d\u5230\u7f16\u7801 {}", (Object)e2.getOrderNumber(), (Object)e2.getCarrierServiceName());
                eo.setTransportStyle(e2.getCarrierServiceName());
            } else {
                eo.setTransportStyleCode(enumByName.getType() + "");
                eo.setTransportStyle(e2.getCarrierServiceName());
            }
            DgShipmentEnterpriseEo shipmentEnterpriseEo = (DgShipmentEnterpriseEo)shipmentEnterpriseMap.get(e2.getCarrierName());
            if (Objects.nonNull(shipmentEnterpriseEo)) {
                logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5339\u914d\u7269\u6d41\u5546 {}", (Object)e2.getOrderNumber(), (Object)JSON.toJSONString((Object)shipmentEnterpriseEo));
                eo.setShippingCompany(shipmentEnterpriseEo.getShipmentEnterpriseCode());
                eo.setShipmentEnterpriseCode(shipmentEnterpriseEo.getShipmentEnterpriseCode());
            } else {
                logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5339\u914d\u4e0d\u5230\u7269\u6d41\u5546", (Object)e2.getOrderNumber());
                eo.setShippingCompany(e2.getCarrierCode());
                eo.setShipmentEnterpriseCode(e2.getCarrierCode());
            }
            DgOutResultOrderEo outResultOrderEo = (DgOutResultOrderEo)outResultOrderMap.get(e2.getPcpNumber());
            if (Objects.nonNull(outResultOrderEo)) {
                logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5339\u914d\u5230\u7ed3\u679c\u5355 {}", (Object)e2.getOrderNumber(), (Object)JSON.toJSONString((Object)outResultOrderEo));
                eo.setRelevanceNo(outResultOrderEo.getRelevanceNo());
                eo.setOutResultNo(outResultOrderEo.getDocumentNo());
                eo.setShopCode(outResultOrderEo.getShopCode());
                eo.setShopName(outResultOrderEo.getShopName());
                eo.setPhysicalWarehouse(outResultOrderEo.getOutPhysicsWarehouseName());
                eo.setPhysicalWarehouseCode(outResultOrderEo.getOutPhysicsWarehouseCode());
                eo.setLogicWarehouse(outResultOrderEo.getOutLogicWarehouseName());
                eo.setLogicWarehouseCode(outResultOrderEo.getOutLogicWarehouseCode());
                eo.setInPhysicalWarehouse(outResultOrderEo.getInPhysicsWarehouseName());
                eo.setInPhysicalWarehouseCode(outResultOrderEo.getInPhysicsWarehouseCode());
                eo.setInLogicWarehouse(outResultOrderEo.getInLogicWarehouseName());
                eo.setInLogicWarehouseCode(outResultOrderEo.getInLogicWarehouseCode());
                eo.setBusinessType(outResultOrderEo.getBusinessType());
                if (StringUtils.isNotEmpty((CharSequence)outResultOrderEo.getExtension())) {
                    JSONObject object = JSONObject.parseObject((String)outResultOrderEo.getExtension());
                    Optional.ofNullable(object.getString("mergeOrderNo")).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(arg_0 -> ((DailyDeliveryReportEo)eo).setJoinMergeDocumentNo(arg_0));
                }
                ArrayList<String> relevanceNos = new ArrayList<String>();
                relevanceNos.add(outResultOrderEo.getBusinessType());
                logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 \u67e5\u8be2\u5230\u5173\u8054\u4e1a\u52a1\u5355\u53f7\u96c6\u5408 {}", (Object)JSON.toJSONString(relevanceNos));
                Map<String, List<DgSaleOrderEo>> saleOrderMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.dgSaleOrderDas.filter().in((Object)"sale_order_no", relevanceNos)).list()).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgSaleOrderEo::getSaleOrderNo));
                List<DgSaleOrderEo> dgSaleOrderEos = saleOrderMap.get(outResultOrderEo.getRelevanceNo());
                if (null != outResultOrderEo.getBusinessType()) {
                    logger.info("\u5173\u8054\u5355\u53f7\uff0c{}\uff0c\u5339\u914d\u5230\u5185\u90e8\u9500\u552e\u8ba2\u5355\u5bf9\u8c61", (Object)outResultOrderEo.getRelevanceNo());
                    DgSaleOrderEo saleOrderEo = this.saleOrderDomain.queryBySaleOrderNo(outResultOrderEo.getRelevanceNo());
                    if (ObjectUtils.isNotEmpty((Object)saleOrderEo)) {
                        logger.info("\u5173\u8054\u5355\u53f7\uff0c{}\uff0c\u5339\u914d\u5230\u5185\u90e8\u9500\u552e\u8ba2\u5355\u5bf9\u8c61\uff0c{}", (Object)outResultOrderEo.getRelevanceNo(), (Object)JSON.toJSONString((Object)saleOrderEo));
                        eo.setEasOrderNo(StringUtils.isNotEmpty((CharSequence)saleOrderEo.getEasOrderNo()) ? saleOrderEo.getEasOrderNo() : saleOrderEo.getEasOutOrderNo());
                    }
                } else {
                    eo.setEasOrderNo(dgSaleOrderEos.get(0).getExternalOrderNo());
                }
            } else if (Objects.nonNull(physicsWarehouseEo)) {
                logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u672a\u5339\u914d\u5230\u7ed3\u679c\u5355", (Object)e2.getOrderNumber());
                eo.setPhysicalWarehouse(physicsWarehouseEo.getWarehouseName());
                eo.setPhysicalWarehouseCode(physicsWarehouseEo.getWarehouseCode());
            }
            DgWarehouseAddressDto warehouseAddressDto = (DgWarehouseAddressDto)warehouseAddressMap.get(eo.getPhysicalWarehouseCode());
            if (Objects.nonNull(warehouseAddressDto)) {
                logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u51fa\u5e93\u7269\u7406\u4ed3\u7f16\u7801 {} \u5339\u914d\u5230\u8d77\u8fd0\u5730 {}", (Object)eo.getPhysicalWarehouseCode(), (Object)JSON.toJSONString((Object)warehouseAddressDto));
                eo.setStartProvinceCode(warehouseAddressDto.getProvinceCode());
                eo.setStartProvince(warehouseAddressDto.getProvince());
                eo.setStartCityCode(warehouseAddressDto.getCityCode());
                eo.setStartCity(warehouseAddressDto.getCity());
            }
            if (Objects.nonNull(outLogicWarehouseEo = (DgLogicWarehouseEo)logicWarehouseEoMap.get(eo.getLogicWarehouseCode()))) {
                eo.setOutInventoryOrgId(outLogicWarehouseEo.getCargoEscheatageId());
                eo.setOutInventoryOrg(outLogicWarehouseEo.getCargoEscheatageName());
                eo.setCostOrgName(outLogicWarehouseEo.getCostOrgName());
                eo.setCostOrgCode(outLogicWarehouseEo.getCostOrg());
                eo.setCostOrgId(outLogicWarehouseEo.getCostOrgId());
            }
            if (Objects.nonNull(inLogicWarehouseEo = (DgLogicWarehouseEo)logicWarehouseEoMap.get(eo.getInLogicWarehouseCode()))) {
                eo.setInInventoryOrgId(inLogicWarehouseEo.getCargoEscheatageId());
                eo.setInInventoryOrg(inLogicWarehouseEo.getCargoEscheatageName());
            }
            if (CollectionUtils.isNotEmpty((Collection)e2.getWmsDailyDeliveryReportDetailRespDtos())) {
                this.saveWmsDailyDeliveryReportDetail(itemMap, e2, eo);
            }
            this.supplementRegionCode(eo);
            if (Objects.equals(eo.getBusinessType(), "other_out")) {
                eo.setJoinMergeDocumentNo("");
            }
            if (Objects.equals(eo.getWmsOrderType(), "E3")) {
                eo.setJoinMergeDocumentNo("");
            }
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u6620\u5c04\u540e\u4fdd\u5b58\u6570\u636e {}", (Object)e2.getOrderNumber(), (Object)JSON.toJSONString((Object)eo));
            eos.add(eo);
        }
        List wmsOrderNoList = wmsDailyDeliveryReportRespDtoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getOrderNumber())).map(e -> e.getOrderNumber()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(wmsOrderNoList)) {
            List ids = this.dailyDeliveryReportDomain.batchDeleteByWmsOrderNoList(wmsOrderNoList);
            this.dailyDeliveryReportDetailDomain.batchLogicDeleteByDailyDeliveryReportIdList(ids);
        }
        this.iDailyDeliveryReportDas.insertBatch(eos);
    }

    private void parseAddress(DailyDeliveryReportEo reportEo) {
        logger.info("\u89e3\u6790\u8be6\u7ec6\u5730\u5740\u4fe1\u606f\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reportEo));
        if (StringUtils.isBlank((CharSequence)reportEo.getReceivingAddress())) {
            return;
        }
        String regex = "(?<province>[^\u7701]+\u81ea\u6cbb\u533a|.*?\u7701|.*?\u884c\u653f\u533a|.*?\u5e02)(?<city>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|.*?\u5e02|.*?\u53bf)(?<district>[^\u533a]+\u533a|.*?\u5e02|.*?\u53bf|.*?\u65d7|.*?\u6d77\u57df|.*?\u5c9b)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(reportEo.getReceivingAddress());
        if (matcher.find()) {
            String province = matcher.group("province");
            String city = matcher.group("city");
            String district = matcher.group("district");
            reportEo.setReceivingAddressProvince(province);
            reportEo.setReceivingAddressCity(city);
            reportEo.setReceivingAddressDistrict(district);
            logger.info("\u89e3\u6790\u8be6\u7ec6\u5730\u5740\u4fe1\u606f\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f\u7ed3\u679c\uff1a{}\uff0c{}\uff0c{}", new Object[]{province, city, district});
        }
    }

    private void saveWmsDailyDeliveryReportDetail(Map<String, DailyDeliveryReportDetailEo> itemMap, WmsDailyDeliveryReportRespDto e, DailyDeliveryReportEo eo) {
        logger.info("wmsDailyDeliveryReportDetailRespDtos.size {}", (Object)e.getWmsDailyDeliveryReportDetailRespDtos().size());
        eo.setId(Long.valueOf(IdWorker.getId()));
        ArrayList<DailyDeliveryReportDetailEo> dailyDeliveryReportDetailEos = new ArrayList<DailyDeliveryReportDetailEo>();
        for (WmsDailyDeliveryReportRespDto.WmsDailyDeliveryReportDetailRespDto detailRespDto : e.getWmsDailyDeliveryReportDetailRespDtos()) {
            DailyDeliveryReportDetailEo detailEo = new DailyDeliveryReportDetailEo();
            detailEo.setDailyDeliveryReportId(eo.getId());
            detailEo.setSkuCode(detailRespDto.getItemCode());
            detailEo.setCargoCode(detailRespDto.getItemCode());
            detailEo.setLongCode(detailRespDto.getItemCode());
            detailEo.setBatch(detailRespDto.getBatch());
            detailEo.setQuantity(detailRespDto.getQuantity());
            detailEo.setItemStatus("common");
            detailEo.setCreatePerson(eo.getCreatePerson());
            detailEo.setUpdatePerson(eo.getUpdatePerson());
            DailyDeliveryReportDetailEo itemEo = itemMap.get(detailRespDto.getItemCode());
            logger.info("itemEo ", (Object)JSON.toJSONString((Object)itemEo));
            if (Objects.nonNull(itemEo)) {
                detailEo.setProductName(itemEo.getProductName());
                detailEo.setSkuName(itemEo.getSkuName());
                detailEo.setCargoId(itemEo.getCargoId());
                detailEo.setInternalTransaction(itemEo.getInternalTransaction());
                detailEo.setRecommendPrice(itemEo.getRecommendPrice());
                detailEo.setCartonQuantity(itemEo.getCartonQuantity());
                detailEo.setSmallBottles(itemEo.getSmallBottles());
                detailEo.setWeight(itemEo.getWeight());
                detailEo.setVolume(itemEo.getVolume());
                detailEo.setCargoId(itemEo.getCargoId());
            }
            dailyDeliveryReportDetailEos.add(detailEo);
        }
        this.dailyDeliveryReportDetailDomain.insertBatch(dailyDeliveryReportDetailEos);
    }

    @Override
    public PageInfo<DgOutResultOrderEo> saveOcsDailyDeliveryReport(String startTime, String endTime, List<String> inWarehouseCodeList, List<String> neWarehouseCodeList) {
        logger.info("\u540c\u6b65OCS\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636estartTime:{} endTime:{} inWarehouseCodeList:{} neWarehouseCodeList:{}", new Object[]{startTime, endTime, inWarehouseCodeList, neWarehouseCodeList});
        AssertUtil.isTrue((StringUtils.isNotEmpty((CharSequence)startTime) && StringUtils.isNotEmpty((CharSequence)endTime) ? 1 : 0) != 0, (String)"\u4fdd\u5b58ocs\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo pageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outResultOrderDomain.filter().le((Object)"create_time", (Object)endTime)).ge((Object)"create_time", (Object)startTime)).eq((Object)"order_type", (Object)"out")).ne((Object)"out_physics_warehouse_code", (Object)PHYSICAL_WAREHOUSE_CODE)).notIn(CollectionUtils.isNotEmpty(neWarehouseCodeList), (Object)"out_physics_warehouse_code", neWarehouseCodeList)).in(CollectionUtils.isNotEmpty(inWarehouseCodeList), (Object)"out_physics_warehouse_code", inWarehouseCodeList)).in((Object)"order_status", Arrays.asList("oro_done_out", "oro_hang_up"))).notIn((Object)"business_type", NOT_CHARGE_TYPES)).page(Integer.valueOf(1), Integer.valueOf(10000));
        List dgOutResultOrderEoList = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)dgOutResultOrderEoList)) {
            logger.info("\u540c\u6b65OCS\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e \u65e0\u6570\u636e\u8fd4\u56de");
            return pageInfo;
        }
        HashSet resultDocumentNoSets = new HashSet();
        HashSet relevanceNoSets = new HashSet();
        HashSet transferResultDocumentNoSets = new HashSet();
        HashMap<String, List> outResultOrderEoMap = new HashMap<String, List>();
        HashSet physicsWarehouseCodes = new HashSet();
        HashSet logicWarehouseCodes = new HashSet();
        dgOutResultOrderEoList.forEach(e -> {
            if (StringUtils.isNotEmpty((CharSequence)e.getOutPhysicsWarehouseCode())) {
                physicsWarehouseCodes.add(e.getOutPhysicsWarehouseCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getOutLogicWarehouseCode())) {
                logicWarehouseCodes.add(e.getOutLogicWarehouseCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getInLogicWarehouseCode())) {
                logicWarehouseCodes.add(e.getInLogicWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)e.getDocumentNo())) {
                resultDocumentNoSets.add(e.getDocumentNo());
            }
            if (StringUtils.isNotBlank((CharSequence)e.getRelevanceNo())) {
                relevanceNoSets.add(e.getRelevanceNo());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getDocumentNo()) && StringUtils.isNotBlank((CharSequence)e.getRelevanceTableName()) && e.getRelevanceTableName().equals("cs_transfer_order")) {
                transferResultDocumentNoSets.add(e.getDocumentNo());
            }
            if (outResultOrderEoMap.containsKey(e.getConsignmentNo())) {
                ((List)outResultOrderEoMap.get(e.getConsignmentNo())).add(e);
            } else {
                ArrayList<DgOutResultOrderEo> list = new ArrayList<DgOutResultOrderEo>();
                list.add((DgOutResultOrderEo)e);
                outResultOrderEoMap.put(e.getConsignmentNo(), list);
            }
        });
        ArrayList resultDocumentNos = Lists.newArrayList(resultDocumentNoSets);
        ArrayList relevanceNos = Lists.newArrayList(relevanceNoSets);
        ArrayList transferResultDocumentNos = Lists.newArrayList(transferResultDocumentNoSets);
        logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: resultDocumentNos={}, relevanceNos={}, transferResultDocumentNos={}", new Object[]{resultDocumentNos.size(), relevanceNos.size(), transferResultDocumentNos.size()});
        ArrayList outResultOrderDetailEos = CollectionUtils.isEmpty((Collection)resultDocumentNos) ? new ArrayList() : (List)Optional.ofNullable(((ExtQueryChainWrapper)this.outResultOrderDetailDomain.filter().in((Object)"document_no", (Collection)resultDocumentNos)).list()).orElse(new ArrayList());
        logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: outResultOrderDetailEos={}", (Object)outResultOrderDetailEos.size());
        Map<String, List<DgOutResultOrderDetailEo>> outResultOrderDetailMap = outResultOrderDetailEos.stream().collect(Collectors.groupingBy(DgOutResultOrderDetailEo::getDocumentNo));
        List skuCodes = outResultOrderDetailEos.stream().map(DgOutResultOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        Map itemMap = CollectionUtils.isEmpty(skuCodes) ? new HashMap() : this.dailyDeliveryReportDetailDomain.queryItemDataBySkuCodes(skuCodes);
        Map addressMap = CollectionUtils.isEmpty((Collection)resultDocumentNos) ? new HashMap() : this.dailyDeliveryReportDomain.queryAddressByResultDocumentList((List)resultDocumentNos);
        Map transferAddressMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)transferResultDocumentNos)) {
            transferAddressMap = this.dailyDeliveryReportDomain.queryAddressByResultDocumentListByTransfer((List)transferResultDocumentNos);
        }
        DgWarehouseAddressPageReqDto dto = new DgWarehouseAddressPageReqDto();
        dto.setWarehouseCodes((List)Lists.newArrayList(physicsWarehouseCodes));
        List warehouseAddressDtos = this.warehouseAddressDomain.queryList(dto);
        Map warehouseAddressMap = ((List)Optional.ofNullable(warehouseAddressDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgWarehouseAddressDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map logicWarehouseEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgLogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map vehicleNumberMap = CollectionUtils.isEmpty((Collection)resultDocumentNos) ? new HashMap() : this.dailyDeliveryReportDomain.queryVehicleNumberByResultDocumentNoList((List)resultDocumentNos);
        long easStart = System.currentTimeMillis();
        ArrayList easByResultNos = CollectionUtils.isEmpty((Collection)resultDocumentNos) ? new ArrayList() : (List)Optional.ofNullable(this.iDailyDeliveryReportDas.getEasByResultNos((List)resultDocumentNos)).orElse(new ArrayList());
        long easNullCount = easByResultNos.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getOutResultNo())).filter(d -> d.getEasOrderNo() == null).count();
        Map<String, String> easOrderNoMap = easByResultNos.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getOutResultNo())).filter(d -> d.getEasOrderNo() != null).collect(Collectors.toMap(DailyDeliveryReportDto::getOutResultNo, DailyDeliveryReportDto::getEasOrderNo, (k1, k2) -> k1));
        logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: easByResultNos={}, easNullCount={}, easOrderNoMap={}, cost={}ms", new Object[]{easByResultNos.size(), easNullCount, easOrderNoMap.size(), System.currentTimeMillis() - easStart});
        List saleOrderRespEsVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)relevanceNos)) {
            GetSaleOrderListPageEsParams param = new GetSaleOrderListPageEsParams();
            param.setOrderNoList((List)relevanceNos);
            long saleStart = System.currentTimeMillis();
            try {
                logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: \u8c03\u7528querySaleOrderList, relevanceNos={}", (Object)relevanceNos.size());
                RestResponse saleOrderResp = this.tradeEsReportQueryApi.querySaleOrderList(param);
                saleOrderRespEsVoList = Optional.ofNullable(saleOrderResp).map(RestResponse::getData).orElse(new ArrayList());
                logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: saleOrderRespEsVoList={}, cost={}ms", (Object)saleOrderRespEsVoList.size(), (Object)(System.currentTimeMillis() - saleStart));
            }
            catch (Exception ex) {
                logger.error("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: querySaleOrderList\u5931\u8d25, relevanceNos={}, cost={}ms", new Object[]{relevanceNos.size(), System.currentTimeMillis() - saleStart, ex});
                throw ex;
            }
        }
        Map<String, List<SaleOrderRespEsVo>> saleOrderMap = ((List)Optional.ofNullable(saleOrderRespEsVoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(SaleOrderRespEsVo::getSaleOrderNo));
        HashMap otherStorageOrderMap = CollectionUtils.isEmpty((Collection)relevanceNos) ? new HashMap() : ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.dgOtherStorageOrderDomain.filter().in((Object)"storage_order_no", (Collection)relevanceNos)).list()).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgOtherStorageOrderEo::getStorageOrderNo));
        HashMap outPlannedOrderMap = CollectionUtils.isEmpty((Collection)relevanceNos) ? new HashMap() : ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.dgOutPlannedOrderDomain.filter().in((Object)"order_no", (Collection)relevanceNos)).list()).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgOutPlannedOrderEo::getOrderNo));
        HashMap transferOrderMap = CollectionUtils.isEmpty((Collection)relevanceNos) ? new HashMap() : ((List)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgTransferOrderDomain.filter().in((Object)"transfer_order_no", (Collection)relevanceNos)).eq((Object)"type", (Object)"out")).list()).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgTransferOrderEo::getTransferOrderNo));
        Map finalTransferAddressMap = transferAddressMap;
        ArrayList<DailyDeliveryReportDetailEo> dailyDeliveryReportDetailEos = new ArrayList<DailyDeliveryReportDetailEo>();
        HashMap detailCacheMap = new HashMap();
        logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: dgOutResultOrderEoList={}", (Object)dgOutResultOrderEoList.size());
        List<DailyDeliveryReportEo> dailyDeliveryReportEos = dgOutResultOrderEoList.stream().map(e -> {
            List<DailyDeliveryReportDetailEo> detailEos;
            DgLogicWarehouseEo inLogicWarehouseEo;
            DgLogicWarehouseEo logicWarehouseEo;
            DailyDeliveryReportEo vehicleNumberEo;
            List consignmentOrders;
            DailyDeliveryReportEo eo = new DailyDeliveryReportEo();
            eo.setId(Long.valueOf(IdWorker.getId()));
            eo.setDataSource(DailyDeliveryReportDataSourceEnum.OCS.getCode());
            eo.setInventoryOrganizationName(e.getOrganizationName());
            eo.setOrderCreateTime(e.getBizDate());
            eo.setOrderShippingTime(e.getCreateTime());
            eo.setMuchDeliveryFlag(Integer.valueOf(0));
            eo.setWmsOrderType("OCS");
            DailyDeliveryReportEo transferAddressEo = (DailyDeliveryReportEo)finalTransferAddressMap.get(e.getDocumentNo());
            DailyDeliveryReportEo addressEo = (DailyDeliveryReportEo)addressMap.get(e.getDocumentNo());
            DailyDeliveryReportEo selAddressEo = new DailyDeliveryReportEo();
            selAddressEo = StringUtils.isNotBlank((CharSequence)e.getRelevanceTableName()) && e.getRelevanceTableName().equals("cs_transfer_order") ? (ObjectUtils.isNotEmpty((Object)transferAddressEo) ? transferAddressEo : addressEo) : addressEo;
            if (Objects.nonNull(selAddressEo)) {
                eo.setReceivingPerson(selAddressEo.getReceivingPerson());
                eo.setReceivingAddressProvinceCode(selAddressEo.getReceivingAddressProvinceCode());
                eo.setReceivingAddressProvince(selAddressEo.getReceivingAddressProvince());
                eo.setReceivingAddressCityCode(selAddressEo.getReceivingAddressCityCode());
                eo.setReceivingAddressCity(selAddressEo.getReceivingAddressCity());
                eo.setReceivingAddressDistrictCode(selAddressEo.getReceivingAddressDistrictCode());
                eo.setReceivingAddressDistrict(selAddressEo.getReceivingAddressDistrict());
                eo.setReceivingAddress(selAddressEo.getReceivingAddress());
                eo.setReceivingPersonPhone(selAddressEo.getReceivingPersonPhone());
                eo.setOrderCreateTime(selAddressEo.getOrderCreateTime());
            }
            eo.setDocumentNo(e.getWmsOrderNo());
            eo.setWmsOrderNo(e.getWmsOrderNo());
            eo.setPickingOrderNo(e.getWmsOrderNo());
            eo.setConsignmentNo(e.getConsignmentNo());
            eo.setRelevanceNo(e.getRelevanceNo());
            eo.setOutNoticeNo(e.getPreOrderNo());
            eo.setOutResultNo(e.getDocumentNo());
            eo.setTransportNo(e.getShippingCode());
            eo.setTotalQuantity(e.getTotalQuantity());
            eo.setTotalCartons(e.getTotalCartons());
            eo.setTotalVolume(e.getTotalVolume());
            eo.setTotalWeight(e.getTotalWeight());
            eo.setBillingCartons(e.getTotalCartons());
            eo.setBillingVolume(e.getTotalVolume());
            eo.setBillingWeight(e.getTotalWeight());
            eo.setShippingCompany(e.getShippingCompanyCode());
            eo.setShippingCompanyName(e.getShippingCompany());
            eo.setShipmentEnterpriseCode(e.getShippingCompanyCode());
            eo.setShipmentEnterpriseName(e.getShippingCompany());
            eo.setBusinessType(e.getBusinessType());
            CsShipmentLogisticsTypeEnum enumByName = CsShipmentLogisticsTypeEnum.getEnumByName((String)e.getShippingType());
            if (enumByName == null) {
                logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u627f\u8fd0\u65b9\u5f0f\u6620\u5c04\u4e0d\u5230\u7f16\u7801 {}", (Object)e.getDocumentNo(), (Object)e.getShippingType());
                eo.setTransportStyle(e.getShippingType());
            } else {
                eo.setTransportStyleCode(enumByName.getType() + "");
                eo.setTransportStyle(e.getShippingType());
            }
            eo.setShopCode(e.getShopCode());
            eo.setShopName(e.getShopName());
            eo.setRemark(e.getRemark());
            eo.setDifferentFlag(Integer.valueOf(0));
            eo.setCreatePerson("OCS");
            eo.setUpdatePerson(eo.getCreatePerson());
            eo.setPhysicalWarehouse(e.getOutPhysicsWarehouseName());
            eo.setPhysicalWarehouseCode(e.getOutPhysicsWarehouseCode());
            eo.setLogicWarehouse(e.getOutLogicWarehouseName());
            eo.setLogicWarehouseCode(e.getOutLogicWarehouseCode());
            eo.setInPhysicalWarehouse(e.getInPhysicsWarehouseName());
            eo.setInPhysicalWarehouseCode(e.getInPhysicsWarehouseCode());
            eo.setInLogicWarehouse(e.getInLogicWarehouseName());
            eo.setInLogicWarehouseCode(e.getInLogicWarehouseCode());
            if (StringUtils.isNotEmpty((CharSequence)e.getExtension())) {
                JSONObject object = JSONObject.parseObject((String)e.getExtension());
                Optional.ofNullable(object.getString("mergeOrderNo")).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(arg_0 -> ((DailyDeliveryReportEo)eo).setJoinMergeDocumentNo(arg_0));
            }
            if (CollectionUtils.isNotEmpty((Collection)(consignmentOrders = (List)outResultOrderEoMap.get(e.getConsignmentNo()))) && consignmentOrders.size() > 1) {
                eo.setJoinMergeDocumentNo(e.getConsignmentNo());
            }
            if (eo.getJoinMergeDocumentNo() == null || StringUtils.equals((CharSequence)"null", (CharSequence)eo.getJoinMergeDocumentNo())) {
                eo.setJoinMergeDocumentNo("");
            }
            if (Objects.nonNull(vehicleNumberEo = (DailyDeliveryReportEo)vehicleNumberMap.get(e.getDocumentNo()))) {
                eo.setVehicleNumber(vehicleNumberEo.getVehicleNumber());
            }
            if (Objects.nonNull(logicWarehouseEo = (DgLogicWarehouseEo)logicWarehouseEoMap.get(e.getOutLogicWarehouseCode()))) {
                eo.setInventoryOrganizationCode(logicWarehouseEo.getOrganizationCode());
                eo.setInventoryOrganizationName(logicWarehouseEo.getOrganizationName());
                eo.setInventoryOrganizationId(logicWarehouseEo.getOrganizationId());
                eo.setCostOrgName(logicWarehouseEo.getCostOrgName());
                eo.setCostOrgCode(logicWarehouseEo.getCostOrg());
                eo.setCostOrgId(logicWarehouseEo.getCostOrgId());
                eo.setOutInventoryOrgId(logicWarehouseEo.getCargoEscheatageId());
                eo.setOutInventoryOrg(logicWarehouseEo.getCargoEscheatageName());
            } else {
                eo.setInventoryOrganizationName(e.getOrganizationName());
                eo.setInventoryOrganizationId(e.getOrganizationId());
                eo.setCostOrgName(e.getOrganizationName());
                eo.setCostOrgId(e.getOrganizationId());
            }
            List transferOrderEos = (List)transferOrderMap.get(e.getRelevanceNo());
            List dgSaleOrderEos = (List)saleOrderMap.get(e.getRelevanceNo());
            List dgOutPlannedOrderEos = (List)outPlannedOrderMap.get(e.getRelevanceNo());
            List dgOtherStorageOrderEos = (List)otherStorageOrderMap.get(e.getRelevanceNo());
            String easOrderNo = (String)easOrderNoMap.get(e.getDocumentNo());
            if (StringUtils.isNotBlank((CharSequence)easOrderNo)) {
                eo.setEasOrderNo(easOrderNo);
            }
            if (CollectionUtils.isNotEmpty((Collection)transferOrderEos)) {
                eo.setReceivingCustomer(((DgTransferOrderEo)transferOrderEos.get(0)).getCustomerName());
                eo.setOrderCreateTime(((DgTransferOrderEo)transferOrderEos.get(0)).getCreateTime());
            } else if (CollectionUtils.isNotEmpty((Collection)dgSaleOrderEos)) {
                if (StringUtils.isBlank((CharSequence)eo.getEasOrderNo())) {
                    eo.setEasOrderNo(((SaleOrderRespEsVo)dgSaleOrderEos.get(0)).getEasOrderNo());
                }
                eo.setReceivingCustomer(((SaleOrderRespEsVo)dgSaleOrderEos.get(0)).getCustomerName());
                eo.setOrderCreateTime(((SaleOrderRespEsVo)dgSaleOrderEos.get(0)).getSaleCreateTime());
            } else if (CollectionUtils.isNotEmpty((Collection)dgOutPlannedOrderEos)) {
                eo.setReceivingCustomer(((DgOutPlannedOrderEo)dgOutPlannedOrderEos.get(0)).getSupplierName());
                eo.setOrderCreateTime(((DgOutPlannedOrderEo)dgOutPlannedOrderEos.get(0)).getCreateTime());
            } else if (CollectionUtils.isNotEmpty((Collection)dgOtherStorageOrderEos)) {
                eo.setReceivingCustomer(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getCustomerName());
                eo.setReceivingPerson(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getConsignee());
                eo.setReceivingAddressProvinceCode(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getProvinceCode());
                eo.setReceivingAddressProvince(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getProvinceName());
                eo.setReceivingAddressCityCode(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getCityCode());
                eo.setReceivingAddressCity(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getCityName());
                eo.setReceivingAddressDistrictCode(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getAreaCode());
                eo.setReceivingAddressDistrict(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getAreaName());
                eo.setReceivingAddress(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getAddress());
                eo.setReceivingPersonPhone(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getPhone());
                eo.setOrderCreateTime(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getCreateTime());
                if (StringUtils.isBlank((CharSequence)eo.getEasOrderNo())) {
                    eo.setEasOrderNo(((DgOtherStorageOrderEo)dgOtherStorageOrderEos.get(0)).getExternalOrderNo());
                }
            } else {
                logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5339\u914d\u4e0d\u5230\u4efb\u4f55\u4e1a\u52a1\u5355\u636e\u6570\u636e", (Object)e.getDocumentNo());
            }
            DgWarehouseAddressDto warehouseAddressDto = (DgWarehouseAddressDto)warehouseAddressMap.get(eo.getPhysicalWarehouseCode());
            if (Objects.nonNull(warehouseAddressDto)) {
                eo.setStartProvinceCode(warehouseAddressDto.getProvinceCode());
                eo.setStartProvince(warehouseAddressDto.getProvince());
                eo.setStartCityCode(warehouseAddressDto.getCityCode());
                eo.setStartCity(warehouseAddressDto.getCity());
            }
            if (Objects.nonNull(inLogicWarehouseEo = (DgLogicWarehouseEo)logicWarehouseEoMap.get(eo.getInLogicWarehouseCode()))) {
                eo.setInInventoryOrgId(inLogicWarehouseEo.getCargoEscheatageId());
                eo.setInInventoryOrg(inLogicWarehouseEo.getCargoEscheatageName());
            }
            if (CollectionUtils.isNotEmpty(detailEos = this.buildDailyDeliveryReportDetails(outResultOrderDetailMap, itemMap, e.getDocumentNo(), eo.getId()))) {
                dailyDeliveryReportDetailEos.addAll(detailEos);
                detailCacheMap.put(e.getDocumentNo(), detailEos);
            }
            if (StringUtils.equals((CharSequence)"null", (CharSequence)eo.getJoinMergeDocumentNo())) {
                eo.setJoinMergeDocumentNo("");
            }
            logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u63d2\u5165\u6570\u636e", (Object)e.getDocumentNo());
            return eo;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)resultDocumentNos)) {
            this.dailyDeliveryReportDomain.batchDeleteByResultDocumentList((List)resultDocumentNos);
        }
        ArrayList mergeDailyDeliveryReportEos = new ArrayList();
        ArrayList mergeDailyDeliveryReportDetailEos = new ArrayList();
        Map<String, List<DailyDeliveryReportEo>> consignmentReportMap = dailyDeliveryReportEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getConsignmentNo())).collect(Collectors.groupingBy(DailyDeliveryReportEo::getConsignmentNo));
        outResultOrderEoMap.forEach((consignmentNo, orderList) -> {
            if (StringUtils.isBlank((CharSequence)consignmentNo) || CollectionUtils.isEmpty((Collection)orderList) || orderList.size() <= 1) {
                return;
            }
            List childReports = (List)consignmentReportMap.get(consignmentNo);
            if (CollectionUtils.isEmpty((Collection)childReports)) {
                return;
            }
            DailyDeliveryReportEo baseReport = (DailyDeliveryReportEo)childReports.get(0);
            if (baseReport.getJoinMergeDocumentNo() == null || StringUtils.equals((CharSequence)"null", (CharSequence)baseReport.getJoinMergeDocumentNo())) {
                baseReport.setJoinMergeDocumentNo("");
            }
            DailyDeliveryReportEo mergeReport = new DailyDeliveryReportEo();
            BeanUtils.copyProperties((Object)baseReport, (Object)mergeReport);
            mergeReport.setId(Long.valueOf(IdWorker.getId()));
            mergeReport.setWmsOrderType("\u5408\u5355\u751f\u6210");
            mergeReport.setWmsMergeDocumentNo(consignmentNo);
            mergeReport.setJoinMergeDocumentNo("");
            mergeReport.setDocumentNo(baseReport.getDocumentNo());
            mergeReport.setWmsOrderNo(consignmentNo);
            mergeReport.setTotalQuantity(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getTotalQuantity));
            mergeReport.setTotalCartons(baseReport.getTotalCartons());
            mergeReport.setTotalVolume(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getTotalVolume));
            mergeReport.setTotalWeight(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getTotalWeight));
            mergeReport.setBillingCartons(baseReport.getBillingCartons());
            mergeReport.setBillingVolume(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getBillingVolume));
            mergeReport.setBillingWeight(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getBillingWeight));
            mergeReport.setWmsTotalQuantity(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getWmsTotalQuantity));
            mergeReport.setWmsTotalCartons(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getWmsTotalCartons));
            mergeReport.setWmsTotalVolume(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getWmsTotalVolume));
            mergeReport.setWmsTotalWeight(this.sumBigDecimal(childReports, DailyDeliveryReportEo::getWmsTotalWeight));
            mergeDailyDeliveryReportEos.add(mergeReport);
            orderList.forEach(order -> {
                List cachedDetails = (List)detailCacheMap.get(order.getDocumentNo());
                if (CollectionUtils.isNotEmpty((Collection)cachedDetails)) {
                    mergeDailyDeliveryReportDetailEos.addAll(this.copyDetailsWithReportId(cachedDetails, mergeReport.getId()));
                } else {
                    List<DailyDeliveryReportDetailEo> detailEos = this.buildDailyDeliveryReportDetails(outResultOrderDetailMap, itemMap, order.getDocumentNo(), mergeReport.getId());
                    if (CollectionUtils.isNotEmpty(detailEos)) {
                        mergeDailyDeliveryReportDetailEos.addAll(detailEos);
                    }
                }
            });
        });
        dailyDeliveryReportEos.addAll(mergeDailyDeliveryReportEos);
        logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: \u5f85\u63d2\u5165\u62a5\u8868\u5355\u6570={}, \u5f85\u63d2\u5165\u660e\u7ec6\u6761\u6570={}", (Object)dailyDeliveryReportEos.size(), (Object)dailyDeliveryReportDetailEos.size());
        this.insertDailyDeliveryReportsInBatches(dailyDeliveryReportEos);
        logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: \u62a5\u8868\u63d2\u5165\u5b8c\u6210, \u6570\u91cf={}", (Object)dailyDeliveryReportEos.size());
        if (CollectionUtils.isNotEmpty(mergeDailyDeliveryReportDetailEos)) {
            dailyDeliveryReportDetailEos.addAll(mergeDailyDeliveryReportDetailEos);
        }
        if (CollectionUtils.isNotEmpty(dailyDeliveryReportDetailEos)) {
            this.insertDailyDeliveryReportDetailsInBatches(dailyDeliveryReportDetailEos);
            logger.info("\u51fa\u5e93\u7ed3\u679c\u5355\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868: \u660e\u7ec6\u63d2\u5165\u5b8c\u6210, \u6570\u91cf={}", (Object)dailyDeliveryReportDetailEos.size());
        }
        return pageInfo;
    }

    private List<DailyDeliveryReportDetailEo> buildDailyDeliveryReportDetails(Map<String, List<DgOutResultOrderDetailEo>> outResultOrderDetailMap, Map<String, DailyDeliveryReportDetailEo> itemMap, String documentNo, Long reportId) {
        if (StringUtils.isBlank((CharSequence)documentNo)) {
            return new ArrayList<DailyDeliveryReportDetailEo>();
        }
        List<DgOutResultOrderDetailEo> detailEos = outResultOrderDetailMap.get(documentNo);
        if (CollectionUtils.isEmpty(detailEos)) {
            return new ArrayList<DailyDeliveryReportDetailEo>();
        }
        ArrayList<DailyDeliveryReportDetailEo> dailyDeliveryReportDetailEos = new ArrayList<DailyDeliveryReportDetailEo>();
        for (DgOutResultOrderDetailEo resultOrderDetailEo : detailEos) {
            DailyDeliveryReportDetailEo detailEo = new DailyDeliveryReportDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)resultOrderDetailEo, (String[])new String[]{"id", "create_time", "update_time"});
            detailEo.setDailyDeliveryReportId(reportId);
            detailEo.setCargoCode(resultOrderDetailEo.getSkuCode());
            detailEo.setLongCode(resultOrderDetailEo.getSkuCode());
            detailEo.setProductName(resultOrderDetailEo.getSkuName());
            detailEo.setQuantity(resultOrderDetailEo.getDoneQuantity());
            detailEo.setPreOrderItemId(resultOrderDetailEo.getTradeOrderItemId());
            DailyDeliveryReportDetailEo itemEo = itemMap.get(detailEo.getLongCode());
            if (Objects.nonNull(itemEo)) {
                detailEo.setInternalTransaction(itemEo.getInternalTransaction());
                detailEo.setRecommendPrice(itemEo.getRecommendPrice());
                detailEo.setCartonQuantity(itemEo.getCartonQuantity());
                detailEo.setSmallBottles(itemEo.getSmallBottles());
                detailEo.setWeight(itemEo.getWeight());
                detailEo.setVolume(itemEo.getVolume());
                detailEo.setCargoId(itemEo.getCargoId());
            }
            dailyDeliveryReportDetailEos.add(detailEo);
        }
        return dailyDeliveryReportDetailEos;
    }

    private List<DailyDeliveryReportDetailEo> copyDetailsWithReportId(List<DailyDeliveryReportDetailEo> sourceDetails, Long reportId) {
        if (CollectionUtils.isEmpty(sourceDetails)) {
            return new ArrayList<DailyDeliveryReportDetailEo>();
        }
        ArrayList<DailyDeliveryReportDetailEo> copiedDetails = new ArrayList<DailyDeliveryReportDetailEo>(sourceDetails.size());
        for (DailyDeliveryReportDetailEo sourceDetail : sourceDetails) {
            DailyDeliveryReportDetailEo copiedDetail = (DailyDeliveryReportDetailEo)BeanUtil.copyProperties((Object)sourceDetail, DailyDeliveryReportDetailEo.class, (String[])new String[0]);
            copiedDetail.setId(null);
            copiedDetail.setDailyDeliveryReportId(reportId);
            copiedDetails.add(copiedDetail);
        }
        return copiedDetails;
    }

    private void insertDailyDeliveryReportsInBatches(List<DailyDeliveryReportEo> reports) {
        if (CollectionUtils.isEmpty(reports)) {
            return;
        }
        for (int i = 0; i < reports.size(); i += 1000) {
            int end = Math.min(i + 1000, reports.size());
            this.iDailyDeliveryReportDas.insertBatch(reports.subList(i, end));
        }
    }

    private void insertDailyDeliveryReportDetailsInBatches(List<DailyDeliveryReportDetailEo> details) {
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        for (int i = 0; i < details.size(); i += 1000) {
            int end = Math.min(i + 1000, details.size());
            this.dailyDeliveryReportDetailDomain.insertBatch(details.subList(i, end));
        }
    }

    private BigDecimal sumBigDecimal(List<DailyDeliveryReportEo> reportEos, Function<DailyDeliveryReportEo, BigDecimal> getter) {
        if (CollectionUtils.isEmpty(reportEos)) {
            return null;
        }
        boolean hasValue = false;
        BigDecimal total = BigDecimal.ZERO;
        for (DailyDeliveryReportEo reportEo : reportEos) {
            BigDecimal value = getter.apply(reportEo);
            if (value == null) continue;
            total = total.add(value);
            hasValue = true;
        }
        return hasValue ? total : null;
    }

    private void matchRegionCode(DailyDeliveryReportEo eo) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\u5339\u914d\u7701\u5e02\u533a\u7f16\u7801\uff1a{}", (Object)eo);
        if (StringUtils.isEmpty((CharSequence)eo.getReceivingAddressProvince()) && StringUtils.isEmpty((CharSequence)eo.getReceivingAddressCity()) && StringUtils.isEmpty((CharSequence)eo.getReceivingAddressDistrict())) {
            logger.info("\u65e0\u7701\u5e02\u533a\u9700\u8981\u5339\u914d\uff1a{}", (Object)eo.getWmsOrderNo());
            return;
        }
        PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
        List regionNames = Stream.of(eo.getReceivingAddressProvince(), eo.getReceivingAddressCity(), eo.getReceivingAddressDistrict()).filter(Objects::nonNull).collect(Collectors.toList());
        pcpRegionReqDto.setNameList(regionNames);
        pcpRegionReqDto.setPageNum(Integer.valueOf(1));
        pcpRegionReqDto.setPageSize(Integer.valueOf(1000));
        logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f {}", (Object)eo.getWmsOrderNo(), (Object)JSON.toJSONString((Object)pcpRegionReqDto));
        List respDtoList = (List)com.yunxi.dg.base.commons.utils.RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)respDtoList), (String)"\u627e\u4e0d\u5230\u884c\u653f\u533a\u57df\u4fe1\u606f");
        logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f\u7ed3\u679c {}", (Object)eo.getWmsOrderNo(), (Object)JSON.toJSONString((Object)respDtoList));
        Map<String, List<PcpRegionRespDto>> stringListMap = respDtoList.stream().collect(Collectors.groupingBy(PcpRegionRespDto::getName));
        PcpRegionRespDto province = respDtoList.stream().filter(ld -> Objects.equals("0", ld.getParentCode()) && Objects.equals(ld.getName(), eo.getReceivingAddressProvince())).findFirst().orElse(null);
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)province), (String)"\u5339\u914d\u4e0d\u5230\u7701\u4efd\u4fe1\u606f");
        eo.setReceivingAddressProvinceCode(province.getCode());
        if (StringUtils.isNotBlank((CharSequence)eo.getReceivingAddressCity())) {
            PcpRegionRespDto city = respDtoList.stream().filter(ld -> Objects.equals(province.getCode(), ld.getParentCode()) && Objects.equals(ld.getName(), eo.getReceivingAddressCity())).findFirst().orElse(null);
            AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)city), (String)"\u5339\u914d\u4e0d\u5230\u5e02\u4fe1\u606f");
            eo.setReceivingAddressCityCode(city.getCode());
            if (StringUtils.isNotBlank((CharSequence)eo.getReceivingAddressDistrict())) {
                PcpRegionRespDto district = respDtoList.stream().filter(ld -> Objects.equals(city.getCode(), ld.getParentCode()) && Objects.equals(ld.getName(), eo.getReceivingAddressDistrict())).findFirst().orElse(null);
                AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)district), (String)"\u5339\u914d\u4e0d\u5230\u533a\u4fe1\u606f");
                eo.setReceivingAddressDistrictCode(district.getCode());
            }
        }
    }

    private void supplementRegionCode(DailyDeliveryReportEo eo) {
        if (StringUtils.isEmpty((CharSequence)eo.getReceivingAddressProvince()) && StringUtils.isEmpty((CharSequence)eo.getReceivingAddressCity()) && StringUtils.isEmpty((CharSequence)eo.getReceivingAddressDistrict())) {
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u7701\u5e02\u533a\u540d\u79f0\u90fd\u4e3a\u7a7a\uff0c\u4e0d\u5339\u914d", (Object)eo.getWmsOrderNo());
        } else {
            PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
            List regionNames = Stream.of(eo.getReceivingAddressProvince(), eo.getReceivingAddressCity(), eo.getReceivingAddressDistrict()).filter(Objects::nonNull).collect(Collectors.toList());
            pcpRegionReqDto.setNameList(regionNames);
            pcpRegionReqDto.setPageNum(Integer.valueOf(1));
            pcpRegionReqDto.setPageSize(Integer.valueOf(1000));
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f {}", (Object)eo.getWmsOrderNo(), (Object)JSON.toJSONString((Object)pcpRegionReqDto));
            List respDtoList = (List)com.yunxi.dg.base.commons.utils.RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f\u7ed3\u679c {}", (Object)eo.getWmsOrderNo(), (Object)JSON.toJSONString((Object)respDtoList));
            if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
                Map<String, List<PcpRegionRespDto>> stringListMap = respDtoList.stream().collect(Collectors.groupingBy(PcpRegionRespDto::getName));
                PcpRegionRespDto shengRegionRespDto = respDtoList.stream().filter(ld -> Objects.equals("0", ld.getParentCode()) && Objects.equals(ld.getName(), eo.getReceivingAddressProvince())).findFirst().orElse(null);
                if (shengRegionRespDto != null) {
                    eo.setReceivingAddressProvinceCode(shengRegionRespDto.getCode());
                    PcpRegionRespDto shiRegionRespDto = respDtoList.stream().filter(ld -> Objects.equals(shengRegionRespDto.getCode(), ld.getParentCode()) && Objects.equals(ld.getName(), eo.getReceivingAddressCity())).findFirst().orElse(null);
                    if (shiRegionRespDto != null) {
                        eo.setReceivingAddressCityCode(shiRegionRespDto.getCode());
                        PcpRegionRespDto quRegionRespDto = respDtoList.stream().filter(ld -> Objects.equals(shiRegionRespDto.getCode(), ld.getParentCode()) && Objects.equals(ld.getName(), eo.getReceivingAddressDistrict())).findFirst().orElse(null);
                        if (quRegionRespDto != null) {
                            eo.setReceivingAddressDistrictCode(quRegionRespDto.getCode());
                        } else {
                            logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5339\u914d\u4e0d\u5230\u533a\uff0c\u76f4\u63a5\u6620\u5c04\u533a\u7ed3\u679c", (Object)eo.getWmsOrderNo());
                            eo.setReceivingAddressDistrictCode((String)Optional.ofNullable(stringListMap.get(eo.getReceivingAddressDistrict())).map(ld -> ((PcpRegionRespDto)ld.get(0)).getCode()).orElse(null));
                        }
                    } else {
                        logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5339\u914d\u4e0d\u5230\u7701\uff0c\u76f4\u63a5\u6620\u5c04\u5e02\u533a\u7ed3\u679c", (Object)eo.getWmsOrderNo());
                        eo.setReceivingAddressCityCode((String)Optional.ofNullable(stringListMap.get(eo.getReceivingAddressCity())).map(ld -> ((PcpRegionRespDto)ld.get(0)).getCode()).orElse(null));
                        eo.setReceivingAddressDistrictCode((String)Optional.ofNullable(stringListMap.get(eo.getReceivingAddressDistrict())).map(ld -> ((PcpRegionRespDto)ld.get(0)).getCode()).orElse(null));
                    }
                } else {
                    logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u5339\u914d\u4e0d\u5230\u7701\uff0c\u76f4\u63a5\u6620\u5c04\u7701\u5e02\u533a\u7ed3\u679c", (Object)eo.getWmsOrderNo());
                    eo.setReceivingAddressProvinceCode((String)Optional.ofNullable(stringListMap.get(eo.getReceivingAddressProvince())).map(ld -> ((PcpRegionRespDto)ld.get(0)).getCode()).orElse(null));
                    eo.setReceivingAddressCityCode((String)Optional.ofNullable(stringListMap.get(eo.getReceivingAddressCity())).map(ld -> ((PcpRegionRespDto)ld.get(0)).getCode()).orElse(null));
                    eo.setReceivingAddressDistrictCode((String)Optional.ofNullable(stringListMap.get(eo.getReceivingAddressDistrict())).map(ld -> ((PcpRegionRespDto)ld.get(0)).getCode()).orElse(null));
                }
            } else {
                logger.info("wms\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868 {} \u641c\u7d22\u7701\u5e02\u533a\u540d\u79f0\u7ed3\u679c\u4e3a\u7a7a\uff0c\u5339\u914d\u5931\u8d25", (Object)eo.getWmsOrderNo());
            }
        }
    }

    @Override
    public RestResponse<DailyDeliveryReportDto> queryByWMS(String wms) {
        List dailyDeliveryReportDtoList = this.iDailyDeliveryReportDas.queryByWMS(wms);
        if (CollectionUtils.isNotEmpty((Collection)dailyDeliveryReportDtoList) && dailyDeliveryReportDtoList.size() > 1) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u552f\u4e00\u5355\u636e");
        }
        if (CollectionUtils.isNotEmpty((Collection)dailyDeliveryReportDtoList)) {
            return new RestResponse(dailyDeliveryReportDtoList.get(0));
        }
        return new RestResponse(null);
    }

    @Override
    public List<DailyDeliveryReportDto> queryByDocumentNo(List<String> documentNoList) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u67e5\u8be2queryByDocumentNo\uff1a{}", documentNoList);
        documentNoList = documentNoList.stream().distinct().collect(Collectors.toList());
        List eoList = ((ExtQueryChainWrapper)this.iDailyDeliveryReportDas.filter().in((Object)"document_no", documentNoList)).list();
        ArrayList<DailyDeliveryReportDto> list = new ArrayList<DailyDeliveryReportDto>();
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            CubeBeanUtils.copyCollection(list, (Collection)eoList, DailyDeliveryReportDto.class);
        }
        return list;
    }

    @Override
    public void synchronousMonthDataByDate(String date) {
        logger.info("\u6309\u5165\u53c2\u65f6\u95f4\u540c\u6b65\u6574\u6708\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5165\u53c2 ", (Object)date);
        AssertUtil.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)date), (String)"\u6309\u5165\u53c2\u65f6\u95f4\u540c\u6b65\u6574\u6708\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        String now = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM");
        if (StringUtils.equals((CharSequence)now, (CharSequence)date)) {
            logger.info("\u5165\u53c2\u65f6\u95f4\u548c\u5f53\u524d\u5e74\u6708\u4e00\u81f4\uff0c\u8c03\u7528\u540c\u6b65\u672c\u6708\u6570\u636e");
            this.synchronousMonthData();
            return;
        }
        logger.info("\u6309\u5165\u53c2\u65f6\u95f4\u540c\u6b65\u6574\u6708\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5f00\u59cb");
        Date month = DateUtil.parseDate((String)date, (String)"yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(month);
        int datInMonth = calendar.getActualMaximum(5);
        for (int i = 1; i <= datInMonth; ++i) {
            calendar.set(5, i);
            String day = DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd");
            String startTime = day + " 00:00:00";
            String endTime = day + " 23:59:59";
            this.queryDailyDeliveryData(startTime, endTime);
        }
    }

    @Override
    public DailyDeliveryReportDto getByGroup(String documentNo, String consignmentNo, String transportNo) {
        return this.iDailyDeliveryReportDas.getByGroup(documentNo, consignmentNo, transportNo);
    }

    @Override
    public RestResponse<Integer> add(DailyDeliveryReportDetailProductDto dto) {
        DailyDeliveryReportDetailEo eo = new DailyDeliveryReportDetailEo();
        BeanUtils.copyProperties((Object)dto, (Object)eo);
        logger.info("\u63d2\u5165\u62a5\u8868\u540e\u660e\u7ec6\u5bf9\u8c61:{}", (Object)eo);
        return new RestResponse((Object)this.dailyDeliveryReportDetailDomain.insert((BaseEo)eo));
    }

    @Override
    public RestResponse<String> getStartPlace(String outLogicWarehouseCode) {
        return new RestResponse((Object)this.iDailyDeliveryReportDas.getStartPlace(outLogicWarehouseCode));
    }

    @Override
    public RestResponse<DailyDeliveryReportExtraDto> getExtraBody(String documentNo) {
        DailyDeliveryReportExtraDto dto = new DailyDeliveryReportExtraDto();
        List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dailyDeliveryReportDomain.filter().eq((Object)"out_notice_no", (Object)documentNo)).eq((Object)"much_delivery_flag", (Object)0)).eq((Object)"dr", (Object)0)).list();
        logger.info("\u603b\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)eoList));
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            DailyDeliveryReportEo eo = (DailyDeliveryReportEo)eoList.get(0);
            BeanUtils.copyProperties((Object)eo, (Object)dto);
        }
        logger.info("\u8fd4\u56de\u8865\u5145\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return new RestResponse((Object)dto);
    }

    @Override
    public RestResponse<Map<String, DailyDeliveryReportDetailDtEo>> getItemByLongCode(@RequestBody List<String> longCodes) {
        Map oldMap = this.dailyDeliveryReportDetailDomain.queryItemDataBySkuCodes(longCodes);
        HashMap Map2 = new HashMap();
        for (Map.Entry entry : oldMap.entrySet()) {
            DailyDeliveryReportDetailDtEo eo = new DailyDeliveryReportDetailDtEo();
            logger.info("\u67e5\u8be2\u5230\u7684\u5546\u54c1\u4fe1\u606f:{}", entry.getValue());
            BeanUtils.copyProperties(entry.getValue(), (Object)eo);
            logger.info("\u83b7\u53d6\u5230\u7684\u5546\u54c1\u4fe1\u606f:{}", (Object)eo);
            Map2.put(entry.getKey(), eo);
        }
        return new RestResponse(Map2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<DailyDeliveryReportDto> queryList(DailyDeliveryReportDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        DailyDeliveryReportEo dailyDeliveryReportEo = (DailyDeliveryReportEo)BeanUtil.copyProperties((Object)dto, DailyDeliveryReportEo.class, (String[])new String[0]);
        AssertUtil.isFalse((StringUtils.isBlank((CharSequence)dailyDeliveryReportEo.getWmsMergeDocumentNo()) && StringUtils.isBlank((CharSequence)dailyDeliveryReportEo.getJoinMergeDocumentNo()) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        List dailyDeliveryReportEos = this.dailyDeliveryReportDomain.selectList((BaseEo)dailyDeliveryReportEo);
        if (CollectionUtils.isNotEmpty((Collection)dailyDeliveryReportEos)) {
            return BeanUtil.copyToList((Collection)dailyDeliveryReportEos, DailyDeliveryReportDto.class);
        }
        return new ArrayList<DailyDeliveryReportDto>();
    }

    @Override
    public RestResponse<Void> del(List<Long> ids) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\u5220\u9664\uff1a{}", (Object)JSON.toJSONString(ids));
        List dailyDeliveryReportEos = this.dailyDeliveryReportDomain.selectByIds(ids);
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)dailyDeliveryReportEos), (String)"\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        List filterList = dailyDeliveryReportEos.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getDataSource()) && !f.getDataSource().equals(DailyDeliveryReportDataSourceEnum.ONE_IMP.getCode()) && !f.getDataSource().equals(DailyDeliveryReportDataSourceEnum.NOT_IMP.getCode())).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtils.isNotEmpty(filterList), (String)"\u53ea\u80fd\u5220\u9664\u5bfc\u5165\u6570\u636e");
        ids.forEach(id -> {
            this.dailyDeliveryReportDomain.logicDeleteById(id);
            List detailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dailyDeliveryReportDetailDomain.filter().eq((Object)"daily_delivery_report_id", id)).eq((Object)"dr", (Object)0)).list();
            if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                List detailIds = detailEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.dailyDeliveryReportDetailDomain.logicDeleteByIds(detailIds);
            }
        });
        return RestResponse.VOID;
    }

    @Override
    public void synchronousDayDataByDate(String startDate, String endDate) {
        logger.info("\u6839\u636e\u65e5\u671f\u540c\u6b65\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        String requestId = ServiceContext.getContext().getRequestId();
        CompletableFuture.runAsync(() -> {
            MDC.put((String)"yes.req.requestId", (String)requestId);
            this.queryDailyDeliveryData(startDate, endDate);
        });
    }

    @Override
    public void synchronousDayData(SynchronousDayDataDto synchronousDayData) {
        logger.info("\u540c\u6b65\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636esynchronousDayData\uff1a{}", (Object)JSON.toJSONString((Object)synchronousDayData));
        AssertUtil.isFalse((StringUtils.isBlank((CharSequence)synchronousDayData.getStartDate()) || StringUtils.isBlank((CharSequence)synchronousDayData.getStartDate()) ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)synchronousDayData.getWarehouseCodeList())) {
            this.synchronousDayDataByDate(synchronousDayData.getStartDate(), synchronousDayData.getEndDate());
            return;
        }
        String requestId = ServiceContext.getContext().getRequestId();
        CompletableFuture.runAsync(() -> {
            MDC.put((String)"yes.req.requestId", (String)requestId);
            this.synchronousDayDataExecute(synchronousDayData);
        });
    }

    private void synchronousDayDataExecute(SynchronousDayDataDto synchronousDayData) {
        ArrayList<String> ocsWarehouseCodeList = new ArrayList<String>();
        ArrayList<String> neWarehouseCodeList = new ArrayList<String>();
        synchronousDayData.getWarehouseCodeList().forEach(warehouse -> {
            SynchronousDayDataConfigEnum configEnum = SynchronousDayDataConfigEnum.getForWarehouseCode(warehouse);
            if (ObjectUtils.isNotEmpty((Object)((Object)configEnum))) {
                try {
                    neWarehouseCodeList.add(configEnum.getWarehouseCode());
                    WmsDailyDeliveryReportQueryDto queryDto = new WmsDailyDeliveryReportQueryDto();
                    queryDto.setStartTime(synchronousDayData.getStartDate());
                    queryDto.setEndTime(synchronousDayData.getEndDate());
                    queryDto.setWarehouseCode(configEnum.getWarehouseCode());
                    queryDto.setWmsChannelCode(configEnum.getWmsMappingEnum().getChannelCode());
                    this.queryWmsDailyDeliveryReportExt(queryDto);
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65wms\u53d1\u8d27\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                ocsWarehouseCodeList.add((String)warehouse);
            }
        });
        if (CollectionUtils.isNotEmpty(ocsWarehouseCodeList)) {
            this.saveOcsDailyDeliveryReport(synchronousDayData.getStartDate(), synchronousDayData.getEndDate(), ocsWarehouseCodeList, neWarehouseCodeList);
        }
    }
}

