/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.credit.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.app.ServiceContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.convert.entity.CreditApplyDgConverter;
import com.yunxi.dg.base.center.report.domain.credit.ICreditApplyDgDomain;
import com.yunxi.dg.base.center.report.dto.credit.CreditApplyDgDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditApplyDgPageReqDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditApplyStatusDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationExtDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.eo.credit.CreditApplyDetailDgEo;
import com.yunxi.dg.base.center.report.eo.credit.CreditApplyDgEo;
import com.yunxi.dg.base.center.report.service.credit.ICreditApplyDgService;
import com.yunxi.dg.base.center.report.service.credit.impl.CustomerRelationHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;

@Service
public class CreditApplyDgServiceImpl
extends BaseServiceImpl<CreditApplyDgDto, CreditApplyDgEo, ICreditApplyDgDomain>
implements ICreditApplyDgService {
    @Resource
    private CustomerRelationHelper customerRelationHelper;

    public CreditApplyDgServiceImpl(ICreditApplyDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CreditApplyDgDto, CreditApplyDgEo> converter() {
        return CreditApplyDgConverter.INSTANCE;
    }

    @Override
    public PageInfo<CreditApplyDgDto> queryPage(CreditApplyDgPageReqDto reqDto) {
        List creditApplyDgDtoList;
        HashSet customerIds;
        HashSet shopIds;
        List<CsOrgCustomerRelationExtDto> relationExtDtoList;
        ServiceContext.getContext().setAttachment("data_limit_authority_selector", CreditApplyDetailDgEo.class.getName());
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "2");
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getRegionIdList()) && CollectionUtil.isNotEmpty(relationExtDtoList = this.customerRelationHelper.getBusinessAreaList(reqDto.getRegionIdList()))) {
            shopIds = Sets.newHashSet();
            customerIds = Sets.newHashSet();
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList) {
                customerIds.add(csOrgCustomerRelationExtDto.getCustomerId());
                shopIds.add(csOrgCustomerRelationExtDto.getShopId());
            }
            reqDto.setCustomerIdList((List)Lists.newArrayList((Iterable)customerIds));
            if (CollectionUtil.isNotEmpty((Collection)reqDto.getShopIdList())) {
                reqDto.getShopIdList().addAll(shopIds);
            } else {
                reqDto.setShopIdList((List)Lists.newArrayList((Iterable)shopIds));
            }
        }
        if (CollectionUtil.isEmpty((Collection)(creditApplyDgDtoList = ((ICreditApplyDgDomain)this.domain).pageQuery(reqDto)))) {
            return new PageInfo();
        }
        shopIds = Sets.newHashSet();
        customerIds = Sets.newHashSet();
        for (CreditApplyDgDto creditApplyDgDto : creditApplyDgDtoList) {
            shopIds.add(creditApplyDgDto.getShopId());
            customerIds.add(creditApplyDgDto.getCustomerId());
        }
        List<CsOrgCustomerRelationExtDto> relationExtDtoList2 = this.customerRelationHelper.getByCustomerIdAndShopId(shopIds, customerIds);
        if (CollectionUtil.isNotEmpty(relationExtDtoList2)) {
            Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel = this.customerRelationHelper.getMapAreaLevel(relationExtDtoList2);
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList2) {
                if (!mapAreaLevel.containsKey(csOrgCustomerRelationExtDto.getAreaId())) continue;
                List<DgBusinessAreaLevelDto> areaLevelDtoList = mapAreaLevel.get(csOrgCustomerRelationExtDto.getAreaId());
                String regionName = this.customerRelationHelper.getRegionName(areaLevelDtoList);
                for (CreditApplyDgDto creditApplyDgDto : creditApplyDgDtoList) {
                    if (!csOrgCustomerRelationExtDto.getCustomerId().equals(creditApplyDgDto.getCustomerId()) || !csOrgCustomerRelationExtDto.getShopId().equals(creditApplyDgDto.getShopId())) continue;
                    creditApplyDgDto.setRegionName(regionName);
                }
            }
        }
        PageInfo pageInfo = new PageInfo(creditApplyDgDtoList);
        return pageInfo;
    }

    @Override
    public List<CreditApplyStatusDto> countStatus(CreditApplyDgPageReqDto reqDto) {
        List<CsOrgCustomerRelationExtDto> relationExtDtoList;
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getRegionIdList()) && CollectionUtil.isNotEmpty(relationExtDtoList = this.customerRelationHelper.getBusinessAreaList(reqDto.getRegionIdList()))) {
            HashSet shopIds = Sets.newHashSet();
            HashSet customerIds = Sets.newHashSet();
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList) {
                customerIds.add(csOrgCustomerRelationExtDto.getCustomerId());
                shopIds.add(csOrgCustomerRelationExtDto.getShopId());
            }
            reqDto.setCustomerIdList((List)Lists.newArrayList((Iterable)customerIds));
            if (CollectionUtil.isNotEmpty((Collection)reqDto.getShopIdList())) {
                reqDto.getShopIdList().addAll(shopIds);
            } else {
                reqDto.setShopIdList((List)Lists.newArrayList((Iterable)shopIds));
            }
        }
        return ((ICreditApplyDgDomain)this.domain).countStatus(reqDto);
    }
}

