/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.credit.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.convert.entity.CreditApplyQuotaDgConverter;
import com.yunxi.dg.base.center.report.domain.credit.ICreditApplyQuotaDgDomain;
import com.yunxi.dg.base.center.report.dto.credit.CreditApplyQuotaDgDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditApplyQuotaDgPageReqDto;
import com.yunxi.dg.base.center.report.dto.credit.CreditApplyQuotaDgPageRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationExtDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.eo.credit.CreditApplyQuotaDgEo;
import com.yunxi.dg.base.center.report.service.credit.ICreditApplyQuotaDgService;
import com.yunxi.dg.base.center.report.service.credit.impl.CustomerRelationHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;

@Service
public class CreditApplyQuotaDgServiceImpl
extends BaseServiceImpl<CreditApplyQuotaDgDto, CreditApplyQuotaDgEo, ICreditApplyQuotaDgDomain>
implements ICreditApplyQuotaDgService {
    @Resource
    private CustomerRelationHelper customerRelationHelper;

    public CreditApplyQuotaDgServiceImpl(ICreditApplyQuotaDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CreditApplyQuotaDgDto, CreditApplyQuotaDgEo> converter() {
        return CreditApplyQuotaDgConverter.INSTANCE;
    }

    @Override
    public PageInfo<CreditApplyQuotaDgPageRespDto> queryPage(CreditApplyQuotaDgPageReqDto dto) {
        List creditApplyQuotaDgPageRespDtoList;
        HashSet customerIds;
        HashSet shopIds;
        List<CsOrgCustomerRelationExtDto> relationExtDtoList;
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (CollectionUtil.isNotEmpty((Collection)dto.getRegionIdList()) && CollectionUtil.isNotEmpty(relationExtDtoList = this.customerRelationHelper.getBusinessAreaList(dto.getRegionIdList()))) {
            shopIds = Sets.newHashSet();
            customerIds = Sets.newHashSet();
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList) {
                customerIds.add(csOrgCustomerRelationExtDto.getCustomerId());
                shopIds.add(csOrgCustomerRelationExtDto.getShopId());
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getCustomerIdList())) {
                dto.getCustomerIdList().addAll(customerIds);
            } else {
                dto.setShopIds((List)Lists.newArrayList((Iterable)customerIds));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getShopIds())) {
                dto.getShopIds().addAll(shopIds);
            } else {
                dto.setShopIds((List)Lists.newArrayList((Iterable)shopIds));
            }
        }
        if (CollectionUtil.isEmpty((Collection)(creditApplyQuotaDgPageRespDtoList = ((ICreditApplyQuotaDgDomain)this.domain).queryPage(dto)))) {
            return new PageInfo();
        }
        shopIds = Sets.newHashSet();
        customerIds = Sets.newHashSet();
        for (CreditApplyQuotaDgPageRespDto quotaDgPageRespDto : creditApplyQuotaDgPageRespDtoList) {
            shopIds.add(quotaDgPageRespDto.getShopId());
            customerIds.add(quotaDgPageRespDto.getCustomerId());
        }
        List<CsOrgCustomerRelationExtDto> relationExtDtoList2 = this.customerRelationHelper.getByCustomerIdAndShopId(shopIds, customerIds);
        if (CollectionUtil.isNotEmpty(relationExtDtoList2)) {
            Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel = this.customerRelationHelper.getMapAreaLevel(relationExtDtoList2);
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList2) {
                if (!mapAreaLevel.containsKey(csOrgCustomerRelationExtDto.getAreaId())) continue;
                List<DgBusinessAreaLevelDto> areaLevelDtoList = mapAreaLevel.get(csOrgCustomerRelationExtDto.getAreaId());
                String regionName = this.customerRelationHelper.getRegionName(areaLevelDtoList);
                for (CreditApplyQuotaDgPageRespDto quotaDgPageRespDto : creditApplyQuotaDgPageRespDtoList) {
                    if (!csOrgCustomerRelationExtDto.getCustomerId().equals(quotaDgPageRespDto.getCustomerId()) || !csOrgCustomerRelationExtDto.getShopId().equals(quotaDgPageRespDto.getShopId())) continue;
                    quotaDgPageRespDto.setRegionName(regionName);
                }
            }
        }
        PageInfo pageInfo = new PageInfo(creditApplyQuotaDgPageRespDtoList);
        return pageInfo;
    }
}

