/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ObjectConvertor;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.erp.dto.inventory.ErpPurchaseDetailLineRequestDto;
import com.yunxi.dg.base.center.erp.dto.inventory.ErpPurchaseDetailRequestDto;
import com.yunxi.dg.base.center.erp.dto.inventory.ErpPurchaseOrderLineRequestDto;
import com.yunxi.dg.base.center.erp.dto.inventory.ErpPurchaseOrderRequestDto;
import com.yunxi.dg.base.center.erp.dto.inventory.ErpSaleOrderLineRequestDto;
import com.yunxi.dg.base.center.erp.dto.inventory.ErpSaleOrderRequestDto;
import com.yunxi.dg.base.center.erp.proxy.IExternalInventoryErpApi;
import com.yunxi.dg.base.center.inventory.dto.request.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.report.convert.entity.EnterpriceCrossOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderLineDomain;
import com.yunxi.dg.base.center.report.dto.companytrade.ErpPurchaseOrderLineDto;
import com.yunxi.dg.base.center.report.dto.companytrade.ErpSaleOrderLineDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultReqDto;
import com.yunxi.dg.base.center.report.enums.BusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.enums.EnterpriceCrossOrderSyncErpStatusEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossOrderService;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossTradeRelationService;
import com.yunxi.dg.base.center.report.service.enterprice.impl.handler.EnterpriceCrossAbstractSceneServiceImpl;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EnterpriceCrossOrderServiceImpl
extends BaseServiceImpl<EnterpriceCrossOrderDto, EnterpriceCrossOrderEo, IEnterpriceCrossOrderDomain>
implements IEnterpriceCrossOrderService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossOrderServiceImpl.class);
    @Resource
    private IEnterpriceCrossOrderLineDomain orderLineDomain;
    @Resource
    private IEnterpriceCrossTradeRelationService tradeRelationService;
    @Resource
    private IExternalInventoryErpApi externalInventoryErpApi;
    @Resource
    private IContext context;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private List<EnterpriceCrossAbstractSceneServiceImpl> enterpriceHandleSerivceList;

    public EnterpriceCrossOrderServiceImpl(IEnterpriceCrossOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<EnterpriceCrossOrderDto, EnterpriceCrossOrderEo> converter() {
        return EnterpriceCrossOrderConverter.INSTANCE;
    }

    @Override
    public PageInfo<EnterpriceCrossOrderDto> queryPage(EnterpriceCrossOrderPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IEnterpriceCrossOrderDomain)this.domain).queryPage(dto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void receiveDeliveryResultPushOrderToErp(List<Long> orderIds) {
        if (orderIds.isEmpty()) {
            return;
        }
        ArrayList<Long> succList = new ArrayList<Long>();
        TreeMap<Long, String> failMap = new TreeMap<Long, String>();
        List orderList = ((ExtQueryChainWrapper)((IEnterpriceCrossOrderDomain)this.domain).filter().in((Object)"id", orderIds)).list();
        orderList.removeIf(next -> !next.getSyncStatus().equals(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_TODO.getType()));
        orderIds = orderList.stream().map(BaseEo::getId).collect(Collectors.toList());
        if (orderIds.isEmpty()) {
            return;
        }
        List orderLineEoList = ((ExtQueryChainWrapper)this.orderLineDomain.filter().in((Object)"order_id", orderIds)).list();
        long checkPrice = orderLineEoList.stream().filter(e -> {
            if (e.getPrice() == null || e.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }).count();
        if (checkPrice != 0L) {
            orderIds.forEach(orderId -> failMap.put((Long)orderId, "\u83b7\u53d6\u4ef7\u683c\u5931\u8d25"));
            this.updatePushErpStatus(succList, failMap);
            return;
        }
        this.pushOrderToErp(orderList);
    }

    @Override
    public void pushOrderToErp(List<EnterpriceCrossOrderEo> orderList) {
        log.info("\u3010\u5f85\u63a8\u9001ERP\u6570\u636e\u3011:{}", (Object)JSONUtil.toJsonStr(orderList));
        ArrayList<Long> succList = new ArrayList<Long>();
        TreeMap<Long, String> failMap = new TreeMap<Long, String>();
        this.pushSaleOrder(orderList, succList, failMap, CompanyTradeTypeEnum.SALE_ORDER);
        this.pushPurchaseOrder(orderList, succList, failMap, CompanyTradeTypeEnum.PURCHASE_ORDER);
        this.pushReturnPurchaseOrder(orderList, succList, failMap, CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER);
        this.pushSaleOrder(orderList, succList, failMap, CompanyTradeTypeEnum.AFTERSALE_ORDER);
        this.updatePushErpStatus(succList, failMap);
    }

    @Override
    public RestResponse<Void> pushErpBatch(List<Long> orderIds) {
        if (orderIds.isEmpty()) {
            return new RestResponse();
        }
        List orderList = ((ExtQueryChainWrapper)((IEnterpriceCrossOrderDomain)this.domain).filter().in((Object)"id", orderIds)).list();
        AssertUtils.notEmpty((Collection)orderList, (String)"\u63a8\u9001\u5931\u8d25\uff0c\u67e5\u65e0\u5355\u636e");
        orderList.forEach(orderEo -> {
            if (orderEo.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType())) {
                AssertUtils.notEmpty((Object)orderEo.getCustomerId(), (String)"\u90e8\u5206\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5904\u7406\u540e\u518d\u64cd\u4f5c");
                AssertUtils.notEmpty((Object)orderEo.getSaleEnterpriseId(), (String)"\u90e8\u5206\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5904\u7406\u540e\u518d\u64cd\u4f5c");
            } else {
                AssertUtils.notEmpty((Object)orderEo.getSupplierId(), (String)"\u90e8\u5206\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5904\u7406\u540e\u518d\u64cd\u4f5c");
                AssertUtils.notEmpty((Object)orderEo.getPurchaseEnterpriseId(), (String)"\u90e8\u5206\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5904\u7406\u540e\u518d\u64cd\u4f5c");
            }
        });
        long count = orderList.stream().filter(e -> e.getSyncStatus().equals(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_SUCC.getType())).count();
        AssertUtils.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u63a8\u9001\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5df2\u63a8\u9001\u5355\u636e\u4e0d\u80fd\u91cd\u590d\u63a8\u9001");
        List orderLineEoList = ((ExtQueryChainWrapper)this.orderLineDomain.filter().in((Object)"order_id", orderIds)).list();
        long checkPrice = orderLineEoList.stream().filter(e -> {
            if (e.getPrice() == null || e.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }).count();
        AssertUtils.isTrue((checkPrice == 0L ? 1 : 0) != 0, (String)"\u63a8\u9001\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5355\u4ef7\u4e3a\u7a7a\u7684\u5355\u636e\u4e0d\u80fd\u63a8\u9001");
        this.pushOrderToErp(orderList);
        return new RestResponse();
    }

    @Override
    public void orderDeduct(Long orderId) {
        EnterpriceCrossOrderEo purchaseAftersaleOrder = (EnterpriceCrossOrderEo)((IEnterpriceCrossOrderDomain)this.domain).selectByPrimaryKey(orderId);
        AssertUtils.notNull((Object)purchaseAftersaleOrder, (String)"\u67e5\u65e0\u5355\u636e");
        AssertUtils.isTrue((boolean)purchaseAftersaleOrder.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType()), (String)"\u5355\u636e\u4e0d\u5141\u8bb8\u8be2\u4ef7");
        AssertUtils.isFalse((boolean)purchaseAftersaleOrder.getSyncStatus().equals(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_SUCC.getType()), (String)"\u5df2\u540c\u6b65ERP\uff0c \u4e0d\u5141\u8bb8\u8be2\u4ef7");
        AssertUtils.notNull((Object)purchaseAftersaleOrder.getPurchaseEnterpriseId(), (String)"\u7f3a\u5c11\u91c7\u8d2d\u65b9\u4fe1\u606f");
        AssertUtils.notNull((Object)purchaseAftersaleOrder.getSupplierId(), (String)"\u7f3a\u5c11\u4f9b\u5e94\u5546\u4fe1\u606f");
        this.orderLineDomain.freshPurchaseOrderReturnDeductAndCreateOrderLine(purchaseAftersaleOrder);
        EnterpriceCrossOrderEo aftersaleOrder = ((IEnterpriceCrossOrderDomain)this.domain).selectRelevanceSaleOrderOrPurchaseOrder(orderId);
        this.orderLineDomain.freshSaleOrderReturnDeductAndCreateOrderLine(aftersaleOrder);
    }

    @Override
    public void transferModifyExternalOrderNo(EnterpriceCrossReceiveDeliveryResultReqDto dto) {
        if (!BusinessTypeEnum.INTER_ORGANIZATION_TRANSACTION_ORDER.getType().equals(dto.getResultDto().getBusinessType())) {
            return;
        }
        log.info("====\u4fee\u6539\u8de8\u7ec4\u7ec7\u8c03\u62e8\u5355\u5173\u8054\u7684\u516c\u53f8\u95f4\u5355\u53f7{}", (Object)dto.getResultDto().getRelevanceNo());
        List list = ((IEnterpriceCrossOrderDomain)this.domain).selectDocumentNo(dto.getResultDto().getRelevanceNo());
        TransferOrderReqDto reqDto = new TransferOrderReqDto();
        reqDto.setTransferOrderNo(dto.getResultDto().getRelevanceNo());
        list.forEach(e -> {
            if (CompanyTradeTypeEnum.isPurchase((String)e.getType()).booleanValue()) {
                reqDto.setExternalPurchaseOrderNo(e.getDocumentNo());
            }
            if (CompanyTradeTypeEnum.isSale((String)e.getType()).booleanValue()) {
                reqDto.setExternalSaleOrderNo(e.getDocumentNo());
            }
        });
        log.info("\u3010\u4fee\u6539\u8c03\u62e8\u5355\u516c\u53f8\u95f4\u4ea4\u6613\u5355\u53f7\u3011\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)reqDto));
        try {
            RestResponse resp = this.transferOrderApiProxy.modifyExternalOrderNo(reqDto);
            log.info("\u3010\u4fee\u6539\u8c03\u62e8\u5355\u516c\u53f8\u95f4\u4ea4\u6613\u5355\u53f7\u3011\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)resp));
        }
        catch (Exception ex) {
            log.error("\u3010\u4fee\u6539\u8c03\u62e8\u5355\u516c\u53f8\u95f4\u4ea4\u6613\u5355\u53f7\u3011\u5f02\u5e38 {}", (Object)JSONUtil.toJsonStr((Object)reqDto));
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void receiveDeliveryResult(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        Optional<EnterpriceCrossAbstractSceneServiceImpl> optional = this.enterpriceHandleSerivceList.stream().filter(e -> e.checkEnterpriceOrderAndHandleBusinessType(context)).findFirst();
        if (optional.isPresent()) {
            optional.get().handleReceiveDeliveryResultOrder(context);
            return;
        }
        log.info(String.format("%s \u975e\u516c\u53f8\u95f4\u4ea4\u6613\uff0c\u4e0d\u5904\u7406\u8be5\u7ed3\u679c\u5355", context.getResultDto().getDocumentNo()));
    }

    private void pushPurchaseOrder(List<EnterpriceCrossOrderEo> orgOrderList, List<Long> succList, Map<Long, String> failMap, CompanyTradeTypeEnum type) {
        List collect = orgOrderList.stream().distinct().filter(e -> e.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType())).filter(e -> e.getType().equals(type.getType())).map(BaseEo::getId).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        log.info("======\u5f00\u59cb\u63a8\u9001{}, orderIds:{}", (Object)type.getDesc(), collect);
        List purchaseOrderDtoList = ((IEnterpriceCrossOrderDomain)this.domain).getPurchaseOrderByOrderIds(collect);
        List purchaseLineDtoList = this.orderLineDomain.getPurchaseOrderLineByOrderIds(collect);
        Map<Long, List<ErpPurchaseOrderLineDto>> purchaseOrderLineMap = purchaseLineDtoList.stream().collect(Collectors.groupingBy(ErpPurchaseOrderLineDto::getOrderId));
        purchaseOrderDtoList.forEach(order -> {
            try {
                ErpPurchaseOrderRequestDto requestDto = (ErpPurchaseOrderRequestDto)BeanUtil.copyProperties((Object)order, ErpPurchaseOrderRequestDto.class, (String[])new String[0]);
                List reqLine = ObjectConvertor.convertObjects((List)((List)purchaseOrderLineMap.get(order.getOrderId())), ErpPurchaseOrderLineRequestDto.class, (String[])new String[0]);
                requestDto.setLine(reqLine);
                log.info("\u3010{}\u3011\uff0corderId: {}, sourceId:{}, reqBody: {}", new Object[]{type.getDesc(), order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)requestDto)});
                RestResponse resultRsp = this.externalInventoryErpApi.inStorage(requestDto);
                log.info("\u3010{}}\u7ed3\u679c\u3011\uff0corderId: {} , sourceId:{}, resp:{}", new Object[]{type.getDesc(), order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)resultRsp)});
                if (resultRsp != null && !resultRsp.isSuccess()) {
                    failMap.put(order.getOrderId(), resultRsp.getResultMsg());
                    return;
                }
                ErpPurchaseDetailRequestDto detailRequestDto = new ErpPurchaseDetailRequestDto();
                detailRequestDto.setSourceId(order.getSourceId());
                detailRequestDto.setDocNumber(order.getDocNumber());
                List detailReqLine = ObjectConvertor.convertObjects((List)((List)purchaseOrderLineMap.get(order.getOrderId())), ErpPurchaseDetailLineRequestDto.class, (String[])new String[0]);
                detailRequestDto.setDetail(detailReqLine);
                log.info("\u3010{}\u660e\u7ec6\u3011\uff0corderId: {} ,sourceId:{}, reqBody: {}", new Object[]{type.getDesc(), order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)detailRequestDto)});
                RestResponse storageDetailRsp = this.externalInventoryErpApi.receiveStorageDetail(detailRequestDto);
                log.info("\u3010{}}\u660e\u7ec6\u7ed3\u679c\u3011\uff0corderId: {} ,sourceId:{}, resultRsp: {}", new Object[]{type.getDesc(), order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)storageDetailRsp)});
                this.checkException((RestResponse<Void>)storageDetailRsp, order.getOrderId(), succList, failMap);
            }
            catch (Exception ex) {
                log.error(order.getOrderId() + "\u63a8\u9001\u5931\u8d25" + ex.getMessage(), (Throwable)ex);
                failMap.put(order.getOrderId(), ex.getMessage());
            }
        });
        log.info("======\u63a8\u9001{}\u7ed3\u675f", (Object)type.getDesc());
    }

    private void pushReturnPurchaseOrder(List<EnterpriceCrossOrderEo> orgOrderList, List<Long> succList, Map<Long, String> failMap, CompanyTradeTypeEnum type) {
        List collect = orgOrderList.stream().distinct().filter(e -> e.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType())).filter(e -> e.getType().equals(type.getType())).map(BaseEo::getId).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        log.info("======\u5f00\u59cb\u63a8\u9001{}, orderIds:{}", (Object)type.getDesc(), collect);
        List purchaseOrderDtoList = ((IEnterpriceCrossOrderDomain)this.domain).getPurchaseOrderByOrderIds(collect);
        List purchaseLineDtoList = this.orderLineDomain.getReturnPurchaseOrderLineByOrderIds(collect);
        Map<Long, List<ErpPurchaseOrderLineDto>> purchaseOrderLineMap = purchaseLineDtoList.stream().collect(Collectors.groupingBy(ErpPurchaseOrderLineDto::getOrderId));
        purchaseOrderDtoList.forEach(order -> {
            try {
                ErpPurchaseDetailRequestDto detailRequestDto = new ErpPurchaseDetailRequestDto();
                detailRequestDto.setSourceId(order.getSourceId());
                detailRequestDto.setDocNumber(order.getDocNumber());
                List detailReqLine = ObjectConvertor.convertObjects((List)((List)purchaseOrderLineMap.get(order.getOrderId())), ErpPurchaseDetailLineRequestDto.class, (String[])new String[0]);
                detailRequestDto.setDetail(detailReqLine);
                log.info("\u3010\u91c7\u8d2d\u9000\u5355\u660e\u7ec6\u3011\uff0corderId: {} ,sourceId:{}, reqBody: {}", new Object[]{order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)detailRequestDto)});
                RestResponse storageDetailRsp = this.externalInventoryErpApi.receiveStorageDetail(detailRequestDto);
                log.info("\u3010\u91c7\u8d2d\u9000\u5355\u660e\u7ec6\u7ed3\u679c\u3011\uff0corderId: {} ,sourceId:{}, resultRsp: {}", new Object[]{order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)storageDetailRsp)});
                this.checkException((RestResponse<Void>)storageDetailRsp, order.getOrderId(), succList, failMap);
            }
            catch (Exception ex) {
                log.error(order.getOrderId() + "\u63a8\u9001\u5931\u8d25" + ex.getMessage(), (Throwable)ex);
                failMap.put(order.getOrderId(), ex.getMessage());
            }
        });
        log.info("======\u63a8\u9001{}\u7ed3\u675f", (Object)type.getDesc());
    }

    private void pushSaleOrder(List<EnterpriceCrossOrderEo> orgOrderList, List<Long> succList, Map<Long, String> failMap, CompanyTradeTypeEnum type) {
        List collect = orgOrderList.stream().distinct().filter(e -> e.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType()) || e.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType())).filter(e -> e.getType().equals(type.getType())).map(BaseEo::getId).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        log.info("======\u5f00\u59cb\u63a8\u9001{}, orderIds:{}", (Object)type.getDesc(), collect);
        List saleOrderDtoList = ((IEnterpriceCrossOrderDomain)this.domain).getSaleOrderByOrderIds(collect);
        List saleOrderLineDtoList = this.orderLineDomain.getSaleOrderLineByOrderIds(collect);
        Map<Long, List<ErpSaleOrderLineDto>> saleOrderLineMap = saleOrderLineDtoList.stream().collect(Collectors.groupingBy(ErpSaleOrderLineDto::getOrderId));
        saleOrderDtoList.forEach(order -> {
            try {
                ErpSaleOrderRequestDto requestDto = (ErpSaleOrderRequestDto)BeanUtil.copyProperties((Object)order, ErpSaleOrderRequestDto.class, (String[])new String[0]);
                List reqLine = ObjectConvertor.convertObjects((List)((List)saleOrderLineMap.get(order.getOrderId())), ErpSaleOrderLineRequestDto.class, (String[])new String[0]);
                requestDto.setLine(reqLine);
                requestDto.setCustomerLocation("-1");
                log.info("\u3010{}\u3011\uff0corderId: {} , sourceId:{}, reqBody: {}", new Object[]{type.getDesc(), order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)requestDto)});
                RestResponse resultRsp = this.externalInventoryErpApi.outStorage(requestDto);
                log.info("\u3010{}\u7ed3\u679c\u3011\uff0corderId: {}  sourceId:{}, resp:{}", new Object[]{type.getDesc(), order.getOrderId(), order.getSourceId(), JSONUtil.toJsonStr((Object)resultRsp)});
                this.checkException((RestResponse<Void>)resultRsp, order.getOrderId(), succList, failMap);
            }
            catch (Exception ex) {
                log.error(order.getOrderId() + "\u63a8\u9001\u5931\u8d25" + ex.getMessage(), (Throwable)ex);
                failMap.put(order.getOrderId(), ex.getMessage());
            }
        });
        log.info("======\u63a8\u9001{}\u7ed3\u675f", (Object)type.getDesc());
    }

    private void checkException(RestResponse<Void> resultRsp, Long orderId, List<Long> succList, Map<Long, String> failMap) {
        if (resultRsp.isSuccess()) {
            succList.add(orderId);
        } else {
            failMap.put(orderId, resultRsp.getResultMsg());
        }
    }

    private void updatePushErpStatus(List<Long> succList, Map<Long, String> failMap) {
        succList.forEach(orderId -> {
            EnterpriceCrossOrderEo orderEo = new EnterpriceCrossOrderEo();
            orderEo.setId(orderId);
            orderEo.setSyncException("-");
            orderEo.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_SUCC.getType());
            ((IEnterpriceCrossOrderDomain)this.domain).updateSelective((BaseEo)orderEo);
        });
        failMap.forEach((orderId, errorMsg) -> {
            EnterpriceCrossOrderEo orderEo = new EnterpriceCrossOrderEo();
            orderEo.setId(orderId);
            this.setExceptionToSyncException(orderEo, (String)errorMsg);
            ((IEnterpriceCrossOrderDomain)this.domain).updateSelective((BaseEo)orderEo);
        });
    }

    protected void setExceptionToSyncException(EnterpriceCrossOrderEo orderEo, String errorMesage) {
        orderEo.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_FAIL.getType());
        if (errorMesage.startsWith(";")) {
            errorMesage = errorMesage.substring(1);
        }
        if (StrUtil.isNotBlank((CharSequence)orderEo.getSyncException()) && orderEo.getSyncException().length() > 1) {
            orderEo.setSyncException(orderEo.getSyncException() + ";" + errorMesage);
        } else {
            orderEo.setSyncException(errorMesage);
        }
    }
}

