/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.CostCategoryConverter;
import com.yunxi.dg.base.center.report.domain.entity.ICostCategoryDomain;
import com.yunxi.dg.base.center.report.dto.cost.response.CostCategoryTreeRespDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCategoryDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCategoryPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CostCategoryResetIdPathReqDto;
import com.yunxi.dg.base.center.report.eo.CostCategoryEo;
import com.yunxi.dg.base.center.report.service.entity.ICostArchiveService;
import com.yunxi.dg.base.center.report.service.entity.ICostCategoryService;
import com.yunxi.dg.base.center.report.service.utils.BeanConvertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CostCategoryServiceImpl
extends BaseServiceImpl<CostCategoryDto, CostCategoryEo, ICostCategoryDomain>
implements ICostCategoryService {
    @Resource
    private ICostArchiveService costArchiveService;

    public CostCategoryServiceImpl(ICostCategoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CostCategoryDto, CostCategoryEo> converter() {
        return CostCategoryConverter.INSTANCE;
    }

    public RestResponse<Long> insert(CostCategoryDto dto) {
        dto.setId(null);
        this.verifyParam(dto);
        return super.insert((BaseDto)dto);
    }

    public RestResponse<Integer> update(CostCategoryDto dto) {
        this.verifyParam(dto);
        return super.update((BaseDto)dto);
    }

    public RestResponse<Void> logicDelete(Long id) {
        CostCategoryEo eo = (CostCategoryEo)((ICostCategoryDomain)this.domain).selectByPrimaryKey(id);
        if (eo == null) {
            throw new BizException("\u7c7b\u76eeID[" + id + "]\u4e0d\u5b58\u5728");
        }
        int count = ((ICostCategoryDomain)this.domain).countByParentId(id);
        if (count > 0) {
            throw new BizException("\u8be5\u7c7b\u76ee\u4e0b\u8fd8\u6709" + count + "\u4e2a\u5b50\u7c7b\u76ee\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        count = this.costArchiveService.countByCategoryCode(eo.getCode());
        if (count > 0) {
            throw new BizException("\u8be5\u7c7b\u76ee\u5df2\u88ab " + count + " \u4e2a\u8d39\u7528\u6863\u6848\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        return super.logicDelete(id);
    }

    @Override
    public List<CostCategoryTreeRespDto> treeList() {
        List costCategoryEos = ((ICostCategoryDomain)this.domain).selectAll();
        if (CollectionUtils.isEmpty((Collection)costCategoryEos)) {
            return null;
        }
        List costCategoryTrees = BeanUtil.copyToList((Collection)costCategoryEos, CostCategoryTreeRespDto.class);
        Map<Long, List<CostCategoryTreeRespDto>> map = ((List)Optional.ofNullable(costCategoryTrees).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(CostCategoryTreeRespDto::getParentId));
        List<CostCategoryTreeRespDto> newTreeDtoList = costCategoryTrees.stream().map(e -> {
            e.setChildren((List)map.get(e.getId()));
            return e;
        }).filter(e -> null == e.getParentId() || e.getParentId().equals(0L)).collect(Collectors.toList());
        return newTreeDtoList;
    }

    public RestResponse<CostCategoryDto> get(Long id) {
        RestResponse response = super.get(id);
        this.setParentDetails((CostCategoryDto)RestResponseHelper.extractData((RestResponse)response));
        return response;
    }

    @Override
    public List<CostCategoryDto> queryList(CostCategoryPageReqDto dto) {
        List costCategoryEos = ((ICostCategoryDomain)this.domain).selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostCategoryEo.class).eq(StrUtil.isNotBlank((CharSequence)dto.getCode()), CostCategoryEo::getCode, (Object)dto.getCode())).like(StrUtil.isNotBlank((CharSequence)dto.getName()), CostCategoryEo::getName, (Object)dto.getName())).in(CollectionUtil.isNotEmpty((Collection)dto.getCodeList()), CostCategoryEo::getCode, (Collection)dto.getCodeList())).eq(dto.getParentId() != null, CostCategoryEo::getParentId, (Object)dto.getParentId()));
        return BeanConvertUtil.copyToList((Collection)costCategoryEos, CostCategoryDto.class);
    }

    public RestResponse<PageInfo<CostCategoryDto>> page(BasePageDto queryDto) {
        CostCategoryPageReqDto dto = (CostCategoryPageReqDto)queryDto;
        PageInfo costArchiveEoPageInfo = ((ICostCategoryDomain)this.domain).selectPage((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostCategoryEo.class).eq(StrUtil.isNotBlank((CharSequence)dto.getCode()), CostCategoryEo::getCode, (Object)dto.getCode())).like(StrUtil.isNotBlank((CharSequence)dto.getName()), CostCategoryEo::getName, (Object)dto.getName())).in(CollectionUtil.isNotEmpty((Collection)dto.getCodeList()), CostCategoryEo::getCode, (Collection)dto.getCodeList())).eq(dto.getParentId() != null, CostCategoryEo::getParentId, (Object)dto.getParentId()), queryDto.getPageNum(), queryDto.getPageSize());
        PageInfo<CostCategoryDto> pageInfo = BeanConvertUtil.convert(costArchiveEoPageInfo, CostCategoryDto.class);
        return new RestResponse(pageInfo);
    }

    @Override
    public Map<String, CostCategoryDto> getCategoryPathMap(List<String> codes) {
        List<CostCategoryDto> list = this.getByCodes(codes);
        List<Long> ids = list.stream().flatMap(e -> Stream.of(e.getIdPath().split(","))).map(Long::parseLong).distinct().collect(Collectors.toList());
        List<CostCategoryDto> all = this.getByIds(ids);
        Map<Long, CostCategoryDto> map = all.stream().collect(Collectors.toMap(BaseDto::getId, v -> v));
        return list.stream().collect(Collectors.toMap(CostCategoryDto::getCode, v -> {
            ArrayList<String> codePaths = new ArrayList<String>();
            ArrayList<String> namePaths = new ArrayList<String>();
            for (String s : v.getIdPath().split(",")) {
                Long id = Long.parseLong(s);
                CostCategoryDto dto = (CostCategoryDto)map.get(id);
                if (dto != null) {
                    codePaths.add(dto.getCode());
                    namePaths.add(dto.getName());
                    continue;
                }
                codePaths.add(id.toString());
                namePaths.add(id.toString());
            }
            v.setCode(String.join((CharSequence)"/", codePaths));
            v.setName(String.join((CharSequence)"/", namePaths));
            return v;
        }));
    }

    @Override
    public <T> void setCategoryPaths(List<T> list, Function<T, String> codeGetter, BiConsumer<T, String> codePathSetter, BiConsumer<T, String> namePathSetter) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List<String> codes = list.stream().map(codeGetter).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (codes.isEmpty()) {
            return;
        }
        Map<String, CostCategoryDto> map = this.getCategoryPathMap(codes);
        list.forEach(dto -> {
            CostCategoryDto category = (CostCategoryDto)map.get(codeGetter.apply(dto));
            if (category == null) {
                return;
            }
            if (codePathSetter != null) {
                codePathSetter.accept(dto, category.getCode());
            }
            if (namePathSetter != null) {
                namePathSetter.accept(dto, category.getName());
            }
        });
    }

    private List<CostCategoryDto> getByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        List eoList = ((ICostCategoryDomain)this.domain).selectByIds(ids);
        return this.converter().toDtoList(eoList);
    }

    private List<CostCategoryDto> getByCodes(List<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyList();
        }
        List eoList = ((ICostCategoryDomain)this.domain).selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostCategoryEo.class).in(CostCategoryEo::getCode, codes)).eq(BaseEo::getDr, (Object)0));
        return this.converter().toDtoList(eoList);
    }

    @Override
    public List<String> getDescendantCodes(List<String> categoryCodes) {
        List<CostCategoryEo> list = this.getDescendants(categoryCodes);
        return list.stream().map(CostCategoryEo::getCode).distinct().collect(Collectors.toList());
    }

    @Override
    public List<CostCategoryEo> getDescendants(List<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyList();
        }
        List categories = ((ICostCategoryDomain)this.domain).selectAll();
        HashMap<Long, List<CostCategoryEo>> group = new HashMap<Long, List<CostCategoryEo>>();
        HashMap map = new HashMap();
        categories.forEach(category -> {
            map.put(category.getCode(), category);
            List list = group.computeIfAbsent(category.getParentId(), i -> new ArrayList());
            list.add(category);
        });
        List<CostCategoryEo> parents = codes.stream().map(map::get).filter(Objects::nonNull).collect(Collectors.toList());
        parents.addAll(this.getDescendants(parents, group));
        return parents;
    }

    private List<CostCategoryEo> getDescendants(List<CostCategoryEo> parents, Map<Long, List<CostCategoryEo>> group) {
        ArrayList<CostCategoryEo> result = new ArrayList<CostCategoryEo>();
        if (parents.isEmpty()) {
            return result;
        }
        for (CostCategoryEo parent : parents) {
            List<CostCategoryEo> children = group.getOrDefault(parent.getId(), Collections.emptyList());
            result.addAll(children);
            result.addAll(this.getDescendants(children, group));
        }
        return result;
    }

    @Override
    public void resetIdPath(CostCategoryResetIdPathReqDto req) {
        CostCategoryEo eo = new CostCategoryEo();
        eo.setId(req.getId());
        eo.setIdPath(req.getIdPath());
        ((ICostCategoryDomain)this.domain).updateSelective((BaseEo)eo);
    }

    private void setParentDetails(CostCategoryDto costCategoryDto) {
        if (Objects.isNull(costCategoryDto) || null == costCategoryDto.getParentId() || costCategoryDto.getParentId().equals(0L)) {
            return;
        }
        CostCategoryEo costCategoryEo = (CostCategoryEo)((ICostCategoryDomain)this.domain).selectByPrimaryKey(costCategoryDto.getParentId());
        costCategoryDto.setParentCode(costCategoryEo.getCode());
        costCategoryDto.setParentName(costCategoryEo.getName());
    }

    private void verifyRepeatCode(CostCategoryDto dto) {
        List categoryEos = ((ICostCategoryDomain)this.domain).selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostCategoryEo.class).eq(CostCategoryEo::getCode, (Object)dto.getCode())).ne(dto.getId() != null && !dto.getId().equals(0L), BaseEo::getId, (Object)dto.getId()));
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)categoryEos), (String)"\u8be5\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
    }

    private void verifyRepeatName(CostCategoryDto dto) {
        List categoryEos = ((ICostCategoryDomain)this.domain).selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostCategoryEo.class).eq(CostCategoryEo::getName, (Object)dto.getName())).ne(dto.getId() != null && !dto.getId().equals(0L), BaseEo::getId, (Object)dto.getId()));
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)categoryEos), (String)"\u8be5\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
    }

    private void verifyParam(CostCategoryDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)dto.getCode().matches("^[a-zA-Z0-9]+$"), (String)"\u7f16\u7801\u53ea\u652f\u6301\u5b57\u6bcd\u548c\u6570\u5b57");
        this.verifyRepeatCode(dto);
        this.verifyRepeatName(dto);
        if (dto.getParentId() == null) {
            dto.setParentId(Long.valueOf(0L));
        }
        String idPath = null;
        if (dto.getParentId() > 0L) {
            CostCategoryEo eo = (CostCategoryEo)((ICostCategoryDomain)this.domain).selectByPrimaryKey(dto.getParentId());
            AssertUtils.notNull((Object)eo, (String)"\u7236\u7ea7\u4e0d\u5b58\u5728");
            idPath = eo.getIdPath();
        }
        if (dto.getId() == null || dto.getId() <= 0L) {
            dto.setId(Long.valueOf(IdGenrator.getDistributedId()));
        }
        idPath = Optional.ofNullable(idPath).map(s -> s + "," + dto.getId()).orElse(dto.getId().toString());
        dto.setIdPath(idPath);
    }
}

