/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.DgOrderTagConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgOrderTagDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderTagDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgOrderTagReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgOrderTagRespDto;
import com.yunxi.dg.base.center.report.eo.trade.DgOrderTagEo;
import com.yunxi.dg.base.center.report.service.entity.IDgOrderTagService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgOrderTagServiceImpl
extends BaseServiceImpl<DgOrderTagDto, DgOrderTagEo, IDgOrderTagDomain>
implements IDgOrderTagService {
    @Resource
    private IDgOrderTagDomain orderTagDomain;

    public DgOrderTagServiceImpl(IDgOrderTagDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgOrderTagDto, DgOrderTagEo> converter() {
        return DgOrderTagConverter.INSTANCE;
    }

    @Override
    public PageInfo<DgOrderTagRespDto> queryByPage(DgOrderTagReqDto orderTagReqDto, Integer pageNum, Integer pageSize) {
        DgOrderTagEo orderTagEo = new DgOrderTagEo();
        DtoHelper.dto2Eo((BaseVo)orderTagReqDto, (BaseEo)orderTagEo);
        ExtQueryChainWrapper filter = this.orderTagDomain.filter();
        if (orderTagReqDto.getTagName() != null) {
            filter.like((Object)"tag_name", (Object)orderTagReqDto.getTagName());
        }
        if (orderTagReqDto.getTagCode() != null) {
            filter.like((Object)"tag_code", (Object)orderTagReqDto.getTagCode());
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = filter.list();
        PageInfo eoPageInfo = new PageInfo(list);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgOrderTagRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgOrderTagRespDto> queryByTagCodes(List<String> tagCodes) {
        ExtQueryChainWrapper filter = this.orderTagDomain.filter();
        filter.in((Object)"tag_code", tagCodes);
        List orderTagEos = filter.list();
        ArrayList<DgOrderTagRespDto> dtoList = new ArrayList<DgOrderTagRespDto>();
        DtoHelper.eoList2DtoList((Collection)orderTagEos, dtoList, DgOrderTagRespDto.class);
        return dtoList;
    }
}

