/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.domain.customer.IDgEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.entity.IRShopSalesCompanyDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgOrganizationLevelDto;
import com.yunxi.dg.base.center.report.dto.shop.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.report.dto.shop.request.DgShopSaleCompanyReqDto;
import com.yunxi.dg.base.center.report.dto.shop.response.DgShopRespDto;
import com.yunxi.dg.base.center.report.eo.DgShopEo;
import com.yunxi.dg.base.center.report.eo.RShopSalesCompanyEo;
import com.yunxi.dg.base.center.report.eo.customer.DgEnterpriseEo;
import com.yunxi.dg.base.center.report.service.entity.IDgShopAssistService;
import com.yunxi.dg.base.center.report.service.utils.BeanConvertUtil;
import com.yunxi.dg.base.center.report.utils.MybatisPlusUtils;
import com.yunxi.dg.base.center.report.utils.RequestUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgShopAssistServiceImpl
implements IDgShopAssistService {
    private static final Logger log = LoggerFactory.getLogger(DgShopAssistServiceImpl.class);
    @Resource
    private IDgShopDomain iDgShopDomain;
    @Resource
    private IUsOrganizationDomain iUsOrganizationDomain;
    @Resource
    private IRShopSalesCompanyDomain irShopSalesCompanyDomain;
    @Resource
    private IDgEnterpriseDomain iDgEnterpriseDomain;

    @Override
    public PageInfo<DgShopRespDto> queryPageShop(DgShopQueryReqDto queryReqDto) {
        PageInfo dgShopEoPageInfo = this.iDgShopDomain.listShopByPage(queryReqDto);
        List list = dgShopEoPageInfo.getList();
        this.setOrgLevelList(list);
        this.toSaleCompanyList(list);
        return dgShopEoPageInfo;
    }

    @Override
    public PageInfo<DgShopRespDto> queryPageShop(DgShopQueryReqDto queryReqDto, Integer sourceType) {
        PageInfo dgShopEoPageInfo = this.iDgShopDomain.selectPage((Wrapper)this.buildLambdaQuery(queryReqDto, sourceType).orderByDesc(BaseEo::getCreateTime), queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo pageInfo = (PageInfo)BeanConvertUtil.copyProperties((Object)dgShopEoPageInfo, PageInfo.class, (String[])new String[]{"list"});
        if (CollectionUtils.isNotEmpty((Collection)dgShopEoPageInfo.getList())) {
            ArrayList dgShopRespDtos = new ArrayList();
            for (DgShopEo dgShopEo : dgShopEoPageInfo.getList()) {
                DgShopRespDto dgShopRespDto = (DgShopRespDto)BeanUtil.copyProperties((Object)dgShopEo, DgShopRespDto.class, (String[])new String[0]);
                dgShopRespDto.setStoreCode(dgShopEo.getCode());
                dgShopRespDto.setStoreName(dgShopEo.getName());
                dgShopRespDto.setStoreType(dgShopEo.getType());
            }
            pageInfo.setList(dgShopRespDtos);
        }
        return pageInfo;
    }

    @Override
    public List<DgShopRespDto> queryListShop(DgShopQueryReqDto queryReqDto) {
        List dgShopRespDtos = this.iDgShopDomain.listShopByCondition(queryReqDto);
        if (CollectionUtils.isEmpty((Collection)dgShopRespDtos)) {
            return dgShopRespDtos;
        }
        this.setOrgLevelList(dgShopRespDtos);
        this.toSaleCompanyList(dgShopRespDtos);
        return dgShopRespDtos;
    }

    private void toSaleCompanyList(List<DgShopRespDto> list) {
        List shopIds = list.stream().map(BaseDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(shopIds)) {
            List rShopSalesCompanyEos = this.irShopSalesCompanyDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RShopSalesCompanyEo.class).in(CollectionUtils.isNotEmpty(shopIds), RShopSalesCompanyEo::getShopId, shopIds)).eq(BaseEo::getDr, (Object)0));
            if (CollectionUtils.isEmpty((Collection)rShopSalesCompanyEos)) {
                return;
            }
            List orgIds = rShopSalesCompanyEos.stream().map(RShopSalesCompanyEo::getCode).distinct().collect(Collectors.toList());
            List enterpriseEoList = this.iDgEnterpriseDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgEnterpriseEo.class).in(DgEnterpriseEo::getCode, orgIds));
            Map<String, Long> enterPriseIdMap = ((List)Optional.ofNullable(enterpriseEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgEnterpriseEo::getCode, DgEnterpriseEo::getId));
            Map<Long, List<RShopSalesCompanyEo>> map = rShopSalesCompanyEos.stream().collect(Collectors.groupingBy(RShopSalesCompanyEo::getShopId));
            list.forEach(e -> {
                List rShopSalesCompanyEo = (List)map.get(e.getId());
                List dgShopSaleCompanyReqDtoList = BeanUtil.copyToList((Collection)rShopSalesCompanyEo, DgShopSaleCompanyReqDto.class);
                if (CollectionUtils.isNotEmpty((Collection)dgShopSaleCompanyReqDtoList)) {
                    for (DgShopSaleCompanyReqDto companyReqDto : dgShopSaleCompanyReqDtoList) {
                        companyReqDto.setEnterpriseId((Long)enterPriseIdMap.get(companyReqDto.getCode()));
                    }
                }
                e.setSalesCompanyList(dgShopSaleCompanyReqDtoList);
            });
        }
    }

    public void setOrgLevelList(List<DgShopRespDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Long, List<DgOrganizationLevelDto>> orgLevelListMap = this.mapOrgLevel(list);
        list.forEach(o -> o.setSaleOrganizationLevelList((List)orgLevelListMap.get(o.getId())));
    }

    public Map<Long, List<DgOrganizationLevelDto>> mapOrgLevel(List<DgShopRespDto> list) {
        HashMap<Long, List<DgOrganizationLevelDto>> map = new HashMap<Long, List<DgOrganizationLevelDto>>();
        String rootOrgIdStr = RequestUtil.getHeader("Root-Organization-Id");
        if (!StrUtil.isNotBlank((CharSequence)rootOrgIdStr) || "undefined".equals(rootOrgIdStr)) {
            log.error("[\u67e5\u8be2\u5e97\u94fa]\u8bf7\u6c42\u5934\u4e2dRoot-Organization-Id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u7ec4\u7ec7\u5c42\u7ea7\u5173\u7cfb");
            return map;
        }
        long rootOrganizationId = Long.parseLong(rootOrgIdStr);
        Map<Long, Long> shopIdOrgIdMap = list.stream().collect(Collectors.toMap(BaseDto::getId, DgShopRespDto::getSaleOrganizationId, (k1, k2) -> k1));
        ArrayList organizationDtoList = new ArrayList();
        this.iUsOrganizationDomain.listChildOrgByOrgIdAndFuncType(Collections.singletonList(rootOrganizationId), "sales", organizationDtoList);
        if (CollectionUtils.isEmpty(organizationDtoList)) {
            return map;
        }
        Map organizationDtoMap = organizationDtoList.stream().collect(Collectors.toMap(CsOrganizationPageRespDto::getId, Function.identity(), (k1, k2) -> k1));
        shopIdOrgIdMap.forEach((shopId, orgId) -> {
            ArrayList<DgOrganizationLevelDto> orgLevelList = new ArrayList<DgOrganizationLevelDto>();
            this.getOrgLevel(rootOrganizationId, (Long)orgId, organizationDtoMap, (List<DgOrganizationLevelDto>)orgLevelList);
            map.put((Long)shopId, (List<DgOrganizationLevelDto>)orgLevelList);
        });
        return map;
    }

    private void getOrgLevel(Long rootOrganizationId, Long orgId, Map<Long, CsOrganizationPageRespDto> organizationDtoMap, List<DgOrganizationLevelDto> orgLevelList) {
        CsOrganizationPageRespDto organizationDto = organizationDtoMap.get(orgId);
        DgOrganizationLevelDto levelDto = (DgOrganizationLevelDto)BeanUtil.toBean((Object)organizationDto, DgOrganizationLevelDto.class);
        levelDto = Objects.isNull(levelDto) ? new DgOrganizationLevelDto() : levelDto;
        orgLevelList.add(levelDto);
        if (Objects.isNull(organizationDto) || Objects.equals(rootOrganizationId, organizationDto.getParentId())) {
            Collections.reverse(orgLevelList);
            return;
        }
        Long parentId = organizationDto.getParentId();
        this.getOrgLevel(rootOrganizationId, parentId, organizationDtoMap, orgLevelList);
    }

    private LambdaQueryWrapper<DgShopEo> buildLambdaQuery(DgShopQueryReqDto queryReqDto, Integer sourceType) {
        return (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.lambdaQuery(DgShopEo.class).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getIdList()), BaseEo::getId, (Collection)queryReqDto.getIdList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getSettlementTypeList()), DgShopEo::getSettlementType, (Collection)queryReqDto.getSettlementTypeList())).like(StrUtil.isNotBlank((CharSequence)queryReqDto.getStoreName()), DgShopEo::getName, (Object)queryReqDto.getStoreName())).like(StrUtil.isNotBlank((CharSequence)queryReqDto.getStoreCode()), DgShopEo::getCode, (Object)queryReqDto.getStoreCode())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getStoreCodeList()), DgShopEo::getCode, (Collection)queryReqDto.getStoreCodeList())).like(StrUtil.isNotBlank((CharSequence)queryReqDto.getCustomerCode()), DgShopEo::getCustomerCode, (Object)queryReqDto.getCustomerCode())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getCustomerCodeList()), DgShopEo::getCustomerCode, (Collection)queryReqDto.getCustomerCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getStatusList()), DgShopEo::getStatus, (Collection)queryReqDto.getStatusList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getCutPaymentTypeList()), DgShopEo::getCutPaymentType, (Collection)queryReqDto.getCutPaymentTypeList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getIsDistribModeList()), DgShopEo::getIsDistribMode, (Collection)queryReqDto.getIsDistribModeList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getStoreTypeList()), DgShopEo::getManageType, (Collection)queryReqDto.getStoreTypeList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getChannelCodeList()), DgShopEo::getChannelCode, (Collection)queryReqDto.getChannelCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getSaleOrganizationCodeList()), DgShopEo::getOrganizationCode, (Collection)queryReqDto.getSaleOrganizationCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getSaleOrganizationIdList()), DgShopEo::getOrganizationId, (Collection)queryReqDto.getSaleOrganizationIdList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getSaleCompanyCodeList()), DgShopEo::getCompanyCode, (Collection)queryReqDto.getSaleCompanyCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getSaleCompanyIdList()), DgShopEo::getCompanyId, (Collection)queryReqDto.getSaleCompanyIdList())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getLineTypeList()), DgShopEo::getType, (Collection)queryReqDto.getLineTypeList())).like(StrUtil.isNotBlank((CharSequence)queryReqDto.getSaleCompanyName()), DgShopEo::getCompanyName, (Object)queryReqDto.getSaleCompanyName())).like(StrUtil.isNotBlank((CharSequence)queryReqDto.getSaleCompanyCode()), DgShopEo::getCompanyCode, (Object)queryReqDto.getSaleCompanyCode())).eq(queryReqDto.getLineType() != null, DgShopEo::getType, (Object)queryReqDto.getLineType())).like(StrUtil.isNotBlank((CharSequence)queryReqDto.getCreatePerson()), BaseEo::getCreatePerson, (Object)queryReqDto.getCreatePerson())).eq(Objects.nonNull(queryReqDto.getCompanyId()), DgShopEo::getCompanyId, (Object)queryReqDto.getCompanyId())).ge(Objects.nonNull(queryReqDto.getCreateTimeStart()), BaseEo::getCreateTime, (Object)queryReqDto.getCreateTimeStart())).le(Objects.nonNull(queryReqDto.getCreateTimeEnd()), BaseEo::getCreateTime, (Object)queryReqDto.getCreateTimeEnd())).eq(Objects.nonNull(sourceType), DgShopEo::getSourceType, (Object)sourceType)).orderByDesc(BaseEo::getId);
    }
}

