/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryWarehouseDto;
import com.yunxi.dg.base.center.report.service.entity.IDomesticInventoryReportService;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import com.yunxi.dg.base.poi.utils.EasyPoiExportUtil;
import com.yunxi.dg.base.poi.utils.SystemConfig;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_domestic_inventory_report")
public class DomesticInventoryReportFileService
extends AbstractBaseFileOperationCommonService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DomesticInventoryReportFileService.class);
    @Resource
    private IDomesticInventoryReportService domesticInventoryReportService;

    public void afterPropertiesSet() throws Exception {
        String key = "domestic_inventory_report";
        PoiFileModeMap.importTemplateMap.put((Object)key, ImportBaseModeDto.class);
        PoiFileModeMap.importTemplateMap.put((Object)key, (Object)1);
        PoiFileModeMap.importTemplateMap.put((Object)key, (Object)"\u56fd\u5185\u5e93\u5b58\u62a5\u8868");
        PoiFileModeMap.exportTemplateMap.put((Object)key, ExportBaseModeDto.class);
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)2);
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)"\u56fd\u5185\u5e93\u5b58\u62a5\u8868");
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)"\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa");
    }

    public String uploadExportDataFile(ExportQueryParamsReqDto exportQueryParamsReqDto, String fileName, Class<? extends ExportBaseModeDto> exportTemplate) {
        int RETRY_MAX_COUNT = Integer.parseInt(SystemConfig.getProperty((String)"base.mgmt.export.retry.max.count", (String)"3"));
        DomesticInventoryReportPageReqDto req = (DomesticInventoryReportPageReqDto)JacksonUtil.readValue((String)exportQueryParamsReqDto.getFilter(), DomesticInventoryReportPageReqDto.class);
        ArrayList<DomesticInventoryReportDto> list = new ArrayList<DomesticInventoryReportDto>();
        int pageNum = 1;
        req.setPageSize(Integer.valueOf(1000));
        boolean hasNextPage = false;
        do {
            int count = 0;
            req.setPageNum(Integer.valueOf(pageNum));
            while (count < RETRY_MAX_COUNT) {
                try {
                    PageInfo<DomesticInventoryReportDto> page = this.domesticInventoryReportService.pageWithoutAlign(req);
                    log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875\uff0c\u91cd\u8bd5\u6b21\u6570 {}", new Object[]{pageNum, page.getSize(), page.getPages(), count});
                    if (page.getList() != null && !page.getList().isEmpty()) {
                        list.addAll(page.getList());
                    }
                    hasNextPage = page.isHasNextPage();
                    count = RETRY_MAX_COUNT + 1;
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25\u4e86\uff0c\u5f00\u59cb\u8fdb\u884c\u91cd\u8bd5\uff0c\u76ee\u524d\u91cd\u8bd5\u7684\u6b21\u6570={}", (Object)(++count), (Object)e);
                    if (count < RETRY_MAX_COUNT) continue;
                    throw new BizException("\u62c9\u53d6\u6570\u636e\u5931\u8d25\u4e86");
                }
            }
            ++pageNum;
        } while (!CollectionUtil.isEmpty(list) && hasNextPage);
        if (list.isEmpty()) {
            return null;
        }
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u5f00\u59cb\u5bf9\u9f50\u4ed3\u5e93\u4fe1\u606f");
        this.domesticInventoryReportService.alignWarehouses(req.getWarehouseCodes(), list);
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u5bf9\u9f50\u4ed3\u5e93\u4fe1\u606f\u5b8c\u6210\uff0c\u51c6\u5907\u8f6c\u6210 Workbook");
        Workbook workbook = this.getWorkbook(list);
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u8f6c\u6210 Workbook \u5b8c\u6210\uff0c\u51c6\u5907\u4e0a\u5230\u5bf9\u8c61\u5b58\u50a8");
        try {
            log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u5f00\u59cb\u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8");
            String url = EasyPoiExportUtil.getLoadWorkbookUrl((Workbook)workbook, (String)exportQueryParamsReqDto.getExportFileName());
            log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8\u6210\u529f\uff0curl={}", (Object)url);
            return url;
        }
        catch (Exception e) {
            log.error("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private Workbook getWorkbook(List<DomesticInventoryReportDto> list) {
        ExcelWriter writer = ExcelUtil.getBigWriter();
        ArrayList primaryTitles = Lists.newArrayList((Object[])new String[]{"\u671f\u95f4", "\u662f\u5426\u6dd8\u6c70", "\u8d27\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7cfb\u5217", "\u4ea7\u54c1\u4e8b\u4e1a\u90e8", "\u4ea7\u54c1IP", "\u4ea7\u54c1\u5c0f\u7c7b", "\u9500\u552e\u6e20\u9053", "\u5305\u88c5\u7c7b\u578b", "\u9500\u552e\u5355\u4ef7"});
        LinkedHashMap<String, List> warehouseTitleMap = new LinkedHashMap<String, List>();
        for (DomesticInventoryWarehouseDto warehouse : list.get(0).getWarehouses()) {
            warehouseTitleMap.put(warehouse.getWarehouseCode() + " - " + warehouse.getWarehouseName(), Lists.newArrayList((Object[])new String[]{"\u671f\u521d\u4ea7\u54c1\u6570\u91cf", "\u5165\u5e93\u4ea7\u54c1\u6570\u91cf\u5408\u8ba1", "\u51fa\u5e93\u4ea7\u54c1\u6570\u91cf\u5408\u8ba1", "\u6e20\u9053\u501f\u5165", "\u6e20\u9053\u501f\u51fa", "\u9884\u5907\u51fa\u5e93\u6570\u91cf\u5408\u8ba1", "\u671f\u672b\u73b0\u6709\u91cf", "\u5e93\u5b58\u91d1\u989d\u5408\u8ba1"}));
        }
        AtomicInteger col = new AtomicInteger(0);
        primaryTitles.forEach(title -> {
            int firstColumn = col.get();
            int lastColumn = col.addAndGet(1) - 1;
            writer.merge(0, 1, firstColumn, lastColumn, title, true);
        });
        ArrayList secondTitles = new ArrayList();
        warehouseTitleMap.forEach((title, values) -> {
            int firstCol = col.get();
            writer.merge(0, 0, col.get(), col.addAndGet(values.size()) - 1, title, true);
            secondTitles.addAll(values);
        });
        writer.setCurrentRow(1);
        writer.writeSecHeadRow(secondTitles);
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u5199\u5165\u6807\u9898\u5230 Workbook \u5b8c\u6210\uff0c\u51c6\u5907\u5199\u5165 {} \u6761\u6570\u636e", (Object)list.size());
        list.forEach(item -> {
            ArrayList row = Lists.newArrayList((Object[])new Object[]{item.getBizMonth(), Objects.equals(item.getEliminate(), 1) ? "\u662f" : "\u5426", item.getSkuCode(), item.getSkuName(), this.toEmpty(item.getSerialName()), this.toEmpty(item.getDepartmentName()), this.toEmpty(item.getSkuIpName()), this.toEmpty(item.getItemClassName()), this.toEmpty(item.getSalesChannelName()), item.getPackageNum(), this.plan(item.getRetailPrice())});
            List warehouses = item.getWarehouses();
            List warehouseRow = warehouses.stream().flatMap(warehouse -> Lists.newArrayList((Object[])new String[]{this.plan(warehouse.getOpeningStorageQty()), this.plan(warehouse.getInStorageQty()), this.plan(warehouse.getOutStorageQty()), this.plan(warehouse.getBorrowStorageQty()), this.plan(warehouse.getLendStorageQty()), this.plan(warehouse.getReadyOutStorageQty()), this.plan(warehouse.getEndStorageQty()), this.plan(warehouse.getStorageAmt())}).stream()).collect(Collectors.toList());
            row.addAll(warehouseRow);
            writer.writeRow((Iterable)row);
        });
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa: \u5199\u5165 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
        return writer.getWorkbook();
    }

    private String toEmpty(String value) {
        return value == null ? "" : value;
    }

    private String plan(BigDecimal value) {
        if (value == null) {
            return "";
        }
        return value.stripTrailingZeros().toPlainString();
    }
}

