/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.PurchaseSaleStockDetailReportConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.IPurchaseSaleStockDetailReportDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.ILogicInventorySnapshotDomain;
import com.yunxi.dg.base.center.report.dto.entity.CodeAndNameDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockDetailReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockTypeDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuRelevantInfoDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDetailPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDto;
import com.yunxi.dg.base.center.report.eo.PurchaseSaleStockDetailReportEo;
import com.yunxi.dg.base.center.report.service.entity.IPurchaseSaleStockDetailReportService;
import com.yunxi.dg.base.center.report.service.entity.IPurchaseSaleStockReportService;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSaleStockDetailReportServiceImpl
extends BaseServiceImpl<PurchaseSaleStockDetailReportDto, PurchaseSaleStockDetailReportEo, IPurchaseSaleStockDetailReportDomain>
implements IPurchaseSaleStockDetailReportService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSaleStockDetailReportServiceImpl.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ILogicInventorySnapshotDomain logicInventorySnapshotDomain;
    @Resource
    private IDgOutResultOrderDomain outResultOrderDomain;
    @Resource
    private IDgOutResultOrderDetailDomain outResultOrderDetailDomain;
    @Resource
    private IPurchaseSaleStockReportService purchaseSaleStockReportService;

    public PurchaseSaleStockDetailReportServiceImpl(IPurchaseSaleStockDetailReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PurchaseSaleStockDetailReportDto, PurchaseSaleStockDetailReportEo> converter() {
        return PurchaseSaleStockDetailReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> this.outResultOrderDomain.getMinUpdateTime());
        dto.syncByStep("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        List deletedBusinessDates = ((IPurchaseSaleStockDetailReportDomain)this.domain).queryBusinessDateBySourceUpdateTime(startTime, endTime);
        ((IPurchaseSaleStockDetailReportDomain)this.domain).physicsDeleteBySourceUpdateTime(startTime, endTime);
        if (!deletedBusinessDates.isEmpty()) {
            log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u91cd\u8dd1\u6536\u5f71\u54cd\u7684\u4e1a\u52a1\u65e5\u671f\uff1atimeRange={}-{}, businessDates={}", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), deletedBusinessDates});
        }
        int pageNum = 1;
        int pageSize = 1000;
        ArrayList<DgOutResultOrderDto> all = new ArrayList<DgOutResultOrderDto>();
        ArrayList orderTypes = Lists.newArrayList((Object[])new String[]{"in", "out"});
        do {
            PageInfo page = this.outResultOrderDomain.pageByUpdateTime(startTime, endTime, (List)orderTypes, pageNum, pageSize);
            log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            if (list == null || list.isEmpty()) continue;
            all.addAll(list);
        } while (hasNextPage);
        Set<LocalDate> businessDates = this.doSyncInternal(all);
        businessDates.addAll(deletedBusinessDates);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u4e00\u5171\u6709 {} \u5929\u7684\u6570\u636e\u9700\u8981\u89e6\u53d1\u6c47\u603b\u8868\u540c\u6b65\uff1a{}", (Object)businessDates.size(), businessDates);
        businessDates.stream().sorted().forEachOrdered(businessDate -> {
            ReportSyncReqDto req = new ReportSyncReqDto(businessDate.atStartOfDay(), businessDate.plusDays(1L).atStartOfDay(), Integer.valueOf(1));
            log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u89e6\u53d1 {} \u5b58\u5e93\u8fdb\u9500\u5b58\u62a5\u8868\u540c\u6b65\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", businessDate, (Object)JSONUtil.toJsonStr((Object)req));
            this.purchaseSaleStockReportService.syncWithParams(req);
        });
    }

    private Set<LocalDate> doSyncInternal(List<DgOutResultOrderDto> list) {
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u5171 {} \u6761\u8bb0\u5f55", (Object)list.size());
        if (list.isEmpty()) {
            return new HashSet<LocalDate>(0);
        }
        List<PurchaseSaleStockDetailReportDto> details = this.outResultOrdersToDetails(list);
        this.processRelevantInfo(details);
        List orderNoList = details.stream().map(PurchaseSaleStockDetailReportDto::getOrderNo).distinct().collect(Collectors.toList());
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e {}", orderNoList);
        ((IPurchaseSaleStockDetailReportDomain)this.domain).physicsDeleteByOrderNoList(orderNoList);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        ArrayList result = new ArrayList(list.size());
        HashSet<LocalDate> businessDates = new HashSet<LocalDate>();
        details.forEach(r -> {
            businessDates.add(LocalDateTimeUtil.of((TemporalAccessor)r.getBusinessDate()).toLocalDate());
            result.add(this.converter().toEo((BaseDto)r));
        });
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e", (Object)list.size());
        ((IPurchaseSaleStockDetailReportDomain)this.domain).insertBatch(result);
        log.info("\u5b58\u5e93\u8fdb\u9500\u5b58\u660e\u7ec6\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
        return businessDates;
    }

    private List<PurchaseSaleStockDetailReportDto> outResultOrdersToDetails(List<DgOutResultOrderDto> list) {
        Map<String, DgOutResultOrderDto> map = list.stream().collect(Collectors.toMap(DgOutResultOrderDto::getDocumentNo, v -> v, (a, b) -> {
            log.warn("cs_out_result_order\u8868\u5b58\u5728\u91cd\u590d\u7684 document_no: {}", (Object)a.getDocumentNo());
            return b;
        }));
        DgOutResultOrderDetailPageReqDto req = new DgOutResultOrderDetailPageReqDto();
        req.setDocumentNoList(new ArrayList<String>(map.keySet()));
        List orderDetails = this.outResultOrderDetailDomain.queryList(req);
        List<PurchaseSaleStockTypeDto> typeList = this.purchaseSaleStockReportService.getPurchaseSaleStockTypeList();
        HashMap businessTypeMap = new HashMap();
        PurchaseSaleStockTypeDto defaultInType = null;
        PurchaseSaleStockTypeDto defaultOutType = null;
        for (PurchaseSaleStockTypeDto type : typeList) {
            Optional.ofNullable(type.getBusinessTypes()).ifPresent(businessTypes -> businessTypes.forEach(businessType -> businessTypeMap.put(type.getOrderType() + "___" + businessType, type)));
            if (type.getDefaultType() == null || !type.getDefaultType().booleanValue()) continue;
            if ("in".equals(type.getOrderType())) {
                defaultInType = type;
            }
            if (!"out".equals(type.getOrderType())) continue;
            defaultOutType = type;
        }
        PurchaseSaleStockTypeDto finalDefaultInType = defaultInType;
        PurchaseSaleStockTypeDto finalDefaultOutType = defaultOutType;
        return orderDetails.stream().map(od -> {
            DgOutResultOrderDto order = (DgOutResultOrderDto)map.get(od.getDocumentNo());
            boolean isIn = "in".equals(order.getOrderType());
            LocalDateTime inOutTime = LocalDateTimeUtil.of((Date)(order.getInOutTime() != null ? order.getInOutTime() : order.getCreateTime()));
            LocalDate businessDate = inOutTime.toLocalDate();
            PurchaseSaleStockTypeDto type = businessTypeMap.getOrDefault(order.getOrderType() + "___" + order.getBusinessType(), isIn ? finalDefaultInType : finalDefaultOutType);
            return PurchaseSaleStockDetailReportDto.builder().businessDate(businessDate).skuCode(od.getSkuCode()).skuName(od.getSkuName()).warehouseCode(isIn ? order.getInLogicWarehouseCode() : order.getOutLogicWarehouseCode()).warehouseName(isIn ? order.getInLogicWarehouseName() : order.getOutLogicWarehouseName()).orderNo(order.getDocumentNo()).relevanceNo(order.getRelevanceNo()).orderType(order.getOrderType()).inOutTime(inOutTime).type(type != null ? type.getCode() : null).documentType(order.getBusinessType()).businessType(order.getDisplayBusinessType()).quantity(od.getDoneQuantity()).sourceUpdateTime(LocalDateTimeUtil.of((Date)order.getUpdateTime())).build();
        }).collect(Collectors.toList());
    }

    @Override
    public void processRelevantInfo(List<PurchaseSaleStockDetailReportDto> list) {
        HashSet<String> skuCodes = new HashSet<String>();
        HashSet warehouseCodes = new HashSet();
        list.forEach(r -> {
            skuCodes.add(r.getSkuCode());
            warehouseCodes.add(r.getWarehouseCode());
        });
        Map<String, SkuRelevantInfoDto> skuMap = this.itemSkuDgService.querySkuRelevantInfoMap(skuCodes);
        Map salesCompanyMap = this.logicWarehouseDomain.querySalesCompanyMap(warehouseCodes);
        list.forEach(r -> {
            SkuRelevantInfoDto sku;
            CodeAndNameDto company = (CodeAndNameDto)salesCompanyMap.get(r.getWarehouseCode());
            if (company != null) {
                r.setSalesCompanyCode(company.getCode());
                r.setSalesCompanyName(company.getName());
                r.setWarehouseName(company.getOtherName());
            }
            if ((sku = (SkuRelevantInfoDto)skuMap.get(r.getSkuCode())) != null) {
                r.setSkuName(sku.getSkuName());
                r.setSerialCode(sku.getSerialCode());
                r.setSerialName(sku.getSerialName());
                r.setItemClassCode(sku.getItemClassCode());
                r.setItemClassName(sku.getItemClassName());
                r.setRetailPrice(sku.getFactoryPrice());
                r.setUnit(sku.getUnit());
                if (sku.getFactoryPrice() != null && r.getQuantity() != null) {
                    r.setAmount(r.getQuantity().multiply(sku.getFactoryPrice()));
                }
            }
        });
    }

    @Override
    public PageInfo<PurchaseSaleStockDetailReportDto> page(PurchaseSaleStockDetailReportPageReqDto dto) {
        PageInfo page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((IPurchaseSaleStockDetailReportDomain)this.domain).queryList(dto));
        this.processRelevantInfo(page.getList());
        return page;
    }

    @Override
    public LocalDateTime getLastSourceUpdateTime() {
        return ((IPurchaseSaleStockDetailReportDomain)this.domain).getLastSourceUpdateTime();
    }
}

