/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.IDictQueryApiProxy;
import com.yunxi.dg.base.center.report.constants.SalesOrderDetailReportSourceTypeEnum;
import com.yunxi.dg.base.center.report.convert.entity.SalesOrderDetailReportConverter;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCompanyInfoDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationShopDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerTypeDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICustomerBelongMappingDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.entity.ISalesOrderDetailReportDomain;
import com.yunxi.dg.base.center.report.domain.item.ISerialCodeDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgBusinessAuditDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsCustomerAreaInfoDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.dto.entity.SalesOrderDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.SalesOrderDetailReportJoinDto;
import com.yunxi.dg.base.center.report.dto.entity.SalesOrderDetailReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuRelevantInfoDto;
import com.yunxi.dg.base.center.report.dto.invoice.BillInfoConditionDto;
import com.yunxi.dg.base.center.report.dto.invoice.BillInfoRespDto;
import com.yunxi.dg.base.center.report.dto.trade.DgPerformNoticeSyncItemCountDto;
import com.yunxi.dg.base.center.report.eo.CustomerBelongMappingEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.report.eo.DgShopEo;
import com.yunxi.dg.base.center.report.eo.SalesOrderDetailReportEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsCompanyInfoEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationShopEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerTypeEo;
import com.yunxi.dg.base.center.report.eo.customer.DgOrgCustomerRelationEo;
import com.yunxi.dg.base.center.report.eo.item.SerialCodeEo;
import com.yunxi.dg.base.center.report.eo.trade.DgBusinessAuditEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.report.service.entity.ISalesOrderDetailReportService;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgService;
import com.yunxi.dg.base.center.report.service.utils.HttpUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SalesOrderDetailReportServiceImpl
extends BaseServiceImpl<SalesOrderDetailReportDto, SalesOrderDetailReportEo, ISalesOrderDetailReportDomain>
implements ISalesOrderDetailReportService {
    private static final Logger log = LoggerFactory.getLogger(SalesOrderDetailReportServiceImpl.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgShopDomain dgShopDomain;
    @Resource
    private IDgCsRRelationShopDomain dgCsRRelationShopDomain;
    @Resource
    private IDgCsOrgCustomerRelationDomain dgCsOrgCustomerRelationDomain;
    @Resource
    private IDgBusinessAuditDomain dgBusinessAuditDomain;
    @Resource
    private IDgCustomerAreaDomain dgCustomerAreaDomain;
    @Resource
    private IDgCustomerDomain dgCustomerDomain;
    @Resource
    private IDgCsCompanyInfoDomain dgCsCompanyInfoDomain;
    @Resource
    private IDgCustomerTypeDomain dgCustomerTypeDomain;
    @Resource
    private ISerialCodeDomain serialCodeDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private ICustomerBelongMappingDomain customerBelongMappingDomain;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgPerformNoticeSyncRecordDomain dgPerformNoticeSyncRecordDomain;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Value(value="${oms.project.name:}")
    private String omsProjectName;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public SalesOrderDetailReportServiceImpl(ISalesOrderDetailReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SalesOrderDetailReportDto, SalesOrderDetailReportEo> converter() {
        return SalesOrderDetailReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> this.dgPerformOrderInfoDomain.getMinUpdateTime());
        dto.syncByStep("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        ((ISalesOrderDetailReportDomain)this.domain).physicsDeleteByOrderUpdateTime(startTime, endTime);
        int pageNum = 1;
        int pageSize = 1000;
        ArrayList<DgPerformOrderInfoEo> all = new ArrayList<DgPerformOrderInfoEo>();
        do {
            PageInfo page = this.dgPerformOrderInfoDomain.pageSalesOrderByUpdateTime(startTime, endTime, pageNum, pageSize);
            log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u540c\u6b65: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            if (list == null || list.isEmpty()) continue;
            all.addAll(list);
        } while (hasNextPage);
        this.doSyncInternal(all);
    }

    private void doSyncInternal(List<DgPerformOrderInfoEo> infoList) {
        ArrayList<Long> deletedOrderIds = new ArrayList<Long>();
        infoList = infoList.stream().peek(info -> {
            if (info.getDr().equals(1)) {
                deletedOrderIds.add(info.getId());
            }
        }).filter(eo -> eo.getDr().equals(0)).collect(Collectors.toList());
        if (!deletedOrderIds.isEmpty()) {
            log.info("\u4ee5\u4e0b\u8ba2\u5355\u5df2\u88ab\u903b\u8f91\u5220\u9664\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u5230\u62a5\u8868\u4e2d\uff1a{}", deletedOrderIds);
        }
        List<SalesOrderDetailReportJoinDto> list = this.process_tr_dg_perform_order_info(infoList);
        List<Long> orderIds = list.stream().map(SalesOrderDetailReportDto::getOrderId).collect(Collectors.toList());
        this.process_tr_dg_perform_order_snapshot(orderIds, list);
        this.process_sc_shop(list);
        this.process_dg_cs_org_customer_relation_And_dg_cs_r_relation_shop(list);
        this.process_tr_dg_business_audit(orderIds, list);
        this.process_dg_cs_customer_area(list);
        this.process_dg_cs_customer(list);
        this.process_dg_cs_company_info(list);
        this.process_dg_cs_customer_type(list);
        this.process_oea_customer_belong_mapping(list);
        list = this.process_tr_dg_perform_order_line(orderIds, list);
        this.process_tr_dg_perform_order_line_amount(orderIds, list);
        this.process_tr_dg_perform_order_addr(orderIds, list);
        this.process_tr_dg_perform_notice_sync_record(orderIds, list);
        this.process_it_item_sku_dg(list);
        this.process_it_serial_code(list);
        if (StringUtils.isNotBlank((CharSequence)this.omsProjectName) && "HCK".equalsIgnoreCase(this.omsProjectName)) {
            this.process_fin_bill_info(list);
        }
        deletedOrderIds.addAll(orderIds);
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u8ba2\u5355\u7684\u65e7\u6570\u636e {}", deletedOrderIds);
        Lists.partition(deletedOrderIds, (int)1000).forEach(once -> ((ISalesOrderDetailReportDomain)this.domain).physicsDeleteByOrderIds(once));
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u8ba2\u5355\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e", (Object)list.size());
        List eoList = list.stream().map(k -> (SalesOrderDetailReportEo)this.converter().toEo((BaseDto)k)).collect(Collectors.toList());
        ((ISalesOrderDetailReportDomain)this.domain).insertBatch(eoList);
        log.info("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
    }

    private void process_oea_customer_belong_mapping(List<SalesOrderDetailReportJoinDto> list) {
        Set shopCodes = list.stream().map(SalesOrderDetailReportDto::getShopCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!shopCodes.isEmpty()) {
            return;
        }
        Map mappingMap = this.customerBelongMappingDomain.queryUniqueKeyMapByShopCodes(shopCodes);
        list.forEach(join -> {
            if (join.getShopCode() == null) {
                return;
            }
            CustomerBelongMappingEo mapping = (CustomerBelongMappingEo)mappingMap.get(join.getShopCode());
            if (mapping == null) {
                return;
            }
            join.setCustomerBelongId(mapping.getId());
            join.setCustomerBelongCode(mapping.getCustomerBelongCode());
            join.setCustomerBelongName(mapping.getCustomerBelongName());
        });
    }

    private List<SalesOrderDetailReportJoinDto> process_tr_dg_perform_order_line_amount(List<Long> orderIds, List<SalesOrderDetailReportJoinDto> list) {
        if (orderIds.isEmpty()) {
            return list;
        }
        List amounts = this.dgPerformOrderLineAmountDomain.selectByOrderIds(orderIds);
        Map<Long, List<DgPerformOrderLineAmountEo>> amountMap = amounts.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId));
        list.forEach(join -> {
            List joinAmounts = (List)amountMap.get(join.getOrderLineId());
            if (joinAmounts == null) {
                return;
            }
            BigDecimal expenseDeductionAmount = BigDecimal.ZERO;
            BigDecimal orderAmount = BigDecimal.ZERO;
            BigDecimal orderSettlementAmount = BigDecimal.ZERO;
            for (DgPerformOrderLineAmountEo amount : joinAmounts) {
                if ("LINE_COST_AMOUNT".equals(amount.getAccountCategory())) {
                    expenseDeductionAmount = expenseDeductionAmount.add(Optional.ofNullable(amount.getAmount()).orElse(BigDecimal.ZERO));
                }
                if ("LINE_ORIG_PRICE".equals(amount.getAccountType())) {
                    orderAmount = orderAmount.add(Optional.ofNullable(amount.getAmount()).orElse(BigDecimal.ZERO));
                }
                if (!"LINE_ACTUAL_PRICE".equals(amount.getAccountType())) continue;
                orderSettlementAmount = orderSettlementAmount.add(Optional.ofNullable(amount.getAmount()).orElse(BigDecimal.ZERO));
            }
            join.setExpenseDeductionAmount(expenseDeductionAmount);
            join.setOrderAmount(orderAmount);
            join.setOrderSettlementAmount(orderSettlementAmount);
            if (join.getOrderAmount().compareTo(BigDecimal.ZERO) != 0) {
                join.setRebateDiscount(join.getExpenseDeductionAmount().divide(join.getOrderAmount(), 4, RoundingMode.HALF_UP));
            } else {
                join.setRebateDiscount(BigDecimal.ZERO);
            }
            join.setSalesPerformanceAmount(orderAmount);
            if (join.getIsRebate().equals(1)) {
                join.setRebateBasisAmount(orderAmount);
            } else {
                join.setRebateBasisAmount(BigDecimal.ZERO);
            }
        });
        return list;
    }

    private void process_tr_dg_perform_order_addr(List<Long> orderIds, List<SalesOrderDetailReportJoinDto> list) {
        if (orderIds.isEmpty()) {
            return;
        }
        List addressList = this.dgPerformOrderAddrDomain.selectByOrderIds(orderIds);
        Map<Long, DgPerformOrderAddrEo> addressMap = addressList.stream().collect(Collectors.toMap(DgPerformOrderAddrEo::getOrderId, v -> v, (a, b) -> b));
        list.forEach(join -> {
            DgPerformOrderAddrEo addr = (DgPerformOrderAddrEo)addressMap.get(join.getOrderId());
            if (addr == null) {
                return;
            }
            join.setContactPerson(addr.getReceiveName());
        });
    }

    private void process_tr_dg_perform_notice_sync_record(List<Long> orderIds, List<SalesOrderDetailReportJoinDto> list) {
        if (orderIds.isEmpty()) {
            return;
        }
        List countList = this.dgPerformNoticeSyncRecordDomain.queryOutItemQuantityByOrderIds(orderIds);
        Map<Long, BigDecimal> countMap = countList.stream().collect(Collectors.toMap(DgPerformNoticeSyncItemCountDto::getOrderLineId, DgPerformNoticeSyncItemCountDto::getQuantity, (a, b) -> b));
        list.forEach(join -> {
            BigDecimal doneQuantity = (BigDecimal)countMap.get(join.getOrderLineId());
            if (doneQuantity == null) {
                join.setWaitQuantity(BigDecimal.ZERO);
                return;
            }
            BigDecimal waitQuantity = join.getItemNum().subtract(doneQuantity);
            join.setWaitQuantity(waitQuantity);
        });
    }

    private void process_it_serial_code(List<SalesOrderDetailReportJoinDto> list) {
        List serialIds = list.stream().map(SalesOrderDetailReportJoinDto::getSerialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (serialIds.isEmpty()) {
            return;
        }
        List serials = this.serialCodeDomain.selectByIds(serialIds);
        Map<Long, SerialCodeEo> skuMap = serials.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        list.forEach(join -> {
            SerialCodeEo serial = (SerialCodeEo)skuMap.get(join.getSerialId());
            if (serial == null) {
                return;
            }
            join.setSerialName(serial.getName());
        });
    }

    private void process_fin_bill_info(List<SalesOrderDetailReportJoinDto> list) {
        List platformOrderNos = list.stream().map(SalesOrderDetailReportDto::getSaleOrderNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List customerCodes = list.stream().map(SalesOrderDetailReportDto::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List shopCodes = list.stream().map(SalesOrderDetailReportDto::getShopCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(platformOrderNos)) {
            return;
        }
        try {
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("oms-hck-cool-url", "oms-hck-cool-url"));
            log.info("\u67e5\u8be2\u914d\u7f6e\u7684\u6570\u636e\u5b57\u5178\uff1a{}", (Object)JSONObject.toJSONString((Object)dictDto));
            if (Objects.isNull(dictDto) || CollectionUtils.isEmpty((Collection)dictDto.getDictValueList())) {
                return;
            }
            Map<String, String> collect = dictDto.getDictValueList().stream().collect(Collectors.toMap(x -> x.getValue(), x -> x.getLabel(), (k1, k2) -> k1));
            String omsOrderUrl = collect.get("url") + collect.get("bill_query");
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            BillInfoConditionDto conditionDto = new BillInfoConditionDto();
            conditionDto.setPlatformOrderNos(platformOrderNos);
            conditionDto.setCustomerCodes(customerCodes);
            conditionDto.setShopCodes(shopCodes);
            conditionDto.setBillTypes(Arrays.asList("blue_ticket"));
            String result = HttpUtils.post(omsOrderUrl, JSONObject.toJSONString((Object)conditionDto), header);
            log.info("\u67e5\u8be2\u5f00\u7968\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (!"0".equals(jsonObject.getString("resultCode")) && !"200".equals(jsonObject.getString("resultCode"))) {
                return;
            }
            Map billInfoRespDtoMap = (Map)JSONObject.parseObject((String)jsonObject.getString("data"), Map.class);
            log.info("\u67e5\u8be2\u5f00\u7968\u4fe1\u606fbillInfoRespDtoMap:{}", (Object)JSONObject.toJSONString((Object)billInfoRespDtoMap));
            list.forEach(v -> {
                if (billInfoRespDtoMap.containsKey(v.getSaleOrderNo())) {
                    BillInfoRespDto billInfoRespDto = (BillInfoRespDto)billInfoRespDtoMap.get(v.getSaleOrderNo());
                    if (Objects.isNull(billInfoRespDto)) {
                        return;
                    }
                    v.setInvoiceState(billInfoRespDto.getInvoiceState());
                    v.setExternalInvoiceTime(null != billInfoRespDto.getExternalInvoiceTime() ? DateUtil.getDateFormat((Date)billInfoRespDto.getExternalInvoiceTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
                    v.setInvoiceCreateTime(null != billInfoRespDto.getCreateTime() ? DateUtil.getDateFormat((Date)billInfoRespDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
                }
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f00\u7968\u4fe1\u606f\u5f02\u5e38\uff1a{},{}", (Object)e, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void process_it_item_sku_dg(List<SalesOrderDetailReportJoinDto> list) {
        Set<String> skuCodes = list.stream().map(SalesOrderDetailReportDto::getSkuCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (skuCodes.isEmpty()) {
            return;
        }
        Map<String, SkuRelevantInfoDto> skuMap = this.itemSkuDgService.querySkuRelevantInfoMap(skuCodes);
        list.forEach(join -> {
            SkuRelevantInfoDto sku = (SkuRelevantInfoDto)skuMap.get(join.getSkuCode());
            if (sku == null) {
                return;
            }
            join.setDepartmentCode(sku.getDepartmentCode());
            join.setDepartmentName(sku.getDepartmentName());
            join.setSerialId(sku.getSerialId());
            join.setSerialCode(sku.getSerialCode());
            join.setItemClassCode(sku.getItemClassCode());
            join.setItemClassName(sku.getItemClassName());
            join.setItemIpCode(sku.getItemIpCode());
            join.setItemIpName(sku.getItemIpName());
        });
    }

    private List<SalesOrderDetailReportJoinDto> process_dg_cs_customer_type(List<SalesOrderDetailReportJoinDto> list) {
        List customerTypeIds = list.stream().map(SalesOrderDetailReportDto::getCustomerTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (customerTypeIds.isEmpty()) {
            return list;
        }
        List customerTypes = this.dgCustomerTypeDomain.selectByIds(customerTypeIds);
        Map<Long, DgCustomerTypeEo> customerTypeMap = customerTypes.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        list.forEach(join -> {
            if (join.getCustomerTypeId() == null) {
                return;
            }
            DgCustomerTypeEo customerType = (DgCustomerTypeEo)customerTypeMap.get(join.getCustomerTypeId());
            if (customerType == null) {
                return;
            }
            join.setCustomerTypeName(customerType.getName());
        });
        return list;
    }

    private List<SalesOrderDetailReportJoinDto> process_dg_cs_company_info(List<SalesOrderDetailReportJoinDto> list) {
        List companyIds = list.stream().map(SalesOrderDetailReportDto::getCompanyId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (companyIds.isEmpty()) {
            return list;
        }
        List companies = this.dgCsCompanyInfoDomain.selectByIds(companyIds);
        Map<Long, DgCsCompanyInfoEo> companyMap = companies.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        list.forEach(join -> {
            DgCsCompanyInfoEo company = (DgCsCompanyInfoEo)companyMap.get(join.getCompanyId());
            if (company == null) {
                return;
            }
            join.setCompanyName(company.getCompanyName());
            join.setLegalName(company.getLegalName());
        });
        return list;
    }

    private void process_dg_cs_customer(List<SalesOrderDetailReportJoinDto> list) {
        List customerIds = list.stream().map(SalesOrderDetailReportJoinDto::getCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (customerIds.isEmpty()) {
            return;
        }
        List customers = this.dgCustomerDomain.selectByIds(customerIds);
        Map<Long, DgCustomerEo> customerMap = customers.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        list.forEach(join -> {
            DgCustomerEo customer = (DgCustomerEo)customerMap.get(join.getCustomerId());
            if (customer == null) {
                return;
            }
            join.setCompanyId(customer.getCompanyId());
        });
    }

    private void process_dg_cs_customer_area(List<SalesOrderDetailReportJoinDto> list) {
        List areaIds = list.stream().map(SalesOrderDetailReportJoinDto::getAreaId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (areaIds.isEmpty()) {
            return;
        }
        Map map = this.dgCustomerAreaDomain.getAreaInfoMap(areaIds);
        list.forEach(join -> {
            CsCustomerAreaInfoDto area = (CsCustomerAreaInfoDto)map.get(join.getAreaId());
            if (area == null) {
                log.info("saleOrderNo={}, areaId:{} not found", (Object)join.getSaleOrderNo(), (Object)join.getAreaId());
                return;
            }
            join.setRegionCode(area.getRegionCode());
            join.setRegionName(area.getRegionName());
            join.setProvinceCode(area.getProvinceCode());
            join.setProvinceName(area.getProvinceName());
            join.setCityCode(area.getCityCode());
            join.setCityName(area.getCityName());
        });
    }

    private List<SalesOrderDetailReportJoinDto> process_tr_dg_perform_order_info(List<DgPerformOrderInfoEo> infoList) {
        return infoList.stream().map(info -> {
            SalesOrderDetailReportJoinDto eo = new SalesOrderDetailReportJoinDto();
            eo.setOrderId(info.getId());
            eo.setSaleOrderNo(info.getSaleOrderNo());
            eo.setBizModel(info.getBizModel());
            eo.setSourceType(this.getSourceType((DgPerformOrderInfoEo)info));
            eo.setOrderType(info.getOrderType());
            eo.setOrderStatus(info.getOrderStatus());
            eo.setOrderTime(info.getCreateTime());
            eo.setOrderUpdateTime(info.getUpdateTime());
            eo.setDeliveryTime(info.getDeliveryTime());
            eo.setTenantId(info.getTenantId());
            eo.setInstanceId(info.getInstanceId());
            return eo;
        }).collect(Collectors.toList());
    }

    private String getSourceType(DgPerformOrderInfoEo info) {
        if ("F2B_ORDER".equals(info.getBizModel()) && !Lists.newArrayList((Object[])new String[]{"overseas_order", "change_delivery_order", "stock_reform_order", "intact_goods_receive", "popularize_goods_receive", "toc_intact_goods_receive"}).contains(info.getOrderType())) {
            return SalesOrderDetailReportSourceTypeEnum.CARGO_ORDER.getCode();
        }
        if ("F2B_ORDER".equals(info.getBizModel()) && Lists.newArrayList((Object[])new String[]{"overseas_order", "change_delivery_order", "stock_reform_order"}).contains(info.getOrderType())) {
            return SalesOrderDetailReportSourceTypeEnum.REFORM_ORDER.getCode();
        }
        if ("overseas_order".equals(info.getOrderType())) {
            return SalesOrderDetailReportSourceTypeEnum.OVERSEAS_ORDER.getCode();
        }
        if ("INSIDE_SALES_ORDER".equals(info.getBizModel()) && !Lists.newArrayList((Object[])new String[]{"overseas_order", "change_delivery_order", "stock_reform_order", "platform_settlement_order", "e3_sale_order"}).contains(info.getOrderType())) {
            return SalesOrderDetailReportSourceTypeEnum.B2B_SALES_ORDER.getCode();
        }
        return null;
    }

    private void process_tr_dg_perform_order_snapshot(List<Long> orderIds, List<SalesOrderDetailReportJoinDto> list) {
        if (orderIds.isEmpty()) {
            return;
        }
        List snapshots = this.dgPerformOrderSnapshotDomain.selectByOrderIds(orderIds);
        Map<Long, DgPerformOrderSnapshotEo> snapshotMap = snapshots.stream().collect(Collectors.toMap(DgPerformOrderSnapshotEo::getOrderId, v -> v));
        list.forEach(join -> {
            DgPerformOrderSnapshotEo snapshot = (DgPerformOrderSnapshotEo)snapshotMap.get(join.getOrderId());
            if (snapshot == null) {
                return;
            }
            join.setShopId(snapshot.getShopId());
            join.setShopCode(snapshot.getShopCode());
            join.setShopName(snapshot.getShopName());
            join.setCustomerId(snapshot.getCustomerId());
            join.setCustomerCode(snapshot.getCustomerCode());
            join.setCustomerName(snapshot.getCustomerName());
            join.setEnterpriseCode(snapshot.getEnterpriseCode());
            join.setEnterpriseName(snapshot.getEnterpriseName());
        });
    }

    private void process_sc_shop(List<SalesOrderDetailReportJoinDto> list) {
        Set shopCodes = list.stream().map(SalesOrderDetailReportDto::getShopCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (shopCodes.isEmpty()) {
            return;
        }
        int type = 1;
        int manageType = 1;
        int sourceType = 1;
        List shops = this.dgShopDomain.selectByCodes(type, manageType, sourceType, shopCodes);
        Map<String, DgShopEo> shopMap = shops.stream().collect(Collectors.toMap(DgShopEo::getCode, v -> v));
        list.forEach(join -> {
            DgShopEo shop = (DgShopEo)shopMap.get(join.getShopCode());
            if (shop == null) {
                return;
            }
            join.setBusinessUnitCode(shop.getBusinessUnitCode());
            join.setBusinessUnitName(shop.getBusinessUnitName());
        });
    }

    private void process_dg_cs_org_customer_relation_And_dg_cs_r_relation_shop(List<SalesOrderDetailReportJoinDto> list) {
        Set customerIds = list.stream().map(SalesOrderDetailReportJoinDto::getCustomerId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (customerIds.isEmpty()) {
            return;
        }
        int status = 4;
        List relations = this.dgCsOrgCustomerRelationDomain.queryByCustomerIdsAndStatus(customerIds, status);
        Map<Long, List<DgOrgCustomerRelationEo>> relationMap = relations.stream().collect(Collectors.groupingBy(DgOrgCustomerRelationEo::getCustomerId));
        List relationIds = relations.stream().map(BaseEo::getId).collect(Collectors.toList());
        List relationShops = this.dgCsRRelationShopDomain.queryByRelationIds(relationIds);
        Map<String, DgCsRRelationShopEo> shopMap = relationShops.stream().collect(Collectors.toMap(k -> k.getRelationId() + "-" + k.getShopId(), v -> v));
        list.forEach(join -> {
            join.setIsPaymentPeriod(Integer.valueOf(0));
            join.setIsAutoInvoice(Integer.valueOf(0));
            List joinRelations = relationMap.getOrDefault(join.getCustomerId(), new ArrayList(0));
            joinRelations = joinRelations.stream().filter(relation -> shopMap.containsKey(relation.getId() + "-" + join.getShopId())).collect(Collectors.toList());
            if (joinRelations.isEmpty()) {
                return;
            }
            DgOrgCustomerRelationEo relation2 = (DgOrgCustomerRelationEo)joinRelations.get(0);
            DgCsRRelationShopEo shop = (DgCsRRelationShopEo)shopMap.get(relation2.getId() + "-" + join.getShopId());
            join.setIsPaymentPeriod(relation2.getIsPaymentPeriod());
            join.setIsAutoInvoice(relation2.getIsAutoInvoice());
            join.setAreaId(relation2.getAreaId());
            join.setAuthFee(relation2.getAuthFee());
            join.setCustomerTypeId(shop.getCustomerTypeId());
        });
    }

    private void process_tr_dg_business_audit(List<Long> orderIds, List<SalesOrderDetailReportJoinDto> list) {
        if (orderIds.isEmpty()) {
            return;
        }
        int businessType = 1;
        int auditType = 1;
        List audits = this.dgBusinessAuditDomain.queryByBusinessIds(businessType, auditType, orderIds);
        Map<Long, List<DgBusinessAuditEo>> auditMap = audits.stream().collect(Collectors.groupingBy(DgBusinessAuditEo::getBusinessId));
        list.forEach(join -> {
            List joinAudits = auditMap.getOrDefault(join.getOrderId(), new ArrayList(0));
            if (joinAudits.isEmpty()) {
                return;
            }
            joinAudits.stream().max(Comparator.comparing(BaseEo::getCreateTime)).ifPresent(audit -> join.setAuditTime(audit.getAuditTime()));
        });
    }

    private List<SalesOrderDetailReportJoinDto> process_tr_dg_perform_order_line(List<Long> orderIds, List<SalesOrderDetailReportJoinDto> list) {
        if (orderIds.isEmpty()) {
            return list;
        }
        List lines = this.dgPerformOrderLineDomain.selectByOrderIds(orderIds);
        Map<Long, List<DgPerformOrderLineEo>> lineMap = lines.stream().collect(Collectors.groupingBy(DgPerformOrderLineEo::getOrderId));
        return list.stream().flatMap(join -> {
            List joinLines = lineMap.getOrDefault(join.getOrderId(), new ArrayList(0));
            return joinLines.stream().map(line -> {
                SalesOrderDetailReportJoinDto newJoin = new SalesOrderDetailReportJoinDto();
                BeanUtils.copyProperties((Object)join, (Object)newJoin);
                newJoin.setOrderLineId(line.getId());
                newJoin.setSkuCode(line.getSkuCode());
                newJoin.setSkuName(line.getSkuName());
                newJoin.setVolume(line.getVolume());
                newJoin.setSalePrice(line.getSalePrice());
                BigDecimal itemNum = Optional.ofNullable(line.getItemNum()).orElse(BigDecimal.ONE);
                BigDecimal packingNumber = BigDecimal.ONE;
                if (itemNum.compareTo(BigDecimal.ZERO) != 0) {
                    packingNumber = Optional.ofNullable(line.getBasicNum()).orElse(BigDecimal.ZERO).divide(itemNum, 2, RoundingMode.DOWN);
                }
                newJoin.setPackingNumber(packingNumber);
                newJoin.setPlaceItemNum(line.getPlaceItemNum());
                newJoin.setItemNum(line.getItemNum());
                BigDecimal unmetNum = Optional.ofNullable(line.getPlaceItemNum()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(line.getItemNum()).orElse(BigDecimal.ZERO));
                newJoin.setUnmetNum(unmetNum);
                newJoin.setUnmetAmount(unmetNum.multiply(Optional.ofNullable(line.getSalePrice()).orElse(BigDecimal.ZERO)));
                newJoin.setHandmadeDiscount(line.getHandmadeDiscount());
                newJoin.setCalcItemNum(line.getCalcItemNum());
                newJoin.setIsRebate(line.getIsRebate());
                return newJoin;
            });
        }).collect(Collectors.toList());
    }

    @Override
    public PageInfo<SalesOrderDetailReportDto> page(SalesOrderDetailReportPageReqDto dto) {
        return PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((ISalesOrderDetailReportDomain)this.domain).queryList(dto));
    }

    @Override
    public LocalDateTime getLastOrderUpdateTime() {
        return ((ISalesOrderDetailReportDomain)this.domain).getLastOrderUpdateTime();
    }
}

