/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.expense.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.expense.IActivityCostFormDomain;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostFormDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostFormListReqDto;
import com.yunxi.dg.base.center.report.dto.expense.BudgetObjectInfoDto;
import com.yunxi.dg.base.center.report.service.expense.BudgetUtils;
import com.yunxi.dg.base.center.report.service.expense.IActivityCostFormService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityCostFormServiceImpl
implements IActivityCostFormService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCostFormServiceImpl.class);
    @Resource
    private IActivityCostFormDomain activityCostFormDomain;
    @Resource
    private BudgetUtils budgetUtils;

    @Override
    public ActivityCostFormDto getById(Long id) {
        ActivityCostFormDto activityCostFormDto = this.activityCostFormDomain.queryById(id);
        if (Objects.isNull(activityCostFormDto)) {
            throw new BizException("\u627e\u4e0d\u5230\u6d3b\u52a8\u5f62\u5f0f");
        }
        this.budgetUtils.dealObjectName(Lists.newArrayList((Object[])new BudgetObjectInfoDto[]{activityCostFormDto}));
        return activityCostFormDto;
    }

    @Override
    public List<ActivityCostFormDto> getByActivityCostId(Long activityCostId) {
        List activityCostFormDtos = this.activityCostFormDomain.queryByActivityCostId(activityCostId);
        if (CollectionUtils.isEmpty((Collection)activityCostFormDtos)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        list.addAll(activityCostFormDtos);
        this.budgetUtils.dealObjectName(list);
        activityCostFormDtos.forEach(this::setValidityVerifyTime);
        return activityCostFormDtos;
    }

    @Override
    public List<ActivityCostFormDto> getActivityCostFormList(ActivityCostFormListReqDto reqDto) {
        List activityCostFormDtos = this.activityCostFormDomain.getActivityCostFormList(reqDto);
        if (CollectionUtils.isEmpty((Collection)activityCostFormDtos)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        list.addAll(activityCostFormDtos);
        this.budgetUtils.dealObjectName(list);
        return activityCostFormDtos;
    }

    private void setValidityVerifyTime(ActivityCostFormDto activityCostFormDto) {
        if (Objects.isNull(activityCostFormDto.getValidityVerify())) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        if (Objects.equals(activityCostFormDto.getClosureStatus(), 1) && Objects.nonNull(activityCostFormDto.getClosureTime())) {
            calendar.setTime(activityCostFormDto.getClosureTime());
        } else {
            calendar.setTime(activityCostFormDto.getEndTime());
        }
        if (Objects.equals(activityCostFormDto.getValidityVerifyUnit(), 1)) {
            calendar.add(5, activityCostFormDto.getValidityVerify());
        } else {
            calendar.add(2, activityCostFormDto.getValidityVerify());
        }
        activityCostFormDto.setValidityVerifyTime(calendar.getTime());
    }
}

