/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.expense.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.domain.expense.IActivityCostDomain;
import com.yunxi.dg.base.center.report.domain.expense.IActivityCostPayDomain;
import com.yunxi.dg.base.center.report.domain.expense.IActivityCostPayItemDomain;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostFormDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostPayDto;
import com.yunxi.dg.base.center.report.dto.expense.ActivityCostPayItemDto;
import com.yunxi.dg.base.center.report.eo.expense.ActivityCostEo;
import com.yunxi.dg.base.center.report.service.expense.IActivityCostFormService;
import com.yunxi.dg.base.center.report.service.expense.IActivityCostService;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityCostServiceImpl
implements IActivityCostService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCostServiceImpl.class);
    @Resource
    private IActivityCostDomain activityCostDomain;
    @Resource
    private IActivityCostFormService activityCostFormService;
    @Resource
    private IActivityCostPayDomain activityCostPayDomain;
    @Resource
    private IActivityCostPayItemDomain activityCostPayItemDomain;

    @Override
    public ActivityCostDto get(Long id) {
        ActivityCostEo activityCostEo = this.checkExist(id);
        List<ActivityCostFormDto> activityCostFormDtos = this.activityCostFormService.getByActivityCostId(id);
        if (CollectionUtils.isEmpty(activityCostFormDtos)) {
            throw new BizException("\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u627e\u4e0d\u5230\u6d3b\u52a8\u8d39\u7528\u5f62\u5f0f\u5185\u5bb9");
        }
        List activityCostPayDtoList = this.activityCostPayDomain.queryByActivityCostId(id);
        Map<Object, Object> activityCostPayMap = Maps.newHashMap();
        Map<Object, Object> activityCostPayItemMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)activityCostPayDtoList)) {
            activityCostPayMap = activityCostPayDtoList.stream().collect(Collectors.groupingBy(ActivityCostPayDto::getActivityCostFormId));
            List activityCostPayItemDtoList = this.activityCostPayItemDomain.queryByActivityCostId(id);
            if (CollectionUtils.isNotEmpty((Collection)activityCostPayItemDtoList)) {
                activityCostPayItemMap = activityCostPayItemDtoList.stream().collect(Collectors.groupingBy(ActivityCostPayItemDto::getActivityCostPayId));
            }
        }
        ActivityCostDto activityCostDto = (ActivityCostDto)BeanCopyUtil.copyProperties((Object)activityCostEo, ActivityCostDto.class);
        for (ActivityCostFormDto dto : activityCostFormDtos) {
            List PayDtos;
            if (Objects.isNull(dto.getAmountVerify())) {
                dto.setAmountVerify(dto.getAmount());
            }
            if (!CollectionUtils.isNotEmpty((Collection)(PayDtos = (List)activityCostPayMap.get(dto.getId())))) continue;
            dto.setActivityCostPayDtos(PayDtos);
            for (ActivityCostPayDto activityCostPayDto : PayDtos) {
                if (!Objects.equals(activityCostPayDto.getPayType(), 1)) continue;
                activityCostPayDto.setActivityCostPayItemDtos((List)activityCostPayItemMap.get(activityCostPayDto.getId()));
            }
        }
        activityCostDto.setActivityCostFormList(activityCostFormDtos);
        return activityCostDto;
    }

    private ActivityCostEo checkExist(Long id) {
        ActivityCostEo activityCostEo = (ActivityCostEo)this.activityCostDomain.getMapper().findById(id);
        if (Objects.isNull(activityCostEo)) {
            throw new BizException("\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7\u5355ID\u4e0d\u6b63\u786e\uff0c\u627e\u4e0d\u5230\u8bb0\u5f55");
        }
        return activityCostEo;
    }
}

