/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.share;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.share.DgInventoryPreemptionSupplyConverter;
import com.yunxi.dg.base.center.report.domain.entity.ISaleOrderDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgInventoryPreemptionSupplyDomain;
import com.yunxi.dg.base.center.report.dto.share.DgInventoryPreemptionSupplyDto;
import com.yunxi.dg.base.center.report.dto.share.DgInventoryPreemptionSupplyPageReqDto;
import com.yunxi.dg.base.center.report.enums.OtherOrderStatusEnum;
import com.yunxi.dg.base.center.report.enums.PerformOrderStatusEnum;
import com.yunxi.dg.base.center.report.enums.SourceTypeEnum;
import com.yunxi.dg.base.center.report.enums.TransferOrderStatus;
import com.yunxi.dg.base.center.report.eo.share.DgInventoryPreemptionSupplyEo;
import com.yunxi.dg.base.center.report.service.share.IDgInventoryPreemptionSupplyService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgInventoryPreemptionSupplyServiceImpl
extends BaseServiceImpl<DgInventoryPreemptionSupplyDto, DgInventoryPreemptionSupplyEo, IDgInventoryPreemptionSupplyDomain>
implements IDgInventoryPreemptionSupplyService {
    private static final Logger log = LoggerFactory.getLogger(DgInventoryPreemptionSupplyServiceImpl.class);
    @Resource
    private ISaleOrderDomain saleOrderDomain;

    public DgInventoryPreemptionSupplyServiceImpl(IDgInventoryPreemptionSupplyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgInventoryPreemptionSupplyDto, DgInventoryPreemptionSupplyEo> converter() {
        return DgInventoryPreemptionSupplyConverter.INSTANCE;
    }

    @Override
    public List<DgInventoryPreemptionSupplyDto> queryList(DgInventoryPreemptionSupplyPageReqDto dto) {
        List inventoryPreemptionSupplyDtos = ((IDgInventoryPreemptionSupplyDomain)this.domain).queryList(dto);
        if (CollectionUtils.isEmpty((Collection)inventoryPreemptionSupplyDtos)) {
            return Collections.emptyList();
        }
        this.setOrderStatus(inventoryPreemptionSupplyDtos);
        return inventoryPreemptionSupplyDtos;
    }

    private void setOrderStatus(List<DgInventoryPreemptionSupplyDto> inventoryPreemptionDtos) {
        inventoryPreemptionDtos.forEach(o -> {
            if (ObjectUtil.equal((Object)SourceTypeEnum.TRANSFER_ORDER.code(), (Object)o.getSourceType()) || ObjectUtil.equal((Object)SourceTypeEnum.TRANSFER_POSITION_ORDER.code(), (Object)o.getSourceType())) {
                if (ObjectUtil.isNotNull((Object)TransferOrderStatus.getByCode((String)o.getOrderStatus()))) {
                    o.setOrderStatusName(TransferOrderStatus.getByCode((String)o.getOrderStatus()).getDesc());
                }
            } else if (ObjectUtil.equal((Object)SourceTypeEnum.INSIDE_SALES_ORDER.code(), (Object)o.getSourceType()) || ObjectUtil.equal((Object)SourceTypeEnum.SALES_OUTBOUND.code(), (Object)o.getSourceType()) || ObjectUtil.equal((Object)SourceTypeEnum.OUT_SALE_PREEMPT.code(), (Object)o.getSourceType())) {
                if (ObjectUtil.isNotNull((Object)PerformOrderStatusEnum.getByCode((String)o.getOrderStatus()))) {
                    o.setOrderStatusName(PerformOrderStatusEnum.getByCode((String)o.getOrderStatus()).getDesc());
                }
            } else if (ObjectUtil.isNotNull((Object)OtherOrderStatusEnum.getByCode((String)o.getOrderStatus()))) {
                o.setOrderStatusName(OtherOrderStatusEnum.getByCode((String)o.getOrderStatus()).getDesc());
            }
        });
    }

    @Override
    public PageInfo<DgInventoryPreemptionSupplyDto> queryPage(DgInventoryPreemptionSupplyPageReqDto dto) {
        log.info("\u5206\u9875\u67e5\u8be2\u5e93\u5b58\u9884\u5360\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.queryList(dto));
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        BigDecimal totalNum = list.stream().map(DgInventoryPreemptionSupplyDto::getPreemptNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        list.forEach(o -> o.setTotalPreemptNum(totalNum));
        return pageInfo;
    }
}

