/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.reconciliation.BaseDispositionEnum;
import com.yunxi.dg.base.center.report.convert.reconciliation.BaseDispositionConverter;
import com.yunxi.dg.base.center.report.domain.reconciliation.IBaseDispositionDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.BaseDispositionDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.BaseDispositionReqDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.BaseDispositionRespDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.DispositionDataDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.BaseDispositionEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IBaseDispositionService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseDispositionServiceImpl
extends BaseServiceImpl<BaseDispositionDto, BaseDispositionEo, IBaseDispositionDomain>
implements IBaseDispositionService {
    private static final Logger log = LoggerFactory.getLogger(BaseDispositionServiceImpl.class);
    @Value(value="${scheduler.client.app_code:ISALE_MARKETING}")
    private String appCode;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;

    public BaseDispositionServiceImpl(IBaseDispositionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BaseDispositionDto, BaseDispositionEo> converter() {
        return BaseDispositionConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> insertDisposition(BaseDispositionReqDto dto) {
        this.verifyParams(dto);
        BaseDispositionEo baseDispositionEo = ((IBaseDispositionDomain)this.domain).selectDisposition(dto.getDispositionNo());
        AssertUtils.isTrue((null != baseDispositionEo ? 1 : 0) != 0, (String)"\u8be5\u5e93\u5b58\u914d\u7f6e\u5df2\u7ecf\u5b58\u5728");
        BaseDispositionEo dispositionEo = new BaseDispositionEo();
        BeanUtil.copyProperties((Object)dto, (Object)dispositionEo, (String[])new String[0]);
        if (null != dto.getValue()) {
            dispositionEo.setValue(JSONObject.toJSONString((Object)dto.getValue()));
        }
        ((IBaseDispositionDomain)this.domain).insert((BaseEo)dispositionEo);
        return new RestResponse((Object)dispositionEo.getId());
    }

    @Override
    public RestResponse<Void> batchInsertDisposition(List<BaseDispositionReqDto> dispositionDtoList) {
        if (CollectionUtils.isEmpty(dispositionDtoList)) {
            return new RestResponse();
        }
        for (BaseDispositionReqDto dispositionDto : dispositionDtoList) {
            AssertUtils.notNull((Object)dispositionDto.getDispositionNo(), (String)"\u5e93\u5b58\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)dispositionDto.getDescription(), (String)"\u5e93\u5b58\u914d\u7f6e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)dispositionDto.getValue(), (String)"\u5e93\u5b58\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty(dispositionDtoList)) {
            ArrayList<BaseDispositionEo> baseDispositionEoList = new ArrayList<BaseDispositionEo>();
            for (BaseDispositionReqDto dispositionDto : dispositionDtoList) {
                BaseDispositionEo dispositionEo = new BaseDispositionEo();
                BeanUtil.copyProperties((Object)dispositionDto, (Object)dispositionEo, (String[])new String[0]);
                if (null != dispositionDto.getValue()) {
                    dispositionEo.setValue(JSONObject.toJSONString((Object)dispositionDto.getValue()));
                }
                baseDispositionEoList.add(dispositionEo);
            }
            ((IBaseDispositionDomain)this.domain).insertBatch(baseDispositionEoList);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Long> updateDisposition(BaseDispositionReqDto dto) {
        this.verifyParams(dto);
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5e93\u5b58\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
        BaseDispositionEo dispositionEo = (BaseDispositionEo)((IBaseDispositionDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)dispositionEo, (String)"\u8be5\u5e93\u5b58\u914d\u7f6e\u4e0d\u5b58\u5728");
        BeanUtil.copyProperties((Object)dto, (Object)dispositionEo, (String[])new String[0]);
        if (null != dto.getValue()) {
            dispositionEo.setValue(JSONObject.toJSONString((Object)dto.getValue()));
        }
        ((IBaseDispositionDomain)this.domain).updateSelective((BaseEo)dispositionEo);
        return new RestResponse((Object)dispositionEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> batchSaveOrUpdateDisposition(List<BaseDispositionReqDto> dispositionDtoList) {
        if (CollectionUtils.isEmpty(dispositionDtoList)) {
            return new RestResponse();
        }
        ArrayList<BaseDispositionEo> saveEoList = new ArrayList<BaseDispositionEo>();
        ArrayList<BaseDispositionEo> updateEoList = new ArrayList<BaseDispositionEo>();
        for (BaseDispositionReqDto dispositionDto : dispositionDtoList) {
            AssertUtils.notNull((Object)dispositionDto.getDescription(), (String)"\u5e93\u5b58\u914d\u7f6e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)dispositionDto.getDispositionNo(), (String)"\u5e93\u5b58\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)dispositionDto.getValue(), (String)"\u5e93\u5b58\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            BaseDispositionEo dispositionEo = new BaseDispositionEo();
            BeanUtil.copyProperties((Object)dispositionDto, (Object)dispositionEo, (String[])new String[0]);
            if (null != dispositionDto.getValue()) {
                dispositionEo.setValue(JSONObject.toJSONString((Object)dispositionDto.getValue()));
            }
            if (null != dispositionDto.getId()) {
                updateEoList.add(dispositionEo);
                continue;
            }
            dispositionEo.setCreateTime(new Date());
            saveEoList.add(dispositionEo);
        }
        if (CollectionUtils.isNotEmpty(saveEoList)) {
            ((IBaseDispositionDomain)this.domain).insertBatch(saveEoList);
            this.addOrUpdateSchedulerTask(saveEoList);
        }
        if (CollectionUtils.isNotEmpty(updateEoList)) {
            for (BaseDispositionEo dispositionEo : updateEoList) {
                ((IBaseDispositionDomain)this.domain).updateSelective((BaseEo)dispositionEo);
            }
            this.addOrUpdateSchedulerTask(updateEoList);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Long> deleteDisposition(BaseDispositionDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5e93\u5b58\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
        BaseDispositionEo dispositionEo = (BaseDispositionEo)((IBaseDispositionDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)dispositionEo, (String)"\u8be5\u5e93\u5b58\u914d\u7f6e\u9879\u4e0d\u5b58\u5728");
        ((IBaseDispositionDomain)this.domain).deleteById(dispositionEo.getId());
        return new RestResponse((Object)dispositionEo.getId());
    }

    @Override
    public RestResponse<List<BaseDispositionRespDto>> selectBaseDisposition() {
        List baseDispositionEoList = ((IBaseDispositionDomain)this.domain).selectAll();
        ArrayList<BaseDispositionRespDto> respDtoList = new ArrayList<BaseDispositionRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)baseDispositionEoList)) {
            for (BaseDispositionEo baseDispositionEo : baseDispositionEoList) {
                BaseDispositionRespDto respDto = new BaseDispositionRespDto();
                BeanUtil.copyProperties((Object)baseDispositionEo, (Object)respDto, (String[])new String[0]);
                respDtoList.add(respDto);
            }
        }
        return new RestResponse(respDtoList);
    }

    @Override
    public BaseDispositionRespDto selectDataByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        BaseDispositionEo dispositionEo = new BaseDispositionEo();
        dispositionEo.setDispositionNo(code);
        BaseDispositionEo baseDispositionEo = (BaseDispositionEo)((IBaseDispositionDomain)this.domain).selectOne((BaseEo)dispositionEo);
        BaseDispositionRespDto respDto = new BaseDispositionRespDto();
        BeanUtil.copyProperties((Object)baseDispositionEo, (Object)respDto, (String[])new String[0]);
        return respDto;
    }

    @Override
    public List<BaseDispositionRespDto> selectDataListByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        BaseDispositionEo dispositionEo = new BaseDispositionEo();
        dispositionEo.setDispositionNo(code);
        List dispositionEoList = ((IBaseDispositionDomain)this.domain).selectList((BaseEo)dispositionEo, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        ArrayList<BaseDispositionRespDto> respDtoList = new ArrayList<BaseDispositionRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)dispositionEoList)) {
            for (BaseDispositionEo baseDispositionEo : dispositionEoList) {
                BaseDispositionRespDto respDto = new BaseDispositionRespDto();
                BeanUtil.copyProperties((Object)baseDispositionEo, (Object)respDto, (String[])new String[0]);
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private void verifyParams(BaseDispositionReqDto dto) {
        AssertUtils.notNull((Object)dto.getDispositionNo(), (String)"\u5e93\u5b58\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getDescription(), (String)"\u5e93\u5b58\u914d\u7f6e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getValue(), (String)"\u5e93\u5b58\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void addOrUpdateSchedulerTask(List<BaseDispositionEo> dispositionEoList) {
        if (CollectionUtils.isNotEmpty(dispositionEoList)) {
            for (BaseDispositionEo dispositionEo : dispositionEoList) {
                TaskQueryRespDto inventoryCompare;
                String inventoryCompareTaskName;
                String inventoryCompareTaskCode;
                DispositionDataDto dispositionDataDto;
                if (BaseDispositionEnum.INVENTORY_SNAPSHOT_TIME.getCode().equals(dispositionEo.getDispositionNo()) || BaseDispositionEnum.ERP_INVENTORY_TIME.getCode().equals(dispositionEo.getDispositionNo()) || BaseDispositionEnum.WDT_INVENTORY_TIME.getCode().contains(dispositionEo.getDispositionNo()) || dispositionEo.getDispositionNo().contains(BaseDispositionEnum.WMS_INVENTORY.getCode())) {
                    if (!StringUtils.isNotEmpty((CharSequence)dispositionEo.getValue()) || !StringUtils.isNotEmpty((CharSequence)(dispositionDataDto = (DispositionDataDto)JSONObject.parseObject((String)dispositionEo.getValue(), DispositionDataDto.class)).getValue())) continue;
                    String pullInventoryTaskCode = "pullThreeInventoryDataJob";
                    String pullInventoryTaskName = "\u4e2d\u53f0\u62c9\u53d6\u5e93\u5b58\u6d41\u6c34\u5b9a\u65f6\u4efb\u52a1_" + dispositionEo.getId();
                    TaskQueryRespDto pullInventoryData = this.getTask(pullInventoryTaskName);
                    this.setTask(pullInventoryData, dispositionEo, pullInventoryTaskName, pullInventoryTaskCode, this.setCron(dispositionDataDto.getValue(), 0));
                    continue;
                }
                if (BaseDispositionEnum.THREE_INVENTORY_RECONCILIATION.getCode().equals(dispositionEo.getDispositionNo())) {
                    if (!StringUtils.isNotEmpty((CharSequence)dispositionEo.getValue()) || null == (dispositionDataDto = (DispositionDataDto)JSONObject.parseObject((String)dispositionEo.getValue(), DispositionDataDto.class)) || !StringUtils.isNotEmpty((CharSequence)dispositionDataDto.getValue())) continue;
                    inventoryCompareTaskCode = "threeInventoryReconciliationJob";
                    inventoryCompareTaskName = "\u5e93\u5b58\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1_" + dispositionEo.getId();
                    inventoryCompare = this.getTask(inventoryCompareTaskName);
                    this.setTask(inventoryCompare, dispositionEo, inventoryCompareTaskName, inventoryCompareTaskCode, this.setCron(dispositionDataDto.getValue(), 0));
                    continue;
                }
                if (BaseDispositionEnum.ERP_ORDER_TIME.getCode().equals(dispositionEo.getDispositionNo())) {
                    if (!StringUtils.isNotEmpty((CharSequence)dispositionEo.getValue()) || null == (dispositionDataDto = (DispositionDataDto)JSONObject.parseObject((String)dispositionEo.getValue(), DispositionDataDto.class)) || !StringUtils.isNotEmpty((CharSequence)dispositionDataDto.getValue())) continue;
                    inventoryCompareTaskCode = "erpInventoryPostDetailGetJob";
                    inventoryCompareTaskName = "\u62bd\u53d6erp\u5355\u636e\u5b9a\u65f6\u4efb\u52a1_" + dispositionEo.getId();
                    inventoryCompare = this.getTask(inventoryCompareTaskName);
                    this.setTask(inventoryCompare, dispositionEo, inventoryCompareTaskName, inventoryCompareTaskCode, this.setCron(dispositionDataDto.getValue(), 0));
                    continue;
                }
                if (!BaseDispositionEnum.COLLECT_ORDER_TIME.getCode().equals(dispositionEo.getDispositionNo()) || !StringUtils.isNotEmpty((CharSequence)dispositionEo.getValue()) || null == (dispositionDataDto = (DispositionDataDto)JSONObject.parseObject((String)dispositionEo.getValue(), DispositionDataDto.class)) || !StringUtils.isNotEmpty((CharSequence)dispositionDataDto.getValue())) continue;
                inventoryCompareTaskCode = "pullInventoryDocumentDetailJob";
                inventoryCompareTaskName = "\u4e2d\u53f0\u62c9\u53d6\u6570\u636e\u4e2d\u53f0\u6c47\u603b\u8bb0\u8d26\u524d\u5355\u636e\u6d41\u6c34\u5b9a\u65f6\u4efb\u52a1_" + dispositionEo.getId();
                inventoryCompare = this.getTask(inventoryCompareTaskName);
                this.setTask(inventoryCompare, dispositionEo, inventoryCompareTaskName, inventoryCompareTaskCode, this.setCron(dispositionDataDto.getValue(), 0));
            }
        }
    }

    private void setTask(TaskQueryRespDto taskQueryRespDto, BaseDispositionEo dispositionEo, String taskName, String taskCode, String scheduleExpression) {
        if (Objects.isNull(taskQueryRespDto)) {
            TaskAndBizCreateReqDto taskAndBizCreateReqDto = this.initCreateReqDto(dispositionEo, taskName, taskCode, scheduleExpression);
            RestResponse response = this.taskApi.addWithBiz(taskAndBizCreateReqDto);
            log.info("\u521d\u59cb\u5316\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
            this.taskApi.enableById((Long)response.getData(), "{}");
        } else {
            TaskUpdateReqDto taskUpdateReqDto = this.initUpdateReqDto(dispositionEo, scheduleExpression, taskQueryRespDto);
            taskUpdateReqDto.setScheduleExpression(scheduleExpression);
            RestResponse response = this.taskApi.modifyById(taskQueryRespDto.getId(), taskUpdateReqDto);
            log.info("\u66f4\u65b0\u4efb\u52a1:" + taskName + JSONObject.toJSONString((Object)response));
            this.taskApi.enableById(taskQueryRespDto.getId(), "{}");
        }
    }

    private TaskAndBizCreateReqDto initCreateReqDto(BaseDispositionEo dispositionEo, String taskName, String taskCode, String scheduleExpression) {
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setTaskName(taskName);
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setAppCode(this.appCode);
        taskAndBizCreateReqDto.setBizCode(taskCode);
        taskAndBizCreateReqDto.setBizName(taskName);
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setParams(dispositionEo.getValue());
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(null != dispositionEo.getInstanceId() ? dispositionEo.getInstanceId() : -1L));
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(null != dispositionEo.getTenantId() ? dispositionEo.getTenantId() : -1L));
        return taskAndBizCreateReqDto;
    }

    private TaskUpdateReqDto initUpdateReqDto(BaseDispositionEo dispositionEo, String scheduleExpression, TaskQueryRespDto taskQueryRespDto) {
        TaskUpdateReqDto taskAndBizCreateReqDto = new TaskUpdateReqDto();
        taskAndBizCreateReqDto.setScheduleExpression(scheduleExpression);
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(null != dispositionEo.getTenantId() ? dispositionEo.getTenantId() : -1L));
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(null != dispositionEo.getInstanceId() ? dispositionEo.getInstanceId() : -1L));
        return taskAndBizCreateReqDto;
    }

    private TaskQueryRespDto getTask(String taskName) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(taskName);
        String query = JSONObject.toJSON((Object)taskQueryReqDto).toString();
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            return (TaskQueryRespDto)taskQueryRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private String setCron(String timeStr, Integer hours) {
        LocalTime time = LocalTime.parse(timeStr, DateTimeFormatter.ofPattern("HH:mm:ss"));
        if (null != hours && 0 != hours) {
            LocalTime newTime = time.plusHours(hours.intValue());
            return newTime.format(DateTimeFormatter.ofPattern("ss mm HH * * ?"));
        }
        return time.format(DateTimeFormatter.ofPattern("ss mm HH * * ?"));
    }
}

