/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.domain.entity.impl;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.dao.das.IVirtualInventoryDas;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualInventoryDomain;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class VirtualInventoryDomainImpl
extends BaseDomainImpl<VirtualInventoryEo>
implements IVirtualInventoryDomain {
    @Resource
    private IVirtualInventoryDas das;

    public ICommonDas<VirtualInventoryEo> commonDas() {
        return this.das;
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        List partitionList = Lists.partition(voList, (int)500);
        for (List calcUpdateInventoryDtos : partitionList) {
            this.das.updateInventory(calcUpdateInventoryDtos);
        }
    }

    @Override
    public int batchInsertInventory(List<VirtualInventoryEo> eoList) {
        if (CollectionUtils.isEmpty(eoList)) {
            return 0;
        }
        return this.das.batchInsertInventory(eoList);
    }

    @Override
    public InventorySummaryRespDto querySummary(InventoryQueryReqDto reqDto) {
        return this.das.querySummary(reqDto);
    }

    @Override
    public void updateSkuNameBySkuCode(String skuCode, String skuName) {
        this.das.updateSkuNameBySkuCode(skuCode, skuName);
    }
}

