/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.domain.entity.impl;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.dao.das.IChannelInventoryDas;
import com.yunxi.dg.base.center.share.domain.entity.IChannelInventoryDomain;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ChannelInventoryDomainImpl
extends BaseDomainImpl<ChannelInventoryEo>
implements IChannelInventoryDomain {
    @Resource
    private IChannelInventoryDas das;

    public ICommonDas<ChannelInventoryEo> commonDas() {
        return this.das;
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        List partitionList = Lists.partition(voList, (int)500);
        for (List calcUpdateInventoryDtos : partitionList) {
            this.das.updateInventory(calcUpdateInventoryDtos);
        }
    }

    @Override
    public int batchInsertInventory(List<ChannelInventoryEo> eoList) {
        if (CollectionUtils.isEmpty(eoList)) {
            return 0;
        }
        return this.das.batchInsertInventory(eoList);
    }

    @Override
    public InventorySummaryRespDto querySummary(InventoryQueryReqDto reqDto) {
        return this.das.querySummary(reqDto);
    }

    @Override
    public void updateSkuNameBySkuCode(String skuCode, String skuName) {
        this.das.updateSkuNameBySkuCode(skuCode, skuName);
    }
}

