/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsVersionDistinguishEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.domain.entity.IChannelInventoryDomain;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedItemDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelShareInventoryDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualInventoryDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.enums.ShareWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelShareInventoryEo;
import com.yunxi.dg.base.center.share.eo.RelVirtualWarehouseEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.share.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.share.service.calc.ICalcAble;
import com.yunxi.dg.base.center.share.service.transcation.TransactionAfterService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarehouseCommonAble {
    private static final Logger log = LoggerFactory.getLogger(WarehouseCommonAble.class);
    protected static final String EXCEPTION_CODE = "09527";
    public static final int LOCK_TIME_OUT = 30;
    public static final int LESS_TIME_OUT = 35;
    protected static final String INVENTORY_ABLE_LOCK = "sh_warehouse_able";
    public static final String REDIS_PRE_KEY = "sh_inventory_able_group";
    public static final String REDIS_CARGO_CODE_KEY = "sh_inventory_able_group_cargo_code";
    public static final String REDIS_CHANNEL_WAREHOUSE_CODE_KEY = "sh_inventory_able_group_channel_warehouse_code";
    public static final String REDIS_CHANNEL_REL_VIRTUAL_KEY = "sh_inventory_able_group_channel_rel_virtual_";
    public static final String REDIS_VIRTUAL_REL_CHANNEL_KEY = "sh_inventory_able_group_virtual_rel_channel_";
    public static final String REDIS_VIRTUAL_WAREHOUSE_CODE_KEY = "sh_inventory_able_group_virtual_warehouse_code";
    public static final int ONE_HOUR = 3600;
    @Autowired
    IChannelInventoryDomain channelInventoryDomain;
    @Autowired
    IVirtualInventoryDomain virtualInventoryDomain;
    @Autowired
    IChannelWarehouseDomain channelWarehouseDomain;
    @Autowired
    IVirtualWarehouseDomain virtualWarehouseDomain;
    @Autowired
    IRelVirtualWarehouseDomain relVirtualWarehouseDomain;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    IInventorySharedWarehouseDomain inventorySharedWarehouseDomain;
    @Autowired
    IInventorySharedDomain inventorySharedDomain;
    @Autowired
    IInventorySharedItemDomain inventorySharedItemDomain;
    @Autowired
    IRelShareInventoryDomain relShareInventoryDomain;
    @Autowired
    ICalcAble calcAble;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Autowired
    IDictQueryApi dictQueryApi;
    @Autowired
    ICacheService cacheService;
    @Autowired
    ILockService lockService;
    @Autowired
    TransactionAfterService transactionAfterService;
    @Autowired
    IContext context;

    protected void checkParam(OperationDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getSourceNo(), (String)"\u539f\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getSourceType(), (String)"\u539f\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected void checkParamDetails(OperationDto dto) {
        List details = dto.getDetails();
        AssertUtils.notEmpty((Collection)details, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!dto.getZeroError().booleanValue()) {
            details.removeIf(o -> BigDecimalUtils.eqZero((BigDecimal)o.getNum()));
        }
        details.forEach(d -> {
            AssertUtils.notBlank((String)d.getSkuCode(), (String)"\u660e\u7ec6\u8d27\u54c1Code\u5b58\u5728\u7a7a\u503c");
            AssertUtils.notBlank((String)d.getWarehouseCode(), (String)"\u660e\u7ec6\u4ed3\u5e93Code\u5b58\u5728\u7a7a\u503c");
            if (BigDecimalUtils.eqZero((BigDecimal)d.getNum()).booleanValue()) {
                throw new BizException(String.format("warehouseCode: %s, skuCode: %s, \u4ed3\u5e93\u53d8\u5316\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u4e3a0", d.getWarehouseCode(), d.getSkuCode()));
            }
        });
        HashMap map = Maps.newHashMap();
        for (OperationDetailDto detail : details) {
            BigDecimal num = detail.getNum();
            String key = String.format("%s_%s", detail.getWarehouseCode(), detail.getSkuCode());
            OperationDetailDto newDetail = (OperationDetailDto)map.get(key);
            if (null == newDetail) {
                newDetail = new OperationDetailDto();
                newDetail.setWarehouseCode(detail.getWarehouseCode());
                newDetail.setSkuCode(detail.getSkuCode());
                newDetail.setNum(num);
            } else {
                newDetail.setNum(BigDecimalUtils.add((BigDecimal)newDetail.getNum(), (BigDecimal)num));
            }
            map.put(key, newDetail);
        }
        dto.setDetails((List)Lists.newArrayList(map.values()));
    }

    protected List<ChannelInventoryEo> queryChannelInventoryEos(List<ItemSkuDto> itemSkuRespDtoList, List<ChannelWarehouseEo> channelWarehouseEos) {
        Set skuCodes = itemSkuRespDtoList.stream().map(ItemSkuDto::getSkuCode).collect(Collectors.toSet());
        Set channelWarehouseCodes = channelWarehouseEos.stream().map(ChannelWarehouseEo::getWarehouseCode).collect(Collectors.toSet());
        List channelInventoryEos = this.channelInventoryDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", channelWarehouseCodes)).in(CollectionUtils.isNotEmpty(skuCodes), (Object)"sku_code", skuCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty(itemSkuRespDtoList)) {
            return channelInventoryEos;
        }
        boolean hasInsert = false;
        int totalCount = 0;
        ArrayList insertCacheKeyList = Lists.newArrayList();
        ArrayList insertChannelInventoryEos = Lists.newArrayList();
        for (String channelWarehouseCode : channelWarehouseCodes) {
            for (String skuCode : skuCodes) {
                ChannelWarehouseEo channelWarehouseEo = this.filterChannelWarehouseByCode(channelWarehouseEos, channelWarehouseCode);
                ItemSkuDto itemSkuDto = this.filterItemSkuByCode(itemSkuRespDtoList, skuCode);
                ++totalCount;
                ChannelInventoryEo channelInventoryEo = channelInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)channelWarehouseEo.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)itemSkuDto.getSkuCode())).findFirst().orElse(null);
                if (null != channelInventoryEo) continue;
                hasInsert = true;
                ChannelInventoryEo insertChannelInventory = this.initChannelInventory(channelWarehouseEo, itemSkuDto);
                String uniqueKey = String.format("channel_%s_%s", channelWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode());
                String cacheKey = "insertChannelInventory" + uniqueKey;
                boolean exists = this.cacheService.exists(cacheKey);
                log.info("queryChannelInventoryEos cacheKey:{}, exists: {}", (Object)cacheKey, (Object)exists);
                if (exists) continue;
                this.cacheService.setCache(cacheKey, (Object)insertChannelInventory.getId(), 60);
                insertChannelInventoryEos.add(insertChannelInventory);
                insertCacheKeyList.add(cacheKey);
            }
        }
        if (!hasInsert) {
            return channelInventoryEos;
        }
        int insertRows = this.channelInventoryDomain.batchInsertInventory((List)insertChannelInventoryEos);
        log.info("queryChannelInventoryEos insert rows: {}", (Object)insertRows);
        channelInventoryEos = this.channelInventoryDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", channelWarehouseCodes)).in(CollectionUtils.isNotEmpty(skuCodes), (Object)"sku_code", skuCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        this.cacheService.delCache((List)insertCacheKeyList);
        if (!Objects.equals(totalCount, channelInventoryEos.size())) {
            log.error("queryChannelInventoryEos exception... totalCount:{}, size:{}", (Object)totalCount, (Object)channelInventoryEos.size());
            throw new WarehouseAbleException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
        }
        return channelInventoryEos;
    }

    protected List<VirtualInventoryEo> queryVirtualInventoryEos(List<ItemSkuDto> itemSkuRespDtoList, List<VirtualWarehouseEo> virtualWarehouseEos) {
        return this.queryVirtualInventoryEos(itemSkuRespDtoList, virtualWarehouseEos, true);
    }

    protected List<VirtualInventoryEo> queryVirtualInventoryEos(List<ItemSkuDto> itemSkuRespDtoList, List<VirtualWarehouseEo> virtualWarehouseEos, Boolean isCheckInventory) {
        return this.queryVirtualInventoryEos(itemSkuRespDtoList, virtualWarehouseEos, isCheckInventory, false);
    }

    protected List<VirtualInventoryEo> queryVirtualInventoryEos(List<ItemSkuDto> itemSkuRespDtoList, List<VirtualWarehouseEo> virtualWarehouseEos, Boolean isCheckInventory, Boolean filterZero) {
        Set skuCodes = itemSkuRespDtoList.stream().map(ItemSkuDto::getSkuCode).collect(Collectors.toSet());
        Set virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).collect(Collectors.toSet());
        List virtualInventoryEos = this.virtualInventoryDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", virtualWarehouseCodes)).in(CollectionUtils.isNotEmpty(skuCodes), (Object)"sku_code", skuCodes)).ne(filterZero.booleanValue(), (Object)"available", (Object)BigDecimal.ZERO)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (!isCheckInventory.booleanValue()) {
            return virtualInventoryEos;
        }
        if (CollectionUtils.isEmpty(itemSkuRespDtoList)) {
            return virtualInventoryEos;
        }
        boolean hasInsert = false;
        int totalCount = 0;
        ArrayList insertCacheKeyList = Lists.newArrayList();
        ArrayList insertVirtualInventoryEos = Lists.newArrayList();
        Map virtualWarehouseEoMap = virtualWarehouseEos.stream().collect(Collectors.toMap(VirtualWarehouseEo::getWarehouseCode, Function.identity()));
        Map virtualInventoryEoMap = virtualInventoryEos.stream().collect(Collectors.toMap(o -> o.getWarehouseCode() + "_" + o.getSkuCode(), Function.identity()));
        for (String virtualWarehouseCode : virtualWarehouseCodes) {
            for (String skuCode : skuCodes) {
                VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEoMap.get(virtualWarehouseCode);
                ItemSkuDto itemSkuDto = this.filterItemSkuByCode(itemSkuRespDtoList, skuCode);
                ++totalCount;
                VirtualInventoryEo virtualInventoryEo = (VirtualInventoryEo)virtualInventoryEoMap.get(virtualWarehouseEo.getWarehouseCode() + "_" + itemSkuDto.getSkuCode());
                if (null != virtualInventoryEo) continue;
                hasInsert = true;
                VirtualInventoryEo insertVirtualInventoryEo = this.initVirtualInventory(virtualWarehouseEo, itemSkuDto);
                String uniqueKey = String.format("virtual_%s_%s", virtualWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode());
                String cacheKey = "insertVirtualInventory" + uniqueKey;
                boolean exists = this.cacheService.exists(cacheKey);
                log.info("queryVirtualInventoryEos cacheKey:{}, exists: {}", (Object)cacheKey, (Object)exists);
                if (exists) continue;
                this.cacheService.setCache(cacheKey, (Object)insertVirtualInventoryEo.getId(), 60);
                insertVirtualInventoryEos.add(insertVirtualInventoryEo);
                insertCacheKeyList.add(cacheKey);
            }
        }
        if (!hasInsert) {
            return virtualInventoryEos;
        }
        int insertRows = this.virtualInventoryDomain.batchInsertInventory((List)insertVirtualInventoryEos);
        log.info("queryVirtualInventoryEos insert rows: {}", (Object)insertRows);
        virtualInventoryEos = this.virtualInventoryDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", virtualWarehouseCodes)).in(CollectionUtils.isNotEmpty(skuCodes), (Object)"sku_code", skuCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        this.cacheService.delCache((List)insertCacheKeyList);
        if (!Objects.equals(totalCount, virtualInventoryEos.size())) {
            log.error("queryChannelInventoryEos exception... totalCount:{}, size:{}", (Object)totalCount, (Object)virtualInventoryEos.size());
            throw new WarehouseAbleException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
        }
        return virtualInventoryEos;
    }

    protected List<RelShareInventoryEo> queryLogicToVirtualInventory(List<ItemSkuDto> skuDtoList, List<VirtualWarehouseEo> virtualWarehouseEos, List<String> logicWarehouseCodes) {
        Set skuCodes = skuDtoList.stream().map(ItemSkuDto::getSkuCode).collect(Collectors.toSet());
        Set virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).collect(Collectors.toSet());
        List relShareInventoryEos = this.relShareInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelShareInventoryEo.class).eq(RelShareInventoryEo::getShareWarehouseType, (Object)ShareWarehouseTypeEnum.TO_VIRTUAL.getCode())).in(RelShareInventoryEo::getShareWarehouseCode, logicWarehouseCodes)).in(RelShareInventoryEo::getSkuCode, skuCodes)).in(RelShareInventoryEo::getReceiveWarehouseCode, virtualWarehouseCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList insertRelShareInventoryEos = Lists.newArrayList();
        boolean hasInsert = false;
        int totalCount = 0;
        ArrayList insertCacheKeyList = Lists.newArrayList();
        logicWarehouseCodes = logicWarehouseCodes.stream().map(StringUtils::trim).distinct().collect(Collectors.toList());
        log.info("queryLogicToVirtualInventory logicWarehouseCodes size: {}", (Object)logicWarehouseCodes.size());
        HashMap map = Maps.newHashMap();
        for (String logicWarehouseCode : logicWarehouseCodes) {
            for (String virtualWarehouseCode : virtualWarehouseCodes) {
                for (String skuCode : skuCodes) {
                    VirtualWarehouseEo virtualWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, virtualWarehouseCode);
                    ItemSkuDto itemSkuDto = this.filterItemSkuByCode(skuDtoList, skuCode);
                    ++totalCount;
                    RelShareInventoryEo relShareInventoryEo = relShareInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)itemSkuDto.getSkuCode()) && StringUtils.equals((CharSequence)o.getReceiveWarehouseCode(), (CharSequence)virtualWarehouseEo.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getShareWarehouseCode(), (CharSequence)logicWarehouseCode)).findFirst().orElse(null);
                    if (null != relShareInventoryEo) continue;
                    RelShareInventoryEo insertRelShareInventoryEo = this.initLogicToVirtualInventory(logicWarehouseCode, virtualWarehouseEo, itemSkuDto.getSkuCode());
                    String uniqueKey = String.format("to_virtual_%s_%s_%s", logicWarehouseCode, virtualWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode());
                    String cacheKey = "insertLogicToVirtualInventory" + uniqueKey;
                    boolean exists = this.cacheService.exists(cacheKey);
                    log.info("queryLogicToVirtualInventory cacheKey:{}, exists: {}", (Object)cacheKey, (Object)exists);
                    if (exists) continue;
                    this.cacheService.setCache(cacheKey, (Object)insertRelShareInventoryEo.getId(), 60);
                    map.put(uniqueKey, insertRelShareInventoryEo);
                    insertCacheKeyList.add(cacheKey);
                    hasInsert = true;
                }
            }
        }
        if (!hasInsert) {
            return relShareInventoryEos;
        }
        insertRelShareInventoryEos.addAll(map.values());
        int insertRows = this.relShareInventoryDomain.batchInsertInventory((List)insertRelShareInventoryEos);
        log.info("queryLogicToVirtualInventory insert rows: {}", (Object)insertRows);
        relShareInventoryEos = this.relShareInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelShareInventoryEo.class).eq(RelShareInventoryEo::getShareWarehouseType, (Object)ShareWarehouseTypeEnum.TO_VIRTUAL.getCode())).in(RelShareInventoryEo::getShareWarehouseCode, logicWarehouseCodes)).in(RelShareInventoryEo::getSkuCode, skuCodes)).in(RelShareInventoryEo::getReceiveWarehouseCode, virtualWarehouseCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        this.cacheService.delCache((List)insertCacheKeyList);
        if (!Objects.equals(totalCount, relShareInventoryEos.size())) {
            log.error("queryChannelInventoryEos exception... totalCount:{}, size:{}", (Object)totalCount, (Object)relShareInventoryEos.size());
            throw new WarehouseAbleException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
        }
        return relShareInventoryEos;
    }

    protected List<RelShareInventoryEo> queryRelLogicInventoryEos(List<VirtualWarehouseEo> virtualWarehouseEos, List<ItemSkuDto> itemSkuRespDtoList, List<String> logicWarehouseCodes) {
        Set skuCodes = itemSkuRespDtoList.stream().map(ItemSkuDto::getSkuCode).collect(Collectors.toSet());
        Set virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).collect(Collectors.toSet());
        return this.relShareInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelShareInventoryEo.class).eq(RelShareInventoryEo::getShareWarehouseType, (Object)ShareWarehouseTypeEnum.TO_VIRTUAL.getCode())).in(CollectionUtils.isNotEmpty(skuCodes), RelShareInventoryEo::getSkuCode, skuCodes)).in(CollectionUtils.isNotEmpty(logicWarehouseCodes), RelShareInventoryEo::getShareWarehouseCode, logicWarehouseCodes)).in(RelShareInventoryEo::getReceiveWarehouseCode, virtualWarehouseCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    protected ChannelWarehouseEo filterChannelWarehouseByCode(List<ChannelWarehouseEo> channelWarehouseEos, String warehouseCode) {
        ChannelWarehouseEo channelWarehouseEo = channelWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)warehouseCode)).findFirst().orElse(null);
        AssertUtils.notNull((Object)channelWarehouseEo, (String)"\u6e20\u9053\u4ed3\u7f16\u7801 \u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        return channelWarehouseEo;
    }

    protected VirtualWarehouseEo filterVirtualWarehouseByCode(List<VirtualWarehouseEo> virtualWarehouseEos, String warehouseCode) {
        VirtualWarehouseEo virtualWarehouseEo = virtualWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)warehouseCode)).findFirst().orElse(null);
        AssertUtils.notNull((Object)virtualWarehouseEo, (String)"\u4f9b\u8d27\u4ed3\u7f16\u7801 \u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        return virtualWarehouseEo;
    }

    protected ItemSkuDto filterItemSkuByCode(List<ItemSkuDto> skuDtoList, String skuCode) {
        ItemSkuDto itemSkuDto = skuDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)skuCode)).findFirst().orElse(null);
        AssertUtils.notNull((Object)itemSkuDto, (String)"\u540e\u54c1\u7f16\u7801 \u67e5\u8be2\u8d27\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        return itemSkuDto;
    }

    protected ChannelInventoryEo filterChannelInventory(List<ChannelInventoryEo> channelInventoryEos, String warehouseCode, String skuCode) {
        return channelInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)warehouseCode) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)skuCode)).findFirst().orElse(null);
    }

    protected VirtualInventoryEo filterVirtualInventory(List<VirtualInventoryEo> virtualInventoryEos, String warehouseCode, String skuCode) {
        return virtualInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)warehouseCode) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)skuCode)).findFirst().orElse(null);
    }

    protected List<ChannelWarehouseEo> queryChannelWarehouseEos(List<OperationDto> dtoList) {
        HashSet warehouseCodes = Sets.newHashSet();
        for (OperationDto dto : dtoList) {
            warehouseCodes.add(((OperationDetailDto)dto.getDetails().get(0)).getWarehouseCode());
        }
        return this.queryEnableChannelWarehouseByCode(Lists.newArrayList((Iterable)warehouseCodes));
    }

    protected List<ChannelWarehouseEo> queryEnableChannelWarehouseByCode(List<String> channelWarehouseCodes) {
        ArrayList warehouseCodes = Lists.newArrayList(channelWarehouseCodes);
        Map redisCargoMapEos = this.cacheService.hmget(REDIS_CHANNEL_WAREHOUSE_CODE_KEY, warehouseCodes.toArray(new String[0]), ChannelWarehouseEo.class);
        ArrayList redisChannelWarehouseEos = Lists.newArrayList(redisCargoMapEos.values());
        redisChannelWarehouseEos.removeIf(Objects::isNull);
        log.info("ChannelWarehouse codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)redisChannelWarehouseEos));
        redisChannelWarehouseEos.removeIf(o -> EnableDisableEnum.DISABLE.getCode().equals(o.getWarehouseStatus()));
        warehouseCodes.removeIf(o -> null != redisChannelWarehouseEos.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)c.getWarehouseCode())).findFirst().orElse(null));
        log.info("ChannelWarehouse codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)warehouseCodes);
        if (CollectionUtils.isNotEmpty((Collection)warehouseCodes)) {
            List warehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChannelWarehouseEo.class).in(ChannelWarehouseEo::getWarehouseCode, (Collection)warehouseCodes)).eq(ChannelWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)warehouseEos, (String)"\u660e\u7ec6\u5bf9\u5e94\u6e20\u9053\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
            HashMap putRedisMap = Maps.newHashMap();
            for (ChannelWarehouseEo warehouseEo : warehouseEos) {
                redisChannelWarehouseEos.add(warehouseEo);
                putRedisMap.put(warehouseEo.getWarehouseCode(), JSON.toJSONString((Object)warehouseEo));
            }
            this.cacheService.hmset(REDIS_CHANNEL_WAREHOUSE_CODE_KEY, (Map)putRedisMap);
            log.info("LogicWarehouse code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)warehouseCodes);
        }
        return redisChannelWarehouseEos;
    }

    protected List<ChannelWarehouseEo> queryChannelWarehouseByCode(List<String> channelWarehouseCodes) {
        ArrayList warehouseCodes = Lists.newArrayList(channelWarehouseCodes);
        Map redisCargoMapEos = this.cacheService.hmget(REDIS_CHANNEL_WAREHOUSE_CODE_KEY, warehouseCodes.toArray(new String[0]), ChannelWarehouseEo.class);
        ArrayList redisChannelWarehouseEos = Lists.newArrayList(redisCargoMapEos.values());
        redisChannelWarehouseEos.removeIf(Objects::isNull);
        log.info("ChannelWarehouse codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)redisChannelWarehouseEos));
        warehouseCodes.removeIf(o -> null != redisChannelWarehouseEos.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)c.getWarehouseCode())).findFirst().orElse(null));
        log.info("ChannelWarehouse codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)warehouseCodes);
        if (CollectionUtils.isNotEmpty((Collection)warehouseCodes)) {
            List warehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChannelWarehouseEo.class).in(ChannelWarehouseEo::getWarehouseCode, (Collection)warehouseCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)warehouseEos, (String)"\u660e\u7ec6\u5bf9\u5e94\u6e20\u9053\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
            HashMap putRedisMap = Maps.newHashMap();
            for (ChannelWarehouseEo warehouseEo : warehouseEos) {
                redisChannelWarehouseEos.add(warehouseEo);
                putRedisMap.put(warehouseEo.getWarehouseCode(), JSON.toJSONString((Object)warehouseEo));
            }
            this.cacheService.hmset(REDIS_CHANNEL_WAREHOUSE_CODE_KEY, (Map)putRedisMap);
            log.info("LogicWarehouse code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)warehouseCodes);
        }
        return redisChannelWarehouseEos;
    }

    protected List<VirtualWarehouseEo> queryVirtualWarehouseByChannelWarehouseCode(List<String> channelWarehouseCodes) {
        ArrayList noRedisChannelWarehouseCodes = Lists.newArrayList();
        List virtualWarehouseEos = Lists.newArrayList();
        for (String channelWarehouseCode : channelWarehouseCodes) {
            String cacheKey = REDIS_CHANNEL_REL_VIRTUAL_KEY + channelWarehouseCode;
            String value = (String)this.cacheService.getCache(cacheKey, String.class);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                virtualWarehouseEos.addAll(JSON.parseArray((String)value, VirtualWarehouseEo.class));
                continue;
            }
            noRedisChannelWarehouseCodes.add(channelWarehouseCode);
        }
        if (CollectionUtils.isEmpty((Collection)noRedisChannelWarehouseCodes)) {
            return virtualWarehouseEos;
        }
        List<ChannelWarehouseEo> channelWarehouseEos = this.queryEnableChannelWarehouseByCode(noRedisChannelWarehouseCodes);
        List channelWarehouseIds = channelWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getChannelWarehouseId, channelWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        for (ChannelWarehouseEo channelWarehouseEo : channelWarehouseEos) {
            String cacheKey = REDIS_CHANNEL_REL_VIRTUAL_KEY + channelWarehouseEo.getWarehouseCode();
            Long channelWarehouseId = channelWarehouseEo.getId();
            List virtualWarehouseEoList = relVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getChannelWarehouseId(), channelWarehouseId)).collect(Collectors.toList());
            AssertUtils.notEmpty(virtualWarehouseEoList, (String)"\u6e20\u9053\u4ed3\u5173\u8054\u865a\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728, \u6e20\u9053\u4ed3\u7f16\u7801: %s", (Object[])new Object[]{channelWarehouseEo.getWarehouseCode()});
            List virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).distinct().collect(Collectors.toList());
            virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).in(BaseEo::getId, virtualWarehouseIds)).eq(VirtualWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            this.cacheService.setCache(cacheKey, (Object)virtualWarehouseEos, 3600);
        }
        return virtualWarehouseEos;
    }

    protected List<VirtualWarehouseEo> queryEnableVirtualWarehouseByCodes(List<String> virtualWarehouseCodes) {
        ArrayList warehouseCodes = Lists.newArrayList(virtualWarehouseCodes);
        Map redisVirtualWarehouseMapEos = this.cacheService.hmget(REDIS_VIRTUAL_WAREHOUSE_CODE_KEY, warehouseCodes.toArray(new String[0]), VirtualWarehouseEo.class);
        ArrayList redisVirtualWarehouseEos = Lists.newArrayList(redisVirtualWarehouseMapEos.values());
        redisVirtualWarehouseEos.removeIf(Objects::isNull);
        log.info("VirtualWarehouse codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)redisVirtualWarehouseEos));
        warehouseCodes.removeIf(o -> null != redisVirtualWarehouseEos.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)c.getWarehouseCode())).findFirst().orElse(null));
        redisVirtualWarehouseEos.removeIf(o -> EnableDisableEnum.DISABLE.getCode().equals(o.getWarehouseStatus()));
        log.info("VirtualWarehouse codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)warehouseCodes);
        if (CollectionUtils.isNotEmpty((Collection)warehouseCodes)) {
            List warehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).in(VirtualWarehouseEo::getWarehouseCode, (Collection)warehouseCodes)).eq(VirtualWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)warehouseEos, (String)"\u660e\u7ec6\u5bf9\u5e94\u4f9b\u8d27\u4ed3\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
            HashMap putRedisMap = Maps.newHashMap();
            for (VirtualWarehouseEo warehouseEo : warehouseEos) {
                redisVirtualWarehouseEos.add(warehouseEo);
                putRedisMap.put(warehouseEo.getWarehouseCode(), JSON.toJSONString((Object)warehouseEo));
            }
            this.cacheService.hmset(REDIS_VIRTUAL_WAREHOUSE_CODE_KEY, (Map)putRedisMap);
            log.info("LogicWarehouse code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)warehouseCodes);
        }
        return redisVirtualWarehouseEos;
    }

    protected List<VirtualWarehouseEo> queryVirtualWarehouseByCodes(List<String> virtualWarehouseCodes) {
        ArrayList warehouseCodes = Lists.newArrayList(virtualWarehouseCodes);
        Map redisVirtualWarehouseMapEos = this.cacheService.hmget(REDIS_VIRTUAL_WAREHOUSE_CODE_KEY, warehouseCodes.toArray(new String[0]), VirtualWarehouseEo.class);
        ArrayList redisVirtualWarehouseEos = Lists.newArrayList(redisVirtualWarehouseMapEos.values());
        redisVirtualWarehouseEos.removeIf(Objects::isNull);
        log.info("VirtualWarehouse codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)redisVirtualWarehouseEos));
        warehouseCodes.removeIf(o -> null != redisVirtualWarehouseEos.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)c.getWarehouseCode())).findFirst().orElse(null));
        log.info("VirtualWarehouse codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)warehouseCodes);
        if (CollectionUtils.isNotEmpty((Collection)warehouseCodes)) {
            List warehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).in(VirtualWarehouseEo::getWarehouseCode, (Collection)warehouseCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)warehouseEos, (String)"\u660e\u7ec6\u5bf9\u5e94\u4f9b\u8d27\u4ed3\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
            HashMap putRedisMap = Maps.newHashMap();
            for (VirtualWarehouseEo warehouseEo : warehouseEos) {
                redisVirtualWarehouseEos.add(warehouseEo);
                putRedisMap.put(warehouseEo.getWarehouseCode(), JSON.toJSONString((Object)warehouseEo));
            }
            this.cacheService.hmset(REDIS_VIRTUAL_WAREHOUSE_CODE_KEY, (Map)putRedisMap);
            log.info("LogicWarehouse code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)warehouseCodes);
        }
        return redisVirtualWarehouseEos;
    }

    protected Map<String, List<ChannelWarehouseEo>> queryChannelWarehouseByVirtualWarehouseCodes(List<String> virtualWarehouseCodes, Boolean readCache) {
        HashMap map = Maps.newHashMap();
        ArrayList noRedisVirtualWarehouseCodes = Lists.newArrayList();
        for (String virtualWarehouseCode : virtualWarehouseCodes) {
            String value;
            String cacheKey = REDIS_VIRTUAL_REL_CHANNEL_KEY + virtualWarehouseCode;
            if (!readCache.booleanValue()) {
                this.cacheService.delCache(cacheKey);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = (String)this.cacheService.getCache(cacheKey, String.class)))) {
                List channelWarehouseEos = JSON.parseArray((String)value, ChannelWarehouseEo.class);
                map.put(virtualWarehouseCode, channelWarehouseEos);
                continue;
            }
            noRedisVirtualWarehouseCodes.add(virtualWarehouseCode);
        }
        this.putRedisVirtualToChannel(noRedisVirtualWarehouseCodes, map);
        return map;
    }

    protected Map<String, List<ChannelWarehouseEo>> queryChannelWarehouseByVirtualWarehouseCodes(List<String> virtualWarehouseCodes) {
        return this.queryChannelWarehouseByVirtualWarehouseCodes(virtualWarehouseCodes, true);
    }

    protected void putRedisVirtualToChannel(List<String> virtualWarehouseCodes, Map<String, List<ChannelWarehouseEo>> map) {
        if (CollectionUtils.isEmpty(virtualWarehouseCodes)) {
            return;
        }
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryVirtualWarehouseByCodes(Lists.newArrayList(virtualWarehouseCodes));
        List virtualWarehouseIds = virtualWarehouseEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getVirtualWarehouseId, virtualWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            for (VirtualWarehouseEo virtualWarehouseEo : virtualWarehouseEos) {
                String cacheKey = REDIS_VIRTUAL_REL_CHANNEL_KEY + virtualWarehouseEo.getWarehouseCode();
                this.cacheService.delCache(cacheKey);
            }
            return;
        }
        List channelWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getChannelWarehouseId).distinct().collect(Collectors.toList());
        List channelWarehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChannelWarehouseEo.class).in(BaseEo::getId, channelWarehouseIds)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        for (String virtualWarehouseCode : virtualWarehouseCodes) {
            String cacheKey = REDIS_VIRTUAL_REL_CHANNEL_KEY + virtualWarehouseCode;
            if (null == map) {
                this.cacheService.delCache(cacheKey);
            }
            VirtualWarehouseEo virtualWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, virtualWarehouseCode);
            List filterRelVirtualWarehouseEos = relVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getVirtualWarehouseId(), virtualWarehouseEo.getId())).collect(Collectors.toList());
            List filterChannelWarehouseIds = filterRelVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getChannelWarehouseId).distinct().collect(Collectors.toList());
            List filterChannelWarehouseEos = channelWarehouseEos.stream().filter(o -> filterChannelWarehouseIds.contains(o.getId())).collect(Collectors.toList());
            if (null != map) {
                map.put(virtualWarehouseCode, filterChannelWarehouseEos);
            }
            this.cacheService.setCache(cacheKey, filterChannelWarehouseEos, 3600);
        }
    }

    protected Map<String, List<VirtualWarehouseEo>> queryVirtualWarehouseByChannelWarehouseCodes(List<String> channelWarehouseCodes, Boolean readCache) {
        HashMap map = Maps.newHashMap();
        ArrayList noRedisChannelWarehouseCodes = Lists.newArrayList();
        for (String channelWarehouseCode : channelWarehouseCodes) {
            String value;
            String cacheKey = REDIS_CHANNEL_REL_VIRTUAL_KEY + channelWarehouseCode;
            if (!readCache.booleanValue()) {
                this.cacheService.delCache(cacheKey);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = (String)this.cacheService.getCache(cacheKey, String.class)))) {
                List channelWarehouseEos = JSON.parseArray((String)value, VirtualWarehouseEo.class);
                map.put(channelWarehouseCode, channelWarehouseEos);
                continue;
            }
            noRedisChannelWarehouseCodes.add(channelWarehouseCode);
        }
        this.putRedisChannelToVirtual(noRedisChannelWarehouseCodes, map);
        return map;
    }

    protected Map<String, List<VirtualWarehouseEo>> queryVirtualWarehouseByChannelWarehouseCodes(List<String> channelWarehouseCodes) {
        return this.queryVirtualWarehouseByChannelWarehouseCodes(channelWarehouseCodes, true);
    }

    protected void putRedisChannelToVirtual(List<String> channelWarehouseCodes, Map<String, List<VirtualWarehouseEo>> map) {
        if (CollectionUtils.isEmpty(channelWarehouseCodes)) {
            return;
        }
        List<ChannelWarehouseEo> channelWarehouseEos = this.queryChannelWarehouseByCode(Lists.newArrayList(channelWarehouseCodes));
        List channelWarehouseIds = channelWarehouseEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getChannelWarehouseId, channelWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            log.info("\u6e20\u9053\u4ed3\u5173\u8054\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        List virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).distinct().collect(Collectors.toList());
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).in(BaseEo::getId, virtualWarehouseIds)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        for (String channelWarehouseCode : channelWarehouseCodes) {
            String cacheKey = REDIS_CHANNEL_REL_VIRTUAL_KEY + channelWarehouseCode;
            if (null == map) {
                this.cacheService.delCache(cacheKey);
            }
            ChannelWarehouseEo channelWarehouseEo = this.filterChannelWarehouseByCode(channelWarehouseEos, channelWarehouseCode);
            List filterRelVirtualWarehouseEos = relVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getChannelWarehouseId(), channelWarehouseEo.getId())).collect(Collectors.toList());
            List filterVirtualWarehouseIds = filterRelVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).distinct().collect(Collectors.toList());
            List filterVirtualWarehouseEos = virtualWarehouseEos.stream().filter(o -> filterVirtualWarehouseIds.contains(o.getId())).collect(Collectors.toList());
            if (null != map) {
                map.put(channelWarehouseCode, filterVirtualWarehouseEos);
            }
            this.cacheService.setCache(cacheKey, filterVirtualWarehouseEos, 3600);
        }
    }

    protected List<ItemSkuDto> queryItemSkuList(List<OperationDto> dtoList) {
        HashSet skuCodes = Sets.newHashSet();
        for (OperationDto param : dtoList) {
            for (OperationDetailDto detailParam : param.getDetails()) {
                skuCodes.add(detailParam.getSkuCode());
            }
        }
        return this.queryItemSkuListByCodes(Lists.newArrayList((Iterable)skuCodes));
    }

    protected List<ItemSkuDto> queryItemSkuListByCodes(List<String> skuCodeList) {
        if (CollectionUtils.isEmpty(skuCodeList)) {
            return Lists.newArrayList();
        }
        ArrayList skuCodes = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)skuCodes, skuCodeList, String.class);
        Map redisCargoMapEos = this.cacheService.hmget(REDIS_CARGO_CODE_KEY, skuCodes.toArray(new String[0]), ItemSkuDto.class);
        ArrayList redisCargoEos = Lists.newArrayList(redisCargoMapEos.values());
        redisCargoEos.removeIf(Objects::isNull);
        log.info("ItemSkuDto codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)redisCargoEos));
        skuCodes.removeIf(o -> null != redisCargoEos.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)c.getSkuCode())).findFirst().orElse(null));
        log.info("ItemSkuDto codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)skuCodes);
        if (CollectionUtils.isNotEmpty((Collection)skuCodes)) {
            List cargoEos = this.itemSkuProxy.queryBySkuCodes((List)Lists.newArrayList((Iterable)skuCodes));
            AssertUtils.notEmpty((Collection)cargoEos, (String)"\u660e\u7ec6\u5bf9\u5e94\u8d27\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728[%s]", (Object[])new Object[]{JSON.toJSONString((Object)skuCodes)});
            HashMap putRedisMap = Maps.newHashMap();
            for (ItemSkuDto itemSkuDto : cargoEos) {
                redisCargoEos.add(itemSkuDto);
                putRedisMap.put(itemSkuDto.getSkuCode(), JSON.toJSONString((Object)itemSkuDto));
            }
            this.cacheService.hmset(REDIS_CARGO_CODE_KEY, (Map)putRedisMap);
            log.info("cargo code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)skuCodes);
        }
        return Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)redisCargoEos));
    }

    protected Boolean checkExistPreempt(String sourceNo) {
        int preemptionEoCount = this.inventoryPreemptionDomain.getMapper().selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"source_no", (Object)sourceNo)).eq((Object)"valid", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (preemptionEoCount > 0) {
            log.info("\u8be5\u5355\u636e: {}, \u5df2\u5b58\u5728\u6709\u6548\u9884\u5360\u8bb0\u5f55", (Object)sourceNo);
            return false;
        }
        return true;
    }

    protected List<InventoryPreemptionEo> queryPreemptEos(List<String> sourceNos, String warehouseClassify) {
        return this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).in(InventoryPreemptionEo::getSourceNo, sourceNos)).eq(StringUtils.isNotBlank((CharSequence)warehouseClassify), InventoryPreemptionEo::getWarehouseClassify, (Object)warehouseClassify)).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    protected CalcInventoryDto createOtherChannelCalcDto(Map<String, List<ChannelWarehouseEo>> virtualToChannelMap, CalcInventoryDto virtualCalcDto, String channelWarehouseCode) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(virtualCalcDto.getSourceNo());
        calcInventoryDto.setSourceType(virtualCalcDto.getSourceType());
        calcInventoryDto.setExternalOrderNo(virtualCalcDto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(virtualCalcDto.getValidNegative());
        calcInventoryDto.setType("channel");
        ArrayList details = Lists.newArrayList();
        for (CalcInventoryDetailDto virtualDetailDto : virtualCalcDto.getDetails()) {
            List<ChannelWarehouseEo> channelWarehouseEos = virtualToChannelMap.get(virtualDetailDto.getWarehouseCode());
            if (CollectionUtils.isEmpty(channelWarehouseEos)) continue;
            for (ChannelWarehouseEo channelWarehouseEo : channelWarehouseEos) {
                if (StringUtils.equals((CharSequence)channelWarehouseCode, (CharSequence)channelWarehouseEo.getWarehouseCode())) continue;
                CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
                BigDecimal changeAvaliable = virtualDetailDto.getChangeAvailable();
                detailDto.setOperate(virtualDetailDto.getOperate() + "-\u5237\u65b0\u5176\u4ed6\u6e20\u9053\u4ed3");
                detailDto.setChangeBalance(changeAvaliable);
                detailDto.setChangeAvailable(changeAvaliable);
                detailDto.setWarehouseCode(channelWarehouseEo.getWarehouseCode());
                detailDto.setSkuCode(virtualDetailDto.getSkuCode());
                detailDto.setValidNegative(virtualDetailDto.getValidNegative());
                details.add(detailDto);
            }
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private ChannelInventoryEo initChannelInventory(ChannelWarehouseEo warehouseEo, ItemSkuDto skuRespDto) {
        String currentUserName = StringUtils.isEmpty((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        ChannelInventoryEo channelInventoryEo = new ChannelInventoryEo();
        channelInventoryEo.setId(Long.valueOf(IdWorker.getId()));
        channelInventoryEo.setWarehouseId(warehouseEo.getId());
        channelInventoryEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        channelInventoryEo.setWarehouseName(warehouseEo.getWarehouseName());
        channelInventoryEo.setSkuCode(skuRespDto.getSkuCode());
        channelInventoryEo.setSkuName(skuRespDto.getSkuName());
        channelInventoryEo.setWarehouseClassify(WarehouseClassifyEnum.CHANNEL.getCode());
        channelInventoryEo.setWarehouseType(VirtualWarehouseTypeEnum.OVERALL.getCode());
        channelInventoryEo.setAvailable(BigDecimal.ZERO);
        channelInventoryEo.setPreempt(BigDecimal.ZERO);
        channelInventoryEo.setBalance(BigDecimal.ZERO);
        channelInventoryEo.setDr(YesNoHelper.NO);
        channelInventoryEo.setRemark("");
        channelInventoryEo.setCreatePerson(currentUserName);
        channelInventoryEo.setUpdatePerson(currentUserName);
        return channelInventoryEo;
    }

    protected VirtualInventoryEo initVirtualInventory(VirtualWarehouseEo warehouseEo, ItemSkuDto itemSkuDto) {
        String currentUserName = StringUtils.isEmpty((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        VirtualInventoryEo virtualInventoryEo = new VirtualInventoryEo();
        virtualInventoryEo.setId(Long.valueOf(IdWorker.getId()));
        virtualInventoryEo.setWarehouseId(warehouseEo.getId());
        virtualInventoryEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        virtualInventoryEo.setWarehouseName(warehouseEo.getWarehouseName());
        virtualInventoryEo.setSkuCode(itemSkuDto.getSkuCode());
        virtualInventoryEo.setSkuName(itemSkuDto.getSkuName());
        virtualInventoryEo.setWarehouseClassify(WarehouseClassifyEnum.VIRTUAL.getCode());
        virtualInventoryEo.setWarehouseType(VirtualWarehouseTypeEnum.OVERALL.getCode());
        virtualInventoryEo.setVersion(CsVersionDistinguishEnum.SECOND.getCode());
        virtualInventoryEo.setAvailable(BigDecimal.ZERO);
        virtualInventoryEo.setPreempt(BigDecimal.ZERO);
        virtualInventoryEo.setBalance(BigDecimal.ZERO);
        virtualInventoryEo.setDr(YesNoHelper.NO);
        virtualInventoryEo.setRemark("");
        virtualInventoryEo.setCreatePerson(currentUserName);
        virtualInventoryEo.setUpdatePerson(currentUserName);
        return virtualInventoryEo;
    }

    protected RelShareInventoryEo initLogicToVirtualInventory(String logicWarehouseCode, VirtualWarehouseEo warehouseEo, String skuCode) {
        String currentUserName = StringUtils.isEmpty((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        RelShareInventoryEo relShareInventoryEo = new RelShareInventoryEo();
        relShareInventoryEo.setId(Long.valueOf(IdWorker.getId()));
        relShareInventoryEo.setShareWarehouseType(ShareWarehouseTypeEnum.TO_VIRTUAL.getCode());
        relShareInventoryEo.setShareWarehouseCode(logicWarehouseCode);
        relShareInventoryEo.setReceiveWarehouseCode(warehouseEo.getWarehouseCode());
        relShareInventoryEo.setSkuCode(skuCode);
        relShareInventoryEo.setAvailable(BigDecimal.ZERO);
        relShareInventoryEo.setPreempt(BigDecimal.ZERO);
        relShareInventoryEo.setBalance(BigDecimal.ZERO);
        relShareInventoryEo.setCreatePerson(currentUserName);
        relShareInventoryEo.setUpdatePerson(currentUserName);
        return relShareInventoryEo;
    }

    protected Boolean queryOtherChannelValidNegative() {
        Boolean isValidNegativeForOtherChannelInventory = Boolean.TRUE;
        try {
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "SHARE_INVENTORY", "IS_VALID_NEGATIVE_FOR_OTHER_CHANNEL_INVENTORY"));
            log.info("\u67e5\u8be2\u914d\u7f6e\uff0c\u67e5\u8be2\u662f\u5426\u5224\u65ad\u5176\u4ed6\u6e20\u9053\u4ed3\u4e3a\u8d1f, \u914d\u7f6e: {}", (Object)JSON.toJSONString((Object)dictDto));
            if (null != dictDto) {
                isValidNegativeForOtherChannelInventory = YesNoHelper.YES.toString().equals(dictDto.getValue());
            }
            log.info("\u67e5\u8be2\u914d\u7f6e\uff0c\u67e5\u8be2\u662f\u5426\u5224\u65ad\u5176\u4ed6\u6e20\u9053\u4ed3\u4e3a\u8d1f, \u914d\u7f6e\u7ed3\u679c: {}", (Object)isValidNegativeForOtherChannelInventory);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u914d\u7f6e\uff0c\u67e5\u8be2\u662f\u5426\u5224\u65ad\u5176\u4ed6\u6e20\u9053\u4ed3\u4e3a\u8d1f \u5931\u8d25: {}", (Object)e.getMessage());
        }
        return isValidNegativeForOtherChannelInventory;
    }

    protected void updateInventoryPreemptionValidBatch(String statusCode, List<InventoryPreemptionEo> preemptionEos) {
        if (CollectionUtils.isEmpty(preemptionEos)) {
            return;
        }
        Set ids = preemptionEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
        this.inventoryPreemptionDomain.updateValidBatch(statusCode, ids);
    }

    protected List<InventorySharedWarehouseEo> queryShareVirtualWarehouseEos(List<String> logicWarehouseCodes) {
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", logicWarehouseCodes)).eq((Object)"status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
            log.info("supplyByLogicLog: \u903b\u8f91\u4ed3\u7f16\u7801\uff1a{}, \u6ca1\u6709\u6709\u6548\u5171\u4eab\u7b56\u7565\u914d\u7f6e", logicWarehouseCodes);
            return null;
        }
        return inventorySharedWarehouseEos;
    }

    protected BigDecimal getRealNum(BigDecimal num) {
        num = BigDecimalUtils.check((BigDecimal)num);
        return num.setScale(0, RoundingMode.DOWN);
    }

    protected Mutex lock(String key) {
        return this.lockService.lock(INVENTORY_ABLE_LOCK, key, 30, 35, TimeUnit.SECONDS);
    }

    protected void unlock(Mutex mutex) {
        if (null == mutex) {
            return;
        }
        this.transactionAfterService.execute(() -> {
            log.info("\u8fdb\u5165\u4e8b\u52a1\u5904\u7406\u540e\u91ca\u653e\u9501: {}", (Object)mutex);
            this.lockService.unlock(mutex);
        });
    }

    protected InventoryPreemptionEo createChannelPreemptEo(CalcInventoryDto calcInventoryDto, CalcInventoryDetailDto detail, ItemSkuDto itemSkuDto, ChannelWarehouseEo warehouseEo, ChannelInventoryEo channelInventoryEo) {
        InventoryPreemptionEo inventoryPreemptionEo = new InventoryPreemptionEo();
        inventoryPreemptionEo.setInventoryId(channelInventoryEo.getId());
        inventoryPreemptionEo.setSkuCode(itemSkuDto.getSkuCode());
        inventoryPreemptionEo.setSkuName(itemSkuDto.getSkuName());
        inventoryPreemptionEo.setDisplay(YesNoHelper.YES);
        inventoryPreemptionEo.setValid(EnableDisableEnum.ENABLE.getCode());
        inventoryPreemptionEo.setExternalOrderNo(calcInventoryDto.getExternalOrderNo());
        inventoryPreemptionEo.setSourceNo(calcInventoryDto.getSourceNo());
        inventoryPreemptionEo.setSourceType(calcInventoryDto.getSourceType());
        inventoryPreemptionEo.setPlatformOrderNo(calcInventoryDto.getExternalOrderNo());
        inventoryPreemptionEo.setWarehouseClassify(WarehouseClassifyEnum.CHANNEL.getCode());
        inventoryPreemptionEo.setWarehouseId(warehouseEo.getId());
        inventoryPreemptionEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        inventoryPreemptionEo.setWarehouseName(warehouseEo.getWarehouseName());
        inventoryPreemptionEo.setWarehouseType(String.format("%s", warehouseEo.getWarehouseType()));
        inventoryPreemptionEo.setRemark(calcInventoryDto.getRemark());
        inventoryPreemptionEo.setPreemptNum(detail.getChangePreempt());
        return inventoryPreemptionEo;
    }

    protected InventoryPreemptionEo createVirtualPreemptEo(CalcInventoryDto calcInventoryDto, CalcInventoryDetailDto detail, ItemSkuDto itemSkuDto, VirtualWarehouseEo warehouseEo, VirtualInventoryEo virtualInventoryEo) {
        InventoryPreemptionEo inventoryPreemptionEo = new InventoryPreemptionEo();
        inventoryPreemptionEo.setInventoryId(virtualInventoryEo.getId());
        inventoryPreemptionEo.setSkuCode(itemSkuDto.getSkuCode());
        inventoryPreemptionEo.setSkuName(itemSkuDto.getSkuName());
        inventoryPreemptionEo.setDisplay(YesNoHelper.YES);
        inventoryPreemptionEo.setValid(EnableDisableEnum.ENABLE.getCode());
        inventoryPreemptionEo.setExternalOrderNo(calcInventoryDto.getExternalOrderNo());
        inventoryPreemptionEo.setSourceNo(calcInventoryDto.getSourceNo());
        inventoryPreemptionEo.setPlatformOrderNo(calcInventoryDto.getExternalOrderNo());
        inventoryPreemptionEo.setSourceType(calcInventoryDto.getSourceType());
        inventoryPreemptionEo.setWarehouseClassify(WarehouseClassifyEnum.VIRTUAL.getCode());
        inventoryPreemptionEo.setWarehouseId(warehouseEo.getId());
        inventoryPreemptionEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        inventoryPreemptionEo.setWarehouseName(warehouseEo.getWarehouseName());
        inventoryPreemptionEo.setWarehouseType(String.format("%s", warehouseEo.getWarehouseType()));
        inventoryPreemptionEo.setRemark(calcInventoryDto.getRemark());
        inventoryPreemptionEo.setPreemptNum(detail.getChangePreempt());
        return inventoryPreemptionEo;
    }

    protected List<InventoryPreemptionEo> createChannelPreemptEos(CalcInventoryDto calcInventoryDto, List<ChannelWarehouseEo> channelWarehouseEos, List<ItemSkuDto> itemSkuRespDtoList, List<ChannelInventoryEo> channelInventoryEos) {
        ArrayList preemptionEos = Lists.newArrayList();
        List details = calcInventoryDto.getDetails();
        for (CalcInventoryDetailDto detailDto : details) {
            ChannelWarehouseEo channelWarehouseEo = this.filterChannelWarehouseByCode(channelWarehouseEos, detailDto.getWarehouseCode());
            ItemSkuDto itemSkuDto = this.filterItemSkuByCode(itemSkuRespDtoList, detailDto.getSkuCode());
            ChannelInventoryEo channelInventoryEo = this.filterChannelInventory(channelInventoryEos, channelWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode());
            AssertUtils.notNull((Object)channelInventoryEo, (String)"\u6e20\u9053\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728: \u6e20\u9053\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", (Object[])new Object[]{channelWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode()});
            preemptionEos.add(this.createChannelPreemptEo(calcInventoryDto, detailDto, itemSkuDto, channelWarehouseEo, channelInventoryEo));
        }
        return preemptionEos;
    }

    protected List<InventoryPreemptionEo> createVirtualPreemptEos(CalcInventoryDto calcInventoryDto, List<VirtualWarehouseEo> virtualWarehouseEos, List<ItemSkuDto> itemSkuRespDtoList, List<VirtualInventoryEo> virtualInventoryEos) {
        ArrayList preemptionEos = Lists.newArrayList();
        List details = calcInventoryDto.getDetails();
        for (CalcInventoryDetailDto detailDto : details) {
            VirtualWarehouseEo virtualWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, detailDto.getWarehouseCode());
            ItemSkuDto itemSkuDto = this.filterItemSkuByCode(itemSkuRespDtoList, detailDto.getSkuCode());
            VirtualInventoryEo virtualInventoryEo = this.filterVirtualInventory(virtualInventoryEos, virtualWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode());
            AssertUtils.notNull((Object)virtualInventoryEo, (String)"\u4f9b\u8d27\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728: \u4f9b\u8d27\u4ed3\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", (Object[])new Object[]{virtualWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode()});
            preemptionEos.add(this.createVirtualPreemptEo(calcInventoryDto, detailDto, itemSkuDto, virtualWarehouseEo, virtualInventoryEo));
        }
        return preemptionEos;
    }
}

