/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.dg;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.OriginSaleOrderEnum;
import com.yunxi.dg.base.center.trade.constants.OutNoticeResultSyncStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyPlanDeliveryDateVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoOutNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.mode.IDgCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IOrderLabelExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryDetailResultDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderInfoOutNoticeSyncRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPlatformSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderInfoOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.PerformRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.utils.DgBeanUtils;
import com.yunxi.dg.base.center.trade.utils.DgPerformOrderNoGreateUtil;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
@ConditionalOnProperty(name={"perform.order.domain.dg.enable"}, havingValue="true")
public class DgPerformOrderDomainImpl
implements IDgPerformOrderExtDomain,
IResetRedisNoIndexCommon {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderDomainImpl.class);
    private static final String DEFAULT_BATCH_NO = "default_batch_no";
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgCalculatorAmountModeDomain calculatorAmountMode;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemExtDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderInfoOutNoticeSyncRecordDomain performOrderInfoOutNoticeSyncRecordDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderItemDomain performOrderItemDomain;
    @Resource
    private IOrderLabelExtDomain labelExtDomain;
    @Resource
    private DgPerformOrderNoGreateUtil performOrderNoGreateUtil;
    @Resource
    private DgPerformOrderDomainImpl dgPerformOrderDomain;
    private static List<String> INDEMPOTENT_ORDERTYPE_CHECK = new ArrayList<String>();

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_UNCOMMITTED)
    @DgRedisLock(lockName="saleOrder", key="#addReqDto.platformOrderNo", condition="#addReqDto.platformOrderNo!=null")
    public String addCisSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"addReqDto\u4e0d\u80fd\u4e3a\u7a7a");
        if (!INDEMPOTENT_ORDERTYPE_CHECK.contains(addReqDto.getOrderType())) {
            this.checkPlatformOrderRepeat((DgPerformOrderInfoDto)addReqDto);
        }
        if (DgSaleOrderSourceEnum.PROMOTION.getType().equals(addReqDto.getOrderSource())) {
            this.checkPromotionOrderRepeat((DgPerformOrderInfoDto)addReqDto);
        }
        DgPerformOrderRespDto performOrderRespDto = this.createSaleOrder(addReqDto);
        if (!INDEMPOTENT_ORDERTYPE_CHECK.contains(addReqDto.getOrderType())) {
            this.reCheckPlatformOrderRepeat((DgPerformOrderInfoDto)addReqDto, performOrderRespDto);
        }
        if (performOrderRespDto.getId() == null) {
            log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw new BizException(DgPcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getCode(), DgPcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getMsg());
        }
        DgPerformOrderAddrReqDto orderAddrReqDto = addReqDto.getOrderAddrReqDto();
        DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
        CubeBeanUtils.copyProperties((Object)performOrderAddrEo, (Object)orderAddrReqDto, (String[])new String[0]);
        performOrderAddrEo.setOrderId(performOrderRespDto.getId());
        this.performOrderAddrDomain.insert((BaseEo)performOrderAddrEo);
        this.saveOrderAndGoodItems(addReqDto, performOrderRespDto);
        addReqDto.setId(performOrderRespDto.getId());
        this.labelExtDomain.markOrderSourcePromotion(addReqDto);
        return performOrderRespDto.getSaleOrderNo();
    }

    @Override
    public void modifySaleOrder(DgBizPerformOrderReqDto addReqDto) {
    }

    private DgPerformOrderRespDto createSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"addReqDto\u4e0d\u80fd\u4e3a\u7a7a");
        this.trimPlatformOrderNo(addReqDto);
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)addReqDto, (String[])new String[]{"id"});
        performOrderInfoEo.setSaleOrderNo(this.performOrderNoGreateUtil.generateOrderNo());
        performOrderInfoEo.setSaleCreateTime(new Date());
        DgSaleOrderTypeEnum.enumOf((String)addReqDto.getOrderType());
        if (addReqDto.getManualCreate().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
                performOrderInfoEo.setPlatformOrderNo(this.performOrderNoGreateUtil.generateDefaultPlatformNo());
            }
            log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u624b\u52a8\u521b\u5efa\u9500\u552e\u8ba2\u5355\uff0c\u9700\u8981\u8ba1\u7b97\u5546\u54c1\u7684\u603b\u4ef7\u683c\u548c\u5e94\u4ed8\u91d1\u989d");
            this.calOrderTotalAmount(addReqDto, performOrderInfoEo);
        }
        performOrderInfoEo.setMerchantOriginReceivableAmount(addReqDto.getMerchantReceivableAmount());
        performOrderInfoEo.setPlanShipmentEnterpriseId(addReqDto.getShipmentEnterpriseId());
        performOrderInfoEo.setPlanShipmentEnterpriseCode(addReqDto.getShipmentEnterpriseCode());
        performOrderInfoEo.setPlanShipmentEnterpriseName(addReqDto.getShipmentEnterpriseCode());
        this.performOrderInfoDomain.insert((BaseEo)performOrderInfoEo);
        DgPerformOrderExtensionEo extensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)extensionEo, (Object)addReqDto.getPerformOrderExtensionDto(), (String[])new String[]{"id"});
        extensionEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderExtensionDomain.insert((BaseEo)extensionEo);
        DgPerformOrderPaymentEo paymentEo = new DgPerformOrderPaymentEo();
        CubeBeanUtils.copyProperties((Object)paymentEo, (Object)addReqDto.getPerformOrderPaymentDto(), (String[])new String[]{"id"});
        paymentEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderPaymentDomain.insert((BaseEo)paymentEo);
        DgPerformOrderSnapshotEo snapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)snapshotEo, (Object)addReqDto.getPerformOrderSnapshotDto(), (String[])new String[]{"id"});
        snapshotEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderSnapshotDomain.insert((BaseEo)snapshotEo);
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)performOrderInfoEo, (String[])new String[0]);
        performOrderRespDto.setPerformOrderPaymentDto(this.pay2Dto(paymentEo));
        performOrderRespDto.setPerformOrderSnapshotDto(this.snap2Dto(snapshotEo));
        performOrderRespDto.setPerformOrderExtensionDto(this.ext2Dto(extensionEo));
        return performOrderRespDto;
    }

    private void saveOrderAndGoodItems(DgBizPerformOrderReqDto addReqDto, DgPerformOrderRespDto performOrderRespDto) {
        ArrayList allItemList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            addReqDto.getItemList().stream().forEach(saleOrderItemReqDto -> {
                if (saleOrderItemReqDto.getGift() == null) {
                    saleOrderItemReqDto.setGift(Integer.valueOf(0));
                }
            });
            allItemList.addAll(addReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            addReqDto.getGiftList().stream().forEach(saleOrderItemReqDto -> {
                saleOrderItemReqDto.setGift(Integer.valueOf(1));
                if (addReqDto.getManualCreate().booleanValue()) {
                    saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                } else {
                    saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.PLATFORM.getType());
                }
            });
            allItemList.addAll(addReqDto.getGiftList());
        }
        ArrayList itemEoList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        for (DgPerformOrderItemReqDto itemReqDto : allItemList) {
            DgPerformOrderItemExtensionDto orderItemExtensionDto = itemReqDto.getPerformOrderItemExtensionDto();
            if (StringUtils.equals((CharSequence)itemReqDto.getType(), (CharSequence)DgSaleOrderItemTypeEnum.COMBINATION.getType())) {
                log.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1\u5747\u644a\u91d1\u989d\uff0c\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)itemReqDto));
                List<DgPerformOrderItemRespDto> subItemEos = this.bundleItemDivide(itemReqDto, null, subItemEo -> {
                    subItemEo.setChannelWarehouseCode(addReqDto.getPerformOrderSnapshotDto().getChannelWarehouseCode());
                    subItemEo.setOrderId(performOrderRespDto.getId());
                });
                itemEoList.addAll(subItemEos);
                continue;
            }
            itemReqDto.setOrderId(performOrderRespDto.getId());
            itemReqDto.setChannelWarehouseCode(addReqDto.getPerformOrderSnapshotDto().getChannelWarehouseCode());
            DgPerformOrderItemRespDto itemEo = new DgPerformOrderItemRespDto();
            CubeBeanUtils.copyProperties((Object)itemEo, (Object)itemReqDto, (String[])new String[0]);
            itemEo.setPerformOrderItemExtensionDto(orderItemExtensionDto);
            itemEoList.add(itemEo);
        }
        log.debug("[\u8ba2\u5355\u65b0\u589e]\u8ba1\u7b97\u8ba2\u5355\u5546\u54c1\u7684\u76f8\u5173\u91d1\u989d\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)itemEoList));
        BigDecimal totalItemCount = itemEoList.stream().filter(saleOrderItemEo -> !StringUtils.equals((CharSequence)DgSaleOrderItemStatusEnum.CANCEL.getCode(), (CharSequence)saleOrderItemEo.getStatus())).map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!totalItemCount.equals(performOrderRespDto.getGoodsTotalNum())) {
            DgPerformOrderInfoEo updateCountEo = new DgPerformOrderInfoEo();
            updateCountEo.setId(performOrderRespDto.getId());
            updateCountEo.setGoodsTotalNum(totalItemCount);
            this.performOrderInfoDomain.updateSelective((BaseEo)updateCountEo);
        }
        DgPerformOrderItemChangeVo saleOrderItermChangeVo = new DgPerformOrderItemChangeVo();
        saleOrderItermChangeVo.setOriginOrderId(performOrderRespDto.getId());
        saleOrderItermChangeVo.setSaleOrderId(performOrderRespDto.getId());
        saleOrderItermChangeVo.setSaleOrderNo(performOrderRespDto.getSaleOrderNo());
        saleOrderItermChangeVo.setPerformOrderItemRespDtos((List)itemEoList);
        this.performOrderItemDomain.insertBatchItemVo(saleOrderItermChangeVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DgPerformOrderInfoEo insert(DgPerformOrderReqDto performOrderReqDto) {
        AssertUtils.notNull((Object)performOrderReqDto, (String)"performOrderReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)performOrderReqDto, (String[])new String[]{"id"});
        this.performOrderInfoDomain.insert((BaseEo)performOrderInfoEo);
        DgPerformOrderExtensionEo performOrderExtensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)performOrderExtensionEo, (Object)performOrderReqDto.getPerformOrderExtensionDto(), (String[])new String[]{"id"});
        performOrderExtensionEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderExtensionDomain.insert((BaseEo)performOrderExtensionEo);
        DgPerformOrderPaymentEo performOrderPaymentEo = new DgPerformOrderPaymentEo();
        CubeBeanUtils.copyProperties((Object)performOrderPaymentEo, (Object)performOrderReqDto.getPerformOrderPaymentDto(), (String[])new String[]{"id"});
        performOrderPaymentEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderPaymentDomain.insert((BaseEo)performOrderPaymentEo);
        DgPerformOrderSnapshotEo performOrderSnapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)performOrderSnapshotEo, (Object)performOrderReqDto.getPerformOrderSnapshotDto(), (String[])new String[]{"id"});
        performOrderSnapshotEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderSnapshotDomain.insert((BaseEo)performOrderSnapshotEo);
        return performOrderInfoEo;
    }

    @Override
    public int insert(DgSaleOrderEo orderEo) {
        return 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DgPerformOrderReqDto performOrderReqDto) {
        AssertUtils.notNull((Object)performOrderReqDto, (String)"performOrderReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        Optional.of(performOrderReqDto).ifPresent(eo -> {
            CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)eo, (String[])new String[0]);
            this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
            Optional.ofNullable(performOrderReqDto.getPerformOrderExtensionDto()).ifPresent(dto -> {
                DgPerformOrderExtensionEo performOrderExtensionEo = new DgPerformOrderExtensionEo();
                CubeBeanUtils.copyProperties((Object)performOrderExtensionEo, (Object)dto, (String[])new String[]{"id"});
                this.performOrderExtensionDomain.updateByOrderId(eo.getId(), (DgPerformOrderExtensionDto)dto);
            });
            Optional.ofNullable(performOrderReqDto.getPerformOrderPaymentDto()).ifPresent(dto -> {
                DgPerformOrderPaymentEo performOrderPaymentEo = new DgPerformOrderPaymentEo();
                CubeBeanUtils.copyProperties((Object)performOrderPaymentEo, (Object)dto, (String[])new String[]{"id"});
                this.performOrderPaymentDomain.updateByOrderId(eo.getId(), performOrderPaymentEo);
            });
            Optional.ofNullable(performOrderReqDto.getPerformOrderSnapshotDto()).ifPresent(dto -> {
                DgPerformOrderSnapshotEo performOrderSnapshotEo = new DgPerformOrderSnapshotEo();
                CubeBeanUtils.copyProperties((Object)performOrderSnapshotEo, (Object)dto, (String[])new String[]{"id"});
                this.performOrderSnapshotDomain.updateByOrderId(eo.getId(), performOrderSnapshotEo);
            });
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleteById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDomain.selectByPrimaryKey(id);
        if (Objects.nonNull(performOrderInfoEo)) {
            Long orderId = performOrderInfoEo.getId();
            DgPerformOrderExtensionEo performOrderExtensionEo = new DgPerformOrderExtensionEo();
            performOrderExtensionEo.setOrderId(orderId);
            this.performOrderExtensionDomain.logicDelete((BaseEo)performOrderExtensionEo);
            DgPerformOrderPaymentEo performOrderPaymentEo = new DgPerformOrderPaymentEo();
            performOrderPaymentEo.setOrderId(orderId);
            this.performOrderPaymentDomain.logicDelete((BaseEo)performOrderPaymentEo);
            DgPerformOrderSnapshotEo performOrderSnapshotEo = new DgPerformOrderSnapshotEo();
            performOrderSnapshotEo.setOrderId(orderId);
            this.performOrderSnapshotDomain.logicDelete((BaseEo)performOrderSnapshotEo);
            this.performOrderInfoDomain.logicDeleteById(id);
        }
    }

    @Override
    public DgPerformOrderRespDto queryByDto(DgPerformOrderReqDto queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((Objects.nonNull(queryEo.getId()) || Objects.nonNull(queryEo.getSaleOrderNo()) ? 1 : 0) != 0, (String)"\u672a\u6ee1\u8db3\u67e5\u8be2\u6761\u4ef6");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)queryEo, (String[])new String[0]);
        return this.eo2Dto(this.performOrderInfoDomain.queryByEo(performOrderInfoEo));
    }

    @Override
    public List<DgPerformOrderRespDto> queryListByDto(DgPerformOrderReqDto queryDto) {
        AssertUtils.notNull((Object)queryDto, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)queryDto, (String[])new String[0]);
        return this.performOrderInfoDomain.queryListByDto(performOrderInfoEo).stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    public PageInfo<DgPerformOrderRespDto> queryByPage(DgPerformOrderReqDto queryDto, Integer pageNum, Integer pageSize) {
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)queryDto, (String[])new String[0]);
        ArrayList orderSqlFilter = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrderStatusList())) {
            orderSqlFilter.add(SqlFilter.in((String)"order_status", (Object)queryDto.getOrderStatusList()));
        }
        performOrderInfoEo.setOrderByDesc("create_time");
        performOrderInfoEo.setSqlFilters((List)orderSqlFilter);
        PageInfo eoPageInfo = this.performOrderInfoDomain.selectPage((BaseEo)performOrderInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = eoPageInfo.getList().stream().map(this::eo2Dto).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgPerformOrderRespDto> queryListByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List<DgPerformOrderInfoEo> performOrderInfoEos = this.performOrderInfoDomain.queryListByOrderIds(orderIds);
        if (CollectionUtils.isEmpty(performOrderInfoEos)) {
            return null;
        }
        return performOrderInfoEos.stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    public DgBizPerformOrderRespDto queryBizDtoByOrderNo(String orderNo) {
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getSaleOrderNo, (Object)orderNo);
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDomain.getMapper().selectOne((Wrapper)queryOrderWrapper);
        AssertUtils.notNull((Object)performOrderInfoEo, (String)"%s\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{orderNo});
        DgPerformOrderRespDto performOrderRespDto = this.eo2Dto(performOrderInfoEo);
        DgBizPerformOrderRespDto dto = new DgBizPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)performOrderRespDto, (String[])new String[0]);
        List<DgRelatedOrderRespDto> relatedOrderRespDtos = this.queryRelatedOrder((DgPerformOrderRespDto)dto);
        dto.setRelatedOrderList(relatedOrderRespDtos);
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderAddrEo::getOrderId, (Object)performOrderInfoEo.getId());
        DgPerformOrderAddrEo performOrderAddrEo = (DgPerformOrderAddrEo)this.performOrderAddrDomain.getMapper().selectOne((Wrapper)queryAddrWrapper);
        DgPerformOrderAddrRespDto orderAddrRespDto = new DgPerformOrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)performOrderAddrEo, (String[])new String[0]);
        dto.setOrderAddrRespDto(orderAddrRespDto);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)performOrderInfoEo.getId());
        List orderItemEos = this.performOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList itemList = new ArrayList();
        CubeBeanUtils.copyCollection(itemList, (Collection)orderItemEos, DgPerformOrderItemExtRespDto.class);
        dto.setItemList(itemList);
        return dto;
    }

    @Override
    public DgPerformOrderInfoEo createChildOrder(DgPerformOrderReqDto childOrderEo) {
        childOrderEo.setSaleOrderNo(this.performOrderNoGreateUtil.generateOrderNo());
        childOrderEo.setOrderLevel(DgSaleOrderLevelEnum.CHILD.getType());
        DgPerformOrderInfoEo eo = this.dgPerformOrderDomain.insert(childOrderEo);
        log.info("[\u62c6\u5355]\u5b50\u8ba2\u5355({})\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\uff1a{}", (Object)eo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)childOrderEo));
        return eo;
    }

    @Override
    public void sendMsgSaleOrderCreated(DgPerformOrderRespDto respDto) {
        List<DgPerformOrderItemRespDto> performOrderItemRespDtos;
        AssertUtils.notNull((Object)respDto, (String)"\u5165\u53c2\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)respDto));
        DgPerformOrderAddrDto saleOrderAddrReqDto = new DgPerformOrderAddrDto();
        saleOrderAddrReqDto.setOrderId(respDto.getId());
        DgPerformOrderAddrDto performOrderAddrDto = this.performOrderAddrDomain.queryAddressByOrderId(respDto.getId());
        if (performOrderAddrDto != null) {
            object.put("saleOrderAddrRespDto", (Object)performOrderAddrDto);
        }
        if (CollectionUtils.isNotEmpty(performOrderItemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(respDto.getId()))) {
            object.put("saleOrderItemExtRespDto", performOrderItemRespDtos);
        }
        messageVo.setData((Object)object.toJSONString());
        log.info("[\u9500\u552e\u8ba2\u5355\u521b\u5efa\u6210\u529fmq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("SALE_ORDER_CREATED_MESSAGE_TAG", (Object)messageVo);
    }

    @Override
    public DgPerformOrderRespDto queryDtoById(Long id) {
        return this.eo2Dto(this.performOrderInfoDomain.queryEoById(id));
    }

    @Override
    public DgPerformOrderRespDto queryDtoByOrderNo(String orderNo) {
        return this.eo2Dto(this.performOrderInfoDomain.queryByOrderNo(orderNo));
    }

    @Override
    public DgPerformOrderRespDto queryByOrderId(Long orderId) {
        return null;
    }

    @Override
    public List<PerformRelatedOrderRespDto> queryRelatedOrder(DgPerformOrderReqDto saleOrderRespDto) {
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoListByOrderNo(List<String> orderNos) {
        return this.performOrderInfoDomain.queryByOrderNos(orderNos).stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    public DgPerformOrderInfoDto queryBaseInfoById(Long id) {
        return DgBeanUtils.eo2Dto(this.performOrderInfoDomain.queryEoById(id), DgPerformOrderInfoDto.class);
    }

    @Override
    public DgPerformOrderInfoDto queryBaseInfoByOrderNo(String orderNo) {
        return DgBeanUtils.eo2Dto(this.performOrderInfoDomain.queryByOrderNo(orderNo), DgPerformOrderInfoDto.class);
    }

    @Override
    public List<DgPerformOrderRespDto> querylistByPlatFormOrderNo(DgPlatformSaleOrderReqDto platformDto) {
        if (Objects.isNull(platformDto) || CollectionUtils.isEmpty((Collection)platformDto.getPlatformOrderNos())) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryChildOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChildOrderWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderInfoEo::getPlatformOrderNo, (Collection)platformDto.getPlatformOrderNos());
        switch (platformDto.getTypeEnum()) {
            case NOW_USE: {
                queryChildOrderWrapper.ne(DgPerformOrderInfoEo::getOrderStatus, (Object)DgOmsSaleOrderStatus.SPLIT.getCode());
                break;
            }
            case ORIGIN: {
                queryChildOrderWrapper.isNull(DgPerformOrderInfoEo::getSplitLevel);
                queryChildOrderWrapper.isNull(DgPerformOrderInfoEo::getMainOrderNo);
                queryChildOrderWrapper.notIn(DgPerformOrderInfoEo::getOrderType, new Object[]{DgSaleOrderTypeEnum.REPLENISH_ORDER.getType(), DgSaleOrderTypeEnum.EXCHANGE_ORDER.getType()});
                break;
            }
            case ALL: {
                break;
            }
            default: {
                throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9519\u8befplatFormOrderSelectTypeCode"});
            }
        }
        List saleOrderEos = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryChildOrderWrapper);
        ArrayList respDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtoList, (Collection)saleOrderEos, DgPerformOrderRespDto.class);
        return respDtoList;
    }

    @Override
    public List<DgPerformOrderRespDto> queryNeedConfirmGoodsOrderList(Long lastOrderId, Integer pageSize) {
        DgPerformOrderInfoEo queryEo = new DgPerformOrderInfoEo();
        queryEo.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.DELIVERY_ALL.getCode());
        queryEo.setDr(0);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper((Object)queryEo);
        Optional.ofNullable(lastOrderId).ifPresent(id -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.gt(BaseEo::getId, (Object)lastOrderId);
        });
        wrapper.isNotNull(DgPerformOrderInfoEo::getDeliveryCompleteDate);
        wrapper.orderByAsc(BaseEo::getId);
        int count = this.performOrderInfoDomain.getMapper().selectCount((Wrapper)wrapper);
        log.info("[\u67e5\u8be2\u9700\u786e\u8ba4\u6536\u8d27\u8ba2\u5355]\u67e5\u8be2\u5230\u6570\u91cf={}", (Object)count);
        if (count <= 0) {
            return null;
        }
        Page page = new Page((long)((Integer)ObjectUtil.defaultIfNull((Object)0, (Object)1)).intValue(), (long)((Integer)ObjectUtil.defaultIfNull((Object)pageSize, (Object)10)).intValue(), false);
        page = (Page)this.performOrderInfoDomain.getMapper().selectPage((IPage)page, (Wrapper)wrapper);
        return Optional.ofNullable(page.getRecords()).orElse(com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList()).stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    private void checkPlatformOrderRepeat(DgPerformOrderInfoDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            List saleOrderEos = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().filter(saleOrderEo -> DgSaleOrderLevelEnum.ORIGINAL.getType().equals(saleOrderEo.getOrderLevel()) || DgSaleOrderLevelEnum.MAIN.getType().equals(saleOrderEo.getOrderLevel())).filter(saleOrderEo -> !DgSaleOrderStatusEnum.OBSOLETE.getCode().equals(saleOrderEo.getOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saleOrderEos)) {
                log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8be5\u5e73\u53f0\u8ba2\u5355\uff08{}\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08{}\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u5355", (Object)addReqDto.getPlatformOrderNo(), (Object)((DgPerformOrderInfoEo)saleOrderEos.get(0)).getSaleOrderNo());
                throw DgPcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.builderException();
            }
        }
    }

    private void checkPromotionOrderRepeat(DgPerformOrderInfoDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            boolean match = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().anyMatch(e -> DgSaleOrderSourceEnum.PROMOTION.getType().equals(e.getOrderSource()));
            AssertUtils.isTrue((!match ? 1 : 0) != 0, (String)"\u5f53\u524d\u5e73\u53f0\u8ba2\u5355\u5df2\u5b58\u5728\u5bf9\u5e94\u7684\u5185\u90e8\u4fc3\u9500\u8ba2\u5355\u4e86");
        }
    }

    private void reCheckPlatformOrderRepeat(DgPerformOrderInfoDto addReqDto, DgPerformOrderRespDto performOrderRespDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            List saleOrderEos = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().filter(orderEo -> DgSaleOrderLevelEnum.ORIGINAL.getType().equals(orderEo.getOrderLevel()) || DgSaleOrderLevelEnum.MAIN.getType().equals(orderEo.getOrderLevel())).filter(orderEo -> !DgSaleOrderStatusEnum.OBSOLETE.getCode().equals(orderEo.getOrderStatus())).collect(Collectors.toList());
            if (saleOrderEos.size() > 1) {
                log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8be5\u5e73\u53f0\u8ba2\u5355\uff08{}\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08{}\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u5355", (Object)addReqDto.getPlatformOrderNo(), (Object)((DgPerformOrderInfoEo)saleOrderEos.get(0)).getSaleOrderNo());
                throw DgPcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.builderException();
            }
            DgPerformOrderInfoEo insertedOrderEo = (DgPerformOrderInfoEo)saleOrderEos.get(0);
            String hadSaleOrderNo = insertedOrderEo.getSaleOrderNo();
            if (!hadSaleOrderNo.equals(performOrderRespDto.getSaleOrderNo())) {
                log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5f53\u524d\u6570\u636e\u5e93\u65b0\u589e\u7684\u9500\u552e\u8ba2\u5355\u975e\u672c\u7ebf\u7a0b\u521b\u5efa\u751f\u6210\uff0c\u5f53\u524d\u7ebf\u7a0b\u751f\u6210\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}\uff0c\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)performOrderRespDto.getSaleOrderNo(), (Object)hadSaleOrderNo);
                throw DgPcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.builderException();
            }
        }
    }

    private void calOrderTotalAmount(DgBizPerformOrderReqDto addReqDto, DgPerformOrderInfoEo performOrderInfoEo) {
        List itemList = addReqDto.getItemList();
        ArrayList totalGoodsList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            totalGoodsList.addAll(itemList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            totalGoodsList.addAll(addReqDto.getGiftList());
        }
        List performOrderItemList = totalGoodsList.stream().collect(Collectors.toList());
        BigDecimal goodsTotalAmount = performOrderItemList.stream().map(saleOrderItemReqDto -> {
            if (saleOrderItemReqDto.getSalePrice() != null) {
                return saleOrderItemReqDto.getSalePrice().multiply(saleOrderItemReqDto.getItemNum());
            }
            return BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountAmount = Optional.ofNullable(performOrderItemList.stream().map(DgPerformOrderItemDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        BigDecimal freightCost = Optional.ofNullable(addReqDto.getFreightCost()).orElse(BigDecimal.ZERO);
        BigDecimal goodsTotalNum = performOrderItemList.stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payAmount = performOrderItemList.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal merchantReceivableAmount = goodsTotalAmount.add(freightCost).subtract(discountAmount);
        log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u6210\u4ea4\u91d1\u989d\uff1a{}, \u4f18\u60e0\u603b\u91d1\u989d\uff1a{}, \u5546\u5bb6\u5e94\u6536\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, payAmount, discountAmount, merchantReceivableAmount});
        performOrderInfoEo.setGoodsTotalNum(goodsTotalNum);
        performOrderInfoEo.setGoodsTotalAmount(goodsTotalAmount);
        performOrderInfoEo.setPayAmount(payAmount);
        performOrderInfoEo.setRealPayAmount(payAmount);
        performOrderInfoEo.setDiscountAmount(discountAmount);
        performOrderInfoEo.setMerchantReceivableAmount(merchantReceivableAmount);
    }

    private void trimPlatformOrderNo(DgBizPerformOrderReqDto addReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)addReqDto.getPlatformOrderNo())) {
            addReqDto.setPlatformOrderNo(addReqDto.getPlatformOrderNo().trim());
        }
    }

    public List<DgRelatedOrderRespDto> queryRelatedOrder(DgPerformOrderRespDto saleOrderRespDto) {
        List respDtoList = null;
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getMainOrderNo())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)"0")).eq(DgPerformOrderInfoEo::getMainOrderNo, (Object)saleOrderRespDto.getSaleOrderNo());
            List relatedOrderList = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)relatedOrderList)) {
                return null;
            }
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u4e3b\u8ba2\u5355\uff08{}\uff09\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(item -> {
                    DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                    relatedOrderRespDto.setId(item.getId());
                    relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                    relatedOrderRespDto.setMainOrderNo(item.getMainOrderNo());
                    relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
                DgRelatedOrderRespDto mainOrderRespDto = new DgRelatedOrderRespDto();
                mainOrderRespDto.setId(saleOrderRespDto.getId());
                mainOrderRespDto.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
                mainOrderRespDto.setMainOrderNo(saleOrderRespDto.getMainOrderNo());
                mainOrderRespDto.setOrderStatus(saleOrderRespDto.getOrderStatus());
                mainOrderRespDto.setMainOrder(Boolean.TRUE);
                respDtoList.add(mainOrderRespDto);
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)"0")).eq(DgPerformOrderInfoEo::getMainOrderNo, (Object)saleOrderRespDto.getMainOrderNo());
            List relatedOrderList = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u5b50\u8ba2\u5355\uff08{}\uff09\uff0c\u76f8\u5173\u8054\u7684\u5144\u5f1f\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(item -> {
                    DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                    relatedOrderRespDto.setId(item.getId());
                    relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                    relatedOrderRespDto.setMainOrderNo(item.getMainOrderNo());
                    relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
                LambdaQueryWrapper queryMainWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryMainWrapper.eq(BaseEo::getDr, (Object)"0")).eq(DgPerformOrderInfoEo::getSaleOrderNo, (Object)saleOrderRespDto.getMainOrderNo());
                List orderEoList = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryWrapper);
                AssertUtils.notEmpty((Collection)orderEoList, (String)String.format("\u6570\u636e\u5f02\u5e38\uff0c\u4e3b\u8ba2\u5355(%s)\u4e0d\u5b58\u5728", saleOrderRespDto.getMainOrderNo()));
                DgPerformOrderInfoEo mainSaleOrderEo = (DgPerformOrderInfoEo)orderEoList.get(0);
                DgRelatedOrderRespDto mainOrderRespDto = new DgRelatedOrderRespDto();
                mainOrderRespDto.setId(mainSaleOrderEo.getId());
                mainOrderRespDto.setSaleOrderNo(mainSaleOrderEo.getSaleOrderNo());
                mainOrderRespDto.setMainOrderNo(mainSaleOrderEo.getMainOrderNo());
                mainOrderRespDto.setOrderStatus(mainSaleOrderEo.getOrderStatus());
                mainOrderRespDto.setMainOrder(Boolean.TRUE);
                respDtoList.add(mainOrderRespDto);
            }
        }
        log.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5173\u8054\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(respDtoList));
        return respDtoList;
    }

    @Override
    public List<DgPerformOrderItemRespDto> bundleItemDivide(DgPerformOrderItemReqDto modifyOrderItemReqDto, DgPerformOrderItemEo oriOrderItemEo, Consumer<DgPerformOrderItemDto> subItemExtendsFunc) {
        List subItemList = modifyOrderItemReqDto.getSubItemList();
        subItemList.sort(Comparator.comparing(DgPerformOrderItemDto::getGift).reversed());
        ArrayList subItemEos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        for (int i = 0; i < subItemList.size(); ++i) {
            DgPerformOrderItemDto subItemReqDto = (DgPerformOrderItemDto)subItemList.get(i);
            DgPerformOrderItemRespDto itemEo = new DgPerformOrderItemRespDto();
            if (oriOrderItemEo != null) {
                CubeBeanUtils.copyProperties((Object)itemEo, (Object)oriOrderItemEo, (String[])new String[]{"imgUrl", "createTime", "updateTime"});
            }
            CubeBeanUtils.copyProperties((Object)itemEo, (Object)subItemReqDto, (String[])new String[0]);
            itemEo.setIsOrigin(OriginSaleOrderEnum.FALSE.getType());
            itemEo.setGroupItemName(modifyOrderItemReqDto.getItemName());
            itemEo.setGroupItemPayAmount(modifyOrderItemReqDto.getPayAmount());
            itemEo.setGroupItemRealPayAmount(modifyOrderItemReqDto.getRealPayAmount());
            itemEo.setGroupItemDiscountAmount(modifyOrderItemReqDto.getDiscountAmount());
            itemEo.setGroupOriginNum(modifyOrderItemReqDto.getItemNum());
            itemEo.setGroupItemNum(subItemReqDto.getItemNum());
            itemEo.setGroupSkuCode(modifyOrderItemReqDto.getSkuCode());
            itemEo.setGroupItemId(modifyOrderItemReqDto.getItemId());
            itemEo.setGroupItemPrice(modifyOrderItemReqDto.getPrice());
            itemEo.setType(DgSaleOrderItemTypeEnum.COMBINATION.getType());
            itemEo.setItemNum(modifyOrderItemReqDto.getItemNum().multiply(subItemReqDto.getItemNum()));
            if (subItemExtendsFunc != null) {
                subItemExtendsFunc.accept((DgPerformOrderItemDto)itemEo);
            }
            if (DgGiftEnum.NOT_GIFT.getType().equals(modifyOrderItemReqDto.getGift())) {
                this.calculatorAmountMode.calculatorGroupItemAmount(modifyOrderItemReqDto, (DgPerformOrderItemDto)itemEo, i);
            } else {
                itemEo.setPayAmount(BigDecimal.ZERO);
                itemEo.setDiscountAmount(BigDecimal.ZERO);
                itemEo.setRealPayAmount(BigDecimal.ZERO);
                itemEo.setSalePrice(BigDecimal.ZERO);
                itemEo.setPrice(BigDecimal.ZERO);
                itemEo.setItemIntegral(BigDecimal.ZERO);
            }
            subItemEos.add(itemEo);
        }
        return subItemEos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyChildOrderBySplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        List<Long> orderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
        List<DgPerformOrderItemRespDto> orderItemRespDtoListForNormal = this.performOrderItemDomain.queryNormalItemsByOrderIds(orderIdList);
        AssertUtils.notEmpty(orderItemRespDtoListForNormal, (String)"\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a");
        Map<Long, List<DgPerformOrderItemDto>> orderItemsMap = orderItemRespDtoListForNormal.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
        childOrderList.forEach(childSaleOrderRespDto -> {
            List saleOrderItemRespDtoList = (List)orderItemsMap.get(childSaleOrderRespDto.getId());
            DgPerformOrderInfoDto modifyReqDto = new DgPerformOrderInfoDto();
            DgPerformOrderPaymentDto payModifyReqDto = new DgPerformOrderPaymentDto();
            modifyReqDto.setId(childSaleOrderRespDto.getId());
            if (CollectionUtils.isEmpty((Collection)saleOrderItemRespDtoList)) {
                modifyReqDto.setOrderStatus(DgOmsSaleOrderStatus.CANCEL.getCode());
                modifyReqDto.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.CANCEL.getCode());
                modifyReqDto.setGoodsTotalNum(BigDecimal.ZERO);
                childSaleOrderRespDto.setOrderStatus(DgOmsSaleOrderStatus.CANCEL.getCode());
                childSaleOrderRespDto.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.CANCEL.getCode());
            } else {
                BigDecimal goodsTotalNum = saleOrderItemRespDtoList.stream().map(DgPerformOrderItemDto::getItemNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                modifyReqDto.setGoodsTotalNum(goodsTotalNum);
            }
            this.performOrderInfoDomain.modifySaleOrder(modifyReqDto);
        });
    }

    @Override
    public void resetOrderBizForSplit(DgPerformOrderRespDto originalOrder, List<DgPerformOrderRespDto> childOrderList) {
        AssertUtils.notEmpty(childOrderList, (String)"childOrderList\u5b50\u8ba2\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> childOrderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemDomain.queryNormalItemsByOrderIds(childOrderIdList);
        AssertUtils.notEmpty(saleOrderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a");
        Map<Long, List<DgPerformOrderItemDto>> orderItemMap = saleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
        for (DgPerformOrderRespDto saleOrderRespDto : childOrderList) {
            List<DgPerformOrderItemDto> orderItemRespDtoList = orderItemMap.get(saleOrderRespDto.getId());
            if (!CollectionUtils.isNotEmpty(orderItemRespDtoList)) continue;
            Map<String, List<DgPerformOrderItemDto>> orderItemBizTypeGroupMap = orderItemRespDtoList.stream().filter(saleOrderItemRespDto -> StringUtils.isNotBlank((CharSequence)saleOrderItemRespDto.getItemAttr())).collect(Collectors.groupingBy(DgPerformOrderItemDto::getItemAttr));
            String bizType = originalOrder.getBizType();
            if (orderItemBizTypeGroupMap.size() > 1) {
                bizType = DgSaleOrderBizTypeEnum.PTDT.getCode();
            } else if (orderItemBizTypeGroupMap.size() == 1) {
                DgPerformOrderItemDto saleOrderItemRespDto2 = orderItemRespDtoList.get(0);
                bizType = saleOrderItemRespDto2.getItemAttr();
            }
            DgPerformOrderInfoDto modifyReqDto = new DgPerformOrderInfoDto();
            modifyReqDto.setId(saleOrderRespDto.getId());
            modifyReqDto.setBizType(bizType);
            this.performOrderInfoDomain.modifySaleOrder(modifyReqDto);
            log.info("[\u62c6\u5355\u540e\u91cd\u7f6e\u8ba2\u5355\u4e1a\u52a1\u7c7b\u578b]\u5b50\u8ba2\u5355\uff1a{}\uff0c\u4fee\u6539\u4e1a\u52a1\u7c7b\u578b\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)bizType);
        }
    }

    @Override
    public List<DgPerformOrderRespDto> queryChildByOriOrderNo(String originalOrderNo) {
        AssertUtils.notBlank((String)originalOrderNo, (String)"originalOrderNo\u7236\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryChildOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChildOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getOriginalOrderNo, (Object)originalOrderNo);
        List performOrderInfoEos = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryChildOrderWrapper);
        return performOrderInfoEos.stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderRespDto> queryChildByMainOrderNo(String originalOrderNo) {
        AssertUtils.notBlank((String)originalOrderNo, (String)"originalOrderNo\u7236\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryChildOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChildOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getMainOrderNo, (Object)originalOrderNo);
        List performOrderInfoEos = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryChildOrderWrapper);
        return performOrderInfoEos.stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#respDto.getId()")
    public void saveOrderByDeliveredResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        log.info("[\u51fa\u5e93\u56de\u4f20]\u51fa\u5e93\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DgPerformOrderRespDto performOrderInfoDto = this.queryDtoById(respDto.getId());
        AssertUtils.isTrue((boolean)performOrderInfoDto.getSaleOrderNo().equals(reqDto.getOrderNo()), (String)"\u56de\u4f20\u9500\u552e\u5355\u53f7\u4e0d\u4e00\u81f4");
        this.saveOutNoticeRecord(performOrderInfoDto, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.getId()")
    public void modifyOrderByDeliveredResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        log.info("[\u51fa\u5e93\u56de\u4f20]\u4fee\u6539\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DgPerformOrderRespDto performOrderInfoDto = this.queryDtoById(respDto.getId());
        AssertUtils.isTrue((boolean)respDto.getSaleOrderNo().equals(reqDto.getOrderNo()), (String)"\u56de\u4f20\u9500\u552e\u5355\u53f7\u4e0d\u4e00\u81f4");
        BigDecimal totalOutDeliveryCount = this.getOrderOutDeliveredCount((DgPerformOrderInfoDto)performOrderInfoDto);
        DgPerformOrderInfoOutNoticeSyncRecordRespDto syncRecordRespDto = this.saveOutNoticeRecord(performOrderInfoDto, reqDto);
        if (OutNoticeResultSyncStatusEnum.ACCEPT.getCode().equals(syncRecordRespDto.getOutNoticeResultSyncStatus()) && reqDto.getTotalQuantity() != null) {
            DgPerformOrderInfoEo updateStatusEo = new DgPerformOrderInfoEo();
            if (totalOutDeliveryCount.add(reqDto.getTotalQuantity()).compareTo(performOrderInfoDto.getGoodsTotalNum()) >= 0) {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1\u5df2\u5168\u90e8\u51fa\u5e93\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)performOrderInfoDto.getSaleOrderNo());
            } else {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u5546\u54c1\u5df2\u90e8\u5206\u51fa\u5e93\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)performOrderInfoDto.getSaleOrderNo());
            }
            if (reqDto.getDeliveryTime() != null) {
                updateStatusEo.setDeliveryTime(reqDto.getDeliveryTime());
                updateStatusEo.setDeliveryCompleteDate(reqDto.getDeliveryTime());
            } else {
                updateStatusEo.setDeliveryCompleteDate(new Date());
                updateStatusEo.setDeliveryTime(new Date());
            }
            updateStatusEo.setId(performOrderInfoDto.getId());
            this.performOrderInfoDomain.updateSaleOrderById(performOrderInfoDto.getId(), updateStatusEo);
            this.modifyOrderItemOutDeliveredResult(performOrderInfoDto.getId(), reqDto);
            DgPerformOrderInfoOutNoticeSyncRecordReqDto saveReqDto = new DgPerformOrderInfoOutNoticeSyncRecordReqDto();
            saveReqDto.setId(syncRecordRespDto.getId());
            saveReqDto.setOutNoticeResultSyncStatus(OutNoticeResultSyncStatusEnum.SUCCESS.getCode());
            this.performOrderInfoOutNoticeSyncRecordDomain.modifySaleOrderOutNoticeSyncRecord(saveReqDto);
        } else if (OutNoticeResultSyncStatusEnum.ACCEPT.getCode().equals(syncRecordRespDto.getOutNoticeResultSyncStatus())) {
            log.warn("[\u51fa\u5e93\u56de\u4f20]{}\u51fa\u5e93\u6570\u91cf\u5f02\u5e38{}", (Object)performOrderInfoDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        } else {
            log.warn("[\u51fa\u5e93\u56de\u4f20]\u51fa\u5e93\u5b8c\u6210");
        }
    }

    private BigDecimal getOrderOutDeliveredCount(DgPerformOrderInfoDto saleOrderEo) {
        List<DgPerformOrderItemRespDto> performOrderItemRespDtos = this.performOrderItemExtDomain.queryOrderItemByOrderId(saleOrderEo.getId());
        AssertUtils.notEmpty(performOrderItemRespDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        BigDecimal totalOutDeliveryCount = performOrderItemRespDtos.stream().filter(Objects::nonNull).map(item -> Optional.ofNullable(item.getOutItemNum()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalOutDeliveryCount = Optional.ofNullable(totalOutDeliveryCount).orElse(BigDecimal.ZERO);
        return totalOutDeliveryCount;
    }

    private void modifyOrderItemOutDeliveredResult(Long saleOrderId, DgOutDeliveryResultReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getDeliveryDetailList(), (String)"\u51fa\u5e93\u5546\u54c1\u4e3a\u7a7a");
        List<DgPerformOrderItemRespDto> performOrderItemRespDtos = this.performOrderItemExtDomain.queryOrderItemByOrderId(saleOrderId);
        log.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u539f\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(performOrderItemRespDtos));
        AssertUtils.notEmpty(performOrderItemRespDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Map<String, Map<String, BigDecimal>> longCodeGroupMap = reqDto.getDeliveryDetailList().stream().map(outDeliveryDetailResultDto -> {
            if (StringUtils.isBlank((CharSequence)outDeliveryDetailResultDto.getBatch())) {
                outDeliveryDetailResultDto.setBatch(DEFAULT_BATCH_NO);
                return outDeliveryDetailResultDto;
            }
            return outDeliveryDetailResultDto;
        }).collect(Collectors.groupingBy(DgOutDeliveryDetailResultDto::getLongCode, Collectors.collectingAndThen(Collectors.toList(), saveOrderItems -> {
            Map<String, BigDecimal> batchCountMap = saveOrderItems.stream().collect(Collectors.groupingBy(DgOutDeliveryDetailResultDto::getBatch, Collectors.collectingAndThen(Collectors.toList(), batchOutDeliveryDetailResults -> batchOutDeliveryDetailResults.stream().filter(Objects::nonNull).map(DgOutDeliveryDetailResultDto::getOutQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add))));
            return batchCountMap;
        })));
        log.info("[\u51fa\u5e93\u56de\u4f20]\u51fa\u5e93\u56de\u4f20\u5206\u7ec4\u5904\u7406\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString(longCodeGroupMap));
        HashMap outDeliveredMap = Maps.newHashMap();
        log.info("[\u51fa\u5e93\u56de\u4f20]\u51fa\u5e93\u5339\u914d\u987a\u5e8f\uff1a{}", (Object)JSON.toJSONString(performOrderItemRespDtos));
        HashMap outDeliveredResultMap = Maps.newHashMap();
        this.expectOutDelivery(performOrderItemRespDtos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap);
        this.updateOutDeliveryResult(outDeliveredResultMap);
    }

    private void updateOutDeliveryResult(Map<Long, DgPerformOrderItemRespDto> outDeliveredResultMap) {
        List<DgPerformOrderItemRespDto> updateOrderItemDtos = outDeliveredResultMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        updateOrderItemDtos.sort(Comparator.comparing(BaseDto::getId));
        updateOrderItemDtos.forEach(updateOrderItemDto -> this.performOrderItemExtDomain.updateSelective(DgBeanUtils.dto2dto(updateOrderItemDto, DgPerformOrderItemReqDto.class)));
    }

    private void expectOutDelivery(List<DgPerformOrderItemRespDto> saleOrderItemEos, Map<String, Map<String, BigDecimal>> longCodeGroupMap, Map<String, Map<String, BigDecimal>> outDeliveredMap, Map<Long, DgPerformOrderItemRespDto> outDeliveredResultMap) {
        saleOrderItemEos.sort(Comparator.comparing(DgPerformOrderItemDto::getGift));
        this.scanOrderItems(saleOrderItemEos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap, (batchCountMap, saleOrderItemEo) -> {
            BigDecimal batchCount;
            if (batchCountMap != null && (batchCount = (BigDecimal)batchCountMap.get(saleOrderItemEo.getDeliveryItemBatchNo())) != null) {
                this.deductOutDelivery(outDeliveredMap, (DgPerformOrderItemRespDto)saleOrderItemEo, saleOrderItemEo.getDeliveryItemBatchNo(), batchCount, outDeliveredResultMap);
            }
        });
        this.scanOrderItems(saleOrderItemEos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap, (batchCountMap, saleOrderItemEo) -> {
            if (batchCountMap != null) {
                batchCountMap.forEach((batchNo, count) -> this.deductOutDelivery(outDeliveredMap, (DgPerformOrderItemRespDto)saleOrderItemEo, (String)batchNo, (BigDecimal)count, outDeliveredResultMap));
            }
        });
    }

    private void scanOrderItems(List<DgPerformOrderItemRespDto> saleOrderItemEos, Map<String, Map<String, BigDecimal>> longCodeGroupMap, Map<String, Map<String, BigDecimal>> outDeliveredMap, Map<Long, DgPerformOrderItemRespDto> outDeliveredResultMap, BiConsumer<Map<String, BigDecimal>, DgPerformOrderItemRespDto> callHandle) {
        for (DgPerformOrderItemRespDto saleOrderItemEo : saleOrderItemEos) {
            if (saleOrderItemEo.getItemNum().equals(saleOrderItemEo.getOutItemNum())) {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u5546\u54c1\u884cid\u4e3a{}\u5df2\u5168\u90e8\u51fa\u5e93", (Object)saleOrderItemEo.getId());
                continue;
            }
            Map<String, BigDecimal> batchCountMap = longCodeGroupMap.get(saleOrderItemEo.getSkuCode());
            callHandle.accept(batchCountMap, saleOrderItemEo);
        }
    }

    private void deductOutDelivery(Map<String, Map<String, BigDecimal>> outDeliveredMap, DgPerformOrderItemRespDto saleOrderItemEo, String deliveryItemBatchNo, BigDecimal batchCount, Map<Long, DgPerformOrderItemRespDto> outDeliveredResultMap) {
        BigDecimal availableCount = this.calAvailableCount(outDeliveredMap, saleOrderItemEo.getSkuCode(), deliveryItemBatchNo, batchCount);
        BigDecimal needCount = saleOrderItemEo.getItemNum().subtract(Optional.ofNullable(saleOrderItemEo.getOutItemNum()).orElse(BigDecimal.ZERO));
        log.info("[\u51fa\u5e93\u56de\u4f20]\u53ef\u7528\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}", (Object)availableCount, (Object)needCount);
        if (availableCount.compareTo(needCount) >= 0) {
            log.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1orderItemId={},\u5df2\u5168\u90e8\u51fa\u5e93", (Object)saleOrderItemEo.getId());
            this.updateItemOutDeliveryCount(saleOrderItemEo.getId(), saleOrderItemEo.getItemNum(), outDeliveredResultMap);
            this.calDeliveredCount(outDeliveredMap, saleOrderItemEo.getSkuCode(), deliveryItemBatchNo, needCount);
        } else if (BigDecimal.ZERO.compareTo(availableCount) < 0) {
            log.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1orderItemId={},\u90e8\u5206\u51fa\u5e93\uff0c\u5df2\u51fa\u5e93\u6570\u91cf\u4e3a\uff1aoutItemNum={}\uff0cavailableCount={}", new Object[]{saleOrderItemEo.getId(), saleOrderItemEo.getOutItemNum(), availableCount});
            this.updateItemOutDeliveryCount(saleOrderItemEo.getId(), saleOrderItemEo.getOutItemNum().add(availableCount), outDeliveredResultMap);
            this.calDeliveredCount(outDeliveredMap, saleOrderItemEo.getSkuCode(), deliveryItemBatchNo, availableCount);
        }
    }

    private BigDecimal calAvailableCount(Map<String, Map<String, BigDecimal>> outDeliveredMap, String longCode, String batchNo, BigDecimal batchCount) {
        Map<String, BigDecimal> batchCountMap = outDeliveredMap.get(longCode);
        if (batchCountMap == null) {
            return batchCount;
        }
        BigDecimal count = batchCountMap.get(batchNo);
        if (count != null) {
            return batchCount.subtract(count);
        }
        return batchCount;
    }

    private void updateItemOutDeliveryCount(Long orderItemId, BigDecimal outDeliveryCount, Map<Long, DgPerformOrderItemRespDto> outDeliveredResultMap) {
        AssertUtils.notNull((Object)orderItemId, (String)"orderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        outDeliveredResultMap.compute(orderItemId, (k, updateItemEo) -> {
            if (updateItemEo == null) {
                updateItemEo = new DgPerformOrderItemRespDto();
                updateItemEo.setOutItemNum(outDeliveryCount);
                updateItemEo.setId(orderItemId);
                return updateItemEo;
            }
            BigDecimal totalDeliveryCount = updateItemEo.getOutItemNum().add(outDeliveryCount);
            updateItemEo.setOutItemNum(totalDeliveryCount);
            return updateItemEo;
        });
    }

    private void calDeliveredCount(Map<String, Map<String, BigDecimal>> outDeliveredMap, String skuCode, String batchNo, BigDecimal count) {
        HashMap batchCountMap = outDeliveredMap.get(skuCode);
        if (batchCountMap == null) {
            batchCountMap = Maps.newHashMap();
            batchCountMap.put(batchNo, count);
            outDeliveredMap.put(skuCode, batchCountMap);
        } else {
            BigDecimal usedCount = Optional.ofNullable(batchCountMap.get(batchNo)).orElse(BigDecimal.ZERO).add(count);
            batchCountMap.put(batchNo, usedCount);
        }
        log.info("[\u51fa\u5e93\u56de\u4f20]\u5df2\u51fa\u5e93\u7684\u8bb0\u5f55\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)batchCountMap));
    }

    @Override
    public DgPerformOrderInfoOutNoticeSyncRecordRespDto saveOutNoticeRecord(DgPerformOrderRespDto saleOrderRespDto, DgOutDeliveryResultReqDto reqDto) {
        log.info("[\u51fa\u5e93\u56de\u4f20]\u4fdd\u5b58\u56de\u4f20\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.notNull((Object)saleOrderRespDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoOutNoticeSyncRecordRespDto saleOrderOutNoticeSyncRecordRespDto = this.performOrderInfoOutNoticeSyncRecordDomain.queryByOrderId(saleOrderRespDto.getId());
        DgPerformOrderInfoOutNoticeSyncRecordReqDto saveReqDto = new DgPerformOrderInfoOutNoticeSyncRecordReqDto();
        if (saleOrderOutNoticeSyncRecordRespDto == null) {
            saveReqDto.setOrderId(saleOrderRespDto.getId());
            saveReqDto.setDeliveryNoticeOrderNo(reqDto.getDeliveryNoticeOrderNo());
            saveReqDto.setOutNoticeOrderNo(reqDto.getOutNoticeOrderNo());
            saveReqDto.setOrganizationCode(saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationCode());
            saveReqDto.setOrganizationId(saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationId());
            saveReqDto.setOrganizationName(saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationName());
            saveReqDto.setOutNoticeResultJson(JSON.toJSONString((Object)reqDto));
            saveReqDto.setOutNoticeResultSyncStatus(OutNoticeResultSyncStatusEnum.ACCEPT.getCode());
            Long recordId = this.performOrderInfoOutNoticeSyncRecordDomain.addSaleOrderOutNoticeSyncRecord(saveReqDto);
            saleOrderOutNoticeSyncRecordRespDto = new DgPerformOrderInfoOutNoticeSyncRecordRespDto();
            CubeBeanUtils.copyProperties((Object)saleOrderOutNoticeSyncRecordRespDto, (Object)saveReqDto, (String[])new String[0]);
            saleOrderOutNoticeSyncRecordRespDto.setId(recordId);
        } else {
            DgOutDeliveryResultReqDto jsonReq = (DgOutDeliveryResultReqDto)JSON.parseObject((String)saleOrderOutNoticeSyncRecordRespDto.getOutNoticeResultJson(), DgOutDeliveryResultReqDto.class);
            List deliveryDetailLists = Optional.ofNullable(jsonReq.getDeliveryDetailList()).orElseGet(ArrayList::new);
            List shippingInfoList = Optional.ofNullable(jsonReq.getShippingInfoList()).orElseGet(ArrayList::new);
            CubeBeanUtils.copyProperties((Object)jsonReq, (Object)reqDto, (String[])new String[]{"shippingInfoList"});
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getDeliveryDetailList())) {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u589e\u52a0\u51fa\u5e93\u5546\u54c1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto.getDeliveryDetailList()));
                deliveryDetailLists.addAll(reqDto.getDeliveryDetailList());
            }
            jsonReq.setDeliveryDetailList(deliveryDetailLists);
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getShippingInfoList())) {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u4fdd\u5b58\u7269\u6d41\u4fe1\u606f-\u8986\u76d6\u7269\u6d41\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto.getShippingInfoList()));
                jsonReq.getShippingInfoList().addAll(reqDto.getShippingInfoList());
            } else {
                jsonReq.setShippingInfoList(shippingInfoList);
            }
            DgPerformOrderInfoOutNoticeSyncRecordReqDto updateDto = new DgPerformOrderInfoOutNoticeSyncRecordReqDto();
            updateDto.setId(saleOrderOutNoticeSyncRecordRespDto.getId());
            updateDto.setOutNoticeResultJson(JSON.toJSONString((Object)jsonReq));
            this.performOrderInfoOutNoticeSyncRecordDomain.modifySaleOrderOutNoticeSyncRecord(updateDto);
        }
        return saleOrderOutNoticeSyncRecordRespDto;
    }

    @Override
    public void sendMsgForDeliveryResult(DgPerformOrderRespDto saleOrderRespDto, DgOmsSaleOrderStatus saleOrderStatus, DgOutDeliveryResultReqDto outDeliveryResultReqDto) {
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"saleOrderRespDto \u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Integer status = 0;
        switch (saleOrderStatus) {
            case WAIT_DELIVERY: {
                status = 1;
                break;
            }
            case DELIVERY_ALL: {
                status = 3;
                break;
            }
            case COMPLETE: {
                status = 4;
                break;
            }
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("orderNo", saleOrderRespDto.getPlatformOrderNo());
        msgMap.put("status", status);
        msgMap.put("consignType", saleOrderRespDto.getConsignType());
        msgMap.put("platformOrderStatus", saleOrderRespDto.getPlatformOrderStatus());
        msgMap.put("platformParentOrderNo", saleOrderRespDto.getPlatformParentOrderNo());
        msgMap.put("orderSourceSystemCode", saleOrderRespDto.getOrderSourceSystemCode());
        msgMap.put("orderSourceSystemName", saleOrderRespDto.getOrderSourceSystemName());
        msgMap.put("orderSource", saleOrderRespDto.getOrderSource());
        if (Objects.nonNull(outDeliveryResultReqDto)) {
            msgMap.put("saleOrderNo", saleOrderRespDto.getSaleOrderNo());
            msgMap.put("saleOrderId", saleOrderRespDto.getId());
            msgMap.put("shipmentEnterpriseCode", outDeliveryResultReqDto.getShipmentEnterpriseCode());
            msgMap.put("shipmentEnterpriseName", outDeliveryResultReqDto.getShipmentEnterpriseName());
            msgMap.put("shippingNo", outDeliveryResultReqDto.getShippingNo());
            msgMap.put("outNoticeOrderNo", outDeliveryResultReqDto.getOutNoticeOrderNo());
            msgMap.put("channelCode", saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
            msgMap.put("shippingInfoList", outDeliveryResultReqDto.getShippingInfoList());
            List<DgPerformOrderItemRespDto> saleOrderItemRespDtos = this.performOrderItemExtDomain.queryOrderItemByOrderId(saleOrderRespDto.getId());
            Map itemRespDtoMap = saleOrderItemRespDtos.stream().collect(Collectors.toMap(DgPerformOrderItemDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
            Map orderItemRespDtoMap = saleOrderItemRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (v1, v2) -> v2));
            ArrayList itemMapList = Lists.newArrayList();
            ((List)Optional.ofNullable(outDeliveryResultReqDto.getDeliveryDetailList()).orElse(new ArrayList())).forEach(item -> Optional.ofNullable(itemRespDtoMap.get(item.getLongCode())).ifPresent(saleOrderItemRespDto -> {
                HashMap itemMap = Maps.newHashMap();
                itemMap.put("itemCode", saleOrderItemRespDto.getItemCode());
                itemMap.put("skuCode", saleOrderItemRespDto.getSkuCode());
                itemMap.put("packId", saleOrderItemRespDto.getPackId());
                itemMap.put("itemNum", item.getOutQuantity());
                if (item.getTradeOrderItemId() != null && orderItemRespDtoMap.get(item.getTradeOrderItemId()) != null) {
                    DgPerformOrderItemRespDto oriOrderItemRespDto = (DgPerformOrderItemRespDto)orderItemRespDtoMap.get(item.getTradeOrderItemId());
                    itemMap.put("platformOrderItemNo", oriOrderItemRespDto.getPlatformOrderItemNo());
                    itemMap.put("gift", oriOrderItemRespDto.getGift());
                    itemMap.put("tradeOrderItemId", item.getTradeOrderItemId());
                } else {
                    itemMap.put("platformOrderItemNo", saleOrderItemRespDto.getPlatformOrderItemNo());
                }
                itemMapList.add(itemMap);
            }));
            List itemDtoList = saleOrderItemRespDtos.stream().filter(dto -> SaleItemStatusEnum.NORMAL.getCode().equals(dto.getStatus())).map(dto -> {
                HashMap itemMap = Maps.newHashMap();
                itemMap.put("itemCode", dto.getItemCode());
                itemMap.put("skuCode", dto.getSkuCode());
                itemMap.put("packId", dto.getPackId());
                itemMap.put("itemNum", dto.getItemNum());
                itemMap.put("platformOrderItemNo", dto.getPlatformOrderItemNo());
                itemMap.put("tradeOrderItemId", dto.getId());
                return itemMap;
            }).collect(Collectors.toList());
            msgMap.put("goodsList", itemMapList);
            msgMap.put("orderItemList", itemDtoList);
        }
        if (Objects.nonNull(saleOrderRespDto.getExchangeOrderNo())) {
            DgAfterSaleOrderRespDto afterDgPerformOrderRespDto = this.afterSaleOrderDomain.queryByNo(saleOrderRespDto.getExchangeOrderNo());
            Optional.ofNullable(afterDgPerformOrderRespDto).ifPresent(afterSaleOrder -> msgMap.put("platformRefundOrderSn", afterSaleOrder.getPlatformRefundOrderSn()));
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString(msgMap));
        log.info("[\u51fa\u5e93\u56de\u4f20\u53d1\u9001mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("DELIVERY_RESULT_B2B_MESSAGE_TAG", (Object)messageVo);
    }

    @Override
    public void modifyPlanDeliveryDate(ModifyPlanDeliveryDateVo modifyPlanDeliveryDateVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEo::getId, (Object)modifyPlanDeliveryDateVo.getSaleOrderId());
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDomain.getMapper().selectOne((Wrapper)wrapper);
        AssertUtils.notNull((Object)performOrderInfoEo, (String)"\u53d1\u8d27\u652f\u4ed8\u5c65\u7ea6\u76f8\u5173\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        performOrderInfoEo.setPlanDeliveryTime(modifyPlanDeliveryDateVo.getPlanDeliveryTime());
        this.performOrderInfoDomain.update((BaseEo)performOrderInfoEo);
    }

    @Override
    public void removePlanShipmentEnterpriseInfo(Long orderId) {
        this.performOrderInfoDomain.removePlanShipmentEnterpriseInfo(orderId);
    }

    @Override
    public void cleanSourceData(Long orderId) {
        this.performOrderInfoDomain.cleanSourceData(orderId);
    }

    @Override
    public void removeShipmentEnterprise(Long saleOrderId) {
        this.performOrderInfoDomain.removeShipmentEnterprise(saleOrderId);
    }

    @Override
    public void removeLabel(Long saleOrderId, String oriLabel, String ... optLabels) {
        this.performOrderInfoDomain.removeLabel(saleOrderId, oriLabel, optLabels);
    }

    @Override
    public void removeAllLabel(Long saleOrderId) {
    }

    @Override
    public int optimisticModifySaleOrder(DgSaleOrderEo updateEo, UpdateWrapper<DgSaleOrderEo> updateWrapper, int i, boolean b) {
        return 0;
    }

    @Override
    public DgPerformOrderRespDto querySaleOrderById(Long id) {
        return null;
    }

    @Override
    public int updateSaleOrderById(Long orderId, DgSaleOrderEo updateEo) {
        return 0;
    }

    @Override
    public void changeDeliveredForOrder(DgPerformOrderReqDto dgPerformOrderReqDto) {
    }

    @Override
    public void removeLogicalWarehouseInfo(String saleOrderNo) {
    }

    @Override
    public List<DgSaleOrderEo> queryByPlatformOrderId(Long platformOrderId) {
        return null;
    }

    @Override
    public List<DgSaleOrderEo> queryByPlatFormOrderNo(String platFormOrderNo, String platFormOrderSelectTypeCode) {
        return null;
    }

    @Override
    public void updateEasVerifyStatus(String saleOrderNo) {
    }

    @Override
    public List<DgPerformOrderRespDto> queryByParamList(DgPerformOrderReqDto queryReqDto) {
        return null;
    }

    @Override
    public DgPerformOrderRespDto queryNewestOrderByCustomerId(Long customerId) {
        return null;
    }

    @Override
    public List<DgSaleOrderEo> queryEoByOrderNos(List<String> orderNos) {
        return null;
    }

    @Override
    public Boolean verifySaleOrderEntireSign(Long orderId, String saleOrderNo) {
        return null;
    }

    private DgPerformOrderRespDto eo2Dto(DgPerformOrderInfoEo performOrderInfoEo) {
        if (Objects.isNull(performOrderInfoEo)) {
            return null;
        }
        Long orderId = performOrderInfoEo.getId();
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)performOrderInfoEo, (String[])new String[0]);
        DgPerformOrderExtensionDto extensionDto = this.performOrderExtensionDomain.selectDtoByOrderId(orderId);
        AssertUtils.notNull((Object)extensionDto, (String)"extensionDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderPaymentDto paymentDto = this.performOrderPaymentDomain.selectDtoByOrderId(orderId);
        AssertUtils.notNull((Object)paymentDto, (String)"paymentDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderSnapshotDto snapshotDto = this.performOrderSnapshotDomain.selectDtoByOrderId(orderId);
        AssertUtils.notNull((Object)snapshotDto, (String)"snapshotDto \u4e0d\u80fd\u4e3a\u7a7a");
        performOrderRespDto.setPerformOrderExtensionDto(extensionDto);
        performOrderRespDto.setPerformOrderPaymentDto(paymentDto);
        performOrderRespDto.setPerformOrderSnapshotDto(snapshotDto);
        return performOrderRespDto;
    }

    private DgPerformOrderExtensionDto ext2Dto(DgPerformOrderExtensionEo extensionEo) {
        DgPerformOrderExtensionDto extensionDto = new DgPerformOrderExtensionDto();
        CubeBeanUtils.copyProperties((Object)extensionDto, (Object)extensionEo, (String[])new String[0]);
        return extensionDto;
    }

    private DgPerformOrderPaymentDto pay2Dto(DgPerformOrderPaymentEo paymentEo) {
        DgPerformOrderPaymentDto paymentDto = new DgPerformOrderPaymentDto();
        CubeBeanUtils.copyProperties((Object)paymentDto, (Object)paymentEo, (String[])new String[0]);
        return paymentDto;
    }

    private DgPerformOrderSnapshotDto snap2Dto(DgPerformOrderSnapshotEo snapshotEo) {
        DgPerformOrderSnapshotDto snapshotDto = new DgPerformOrderSnapshotDto();
        CubeBeanUtils.copyProperties((Object)snapshotDto, (Object)snapshotEo, (String[])new String[0]);
        return snapshotDto;
    }

    @Override
    public String getLatestNo() {
        return this.performOrderInfoDomain.getLatestNo();
    }

    static {
        INDEMPOTENT_ORDERTYPE_CHECK.add(DgSaleOrderTypeEnum.REPLENISH_ORDER.getType());
        INDEMPOTENT_ORDERTYPE_CHECK.add(DgSaleOrderTypeEnum.EXCHANGE_ORDER.getType());
    }
}

