/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgOrderLabelRecordDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRecordRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderLabelRecordEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOrderLabelRecordDomainImpl
extends BaseDomainImpl<DgOrderLabelRecordEo>
implements IDgOrderLabelRecordDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOrderLabelRecordDomainImpl.class);
    @Resource
    private IDgOrderLabelRecordDas das;

    public ICommonDas<DgOrderLabelRecordEo> commonDas() {
        return this.das;
    }

    @Override
    public List<DgOrderLabelRecordRespDto> queryByOrderId(Long orderId) {
        AssertUtils.notEmpty((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgOrderLabelRecordEo::getOrderId, (Object)orderId);
        List orderLabelRecordEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderLabelRecordEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)orderLabelRecordEos, DgOrderLabelRecordRespDto.class);
        return resultList;
    }

    @Override
    public List<DgOrderLabelRecordDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgOrderLabelRecordEo::getOrderId, orderIds);
        List orderLabelRecordEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderLabelRecordEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)orderLabelRecordEos, DgOrderLabelRecordDto.class);
        return resultList;
    }

    @Override
    public Long addOrderLabelRecord(Long orderId, DgOrderLabelEnum addReqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelRecordEo record = new DgOrderLabelRecordEo();
        record.setOrderId(orderId);
        record.setLabelCode(addReqDto.getCode());
        record.setDisplay(addReqDto.getDisplay());
        DgOrderLabelRecordEo eo = (DgOrderLabelRecordEo)this.das.selectOne((BaseEo)record);
        if (Objects.nonNull(eo)) {
            log.warn(String.format("[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5\u6807\u8bc6", orderId, addReqDto.getCode()));
            return null;
        }
        DgOrderLabelRecordEo orderLabelRecordEo = new DgOrderLabelRecordEo();
        orderLabelRecordEo.setLabelCode(addReqDto.getCode());
        orderLabelRecordEo.setOrderId(orderId);
        orderLabelRecordEo.setDisplay(addReqDto.getDisplay());
        this.das.insert((BaseEo)orderLabelRecordEo);
        return orderLabelRecordEo.getId();
    }

    @Override
    public List<DgOrderLabelRecordRespDto> queryByParam(DgOrderLabelRecordReqDto orderLabelRecordReqDto) {
        List orderLabelRecordEos;
        AssertUtils.notNull((Object)orderLabelRecordReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderLabelRecordReqDto.getLabelCode())) {
            queryWrapper.eq(DgOrderLabelRecordEo::getLabelCode, (Object)orderLabelRecordReqDto.getLabelCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordReqDto.getLabelCodes())) {
            queryWrapper.in(DgOrderLabelRecordEo::getLabelCode, (Collection)orderLabelRecordReqDto.getLabelCodes());
        }
        if (Objects.nonNull(orderLabelRecordReqDto.getOrderId())) {
            queryWrapper.eq(DgOrderLabelRecordEo::getOrderId, (Object)orderLabelRecordReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordReqDto.getOrderIds())) {
            queryWrapper.in(DgOrderLabelRecordEo::getOrderId, (Collection)orderLabelRecordReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(orderLabelRecordEos = this.das.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)orderLabelRecordEos, DgOrderLabelRecordRespDto.class);
        return resultList;
    }

    @Override
    public List<String> queryExistLabelCode(Long orderId, List<DgOrderLabelEnum> orderLabelEnumList) {
        AssertUtils.notNull((Object)orderId, (String)"\u9500\u552e\u8ba2\u5355ID\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull(orderLabelEnumList, (String)"\u6807\u8bc6\u7f16\u7801\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgOrderLabelRecordReqDto orderLabelRecordReqDto = new DgOrderLabelRecordReqDto();
        orderLabelRecordReqDto.setOrderId(orderId);
        orderLabelRecordReqDto.setLabelCodes(orderLabelEnumList.stream().map(DgOrderLabelEnum::getCode).collect(Collectors.toList()));
        List<DgOrderLabelRecordRespDto> orderLabelRecordRespDtos = this.queryByParam(orderLabelRecordReqDto);
        if (CollectionUtils.isEmpty(orderLabelRecordRespDtos)) {
            return null;
        }
        return orderLabelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
    }

    @Override
    public void removeOrderLabelRecordById(Long id) {
        this.das.logicDeleteById(id);
    }

    @Override
    public void removeOrderLabelRecordById(Long orderId, DgOrderLabelEnum reqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelRecordEo record = new DgOrderLabelRecordEo();
        record.setOrderId(orderId);
        record.setLabelCode(reqDto.getCode());
        record.setDisplay(reqDto.getDisplay());
        DgOrderLabelRecordEo orderLabelRecordEo = (DgOrderLabelRecordEo)this.das.selectOne((BaseEo)record);
        if (Objects.isNull(orderLabelRecordEo)) {
            log.warn(String.format("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5\u6807\u8bc6", orderId, reqDto.getCode()));
            return;
        }
        this.das.logicDeleteById(orderLabelRecordEo.getId());
    }
}

