/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constant;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.constant.BdTradeStatusFlow;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusFlowTemplate;
import com.dtyunxi.yundt.cube.center.trade.api.constant.TcTradeStatusFlow;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import java.util.List;
import java.util.Map;

public enum TradeStatusFlowSelector {
    TC("TC"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return TcTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return TcTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    BD("BD"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return BdTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return BdTradeStatusFlow.STATUS_LIST;
        }
    };

    private String code;

    private TradeStatusFlowSelector(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static TradeStatusFlowSelector enumOf(String code) {
        for (TradeStatusFlowSelector typeEnum : TradeStatusFlowSelector.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", code, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    public abstract Map<String, SaleOrderStatusFlowTemplate> getLookup();

    public abstract List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList();
}

