/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtRelationComparisonQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.StandardPriceQueryDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.StandardPriceDetailRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.StandardPriceInfoDetailRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IStandardPriceConfigQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.query.IStandardPriceInfoQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Functions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.warehouse.ILogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseAddressDto;
import com.yunxi.dg.base.center.item.api.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.shop.api.query.IDgShopQueryApi;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.IDgAfterSaleOrderSplitAction;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderFillReturnInfoEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformApplyGoodsReturnTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformApplyOriginOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformApplyRefundTypeEnum;
import com.yunxi.dg.base.center.trade.dao.vo.DgPerformOrderGoodsItemQueryVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderPromotionGiftDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderGoodsItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderGoodsItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderGoodsItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderPromotionGiftRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderOutNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderSplitActionImpl
implements IDgAfterSaleOrderSplitAction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgShopQueryApi shopQueryApi;
    @Resource
    private IDgPerformOrderGoodsItemExtDomain performOrderGoodsItemDomain;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IDgSaleOrderPromotionGiftDomain saleOrderPromotionGiftDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderOutNoticeSyncRecordService performOrderOutNoticeSyncRecordService;
    @Resource
    private ILogicWarehouseApi logicWarehouseApi;
    @Resource
    private IItemSkuDgQueryApi itemSkuDgQueryApi;
    @Resource
    private IItemExtRelationComparisonQueryApi itemExtRelationComparisonQueryApi;
    @Resource
    private IStandardPriceInfoQueryApi iStandardPriceInfoQueryApi;
    @Resource
    private IStandardPriceConfigQueryApi standardPriceConfigQueryApi;
    @Value(value="${oms.afterSale.order.rate.gift:0.9}")
    private double returnGiftRateConfig;
    @Value(value="${oms.afterSale.order.jtk.only:true}")
    private Boolean onlyJtk;
    @Value(value="${oms.afterSale.order.start.time:1669651199000}")
    private Long afterSaleOrderStartTime;
    private String SPLIT_COMMON_PREFIX = "SPLIT_COMMON_PREFIX";
    @Value(value="${oms.afterSale.order.fill.return.info:DEFAULT}")
    private String fillReturnInfo;
    @Value(value="${oms.afterSale.order.split.fill.return.info:DEFAULT}")
    private String splitFillReturnInfo;
    @Value(value="${oms.afterSale.order.default.delivery.logical.warehouseCode:DEFAULT}")
    private String defaultDeliveryLogicalWarehouseCode;
    @Value(value="${oms.afterSale.exclude.match.gift.channels:DEFAULT}")
    private String excludeMatchGiftChannels;
    @Value(value="${oms.afterSale.order.default.platform.apply.goods.return.type:true}")
    private Boolean platformApplyGoodsReturnTypeConfig;
    @Value(value="${oms.afterSale.order.default.divide.after.saleorder.type.proportion.config:0.15}")
    private Double divideAfterSaleOrderTypeProportionConfig;
    @Value(value="${oms.afterSale.order.hh.check.refundAmount:true}")
    private Boolean hhCheckRefundAmount;
    private static final Long RETAIL_PRICE = 1294971374833859588L;
    private final Function<DgPerformOrderItemRespDto, DgPerformOrderItemExtRespDto> orderItemRespDto2SaleOrderItemExtRespDtoFunc = orderItem -> {
        DgPerformOrderItemExtRespDto orderExtItem = new DgPerformOrderItemExtRespDto();
        CubeBeanUtils.copyProperties((Object)orderExtItem, (Object)orderItem, (String[])new String[0]);
        orderExtItem.setRestAfterSaleNum(orderItem.getItemNum().subtract(orderItem.getRefundedItemNum()));
        return orderExtItem;
    };

    @Override
    public RestResponse<List<DgBizAfterSaleOrderReqDto>> splitPlatformAfterSaleOrder(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto) {
        this.logger.info("\u5e73\u53f0\u552e\u540e\u5355\u62c6\u5206\u5165\u53e3, afterSaleOrderReqDto={}", (Object)JacksonUtil.toJson((Object)afterSaleOrderReqDto));
        String platformOrderNo = afterSaleOrderReqDto.getPlatformOrderNo();
        String platformRefundOrderSn = afterSaleOrderReqDto.getPlatformRefundOrderSn();
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() == null && StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getSaleOrderNo())) {
            afterSaleOrderReqDto.setRelateToPlatformOrder(Integer.valueOf(0));
        }
        List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemReqDtoList = afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().stream().filter(item -> item.getAfterSaleOrderItemType() == null || item.getAfterSaleOrderItemType() == 0).collect(Collectors.toList());
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() != null && Objects.equals(afterSaleOrderReqDto.getRelateToPlatformOrder(), 1)) {
            this.fillReturnInfo(afterSaleOrderReqDto);
            return new RestResponse(Collections.singletonList(afterSaleOrderReqDto));
        }
        List platformItemNoList = afterSaleOrderItemReqDtoList.stream().map(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo).distinct().collect(Collectors.toList());
        DgPerformOrderGoodsItemQueryVo performOrderGoodsItemQueryVo = new DgPerformOrderGoodsItemQueryVo();
        performOrderGoodsItemQueryVo.setPlatformOrderItemNos(platformItemNoList);
        performOrderGoodsItemQueryVo.setPlatformOrderNo(platformOrderNo);
        performOrderGoodsItemQueryVo.setGourdByOrderId(true);
        performOrderGoodsItemQueryVo.setGourdPlatformOrderItemNo(true);
        performOrderGoodsItemQueryVo.setGourdByOrderItemId(true);
        List dgPerformGoodsItemRespDtoList = this.performOrderGoodsItemDomain.queryAfterSaleOrderLinkGoodsItems(performOrderGoodsItemQueryVo, null, Integer.valueOf(1000));
        if (dgPerformGoodsItemRespDtoList.size() >= 1000) {
            throw PcpTradeExceptionCode.AFTER_SALE_SPLIT_ORDER_ORDER_LINK_COUNT.buildBizException(new Object[]{platformRefundOrderSn});
        }
        if (dgPerformGoodsItemRespDtoList.isEmpty()) {
            throw PcpTradeExceptionCode.AFTER_SALE_SPLIT_ORDER_ORDER_ITEM_COUNT.buildBizException(new Object[]{platformRefundOrderSn, JacksonUtil.toJson(platformItemNoList)});
        }
        dgPerformGoodsItemRespDtoList = dgPerformGoodsItemRespDtoList.stream().filter(goodsItemDto -> DgSaleOrderItemStatusEnum.NORMAL.getCode().equals(goodsItemDto.getStatus())).collect(Collectors.toList());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dgPerformGoodsItemRespDtoList), (String)"\u672a\u80fd\u5339\u914d\u7b26\u5408\u552e\u540e\u6761\u4ef6\u7684\u9500\u552e\u8ba2\u5355");
        List noAcceptPlatFormNo = dgPerformGoodsItemRespDtoList.stream().map(DgPerformOrderGoodsItemRespDto::getPlatformOrderItemNo).filter(itemNo -> !platformItemNoList.contains(itemNo)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(noAcceptPlatFormNo)) {
            this.logger.error("\u5e73\u53f0\u552e\u540e\u5355\u62c6\u5206\u4ee5\u4e0b\u5546\u54c1\u884c\u5339\u914d\u4e0d\u5230\u53ef\u552e\u540e\u5546\u54c1\u884c:{}", (Object)JSON.toJSONString(noAcceptPlatFormNo));
        }
        List linkDgSaleOrderRespDtoList = this.performOrderDomain.queryListByOrderIds(dgPerformGoodsItemRespDtoList.stream().map(DgPerformOrderGoodsItemRespDto::getOrderId).distinct().collect(Collectors.toList()));
        List saleOrderItemIdList = dgPerformGoodsItemRespDtoList.stream().map(DgPerformOrderGoodsItemRespDto::getOrderItemId).distinct().collect(Collectors.toList());
        List<DgPerformOrderItemRespDto> dgPerformOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderItemIds(saleOrderItemIdList);
        this.logger.info("saleOrderItemRespDtoList: {}", (Object)JacksonUtil.toJson((Object)dgPerformOrderItemRespDtoList));
        dgPerformOrderItemRespDtoList = dgPerformOrderItemRespDtoList.stream().filter(saleOrderItemDto -> DgSaleOrderItemStatusEnum.NORMAL.getCode().equals(saleOrderItemDto.getStatus()) && saleOrderItemDto.getItemNum().subtract(saleOrderItemDto.getRefundedItemNum()).intValue() > 0).collect(Collectors.toList());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dgPerformOrderItemRespDtoList), (String)"\u672a\u80fd\u5339\u914d\u7b26\u5408\u552e\u540e\u6761\u4ef6\u7684\u9500\u552e\u8ba2\u5355");
        Map<Long, List<DgPerformOrderItemRespDto>> saleOrderItemMap = dgPerformOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
        this.splitItems(afterSaleOrderReqDto, afterSaleOrderItemReqDtoList, dgPerformOrderItemRespDtoList);
        List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemList = this.buildAfterSaleOrderItemReqDtoList(afterSaleOrderReqDto, afterSaleOrderItemReqDtoList, dgPerformOrderItemRespDtoList);
        Map<Long, List<DgAfterSaleOrderItemModifyReqDto>> afterSaleOrderItemMap = afterSaleOrderItemList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getSaleOrderId));
        Map<Long, DgPerformOrderRespDto> DgPerformOrderRespDtoMap = linkDgSaleOrderRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, v1 -> v1));
        ArrayList bizAfterSaleOrderReqDtoList = new ArrayList();
        afterSaleOrderItemMap.forEach((orderId, afterItemList) -> {
            DgPerformOrderRespDto dgPerformOrderRespDto = (DgPerformOrderRespDto)DgPerformOrderRespDtoMap.get(orderId);
            List goodsItemRespDtoList = this.performOrderGoodsItemDomain.queryAfterSaleOrderLinkGoodsItems(performOrderGoodsItemQueryVo, null, Integer.valueOf(10000));
            if (goodsItemRespDtoList.size() >= 10000) {
                throw PcpTradeExceptionCode.AFTER_SALE_SPLIT_ORDER_ORDER_LINK_COUNT.buildBizException(new Object[]{platformRefundOrderSn});
            }
            List childSaleOrderItemList = (List)saleOrderItemMap.get(orderId);
            DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
            CubeBeanUtils.copyProperties((Object)bizAfterSaleOrderReqDto, (Object)afterSaleOrderReqDto, (String[])new String[0]);
            bizAfterSaleOrderReqDto.setId(null);
            bizAfterSaleOrderReqDto.setPerformOrderRespDto(dgPerformOrderRespDto);
            bizAfterSaleOrderReqDto.setSaleOrderId(dgPerformOrderRespDto.getId());
            bizAfterSaleOrderReqDto.setSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
            bizAfterSaleOrderReqDto.setOriginalRefundFee(afterSaleOrderReqDto.getRefundFee());
            bizAfterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(afterItemList);
            bizAfterSaleOrderReqDto.setOrderSource(DgSaleOrderSourceEnum.PLATFORM.getType());
            bizAfterSaleOrderReqDto.setPerformOrderItemRespDtoList(childSaleOrderItemList);
            bizAfterSaleOrderReqDto.setOaid(dgPerformOrderRespDto.getOaid());
            List<DgPerformOrderGoodsItemRespDto> tempGoodsItemList = goodsItemRespDtoList.stream().filter(goodsItem -> goodsItem.getOrderId().equals(orderId)).collect(Collectors.toList());
            List<DgAfterSaleOrderGoodsItemReqDto> afterSaleOrderGoodsItemReqDtoList = this.buildAfterSaleOrderGoodsItemReqDtoList(afterSaleOrderReqDto, dgPerformOrderRespDto, tempGoodsItemList, afterSaleOrderItemList);
            bizAfterSaleOrderReqDto.setAfterSaleGoodsItemReqDtoList(afterSaleOrderGoodsItemReqDtoList);
            BigDecimal refundFee = BigDecimal.valueOf(afterItemList.stream().mapToDouble(a -> a.getRefundAmount().doubleValue()).sum());
            bizAfterSaleOrderReqDto.setRefundFee(refundFee);
            bizAfterSaleOrderReqDtoList.add(bizAfterSaleOrderReqDto);
        });
        Map<String, List<DgAfterSaleOrderItemModifyReqDto>> platformOrderItemNoMaps = afterSaleOrderItemList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo));
        List sendItemReqDtoList = afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().stream().filter(item -> item.getAfterSaleOrderItemType() != null && item.getAfterSaleOrderItemType() == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sendItemReqDtoList)) {
            ArrayList<DgAfterSaleOrderItemModifyReqDto> newItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
            sendItemReqDtoList.stream().forEach(e -> {
                List saleOrderItemRespDtos = (List)platformOrderItemNoMaps.get(e.getPlatformOrderItemNo().replace("HH_", ""));
                AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtos), (String)"\u552e\u540e\u6362\u8d27\u53d1\u51fa\u5546\u54c1\u884c\u672a\u80fd\u5339\u914d\u5230\u539f\u5355\u5546\u54c1");
                if (e.getCombineGood() == 1) {
                    List<RItemBundleQueryRespDto> itemBundleQueryRespDtos = this.getGroupGoods((DgAfterSaleOrderItemModifyReqDto)e);
                    if (!CollectionUtils.isNotEmpty(itemBundleQueryRespDtos)) throw new BizException("\u65e0\u6cd5\u5339\u914d\u6362\u8d27\u7ec4\u5408\u5546\u54c1\u5173\u7cfb");
                    itemBundleQueryRespDtos.forEach(itemBundle -> {
                        DgAfterSaleOrderItemModifyReqDto newItem = new DgAfterSaleOrderItemModifyReqDto();
                        CubeBeanUtils.copyProperties((Object)newItem, (Object)e, (String[])new String[0]);
                        newItem.setItemName(itemBundle.getSubItemName());
                        newItem.setItemId(itemBundle.getSubItemId());
                        newItem.setItemCode(itemBundle.getSubItemCode());
                        newItem.setSkuId(itemBundle.getSubSkuId());
                        newItem.setSkuCode(itemBundle.getSubItemCode());
                        newItem.setSkuName(itemBundle.getSubItemName());
                        newItem.setItemNum(itemBundle.getNum());
                        newItem.setItemPrice(itemBundle.getUnitPrice());
                        newItem.setRefundAmount(null);
                        newItemReqDtoList.add(newItem);
                    });
                    return;
                } else {
                    e.setRefundAmount(null);
                    this.getPrice(e.getSkuCode(), (DgAfterSaleOrderItemModifyReqDto)e);
                    AssertUtils.notNull((Object)e.getItemPrice(), (String)String.format("\u5546\u54c1[%s]\u5355\u4ef7\u4e0d\u5141\u8bb8\u4e3a\u7a7a", e.getSkuCode()));
                    newItemReqDtoList.add((DgAfterSaleOrderItemModifyReqDto)e);
                }
            });
            this.splitSendItemsAmount(afterSaleOrderItemList, newItemReqDtoList);
            this.logger.info("\u6362\u8d27\u6362\u51fa\u5546\u54c1, newItemReqDtoList={}", (Object)JacksonUtil.toJson(newItemReqDtoList));
            ((DgBizAfterSaleOrderReqDto)bizAfterSaleOrderReqDtoList.get(0)).getAfterSaleOrderItemReqDtoList().addAll(newItemReqDtoList);
        }
        this.logger.info("\u5e73\u53f0\u552e\u540e\u5355\u5339\u914d\u5230\u8ba2\u5355\u96c6\u5408\u7ed3\u679c, platformRefundOrderSn: {}, orderNoList={}", (Object)platformRefundOrderSn, (Object)JacksonUtil.toJson(bizAfterSaleOrderReqDtoList));
        if (bizAfterSaleOrderReqDtoList.isEmpty()) {
            throw new BizException("-1", "\u552e\u540e\u5546\u54c1\u884c\u5339\u914d\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u53ef\u552e\u540e\u8ba2\u5355\u4fe1\u606f");
        }
        return new RestResponse(bizAfterSaleOrderReqDtoList);
    }

    private void splitSendItemsAmount(List<DgAfterSaleOrderItemModifyReqDto> saleOrderItemRespDtos, List<DgAfterSaleOrderItemModifyReqDto> sendItemReqDtos) {
        BigDecimal afterSaleOrderItemExchangeRealPayAmount;
        BigDecimal afterSaleOrderItemRealPayAmount;
        sendItemReqDtos.forEach(e -> {
            e.setRealPayAmount(null);
            e.setOrigPayAmount(null);
            e.setRefundAmount(null);
        });
        this.logger.info("splitSendItemsAmount-saleOrderItemRespDtos:{}", (Object)JSON.toJSONString(saleOrderItemRespDtos));
        this.logger.info("splitSendItemsAmount-sendItemReqDtos:{}", (Object)JSON.toJSONString(sendItemReqDtos));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(saleOrderItemRespDtos), (String)"\u9000\u8d27\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(sendItemReqDtos), (String)"\u9000\u8d27\u53d1\u51fa\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, List<DgAfterSaleOrderItemModifyReqDto>> saleOrderItemMaps = saleOrderItemRespDtos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo));
        Map<String, List<DgAfterSaleOrderItemModifyReqDto>> sendItemMaps = sendItemReqDtos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo));
        sendItemMaps.forEach((platformOrderItemNo, afterItems) -> {
            List saleOrderItemList = (List)saleOrderItemMaps.get(platformOrderItemNo);
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)saleOrderItemList), (String)String.format("\u6362\u8d27\u53d1\u51fa\u5546\u54c1[%s]\u65e0\u6cd5\u5173\u8054\u5546\u54c1\u884c", platformOrderItemNo));
            if (saleOrderItemList.size() == afterItems.size()) {
                for (int i = 0; i < afterItems.size(); ++i) {
                    DgAfterSaleOrderItemModifyReqDto newItem = (DgAfterSaleOrderItemModifyReqDto)afterItems.get(i);
                    DgAfterSaleOrderItemModifyReqDto saleOrderItem = (DgAfterSaleOrderItemModifyReqDto)saleOrderItemList.get(i);
                    newItem.setGift(saleOrderItem.getGift());
                    newItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    newItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
                    newItem.setOrigItemNum(saleOrderItem.getOrigItemNum());
                    newItem.setItemPrice(saleOrderItem.getItemPrice());
                    newItem.setPlatformRefundAmount(saleOrderItem.getPlatformRefundAmount());
                }
            }
            BigDecimal realPayAmountSum = saleOrderItemList.stream().map(DgAfterSaleOrderItemReqDto::getRealPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal origPayAmountSum = saleOrderItemList.stream().map(DgAfterSaleOrderItemReqDto::getOrigPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundAmountSum = saleOrderItemList.stream().map(DgAfterSaleOrderItemReqDto::getRefundAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (int i = 0; i < afterItems.size(); ++i) {
                DgAfterSaleOrderItemModifyReqDto itemModifyReqDto = (DgAfterSaleOrderItemModifyReqDto)afterItems.get(i);
                if (afterItems.size() - 1 != i) {
                    Integer sumNum = afterItems.stream().map(DgAfterSaleOrderItemReqDto::getItemNum).reduce(Integer::sum).orElse(0);
                    AssertUtils.isTrue((sumNum != 0 ? 1 : 0) != 0, (String)"\u4e0d\u5141\u8bb8\u6362\u8d27\u53d1\u51fa\u5546\u54c1\u6570\u91cf\u4e3a0");
                    itemModifyReqDto.setRealPayAmount(realPayAmountSum.divide(BigDecimal.valueOf(sumNum.intValue()), 2, 4));
                    itemModifyReqDto.setOrigPayAmount(origPayAmountSum.divide(BigDecimal.valueOf(sumNum.intValue()), 2, 4));
                    itemModifyReqDto.setRefundAmount(refundAmountSum.divide(BigDecimal.valueOf(sumNum.intValue()), 2, 4));
                    continue;
                }
                itemModifyReqDto.setRealPayAmount(realPayAmountSum.subtract(afterItems.stream().map(DgAfterSaleOrderItemReqDto::getRealPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).setScale(2, 4));
                itemModifyReqDto.setOrigPayAmount(origPayAmountSum.subtract(afterItems.stream().map(DgAfterSaleOrderItemReqDto::getOrigPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).setScale(2, 4));
                itemModifyReqDto.setRefundAmount(refundAmountSum.subtract(afterItems.stream().map(DgAfterSaleOrderItemReqDto::getRefundAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).setScale(2, 4));
            }
        });
        this.logger.info("splitSendItemsAmount-\u5206\u644a\u540e-saleOrderItemRespDtos:{}", (Object)JSON.toJSONString(saleOrderItemRespDtos));
        this.logger.info("splitSendItemsAmount-\u5206\u644a\u540e-sendItemReqDtos:{}", (Object)JSON.toJSONString(sendItemReqDtos));
        if (this.hhCheckRefundAmount.booleanValue() && (afterSaleOrderItemRealPayAmount = saleOrderItemRespDtos.stream().map(DgAfterSaleOrderItemReqDto::getRealPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(afterSaleOrderItemExchangeRealPayAmount = sendItemReqDtos.stream().map(DgAfterSaleOrderItemReqDto::getRealPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
            throw new BizException("-1", String.format("\u552e\u540e\u5546\u54c1\u884c\u6362\u8d27\u53d1\u51fa\u91d1\u989d\u4e0d\u4e00\u81f4,\u6536:%s,\u53d1:%s", afterSaleOrderItemRealPayAmount, afterSaleOrderItemExchangeRealPayAmount));
        }
    }

    private List<RItemBundleQueryRespDto> getGroupGoods(DgAfterSaleOrderItemModifyReqDto afterSaleItem) {
        if (Objects.isNull(afterSaleItem.getCombineGood()) || afterSaleItem.getCombineGood() == 0) {
            this.logger.info("\u975e\u7ec4\u5408\u5546\u54c1");
            return null;
        }
        List itemBundleList = (List)RestResponseHelper.extractData((RestResponse)this.itemExtRelationComparisonQueryApi.queryRItemBundleBySkuCodes(Arrays.asList(afterSaleItem.getSkuCode())));
        if (CollectionUtils.isEmpty((Collection)itemBundleList)) {
            this.logger.info("\u5546\u54c1\u884c\uff1a{} \u5339\u914d\u65e0\u7ec4\u5408\u5546\u54c1", (Object)afterSaleItem.getSkuCode());
            return null;
        }
        return itemBundleList;
    }

    private void splitItems(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto, List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemList, List<DgPerformOrderItemRespDto> saleOrderItemList) {
        this.logger.info("splitItems afterSaleOrderReqDto:{}", (Object)JSON.toJSONString((Object)afterSaleOrderReqDto));
        this.logger.info("splitItems afterSaleOrderItemList:{}", (Object)JSON.toJSONString(afterSaleOrderItemList));
        this.logger.info("splitItems saleOrderItemList:{}", (Object)JSON.toJSONString(saleOrderItemList));
        Boolean isHH = afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().stream().anyMatch(item -> Objects.nonNull(item.getAfterSaleOrderItemType()) && item.getAfterSaleOrderItemType() == 1);
        List platformOrderItemNos = afterSaleOrderItemList.stream().map(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo).collect(Collectors.toList());
        List saleOrderItems = saleOrderItemList.stream().filter(item -> platformOrderItemNos.contains(item.getPlatformOrderItemNo())).collect(Collectors.toList());
        Map<String, List<DgPerformOrderItemRespDto>> saleOrderItemMaps = saleOrderItems.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getPlatformOrderItemNo));
        BigDecimal saleOrderItemAmountSum = saleOrderItemList.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashBasedTable saleOrderItemAmountTable = HashBasedTable.create();
        for (DgPerformOrderItemRespDto saleOrderItem : saleOrderItemList) {
            BigDecimal plusPayAmount;
            String groupSkuCode = saleOrderItem.getGroupSkuCode();
            BigDecimal payAmount = saleOrderItem.getPayAmount();
            String skuCode = saleOrderItem.getMainSkuCode();
            if (Objects.isNull(groupSkuCode)) {
                groupSkuCode = this.SPLIT_COMMON_PREFIX;
            }
            if (Objects.isNull(plusPayAmount = (BigDecimal)saleOrderItemAmountTable.get((Object)groupSkuCode, (Object)skuCode))) {
                saleOrderItemAmountTable.put((Object)groupSkuCode, (Object)skuCode, (Object)payAmount);
                continue;
            }
            saleOrderItemAmountTable.put((Object)groupSkuCode, (Object)skuCode, (Object)plusPayAmount.add(payAmount));
        }
        this.logger.info("saleOrderItemAmountTable: {}", (Object)JacksonUtil.toJson((Object)saleOrderItemAmountTable));
        ArrayList<DgAfterSaleOrderItemModifyReqDto> splitAfterItemList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        Map<String, List<DgAfterSaleOrderItemModifyReqDto>> afterSaleOrderItemNoMaps = afterSaleOrderItemList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo));
        Iterator<DgAfterSaleOrderItemModifyReqDto> iterator = afterSaleOrderItemList.iterator();
        while (iterator.hasNext()) {
            DgAfterSaleOrderItemModifyReqDto afterSaleOrderItem = iterator.next();
            BigDecimal itemNum = BigDecimal.valueOf(afterSaleOrderItem.getItemNum().intValue());
            String skuCode = afterSaleOrderItem.getSkuCode();
            String platformOrderItemNo = afterSaleOrderItem.getPlatformOrderItemNo();
            if (!saleOrderItemMaps.containsKey(platformOrderItemNo)) {
                throw new BizException(String.format("\u539f\u5355\u4e0d\u5b58\u5728\u8be5\u7ec4\u5408\u5546\u54c1-itemName:%s,skuCode:%s", afterSaleOrderItem.getItemName(), skuCode));
            }
            List<DgPerformOrderItemRespDto> saleOrderSubItemList = Optional.ofNullable(saleOrderItemMaps.get(platformOrderItemNo)).orElse(Lists.newArrayList());
            Integer itemNumSum = Optional.ofNullable(afterSaleOrderItemNoMaps.get(platformOrderItemNo)).orElse(Lists.newArrayList()).stream().mapToInt(DgAfterSaleOrderItemReqDto::getItemNum).sum();
            for (DgPerformOrderItemRespDto subItem : saleOrderSubItemList) {
                if (!StringUtils.equals((CharSequence)subItem.getStatus(), (CharSequence)DgSaleOrderItemStatusEnum.NORMAL.getCode()) || Objects.isNull(subItem.getGroupSkuCode()) && StringUtils.equals((CharSequence)subItem.getPerformOrderItemExtensionDto().getReplaceDifferentFlag(), (CharSequence)"0") && subItem.getGift() == 1) continue;
                DgAfterSaleOrderItemModifyReqDto splitItem = new DgAfterSaleOrderItemModifyReqDto();
                CubeBeanUtils.copyProperties((Object)splitItem, (Object)afterSaleOrderItem, (String[])new String[]{"subItemList"});
                if (Objects.nonNull(subItem)) {
                    splitItem.setItemName(subItem.getItemName());
                    splitItem.setItemId(subItem.getItemId());
                    splitItem.setItemCode(subItem.getItemCode());
                    splitItem.setSkuId(subItem.getSkuId());
                    splitItem.setSkuCode(subItem.getSkuCode());
                    splitItem.setSkuName(subItem.getSkuName());
                    splitItem.setSaleOrderId(subItem.getOrderId());
                    splitItem.setSaleOrderItemId(subItem.getId());
                    splitItem.setRealPayAmount(subItem.getRealPayAmount());
                    splitItem.setOrigPayAmount(subItem.getPayAmount());
                    splitItem.setItemPrice(subItem.getSalePrice());
                    splitItem.setSupplyPrice(subItem.getSupplyPrice());
                    splitItem.setSplitItemNum(itemNumSum);
                    splitItem.setPayAmount(subItem.getPayAmount());
                    splitItem.setOrigRealPayAmount(subItem.getRealPayAmount());
                }
                BigDecimal refundableNum = subItem.getItemNum().subtract(subItem.getRefundedItemNum());
                Double saleOrderTotalPayAmount = null;
                if (Objects.nonNull(subItem.getGroupSkuCode())) {
                    saleOrderTotalPayAmount = saleOrderItemAmountTable.row((Object)subItem.getGroupSkuCode()).values().stream().mapToDouble(BigDecimal::doubleValue).sum();
                } else {
                    BigDecimal plusPayAmount = (BigDecimal)saleOrderItemAmountTable.row((Object)this.SPLIT_COMMON_PREFIX).get(skuCode);
                    AssertUtils.notNull((Object)plusPayAmount, (String)String.format("\u539f\u5355\u5546\u54c1\u884c%s\u91d1\u989d\u4e0d\u5b58\u5728", skuCode));
                    saleOrderTotalPayAmount = plusPayAmount.doubleValue();
                }
                Boolean needSplitRefundAmount = false;
                if (StringUtils.equals((CharSequence)subItem.getPerformOrderItemExtensionDto().getReplaceDifferentFlag(), (CharSequence)"1")) {
                    if (isHH.booleanValue()) {
                        throw new BizException("\u66ff\u6362\u8865\u5dee\u4e0d\u5141\u8bb8\u7533\u8bf7\u6362\u8d27\uff01");
                    }
                    splitItem.setItemNum(Integer.valueOf(refundableNum.intValue()));
                    needSplitRefundAmount = true;
                } else if (StringUtils.isNotEmpty((CharSequence)subItem.getGroupSkuCode()) || StringUtils.equals((CharSequence)afterSaleOrderReqDto.getAfterSaleOrderType(), (CharSequence)PlatformApplyRefundTypeEnum.REFUND_ONLY.getCode())) {
                    splitItem.setItemNum(Integer.valueOf(subItem.getItemNum().intValue()));
                    needSplitRefundAmount = true;
                } else {
                    if (itemNum.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal num = itemNum.subtract(subItem.getItemNum());
                    if (num.compareTo(BigDecimal.ZERO) > -1) {
                        itemNum = num;
                        splitItem.setItemNum(Integer.valueOf(subItem.getItemNum().intValue()));
                        splitItem.setOrigRefundAmount(splitItem.getRefundAmount());
                    } else {
                        splitItem.setItemNum(Integer.valueOf(itemNum.intValue()));
                        itemNum = BigDecimal.ZERO;
                        splitItem.setOrigRefundAmount(splitItem.getRefundAmount());
                    }
                }
                if (needSplitRefundAmount.booleanValue()) {
                    this.logger.info("\u9000\u6b3e\u91d1\u989d\u8ba1\u7b97:[{}-{}:{}]=(({}/{})*({}/{}))*{}", new Object[]{subItem.getItemName(), subItem.getMainSkuCode(), splitItem.getItemNum(), subItem.getPayAmount(), saleOrderTotalPayAmount, saleOrderTotalPayAmount, saleOrderItemAmountSum, afterSaleOrderReqDto.getRefundFee()});
                    BigDecimal refundAmount = BigDecimal.ZERO;
                    if ((Objects.isNull(subItem.getGift()) || subItem.getGift() == 0) && Objects.nonNull(subItem.getPayAmount()) && subItem.getPayAmount().compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal subGroupProp = BigDecimal.ZERO;
                        if (BigDecimal.valueOf(saleOrderTotalPayAmount).compareTo(BigDecimal.ZERO) != 0) {
                            subGroupProp = subItem.getPayAmount().divide(BigDecimal.valueOf(saleOrderTotalPayAmount), 10, 4);
                        }
                        BigDecimal groupProp = BigDecimal.ZERO;
                        if (saleOrderItemAmountSum.compareTo(BigDecimal.ZERO) != 0) {
                            groupProp = BigDecimal.valueOf(saleOrderTotalPayAmount).divide(saleOrderItemAmountSum, 10, 4);
                        }
                        refundAmount = subGroupProp.multiply(groupProp).multiply(afterSaleOrderReqDto.getRefundFee()).setScale(2, 4);
                    }
                    splitItem.setRefundAmount(refundAmount);
                    splitItem.setOrigRefundAmount(refundAmount);
                }
                splitAfterItemList.add(splitItem);
            }
            iterator.remove();
        }
        this.logger.info("splitAfterItemList: {}", (Object)JacksonUtil.toJson(splitAfterItemList));
        if (CollectionUtils.isNotEmpty(splitAfterItemList)) {
            afterSaleOrderItemList.addAll(splitAfterItemList);
        }
    }

    private void splitGroupItems(List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemList, List<DgPerformOrderItemRespDto> saleOrderItemList) {
        boolean hasGroupItem = saleOrderItemList.stream().anyMatch(saleOrderItem -> StringUtils.isNotEmpty((CharSequence)saleOrderItem.getGroupSkuCode()));
        if (!hasGroupItem) {
            return;
        }
        hasGroupItem = afterSaleOrderItemList.stream().anyMatch(afterSaleOrderItem -> afterSaleOrderItem.getCombineGood() != null && afterSaleOrderItem.getCombineGood() == 1);
        if (!hasGroupItem) {
            return;
        }
        HashBasedTable saleOrderGroupItemAmountTable = HashBasedTable.create();
        for (DgPerformOrderItemRespDto dgPerformOrderItemRespDto : saleOrderItemList) {
            String groupSkuCode = dgPerformOrderItemRespDto.getGroupSkuCode();
            if (StringUtils.isEmpty((CharSequence)groupSkuCode)) continue;
            String skuCode = dgPerformOrderItemRespDto.getMainSkuCode();
            BigDecimal payAmount = dgPerformOrderItemRespDto.getPayAmount();
            if (!saleOrderGroupItemAmountTable.containsRow((Object)groupSkuCode)) {
                saleOrderGroupItemAmountTable.put((Object)groupSkuCode, (Object)skuCode, (Object)payAmount);
                continue;
            }
            if (!saleOrderGroupItemAmountTable.containsColumn((Object)skuCode)) {
                saleOrderGroupItemAmountTable.put((Object)groupSkuCode, (Object)skuCode, (Object)payAmount);
                continue;
            }
            BigDecimal plusPayAmount = (BigDecimal)saleOrderGroupItemAmountTable.get((Object)groupSkuCode, (Object)skuCode);
            if (Objects.isNull(plusPayAmount)) {
                saleOrderGroupItemAmountTable.put((Object)groupSkuCode, (Object)skuCode, (Object)payAmount);
                continue;
            }
            saleOrderGroupItemAmountTable.put((Object)groupSkuCode, (Object)skuCode, (Object)plusPayAmount.add(payAmount));
        }
        this.logger.info("saleOrderGroupItemAmountTable: {}", (Object)JacksonUtil.toJson((Object)saleOrderGroupItemAmountTable));
        HashMap<String, BigDecimal> afterSaleOrderGroupItemRefundFeeTable = new HashMap<String, BigDecimal>();
        for (DgAfterSaleOrderItemModifyReqDto afterSaleOrderItem2 : afterSaleOrderItemList) {
            if (afterSaleOrderItem2.getCombineGood() == null || afterSaleOrderItem2.getCombineGood() == 0) continue;
            afterSaleOrderGroupItemRefundFeeTable.put(afterSaleOrderItem2.getSkuCode(), afterSaleOrderItem2.getRefundAmount());
        }
        this.logger.info("afterSaleOrderGroupItemRefundFeeTable: {}", (Object)JacksonUtil.toJson(afterSaleOrderGroupItemRefundFeeTable));
        ArrayList<DgAfterSaleOrderItemModifyReqDto> arrayList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        Iterator<DgAfterSaleOrderItemModifyReqDto> iterator = afterSaleOrderItemList.iterator();
        while (iterator.hasNext()) {
            DgAfterSaleOrderItemModifyReqDto afterSaleOrderItem3 = iterator.next();
            if (afterSaleOrderItem3.getCombineGood() == null || afterSaleOrderItem3.getCombineGood() == 0 || CollectionUtils.isEmpty((Collection)afterSaleOrderItem3.getSubItemList())) continue;
            String groupSkuCode = afterSaleOrderItem3.getSkuCode();
            List subItemList = afterSaleOrderItem3.getSubItemList();
            int itemNumber = afterSaleOrderItem3.getItemNum();
            for (DgAfterSaleOrderItemModifyReqDto subItem : subItemList) {
                DgAfterSaleOrderItemModifyReqDto splitItem = new DgAfterSaleOrderItemModifyReqDto();
                CubeBeanUtils.copyProperties((Object)splitItem, (Object)afterSaleOrderItem3, (String[])new String[]{"subItemList"});
                CubeBeanUtils.copyProperties((Object)splitItem, (Object)subItem, (String[])new String[]{"subItemList"});
                splitItem.setItemNum(Integer.valueOf(itemNumber * subItem.getItemNum()));
                splitItem.setOrigItemNum(splitItem.getItemNum());
                Map rowMap = saleOrderGroupItemAmountTable.row((Object)groupSkuCode);
                AssertUtils.notNull((Object)rowMap, (String)String.format("\u552e\u540e\u5355\u6ca1\u6709\u5339\u914d\u5230\u9002\u5408\u7684\u7ec4\u5408\u5546\u54c1, afterSaleOrderItem: %s", JacksonUtil.toJson((Object)afterSaleOrderItem3)));
                BigDecimal groupRefundFee = (BigDecimal)afterSaleOrderGroupItemRefundFeeTable.get(groupSkuCode);
                double saleOrderGroupTotalPayAmount = rowMap.values().stream().mapToDouble(BigDecimal::doubleValue).sum();
                if (saleOrderGroupTotalPayAmount == 0.0) continue;
                BigDecimal saleOrderGroupItemPayAmount = (BigDecimal)saleOrderGroupItemAmountTable.get((Object)groupSkuCode, (Object)subItem.getSkuCode());
                AssertUtils.notNull((Object)rowMap, (String)String.format("\u552e\u540e\u5355\u6ca1\u6709\u5339\u914d\u5230\u9002\u5408\u7684\u7ec4\u5408\u5546\u54c1item, afterSaleOrderItem: %s", JacksonUtil.toJson((Object)afterSaleOrderItem3)));
                splitItem.setRefundAmount(saleOrderGroupItemPayAmount.divide(BigDecimal.valueOf(saleOrderGroupTotalPayAmount), RoundingMode.HALF_UP).multiply(groupRefundFee));
                splitItem.setOrigRefundAmount(afterSaleOrderItem3.getRefundAmount());
                arrayList.add(splitItem);
            }
            iterator.remove();
        }
        this.logger.info("splitAfterItemList: {}", (Object)JacksonUtil.toJson(arrayList));
        if (CollectionUtils.isNotEmpty(arrayList)) {
            afterSaleOrderItemList.addAll(arrayList);
        }
    }

    public List<DgAfterSaleOrderItemModifyReqDto> buildAfterSaleOrderItemReqDtoList(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto, List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemList, List<DgPerformOrderItemRespDto> saleOrderItemList) {
        this.logger.info("platformOrderNo: {}, platformRefundOrderSn: {} \u62c6\u5206\u552e\u540e\u5355\u660e\u7ec6: {}", new Object[]{afterSaleOrderReqDto.getPlatformOrderNo(), afterSaleOrderReqDto.getPlatformRefundOrderSn(), JacksonUtil.toJson(afterSaleOrderItemList)});
        this.logger.info("platformOrderNo: {}, platformRefundOrderSn: {} \u62c6\u5206\u5bf9\u5e94\u8ba2\u5355\u660e\u7ec6: {}", new Object[]{afterSaleOrderReqDto.getPlatformOrderNo(), afterSaleOrderReqDto.getPlatformRefundOrderSn(), JacksonUtil.toJson(saleOrderItemList)});
        List<DgAfterSaleOrderItemModifyReqDto> saveList = StringUtils.equals((CharSequence)afterSaleOrderReqDto.getAfterSaleOrderType(), (CharSequence)PlatformApplyRefundTypeEnum.REFUND_ONLY.getCode()) ? afterSaleOrderItemList : this.splitReturnItem(afterSaleOrderItemList, saleOrderItemList);
        BigDecimal refundFee = afterSaleOrderReqDto.getRefundFee();
        if (saveList.size() > 1) {
            double totalFee = saveList.stream().mapToDouble(afterSaleItem -> afterSaleItem.getRefundAmount().doubleValue()).sum();
            if (totalFee == 0.0) {
                this.logger.info("saveList: {}", (Object)JacksonUtil.toJson(saveList));
                return saveList;
            }
            DgAfterSaleOrderItemModifyReqDto lastDto = saveList.get(saveList.size() - 1);
            lastDto.setRefundAmount(lastDto.getRefundAmount().add(refundFee.subtract(BigDecimal.valueOf(totalFee))));
        }
        this.logger.info("saveList: {}", (Object)JacksonUtil.toJson(saveList));
        return saveList;
    }

    private List<DgAfterSaleOrderItemModifyReqDto> splitRefundOnlyItem(List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemList, List<DgPerformOrderItemRespDto> saleOrderItemList) {
        ArrayList<DgAfterSaleOrderItemModifyReqDto> saveList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        Map<String, List<DgPerformOrderItemRespDto>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getPlatformOrderItemNo));
        this.logger.info("saleOrderItemMap: {}", (Object)JacksonUtil.toJson(saleOrderItemMap));
        for (DgAfterSaleOrderItemModifyReqDto afterSaleOrderItem : afterSaleOrderItemList) {
            String oid = afterSaleOrderItem.getPlatformOrderItemNo();
            List<DgPerformOrderItemRespDto> childSaleOrderItemList = saleOrderItemMap.get(oid);
            if (!CollectionUtils.isNotEmpty(childSaleOrderItemList)) continue;
            double totalPayAmount = childSaleOrderItemList.stream().mapToDouble(saleItem -> saleItem.getPayAmount().doubleValue()).sum();
            for (DgPerformOrderItemRespDto saleOrderItem : childSaleOrderItemList) {
                if (StringUtils.isNotBlank((CharSequence)saleOrderItem.getGroupSkuCode()) && !StringUtils.equals((CharSequence)afterSaleOrderItem.getSkuCode(), (CharSequence)saleOrderItem.getMainSkuCode())) {
                    this.logger.info("\u7533\u8bf7\u7684\u5546\u54c1\u884cskuCode\u4e0d\u5339\u914d{},{}", (Object)afterSaleOrderItem.getSkuCode(), (Object)saleOrderItem.getMainSkuCode());
                    continue;
                }
                DgAfterSaleOrderItemModifyReqDto saveAfterItem = new DgAfterSaleOrderItemModifyReqDto();
                CubeBeanUtils.copyProperties((Object)saveAfterItem, (Object)afterSaleOrderItem, (String[])new String[0]);
                saveAfterItem.setItemNum(Integer.valueOf(saleOrderItem.getItemNum().intValue()));
                saveAfterItem.setSaleOrderId(saleOrderItem.getOrderId());
                saveAfterItem.setSaleOrderItemId(saleOrderItem.getId());
                if (totalPayAmount > 0.0) {
                    BigDecimal refundAmount = saleOrderItem.getPayAmount().divide(BigDecimal.valueOf(totalPayAmount), RoundingMode.HALF_UP).multiply(afterSaleOrderItem.getOrigRefundAmount());
                    saveAfterItem.setRefundAmount(refundAmount);
                    saveAfterItem.setRealPayAmount(afterSaleOrderItem.getRealPayAmount());
                    saveAfterItem.setItemPrice(refundAmount.divide(BigDecimal.valueOf(saveAfterItem.getItemNum().intValue()), RoundingMode.HALF_UP));
                } else {
                    saveAfterItem.setRefundAmount(BigDecimal.ZERO);
                    saveAfterItem.setItemPrice(BigDecimal.ZERO);
                    saveAfterItem.setRealPayAmount(BigDecimal.ZERO);
                }
                saveList.add(saveAfterItem);
            }
        }
        return saveList;
    }

    private List<DgAfterSaleOrderItemModifyReqDto> splitReturnItem(List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemList, List<DgPerformOrderItemRespDto> saleOrderItemList) {
        ArrayList<DgAfterSaleOrderItemModifyReqDto> saveList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        Map<String, List<DgPerformOrderItemExtRespDto>> saleOrderItemMap = saleOrderItemList.stream().map(this.orderItemRespDto2SaleOrderItemExtRespDtoFunc).collect(Collectors.groupingBy(DgPerformOrderItemDto::getPlatformOrderItemNo));
        this.logger.info("saleOrderItemMap: {}", (Object)JacksonUtil.toJson(saleOrderItemMap));
        for (DgAfterSaleOrderItemModifyReqDto afterSaleOrderItem : afterSaleOrderItemList) {
            while (afterSaleOrderItem.getItemNum() > 0) {
                this.logger.info("\u62c6\u5206\u5546\u54c1-platformOrderItemNo:{},itemNum:{}", (Object)afterSaleOrderItem.getPlatformOrderItemNo(), (Object)afterSaleOrderItem.getItemNum());
                List<DgPerformOrderItemExtRespDto> orderItemList = saleOrderItemMap.get(afterSaleOrderItem.getPlatformOrderItemNo());
                if (CollectionUtils.isNotEmpty(orderItemList)) {
                    saveList.add(this.split(afterSaleOrderItem, orderItemList));
                    continue;
                }
                throw new BizException(String.format("\u62c6\u5355\u5546\u54c1\u884c\u6570\u91cf\u6263\u51cf\u4e0d\u8db3,\u5546\u54c1\u884c\u7f16\u7801:%s,\u7f3a\u5c11\u6570\u91cf:%s", afterSaleOrderItem.getPlatformOrderItemNo(), afterSaleOrderItem.getItemNum()));
            }
        }
        return saveList;
    }

    private DgAfterSaleOrderItemModifyReqDto split(DgAfterSaleOrderItemModifyReqDto afterItem, List<DgPerformOrderItemExtRespDto> orderItemExtList) {
        int totalRefundNum = orderItemExtList.stream().mapToInt(orderItem -> {
            orderItem.setRestAfterSaleNum(orderItem.getItemNum().subtract(orderItem.getRefundedItemNum()));
            return orderItem.getRestAfterSaleNum().intValue();
        }).sum();
        if (totalRefundNum < afterItem.getItemNum()) {
            throw new BizException(String.format("(%s)sku: %s \u5546\u54c1\u53ef\u552e\u540e\u6570\u91cf\u4e0d\u8db3, \u7533\u8bf7\u552e\u540e\u6570\u91cf: %s, \u53ef\u552e\u540e\u6570\u91cf: %s", afterItem.getPlatformRefundOrderNo(), afterItem.getSkuCode(), afterItem.getItemNum(), totalRefundNum));
        }
        DgPerformOrderItemExtRespDto tradeItem = null;
        orderItemExtList.sort(Comparator.comparing(DgPerformOrderItemExtRespDto::getRestAfterSaleNum).reversed());
        int afterItemNum = afterItem.getItemNum();
        DgAfterSaleOrderItemModifyReqDto saveAfterItem = new DgAfterSaleOrderItemModifyReqDto();
        if (afterItemNum > orderItemExtList.get(0).getRestAfterSaleNum().intValue()) {
            tradeItem = orderItemExtList.get(0);
            BeanUtils.copyProperties((Object)afterItem, (Object)saveAfterItem);
            saveAfterItem.setItemNum(Integer.valueOf(tradeItem.getRestAfterSaleNum().intValue()));
            saveAfterItem.setSaleOrderItemId(tradeItem.getId());
            saveAfterItem.setSaleOrderId(tradeItem.getOrderId());
            orderItemExtList.remove(0);
            afterItem.setItemNum(Integer.valueOf(afterItem.getItemNum() - saveAfterItem.getItemNum()));
        } else if (afterItemNum < orderItemExtList.get(orderItemExtList.size() - 1).getRestAfterSaleNum().intValue()) {
            tradeItem = orderItemExtList.get(orderItemExtList.size() - 1);
            BeanUtils.copyProperties((Object)afterItem, (Object)saveAfterItem);
            saveAfterItem.setSaleOrderItemId(tradeItem.getId());
            saveAfterItem.setSaleOrderId(tradeItem.getOrderId());
            tradeItem.setRestAfterSaleNum(tradeItem.getRestAfterSaleNum().subtract(BigDecimal.valueOf(afterItem.getItemNum().intValue())));
            afterItem.setItemNum(Integer.valueOf(0));
        } else {
            int removeIndex = -1;
            int diff = 10000;
            int diffIndex = -1;
            for (int i = 0; i < orderItemExtList.size(); ++i) {
                DgPerformOrderItemExtRespDto tradeItemCompare = orderItemExtList.get(i);
                int tradeItemNum = tradeItemCompare.getRestAfterSaleNum().intValue();
                if (afterItemNum == tradeItemNum) {
                    removeIndex = i;
                    break;
                }
                if (afterItemNum >= tradeItemNum) continue;
                int tempDiff = tradeItemNum - afterItemNum;
                diffIndex = diff > tempDiff ? i : diffIndex;
                diff = Math.min(diff, tempDiff);
            }
            if (removeIndex == -1) {
                tradeItem = orderItemExtList.get(diffIndex);
                tradeItem.setRestAfterSaleNum(tradeItem.getRestAfterSaleNum().subtract(BigDecimal.valueOf(diff)));
                BeanUtils.copyProperties((Object)afterItem, (Object)saveAfterItem);
                saveAfterItem.setItemNum(Integer.valueOf(diff));
                saveAfterItem.setSaleOrderItemId(tradeItem.getId());
                saveAfterItem.setSaleOrderId(tradeItem.getOrderId());
                afterItem.setItemNum(Integer.valueOf(tradeItem.getRestAfterSaleNum().intValue()));
            } else {
                BeanUtils.copyProperties((Object)afterItem, (Object)saveAfterItem);
                tradeItem = orderItemExtList.get(removeIndex);
                saveAfterItem.setSaleOrderItemId(tradeItem.getId());
                saveAfterItem.setSaleOrderId(tradeItem.getOrderId());
                orderItemExtList.remove(removeIndex);
                afterItem.setItemNum(Integer.valueOf(0));
            }
        }
        BigDecimal refundAmount = BigDecimal.valueOf(saveAfterItem.getItemNum().doubleValue()).divide(BigDecimal.valueOf(afterItem.getSplitItemNum().doubleValue()), 6, RoundingMode.HALF_UP).multiply(afterItem.getOrigRefundAmount()).setScale(2, RoundingMode.HALF_UP);
        this.logger.info("\u552e\u540e\u9000\u6b3e\u91d1\u989d\u5206\u644a,itemNum:{},splitItemNum:{},origRefundAmount:{},refundAmount:{}", new Object[]{saveAfterItem.getItemNum(), afterItem.getSplitItemNum(), afterItem.getOrigRefundAmount(), refundAmount});
        AssertUtils.notNull((Object)tradeItem, (String)"\u5339\u914d\u5546\u54c1\u53ef\u552e\u540e\u914d\u8d27\u8ba2\u5355\u5931\u8d25");
        BigDecimal realPayAmount = BigDecimal.valueOf(saveAfterItem.getItemNum().doubleValue()).divide(BigDecimal.valueOf(tradeItem.getItemNum().doubleValue()), 6, RoundingMode.HALF_UP).multiply(tradeItem.getRealPayAmount()).setScale(2, RoundingMode.HALF_UP);
        this.logger.info("\u552e\u540e\u5b9e\u4ed8\u91d1\u989d\u5206\u644a,itemNum:{},origItemNum:{},realPayAmount:{},realPayAmount:{}", new Object[]{saveAfterItem.getItemNum(), tradeItem.getItemNum(), tradeItem.getRealPayAmount(), realPayAmount});
        saveAfterItem.setRealPayAmount(realPayAmount);
        BigDecimal origPayAmount = BigDecimal.valueOf(saveAfterItem.getItemNum().doubleValue()).divide(BigDecimal.valueOf(tradeItem.getItemNum().doubleValue()), 6, RoundingMode.HALF_UP).multiply(tradeItem.getPayAmount()).setScale(2, RoundingMode.HALF_UP);
        this.logger.info("\u552e\u540e\u6210\u4ea4\u91d1\u989d\u5206\u644a,itemNum:{},origItemNum:{},payAmount:{},origPayAmount:{}", new Object[]{saveAfterItem.getItemNum(), tradeItem.getItemNum(), tradeItem.getPayAmount(), origPayAmount});
        saveAfterItem.setOrigPayAmount(origPayAmount);
        saveAfterItem.setOrigItemNum(Integer.valueOf(tradeItem.getItemNum().intValue()));
        saveAfterItem.setPayAmount(tradeItem.getPayAmount());
        saveAfterItem.setOrigRealPayAmount(tradeItem.getRealPayAmount());
        saveAfterItem.setRefundAmount(refundAmount);
        if (saveAfterItem.getItemNum() == 0) {
            saveAfterItem.setItemPrice(BigDecimal.ZERO);
        } else {
            saveAfterItem.setItemPrice(refundAmount.divide(BigDecimal.valueOf(saveAfterItem.getItemNum().intValue()), 6, RoundingMode.HALF_UP));
        }
        this.logger.info("\u552e\u540e\u5546\u54c1\u5355\u4ef7,itemNum:{},itemPrice:{}", (Object)saveAfterItem.getItemNum(), (Object)saveAfterItem.getItemPrice());
        return saveAfterItem;
    }

    @Override
    public RestResponse<DgBizAfterSaleOrderReqDto> assemblyAfterSaleOrder(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto) {
        this.logger.info("\u5185\u90e8\u552e\u540e\u5355\u62c6\u5206\u5165\u53e3\uff0cafterSaleOrderReqDto={}", (Object)JacksonUtil.toJson((Object)afterSaleOrderReqDto));
        this.fillShopInfo(afterSaleOrderReqDto);
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() != null && afterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
            if (Objects.isNull(afterSaleOrderReqDto.getReturnWarehouseCode())) {
                this.fillReturnInfo(afterSaleOrderReqDto);
            } else {
                LogicWarehouseExtRespDto warehouseDto = (LogicWarehouseExtRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseAndAddressByCode(afterSaleOrderReqDto.getReturnWarehouseCode()));
                this.logger.info("\u6839\u636e\u53d1\u8d27\u4ed3\u7f16\u7801\u5339\u914d\u586b\u5145\u9000\u8d27\u4ed3\u5e93\u7684\u5730\u5740\u4fe1\u606f:\u5339\u914d\u4ed3\u5e93:{}", (Object)JSON.toJSONString((Object)warehouseDto));
                AssertUtils.notNull((Object)warehouseDto, (String)"\u53d1\u8d27\u903b\u8f91\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
                this.fillReturnWarehouseInfo(warehouseDto, afterSaleOrderReqDto);
            }
            return new RestResponse((Object)afterSaleOrderReqDto);
        }
        DgPerformOrderRespDto dgPerformOrderRespDto = this.performOrderDomain.queryDtoById(afterSaleOrderReqDto.getSaleOrderId());
        AssertUtils.notNull((Object)dgPerformOrderRespDto, (String)String.format("\u65e0\u6cd5\u5173\u8054\u914d\u8d27\u8ba2\u5355, orderId: %s", afterSaleOrderReqDto.getSaleOrderId()));
        AssertUtils.notIn((Object)dgPerformOrderRespDto.getOrderStatus(), new HashSet<String>(Arrays.asList(DgOmsSaleOrderStatus.COMPLETE.getCode(), DgOmsSaleOrderStatus.DELIVERED.getCode())), (String)"\u8ba2\u5355\u72b6\u6001\u672a\u53d1\u8d27\uff0c\u4e0d\u5141\u8bb8\u7533\u8bf7\u552e\u540e", (Object[])new Object[0]);
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = this.buildBizAfterSaleOrderReqDto(afterSaleOrderReqDto, dgPerformOrderRespDto);
        bizAfterSaleOrderReqDto.setOrderSource(DgSaleOrderSourceEnum.CREATE.getType());
        List dgPerformOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderItemIds(afterSaleOrderReqDto.getSaleOrderId(), afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().stream().map(DgAfterSaleOrderItemReqDto::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        AssertUtils.notEmpty((Collection)dgPerformOrderItemRespDtoList, (String)(afterSaleOrderReqDto.getSaleOrderNo() + "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u4fe1\u606f"));
        DgPerformOrderGoodsItemQueryVo goodsItemQueryVo = new DgPerformOrderGoodsItemQueryVo();
        goodsItemQueryVo.setOrderIds(Collections.singletonList(afterSaleOrderReqDto.getSaleOrderId()));
        goodsItemQueryVo.setOrderItemIds(dgPerformOrderItemRespDtoList.stream().map(BaseDto::getId).distinct().collect(Collectors.toList()));
        List goodsItemRespDtoList = this.performOrderGoodsItemDomain.queryAfterSaleOrderLinkGoodsItems(goodsItemQueryVo, null, Integer.valueOf(10000));
        AssertUtils.notEmpty((Collection)goodsItemRespDtoList, (String)(afterSaleOrderReqDto.getSaleOrderNo() + "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u660e\u7ec6\u4fe1\u606f"));
        if (goodsItemRespDtoList.size() >= 10000) {
            throw PcpTradeExceptionCode.AFTER_SALE_SPLIT_ORDER_ORDER_LINK_COUNT.buildBizException(new Object[]{afterSaleOrderReqDto.getPlatformRefundOrderSn()});
        }
        Map saleOrderItemRespDtoMap = dgPerformOrderItemRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        List afterSaleOrderItemReqDtoList = afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList();
        afterSaleOrderItemReqDtoList.stream().forEach(v -> v.setSupplyPrice(Objects.nonNull(saleOrderItemRespDtoMap.get(v.getSaleOrderItemId())) ? ((DgPerformOrderItemRespDto)saleOrderItemRespDtoMap.get(v.getSaleOrderItemId())).getSupplyPrice() : null));
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() != null && afterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
            List itemSkuCode = afterSaleOrderItemReqDtoList.stream().map(DgAfterSaleOrderItemReqDto::getSkuCode).collect(Collectors.toList());
            ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
            reqDto.setSkuCodes(itemSkuCode);
            this.logger.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
            List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
            this.logger.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemRespDtos));
            if (CollectionUtils.isEmpty((Collection)itemRespDtos)) {
                throw new BizException("-1", "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            }
            Map itemRespDtoMap = itemRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (v1, v2) -> v1));
            afterSaleOrderItemReqDtoList.forEach(v -> v.setItemPrice(Objects.nonNull(itemRespDtoMap.get(v.getSkuCode())) ? ((DgItemSkuDetailRespDto)itemRespDtoMap.get(v.getSkuCode())).getRetailPrice() : null));
        } else if (afterSaleOrderReqDto.getRelateToPlatformOrder() == null || afterSaleOrderReqDto.getRelateToPlatformOrder() == 0) {
            afterSaleOrderItemReqDtoList.forEach(v -> v.setItemPrice(Objects.nonNull(saleOrderItemRespDtoMap.get(v.getSaleOrderItemId())) ? ((DgPerformOrderItemRespDto)saleOrderItemRespDtoMap.get(v.getSaleOrderItemId())).getSalePrice() : null));
        }
        List<DgAfterSaleOrderGoodsItemReqDto> afterSaleOrderGoodsItemReqDtoList = this.buildAfterSaleOrderGoodsItemReqDtoListByAdd(afterSaleOrderReqDto, dgPerformOrderRespDto, goodsItemRespDtoList, afterSaleOrderItemReqDtoList);
        bizAfterSaleOrderReqDto.setPerformOrderItemRespDtoList(dgPerformOrderItemRespDtoList);
        bizAfterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(afterSaleOrderItemReqDtoList);
        bizAfterSaleOrderReqDto.setAfterSaleGoodsItemReqDtoList(afterSaleOrderGoodsItemReqDtoList);
        return new RestResponse((Object)bizAfterSaleOrderReqDto);
    }

    @Override
    public RestResponse<List<DgBizAfterSaleOrderReqDto>> divideAfterSaleOrderType(List<DgBizAfterSaleOrderReqDto> bizAfterSaleOrderReqDtoList) {
        this.logger.info("\u5e73\u53f0\u552e\u540e\u5355\u62c6\u5206-\u5185\u90e8\u552e\u540e\u5355\u7c7b\u578b\u533a\u5206\uff0cbizAfterSaleOrderReqDtoList={}", (Object)JacksonUtil.toJson(bizAfterSaleOrderReqDtoList));
        bizAfterSaleOrderReqDtoList.forEach(afterSaleOrderReqDto -> {
            afterSaleOrderReqDto.setNeedCreateAfterSale(false);
            if (afterSaleOrderReqDto.getRelateToPlatformOrder() != null && afterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
                PlatformApplyRefundTypeEnum applyRefundType = PlatformApplyRefundTypeEnum.forCode((String)afterSaleOrderReqDto.getPlatformApplyRefundType());
                switch (applyRefundType) {
                    case REFUND_ONLY: {
                        afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.FHHTK.getCode());
                        break;
                    }
                    case REFUND_RETURN: {
                        afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.THTK.getCode());
                        break;
                    }
                    case EXCHANGE: {
                        afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.HH.getCode());
                        break;
                    }
                    default: {
                        throw new BizException("\u65e0\u5355\u636e\u552e\u540e, \u9519\u8befplatformApplyRefundType\uff1a" + afterSaleOrderReqDto.getPlatformApplyRefundType());
                    }
                }
                afterSaleOrderReqDto.setNeedCreateAfterSale(true);
                return;
            }
            DgPerformOrderRespDto saleOrder = afterSaleOrderReqDto.getPerformOrderRespDto();
            DgOmsSaleOrderStatus saleOrderStatus = DgOmsSaleOrderStatus.forCode((String)saleOrder.getOrderStatus());
            switch (saleOrderStatus) {
                case CREATED: 
                case CANCELING: 
                case DRAFT: 
                case WAIT_CHECK: 
                case WAIT_PICK_UNLOCK: 
                case WAIT_WAREHOUSE_SOURCE: 
                case WAIT_LOCK_INVENTORY: 
                case WAIT_LOGISTICS_SOURCE: 
                case DELIVERY_PART: 
                case DELIVERY_ALL: 
                case RECEIVED: 
                case SPLIT: 
                case OBSOLETE: 
                case WAIT_ASSIGN: 
                case FINISH: {
                    throw PcpTradeExceptionCode.AFTER_SALE_SPLIT_ORDER_SALE_ORDER_STATUS_WRONG.buildBizException(new Object[]{afterSaleOrderReqDto.getSaleOrderNo(), saleOrderStatus.getDesc()});
                }
                case CANCEL: {
                    afterSaleOrderReqDto.setNeedCreateAfterSale(false);
                    break;
                }
                case WAIT_CUSTOMER_AUDIT: 
                case WAIT_BUSINESS_AUDIT: 
                case LACK: 
                case PICKED: 
                case WAIT_PICK: 
                case WAIT_DELIVERY: {
                    if (this.checkAllItemCancel(afterSaleOrderReqDto.getPerformOrderItemRespDtoList())) break;
                    Map<Long, DgPerformOrderItemRespDto> saleOrderItemRespDtoMap = afterSaleOrderReqDto.getPerformOrderItemRespDtoList().stream().filter(saleOrderItemRespDto -> DgSaleOrderItemStatusEnum.CANCEL.getCode().equals(saleOrderItemRespDto.getStatus())).collect(Collectors.toMap(BaseDto::getId, v1 -> v1));
                    afterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(afterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().stream().filter(dto -> !saleOrderItemRespDtoMap.containsKey(dto.getSaleOrderItemId())).collect(Collectors.toList()));
                    afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.JTK.getCode());
                    afterSaleOrderReqDto.setNeedCreateAfterSale(true);
                    break;
                }
                case DELIVERED: 
                case COMPLETE: {
                    if (PlatformApplyOriginOrderTypeEnum.INVENTED.getCode().equals(afterSaleOrderReqDto.getPlatformApplyOriginOrderType())) {
                        afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.FHHTK.getCode());
                        break;
                    }
                    afterSaleOrderReqDto.setNeedCreateAfterSale(true);
                    if (PlatformApplyRefundTypeEnum.REFUND_RETURN.getCode().equals(afterSaleOrderReqDto.getPlatformApplyRefundType())) {
                        afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.THTK.getCode());
                        break;
                    }
                    if (PlatformApplyRefundTypeEnum.EXCHANGE.getCode().equals(afterSaleOrderReqDto.getPlatformApplyRefundType())) {
                        afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.HH.getCode());
                        break;
                    }
                    if (PlatformApplyRefundTypeEnum.REFUND_ONLY.getCode().equals(afterSaleOrderReqDto.getPlatformApplyRefundType())) {
                        if (this.platformApplyGoodsReturnTypeConfig.booleanValue()) {
                            if (PlatformApplyGoodsReturnTypeEnum.RECEIVED.getCode().equals(afterSaleOrderReqDto.getPlatformApplyGoodsReturnType())) {
                                this.divideAfterSaleOrderTypeProportion((DgBizAfterSaleOrderReqDto)afterSaleOrderReqDto);
                                break;
                            }
                            if (PlatformApplyGoodsReturnTypeEnum.NO_RECEIVED.getCode().equals(afterSaleOrderReqDto.getPlatformApplyGoodsReturnType())) {
                                afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.THTK.getCode());
                                afterSaleOrderReqDto.setReturnType(Integer.valueOf(1));
                                break;
                            }
                            this.divideAfterSaleOrderTypeProportion((DgBizAfterSaleOrderReqDto)afterSaleOrderReqDto);
                            break;
                        }
                        this.divideAfterSaleOrderTypeProportion((DgBizAfterSaleOrderReqDto)afterSaleOrderReqDto);
                        break;
                    }
                    throw new BizException("\u9519\u8befplatformApplyRefundType\uff1a" + afterSaleOrderReqDto.getPlatformApplyRefundType());
                }
            }
            this.logger.info("\u5e73\u53f0\u552e\u540e\u5355\u62c6\u5206-\u5185\u90e8\u552e\u540e\u5355\u7c7b\u578b\u533a\u5206\u7ed3\u679c\uff0csaleOrderNo={}\uff0ctype={}\uff0ccreatedFlag={}", new Object[]{afterSaleOrderReqDto.getSaleOrderNo(), afterSaleOrderReqDto.getAfterSaleOrderType(), afterSaleOrderReqDto.isNeedCreateAfterSale()});
            if (this.afterSaleOrderStartTime > afterSaleOrderReqDto.getPlatformCreated().getTime() && !afterSaleOrderReqDto.getAfterSaleOrderType().equals(AfterSaleOrderTypeEnum.JTK.getCode())) {
                throw new BizException("\u7cfb\u7edf\u5207\u6362\u4e4b\u524d\u7533\u8bf7\u7684\u552e\u540e\u5355\u4e0d\u8fdb\u884c\u5904\u7406");
            }
            if ((afterSaleOrderReqDto.getRelateToPlatformOrder() == null || Objects.equals(afterSaleOrderReqDto.getRelateToPlatformOrder(), 0)) && (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.THTK.getCode().equals(afterSaleOrderReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderReqDto.getAfterSaleOrderType()))) {
                this.fillReturnInfo((DgBizAfterSaleOrderReqDto)afterSaleOrderReqDto);
            }
        });
        return new RestResponse(bizAfterSaleOrderReqDtoList);
    }

    private void divideAfterSaleOrderTypeProportion(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto) {
        BigDecimal payAmount = BigDecimal.valueOf(afterSaleOrderReqDto.getPerformOrderItemRespDtoList().stream().map(DgPerformOrderItemDto::getRealPayAmount).mapToDouble(BigDecimal::doubleValue).sum());
        BigDecimal refundFee = afterSaleOrderReqDto.getRefundFee();
        BigDecimal bigDecimal = new BigDecimal(1);
        if (bigDecimal.subtract(payAmount.subtract(refundFee).divide(payAmount, 2, 4)).doubleValue() >= this.divideAfterSaleOrderTypeProportionConfig) {
            afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.THTK.getCode());
            afterSaleOrderReqDto.setReturnType(Integer.valueOf(1));
        } else {
            afterSaleOrderReqDto.setAfterSaleOrderType(AfterSaleOrderTypeEnum.FHHTK.getCode());
        }
    }

    @Override
    public RestResponse<List<DgBizAfterSaleOrderReqDto>> giftAfterSaleOrder(List<DgBizAfterSaleOrderReqDto> bizAfterSaleOrderReqDtoList) {
        List<String> excludeMatchGiftChannelList = Arrays.asList(this.excludeMatchGiftChannels.split(","));
        bizAfterSaleOrderReqDtoList.stream().forEach(bizAfterSaleOrderReqDto -> {
            if (!excludeMatchGiftChannelList.contains(bizAfterSaleOrderReqDto.getChannelCode())) {
                this.logger.info("\u901a\u8fc7\u62c6\u5206\u7ed3\u679c\u83b7\u53d6\u8d60\u54c1\u6302\u9760 saleOrderNo:{},afterSaleOrderType:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)bizAfterSaleOrderReqDto.getAfterSaleOrderType());
                if (StringUtils.equalsAny((CharSequence)bizAfterSaleOrderReqDto.getAfterSaleOrderType(), (CharSequence[])new CharSequence[]{AfterSaleOrderTypeEnum.JTK.getCode(), AfterSaleOrderTypeEnum.THTK.getCode()})) {
                    DgPerformOrderRespDto dgPerformOrderRespDto = bizAfterSaleOrderReqDto.getPerformOrderRespDto();
                    List afterItemList = bizAfterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList();
                    BigDecimal saleOrderPayAmount = dgPerformOrderRespDto.getRealPayAmount();
                    BigDecimal refundFee = BigDecimal.valueOf(afterItemList.stream().mapToDouble(a -> a.getRefundAmount().doubleValue()).sum());
                    this.logger.info("\u6302\u9760\u8d60\u54c1 saleOrderPayAmount:{},refundFee:{},rateConfig:{}", new Object[]{saleOrderPayAmount, refundFee, this.returnGiftRateConfig});
                    if (Objects.nonNull(saleOrderPayAmount) && saleOrderPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                        List giftList;
                        List dgSaleOrderItemRespDtos;
                        List itemIdList = afterItemList.stream().map(DgAfterSaleOrderItemReqDto::getSaleOrderItemId).distinct().collect(Collectors.toList());
                        this.logger.info("\u6302\u9760\u8d60\u54c1 \u5e73\u53f0\u5df2\u4f20\u8d60\u54c1 itemIdList:{}", (Object)JSON.toJSONString(itemIdList));
                        double rate = refundFee.divide(saleOrderPayAmount, RoundingMode.HALF_UP).doubleValue();
                        if (rate >= this.returnGiftRateConfig && CollectionUtils.isNotEmpty((Collection)(dgSaleOrderItemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(dgPerformOrderRespDto.getId()))) && dgSaleOrderItemRespDtos.stream().filter(item -> !itemIdList.contains(item.getId())).anyMatch(item -> item.getGift() == 1) && CollectionUtils.isNotEmpty(giftList = dgSaleOrderItemRespDtos.stream().filter(item -> item.getGift() == 1 && !itemIdList.contains(item.getId())).map(saleOrderItem -> {
                            DgAfterSaleOrderItemModifyReqDto saveAfterItem = new DgAfterSaleOrderItemModifyReqDto();
                            CubeBeanUtils.copyProperties((Object)saveAfterItem, (Object)saleOrderItem, (String[])new String[]{"id", "createTime", "updateTime"});
                            saveAfterItem.setSaleOrderId(saleOrderItem.getOrderId());
                            saveAfterItem.setSaleOrderItemId(saleOrderItem.getId());
                            saveAfterItem.setAfterSaleOrderItemType(Integer.valueOf(0));
                            saveAfterItem.setPlatformRefundOrderNo(bizAfterSaleOrderReqDto.getPlatformRefundOrderSn());
                            saveAfterItem.setOrigItemNum(Integer.valueOf(saleOrderItem.getItemNum().intValue()));
                            saveAfterItem.setItemNum(Integer.valueOf(saleOrderItem.getItemNum().intValue()));
                            saveAfterItem.setCombineGood(Integer.valueOf(0));
                            saveAfterItem.setItemPrice(saleOrderItem.getPrice());
                            saveAfterItem.setOrigPayAmount(BigDecimal.ZERO);
                            saveAfterItem.setRefundAmount(BigDecimal.ZERO);
                            return saveAfterItem;
                        }).collect(Collectors.toList()))) {
                            this.logger.info("\u6302\u9760\u8d60\u54c1\u6210\u529f giftList:{}", (Object)JSON.toJSONString(giftList));
                            bizAfterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().addAll(giftList);
                        }
                    }
                }
            }
        });
        return new RestResponse(bizAfterSaleOrderReqDtoList);
    }

    @Override
    public RestResponse<List<DgBizAfterSaleOrderReqDto>> relPromotionGifts(List<DgBizAfterSaleOrderReqDto> bizAfterSaleOrderReqDtoList) {
        if (CollectionUtils.isEmpty(bizAfterSaleOrderReqDtoList)) {
            this.logger.info("\u5173\u8054\u552e\u540e\u5355\u96c6\u5408\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4fc3\u9500\u8d60\u54c1\u5339\u914d");
            return new RestResponse(bizAfterSaleOrderReqDtoList);
        }
        Map afterSaleRelMap = bizAfterSaleOrderReqDtoList.stream().collect(Collectors.toMap(DgAfterSaleOrderDto::getSaleOrderId, Function.identity()));
        List orderIdList = bizAfterSaleOrderReqDtoList.stream().map(DgAfterSaleOrderDto::getSaleOrderId).collect(Collectors.toList());
        List dgPerformOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderIds(orderIdList);
        AssertUtils.notEmpty((Collection)dgPerformOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        Map performOrderItemIdMap = dgPerformOrderItemRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        HashSet afterSaleLinkMainOrderItemIdSet = new HashSet();
        HashMap afterSaleOrderItemLinkDtoMap = new HashMap();
        bizAfterSaleOrderReqDtoList.forEach(bizAfterSaleOrderReqDto -> {
            if (CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList())) {
                this.logger.info(bizAfterSaleOrderReqDto.getSaleOrderId() + "\u5173\u8054\u552e\u540e\u5355\u5546\u54c1\u96c6\u5408\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4fc3\u9500\u8d60\u54c1\u5339\u914d");
                return;
            }
            bizAfterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).forEach(afterSaleOrderItemModifyReqDto -> {
                DgPerformOrderItemRespDto dgSaleOrderItemRespDto = (DgPerformOrderItemRespDto)performOrderItemIdMap.get(afterSaleOrderItemModifyReqDto.getSaleOrderItemId());
                AssertUtils.notNull((Object)dgSaleOrderItemRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u5173\u8054\u5546\u54c1\u884c\u6570\u636e\uff0c\u5339\u914d\u4fc3\u9500\u8d60\u54c1\u5931\u8d25");
                afterSaleLinkMainOrderItemIdSet.add(dgSaleOrderItemRespDto.getMainOrderItemId());
                if (afterSaleOrderItemLinkDtoMap.containsKey(afterSaleOrderItemModifyReqDto.getSaleOrderItemId())) {
                    throw new BizException("-1", "\u552e\u540e\u5173\u8054\u8ba2\u5355\u5546\u54c1\u884c\u91cd\u590d");
                }
                afterSaleOrderItemLinkDtoMap.put(afterSaleOrderItemModifyReqDto.getSaleOrderItemId(), afterSaleOrderItemModifyReqDto);
            });
        });
        List saleOrderPromotionGiftRespDtoList = this.saleOrderPromotionGiftDomain.querySaleOrderItemPromotionGiftByMainOrderItemIdList(new ArrayList(afterSaleLinkMainOrderItemIdSet));
        if (CollectionUtils.isEmpty((Collection)saleOrderPromotionGiftRespDtoList)) {
            this.logger.info("\u83b7\u53d6\u4fc3\u9500\u5173\u7cfb\u5339\u914d\u4e3a\u7a7a\uff0c\u65e0\u9700\u4fc3\u9500\u5339\u914d");
            return new RestResponse(bizAfterSaleOrderReqDtoList);
        }
        Set linkMainOrderItemIdSet = saleOrderPromotionGiftRespDtoList.stream().map(DgSaleOrderPromotionGiftRespDto::getLinkMainOrderItemId).collect(Collectors.toSet());
        DgPerformOrderGoodsItemQueryVo performOrderGoodsItemQueryVo = new DgPerformOrderGoodsItemQueryVo();
        performOrderGoodsItemQueryVo.setMainOrderItemIds(new ArrayList(linkMainOrderItemIdSet));
        performOrderGoodsItemQueryVo.setGourdByOrderItemId(true);
        List dgPerformGoodsItemRespDtoList = this.performOrderGoodsItemDomain.queryAfterSaleOrderLinkGoodsItems(performOrderGoodsItemQueryVo, null, Integer.valueOf(1000));
        if (dgPerformGoodsItemRespDtoList.size() >= 1000) {
            throw PcpTradeExceptionCode.AFTER_SALE_SPLIT_ORDER_ORDER_LINK_COUNT.buildBizException(new Object[]{""});
        }
        if (CollectionUtils.isEmpty(dgPerformGoodsItemRespDtoList = dgPerformGoodsItemRespDtoList.stream().filter(dto -> !afterSaleOrderItemLinkDtoMap.containsKey(dto.getOrderItemId())).collect(Collectors.toList()))) {
            this.logger.info("\u8fc7\u6ee4\u540e\u8d60\u54c1\u884c\u4e3a\u7a7a\uff0c\u65e0\u9700\u4fc3\u9500\u5339\u914d");
            return new RestResponse(bizAfterSaleOrderReqDtoList);
        }
        List newOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderItemIds(dgPerformGoodsItemRespDtoList.stream().map(DgPerformOrderGoodsItemRespDto::getOrderItemId).collect(Collectors.toList()));
        AssertUtils.notEmpty((Collection)newOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u9700\u552e\u540e\u7684\u4fc3\u9500\u5546\u54c1\u884c");
        newOrderItemRespDtoList = newOrderItemRespDtoList.stream().filter(dto -> DgSaleOrderItemStatusEnum.NORMAL.getCode().equals(dto.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newOrderItemRespDtoList)) {
            this.logger.info("\u8fc7\u6ee4\u540e\u8d60\u54c1\u884c\u4e3a\u7a7a\uff0c\u65e0\u9700\u4fc3\u9500\u5339\u914d");
            return new RestResponse(bizAfterSaleOrderReqDtoList);
        }
        Map<Long, List<DgPerformOrderItemRespDto>> waitAfterSaleOrderLinkMap = newOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
        waitAfterSaleOrderLinkMap.forEach((orderId, orderItemList) -> {
            if (afterSaleRelMap.containsKey(orderId)) {
                DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = (DgBizAfterSaleOrderReqDto)afterSaleRelMap.get(orderId);
                orderItemList.forEach(saleOrderItem -> {
                    DgAfterSaleOrderItemModifyReqDto saveAfterItem = new DgAfterSaleOrderItemModifyReqDto();
                    CubeBeanUtils.copyProperties((Object)saveAfterItem, (Object)saleOrderItem, (String[])new String[]{"id", "createTime", "updateTime"});
                    saveAfterItem.setSaleOrderId(saleOrderItem.getOrderId());
                    saveAfterItem.setSaleOrderItemId(saleOrderItem.getId());
                    saveAfterItem.setAfterSaleOrderItemType(Integer.valueOf(0));
                    saveAfterItem.setPlatformRefundOrderNo(bizAfterSaleOrderReqDto.getPlatformRefundOrderSn());
                    saveAfterItem.setOrigItemNum(Integer.valueOf(saleOrderItem.getItemNum().intValue()));
                    saveAfterItem.setItemNum(Integer.valueOf(saleOrderItem.getItemNum().intValue()));
                    saveAfterItem.setItemPrice(saleOrderItem.getSalePrice());
                    saveAfterItem.setRefundAmount(BigDecimal.ZERO);
                    saveAfterItem.setOrigRefundAmount(BigDecimal.ZERO);
                    saveAfterItem.setOrigPayAmount(BigDecimal.ZERO);
                    saveAfterItem.setPlatformRefundAmount(BigDecimal.ZERO);
                    saveAfterItem.setRealPayAmount(BigDecimal.ZERO);
                    saveAfterItem.setCombineGood(Integer.valueOf(0));
                    bizAfterSaleOrderReqDto.getAfterSaleOrderItemReqDtoList().add(saveAfterItem);
                });
            } else {
                this.logger.info("\u8be5\u60c5\u51b5\u6682\u65f6\u65e0\u9700\u5904\u7406");
            }
        });
        return new RestResponse(bizAfterSaleOrderReqDtoList);
    }

    private boolean checkAllItemCancel(List<DgPerformOrderItemRespDto> dgPerformOrderItemRespDtoList) {
        return dgPerformOrderItemRespDtoList.stream().allMatch(dgSaleOrderItemRespDto -> DgSaleOrderItemStatusEnum.CANCEL.getCode().equals(dgSaleOrderItemRespDto.getStatus()));
    }

    private List<DgAfterSaleOrderGoodsItemReqDto> buildAfterSaleOrderGoodsItemReqDtoList(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto, DgPerformOrderRespDto dgPerformOrderRespDto, List<DgPerformOrderGoodsItemRespDto> goodsItemRespDtoList, List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemReqDtoList) {
        Map<String, List<DgAfterSaleOrderItemModifyReqDto>> afterSaleOrderItemReqDtoMap = afterSaleOrderItemReqDtoList.stream().filter(goodsItem -> goodsItem.getAfterSaleOrderItemType() == null || goodsItem.getAfterSaleOrderItemType() == 0).collect(Collectors.groupingBy(DgAfterSaleOrderItemReqDto::getPlatformOrderItemNo));
        return goodsItemRespDtoList.stream().flatMap(afterSaleItem -> {
            List afterSaleOrderItemReqDtos = (List)afterSaleOrderItemReqDtoMap.get(afterSaleItem.getPlatformOrderItemNo());
            return afterSaleOrderItemReqDtos.stream().map(afterSaleOrderItemReqDto -> {
                DgAfterSaleOrderGoodsItemReqDto afterSaleOrderGoodsItemReqDto = new DgAfterSaleOrderGoodsItemReqDto();
                afterSaleOrderGoodsItemReqDto.setLinkSaleOrderGoodsItemId(afterSaleItem.getId());
                afterSaleOrderGoodsItemReqDto.setLinkSaleOrderId(dgPerformOrderRespDto.getId());
                afterSaleOrderGoodsItemReqDto.setLinkSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
                afterSaleOrderGoodsItemReqDto.setLinkSaleOrderItemId(afterSaleItem.getOrderItemId());
                afterSaleOrderGoodsItemReqDto.setAfterSaleOrderId(afterSaleOrderReqDto.getId());
                afterSaleOrderGoodsItemReqDto.setAfterSaleOrderItemId(afterSaleOrderItemReqDto.getId());
                afterSaleOrderGoodsItemReqDto.setPlatformOrderItemNo(afterSaleItem.getPlatformOrderItemNo());
                afterSaleOrderGoodsItemReqDto.setPlatformRefundOrderId(afterSaleOrderItemReqDto.getPlatformRefundOrderId());
                afterSaleOrderGoodsItemReqDto.setPlatformRefundOrderNo(afterSaleOrderItemReqDto.getPlatformRefundOrderNo());
                return afterSaleOrderGoodsItemReqDto;
            });
        }).collect(Collectors.toList());
    }

    private List<DgAfterSaleOrderGoodsItemReqDto> buildAfterSaleOrderGoodsItemReqDtoListByAdd(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto, DgPerformOrderRespDto dgPerformOrderRespDto, List<DgPerformOrderGoodsItemRespDto> goodsItemRespDtoList, List<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemReqDtoList) {
        Map afterSaleOrderItemReqDtoMap = afterSaleOrderItemReqDtoList.stream().filter(dto -> Objects.equals(dto.getAfterSaleOrderItemType(), 0)).collect(Collectors.toMap(DgAfterSaleOrderItemReqDto::getSaleOrderItemId, Functions.identity(), (v1, v2) -> v2));
        afterSaleOrderItemReqDtoList.stream().forEach(dto -> dto.setSaleOrderId(dgPerformOrderRespDto.getId()));
        return goodsItemRespDtoList.stream().map(afterSaleItem -> {
            DgAfterSaleOrderItemModifyReqDto afterSaleOrderItemReqDto = (DgAfterSaleOrderItemModifyReqDto)afterSaleOrderItemReqDtoMap.get(afterSaleItem.getOrderItemId());
            DgAfterSaleOrderGoodsItemReqDto afterSaleOrderGoodsItemReqDto = new DgAfterSaleOrderGoodsItemReqDto();
            afterSaleOrderGoodsItemReqDto.setLinkSaleOrderGoodsItemId(afterSaleItem.getId());
            afterSaleOrderGoodsItemReqDto.setLinkSaleOrderId(dgPerformOrderRespDto.getId());
            afterSaleOrderGoodsItemReqDto.setLinkSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
            afterSaleOrderGoodsItemReqDto.setLinkSaleOrderItemId(afterSaleItem.getId());
            afterSaleOrderGoodsItemReqDto.setAfterSaleOrderId(afterSaleOrderReqDto.getId());
            afterSaleOrderGoodsItemReqDto.setAfterSaleOrderItemId(afterSaleOrderItemReqDto.getId());
            afterSaleOrderGoodsItemReqDto.setPlatformOrderItemNo(afterSaleItem.getPlatformOrderItemNo());
            afterSaleOrderGoodsItemReqDto.setPlatformRefundOrderId(afterSaleOrderItemReqDto.getPlatformRefundOrderId());
            afterSaleOrderGoodsItemReqDto.setPlatformRefundOrderNo(afterSaleOrderItemReqDto.getPlatformRefundOrderNo());
            return afterSaleOrderGoodsItemReqDto;
        }).collect(Collectors.toList());
    }

    private List<DgAfterSaleOrderItemModifyReqDto> buildAfterSaleOrderItemReqDtoListAdd(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto, List<DgPerformOrderItemRespDto> dgPerformOrderItemRespDtoList) {
        return dgPerformOrderItemRespDtoList.stream().map(saleOrderItem -> {
            DgAfterSaleOrderItemModifyReqDto afterSaleOrderItemReqDto = new DgAfterSaleOrderItemModifyReqDto();
            CubeBeanUtils.copyProperties((Object)afterSaleOrderItemReqDto, (Object)saleOrderItem, (String[])new String[0]);
            afterSaleOrderItemReqDto.setId(null);
            afterSaleOrderItemReqDto.setSaleOrderItemId(saleOrderItem.getId());
            afterSaleOrderItemReqDto.setPlatformOrderItemNo(saleOrderItem.getPlatformOrderItemNo());
            afterSaleOrderItemReqDto.setItemNum(Integer.valueOf(saleOrderItem.getItemNum().intValue()));
            return afterSaleOrderItemReqDto;
        }).collect(Collectors.toList());
    }

    private DgBizAfterSaleOrderReqDto buildBizAfterSaleOrderReqDto(DgBizAfterSaleOrderReqDto afterSaleOrderReqDto, DgPerformOrderRespDto dgPerformOrderRespDto) {
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() == null || Objects.equals(afterSaleOrderReqDto.getRelateToPlatformOrder(), 0)) {
            afterSaleOrderReqDto.setPerformOrderRespDto(dgPerformOrderRespDto);
            if (Objects.isNull(afterSaleOrderReqDto.getReturnWarehouseCode())) {
                this.fillReturnInfo(afterSaleOrderReqDto);
            }
        }
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        CubeBeanUtils.copyProperties((Object)bizAfterSaleOrderReqDto, (Object)afterSaleOrderReqDto, (String[])new String[0]);
        bizAfterSaleOrderReqDto.setId(null);
        bizAfterSaleOrderReqDto.setPerformOrderRespDto(dgPerformOrderRespDto);
        bizAfterSaleOrderReqDto.setSaleOrderId(dgPerformOrderRespDto.getId());
        bizAfterSaleOrderReqDto.setSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
        bizAfterSaleOrderReqDto.setPlatformOrderNo(dgPerformOrderRespDto.getPlatformOrderNo());
        bizAfterSaleOrderReqDto.setPlatformCreated(new Date());
        return bizAfterSaleOrderReqDto;
    }

    private void fillReturnInfo(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        if (bizAfterSaleOrderReqDto.getRelateToPlatformOrder() != null && bizAfterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
            this.logger.info("fillReturnInfo-fillReturnInfoByShop:{}", (Object)bizAfterSaleOrderReqDto.getShopWarehouseCode());
            this.fillReturnInfoByShop(bizAfterSaleOrderReqDto);
        } else {
            DgAfterSaleOrderFillReturnInfoEnum fillReturnInfoEnum = DgAfterSaleOrderFillReturnInfoEnum.enumOf((String)this.fillReturnInfo);
            this.logger.info("fillReturnInfo-fillReturnInfoEnum:{}", (Object)fillReturnInfoEnum.getCode());
            this.splitFillReturnInfo(bizAfterSaleOrderReqDto, fillReturnInfoEnum);
        }
    }

    private void splitFillReturnInfo(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto, DgAfterSaleOrderFillReturnInfoEnum fillReturnInfoEnum) {
        DgPerformOrderRespDto dgPerformOrderRespDto;
        DgPerformOrderOutNoticeSyncRecordRespDto saleOrderOutNoticeSyncRecordRespDto;
        if (Objects.isNull(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getDeliveryLogicalWarehouseCode())) {
            bizAfterSaleOrderReqDto.getPerformOrderRespDto().setDeliveryLogicalWarehouseCode(this.defaultDeliveryLogicalWarehouseCode);
        }
        if (Objects.nonNull(bizAfterSaleOrderReqDto.getReturnType()) && 1 == bizAfterSaleOrderReqDto.getReturnType() && Objects.nonNull(saleOrderOutNoticeSyncRecordRespDto = this.performOrderOutNoticeSyncRecordService.queryByOrderId((dgPerformOrderRespDto = bizAfterSaleOrderReqDto.getPerformOrderRespDto()).getId()))) {
            this.logger.info("\u62e6\u622a\u9000\u539f\u5355\u7269\u6d41\u4fe1\u606f:{}", (Object)saleOrderOutNoticeSyncRecordRespDto.getOutNoticeResultJson());
            DgOutDeliveryResultReqDto outDeliveryResultReqDto = (DgOutDeliveryResultReqDto)JSON.parseObject((String)saleOrderOutNoticeSyncRecordRespDto.getOutNoticeResultJson(), DgOutDeliveryResultReqDto.class);
            if (Objects.nonNull(outDeliveryResultReqDto) && CollectionUtils.isNotEmpty((Collection)outDeliveryResultReqDto.getShippingInfoList())) {
                outDeliveryResultReqDto.getShippingInfoList().stream().findFirst().ifPresent(e -> {
                    bizAfterSaleOrderReqDto.setReturnShippingSn(e.getShippingNo());
                    bizAfterSaleOrderReqDto.setShippingName(e.getShippingCompanyName());
                    bizAfterSaleOrderReqDto.setShippingCode(e.getShippingCompanyCode());
                });
            }
        }
        if (fillReturnInfoEnum == DgAfterSaleOrderFillReturnInfoEnum.DEFAULT) {
            if (Objects.nonNull(bizAfterSaleOrderReqDto.getReturnType()) && 1 == bizAfterSaleOrderReqDto.getReturnType() && DgConsignTypeEnum.THIRD.getType().equals(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getConsignType())) {
                this.fillReturnInfoByDeliveryWarehouse(bizAfterSaleOrderReqDto);
            } else {
                this.fillReturnInfoByDeliveryReturnWarehouse(bizAfterSaleOrderReqDto);
            }
        } else {
            switch (fillReturnInfoEnum) {
                case SALE_ORDER_DELIVERY_WAREHOUSE: {
                    this.fillReturnInfoByDeliveryWarehouse(bizAfterSaleOrderReqDto);
                    break;
                }
                case SALE_ORDER_DELIVERY_RETURN_WAREHOUSE: {
                    this.fillReturnInfoByDeliveryReturnWarehouse(bizAfterSaleOrderReqDto);
                    break;
                }
                default: {
                    throw new BizException("-1", "\u672a\u914d\u7f6e\u552e\u540e\u9000\u8d27\u4fe1\u606f\u7b56\u7565");
                }
            }
        }
        if (AfterSaleOrderTypeEnum.THTK.getCode().equals(bizAfterSaleOrderReqDto.getAfterSaleOrderType())) {
            this.fillExchangeInfoByOrigSaleOrderAddr(bizAfterSaleOrderReqDto);
        }
    }

    private void fillReturnInfoByShop(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        this.fillShopInfo(bizAfterSaleOrderReqDto);
        if (StringUtils.isNotEmpty((CharSequence)bizAfterSaleOrderReqDto.getShopWarehouseCode())) {
            if (StringUtils.isEmpty((CharSequence)bizAfterSaleOrderReqDto.getReturnProvinceCode()) && StringUtils.isEmpty((CharSequence)bizAfterSaleOrderReqDto.getReturnCityCode()) && StringUtils.isEmpty((CharSequence)bizAfterSaleOrderReqDto.getReturnCountyCode())) {
                LogicWarehouseExtRespDto warehouseDto = (LogicWarehouseExtRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseAndAddressByCode(bizAfterSaleOrderReqDto.getShopWarehouseCode()));
                this.logger.info("\u6839\u636e\u5e97\u94fa\u4fe1\u606f\u586b\u5145\u9000\u8d27\u5bc4\u56de\u7684\u5730\u5740\u4fe1\u606f:\u5185\u90e8\u9500\u552e\u5355\u53f7:{},\u5339\u914d\u4ed3\u5e93:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)warehouseDto));
                if (Objects.nonNull(warehouseDto)) {
                    this.fillReturnWarehouseInfo(warehouseDto, bizAfterSaleOrderReqDto);
                }
            }
        } else {
            throw new BizException("\u5e97\u94fa\u4e2d\u5fc3\u65e0\u6570\u636e " + bizAfterSaleOrderReqDto.getShopId());
        }
    }

    @Override
    public void fillShopInfo(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        if (Objects.nonNull(bizAfterSaleOrderReqDto.getShopId())) {
            RestResponse shopResponse = this.shopQueryApi.getShopDetailById(bizAfterSaleOrderReqDto.getShopId());
            this.logger.info("\u5e97\u94faID:{},\u8be6\u60c5: {}", (Object)bizAfterSaleOrderReqDto.getShopId(), (Object)JacksonUtil.toJson((Object)shopResponse));
            if ("0".equals(shopResponse.getResultCode())) {
                DgShopRespDto shopDto = (DgShopRespDto)shopResponse.getData();
                if (StringUtils.isEmpty((CharSequence)bizAfterSaleOrderReqDto.getShopWebsite())) {
                    bizAfterSaleOrderReqDto.setShopWebsite(shopDto.getChannelName());
                }
                if (StringUtils.isEmpty((CharSequence)bizAfterSaleOrderReqDto.getShopWebsiteCode())) {
                    bizAfterSaleOrderReqDto.setShopWebsiteCode(shopDto.getChannelCode());
                }
                if (bizAfterSaleOrderReqDto.getShopWebsiteId() == null) {
                    bizAfterSaleOrderReqDto.setShopWebsiteId(shopDto.getChannelId());
                }
                if (StringUtils.isNotEmpty((CharSequence)shopDto.getLogicWarehouseCode())) {
                    bizAfterSaleOrderReqDto.setShopWarehouseCode(shopDto.getLogicWarehouseCode());
                }
            } else {
                throw new BizException("\u5e97\u94fa\u4e2d\u5fc3\u65e0\u6570\u636e " + bizAfterSaleOrderReqDto.getShopId());
            }
        }
    }

    private void fillReturnInfoByDeliveryReturnWarehouse(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        this.logger.info("\u6839\u636e\u539f\u5355\u53d1\u8d27\u4ed3\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u9000\u8d27\u4ed3\u4fe1\u606f\u586b\u5145\u9000\u8d27\u5bc4\u56de\u7684\u5730\u5740\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        if (Objects.nonNull(bizAfterSaleOrderReqDto.getPerformOrderRespDto())) {
            // empty if block
        }
    }

    private void fillExchangeInfoByOrigSaleOrderAddr(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        this.logger.info("\u6839\u636e\u539f\u5355\u83b7\u53d6\u6536\u8d27\u5730\u5740\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        DgPerformOrderAddrDto address = this.performOrderAddrDomain.queryAddressByOrderId(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getId());
        AssertUtils.notNull((Object)address, (String)String.format("\u539f\u5355[%s]\u6536\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", bizAfterSaleOrderReqDto.getPerformOrderRespDto().getSaleOrderNo()));
        this.logger.info("\u6839\u636e\u539f\u5355\u83b7\u53d6\u6536\u8d27\u4fe1\u606f:\u5185\u90e8\u9500\u552e\u5355\u53f7:{},\u5730\u5740\u4fe1\u606f:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)address));
        bizAfterSaleOrderReqDto.setExchangeRecipient(address.getReceiveName());
        bizAfterSaleOrderReqDto.setExchangeAddress(address.getReceiveAddress());
        bizAfterSaleOrderReqDto.setExchangeAddrStreet(address.getReceiveAddress());
        bizAfterSaleOrderReqDto.setExchangeCityCode(address.getCityCode());
        bizAfterSaleOrderReqDto.setExchangeCityName(address.getCity());
        bizAfterSaleOrderReqDto.setExchangeProvinceCode(address.getProvinceCode());
        bizAfterSaleOrderReqDto.setExchangeProvinceName(address.getProvince());
        bizAfterSaleOrderReqDto.setExchangeCountyCode(address.getCountyCode());
        bizAfterSaleOrderReqDto.setExchangeCountyName(address.getCounty());
        bizAfterSaleOrderReqDto.setExchangeRecipientPhone(address.getReceivePhone());
    }

    private void fillReturnInfoByDeliveryWarehouse(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        this.logger.info("\u6839\u636e\u539f\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u586b\u5145\u9000\u8d27\u4ed3\u5e93\u7684\u5730\u5740\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        LogicWarehouseExtRespDto warehouseDto = (LogicWarehouseExtRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseAndAddressByCode(bizAfterSaleOrderReqDto.getPerformOrderRespDto().getDeliveryLogicalWarehouseCode()));
        this.logger.info("\u6839\u636e\u539f\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u586b\u5145\u9000\u8d27\u4ed3\u5e93\u7684\u5730\u5740\u4fe1\u606f:\u5185\u90e8\u9500\u552e\u5355\u53f7:{},\u5339\u914d\u4ed3\u5e93:{}", (Object)bizAfterSaleOrderReqDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)warehouseDto));
        AssertUtils.notNull((Object)warehouseDto, (String)"\u539f\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
        this.fillReturnWarehouseInfo(warehouseDto, bizAfterSaleOrderReqDto);
    }

    private void fillReturnWarehouseInfo(LogicWarehouseExtRespDto warehouseDto, DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        this.logger.info("fillReturnWarehouseInfo-warehouseDto: {}", (Object)JacksonUtil.toJson((Object)warehouseDto));
        bizAfterSaleOrderReqDto.setReturnWarehouseCode(warehouseDto.getWarehouseCode());
        bizAfterSaleOrderReqDto.setReturnWarehouseName(warehouseDto.getWarehouseName());
        WarehouseAddressDto address = warehouseDto.getWarehouseAddressDto();
        if (address == null) {
            throw new BizException("\u9ed8\u8ba4\u9000\u8d27\u4ed3\u5e93\u6ca1\u6709\u7ef4\u62a4\u5730\u5740\u4fe1\u606f: " + warehouseDto.getWarehouseName());
        }
        bizAfterSaleOrderReqDto.setReturnRecipient(address.getContacts());
        bizAfterSaleOrderReqDto.setReturnAddress(address.getDetailAddress());
        bizAfterSaleOrderReqDto.setReturnAddrStreet(address.getDetailAddress());
        bizAfterSaleOrderReqDto.setReturnCityCode(address.getCityCode());
        bizAfterSaleOrderReqDto.setReturnCityName(address.getCity());
        bizAfterSaleOrderReqDto.setReturnProvinceCode(address.getProvinceCode());
        bizAfterSaleOrderReqDto.setReturnProvinceName(address.getProvince());
        bizAfterSaleOrderReqDto.setReturnCountyCode(address.getDistrictCode());
        bizAfterSaleOrderReqDto.setReturnCountyName(address.getDistrict());
        bizAfterSaleOrderReqDto.setReturnRecipientPhone(address.getPhone());
    }

    public void getPrice(String code, DgAfterSaleOrderItemModifyReqDto itemReqDto) {
        StandardPriceQueryDto standardPriceQueryDto = new StandardPriceQueryDto();
        standardPriceQueryDto.setProductCode(code);
        this.logger.info("\u65e5\u5e38\u96f6\u552e\u4ef71 : {}", (Object)JSON.toJSONString((Object)standardPriceQueryDto));
        PageInfo standardPriceDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iStandardPriceInfoQueryApi.list(standardPriceQueryDto));
        this.logger.info("\u65e5\u5e38\u96f6\u552e\u4ef72 : {}", (Object)JSON.toJSONString((Object)standardPriceDetailRespDtoPageInfo));
        if (!CollectionUtils.isEmpty((Collection)standardPriceDetailRespDtoPageInfo.getList())) {
            for (StandardPriceDetailRespDto priceDetailRespDto : standardPriceDetailRespDtoPageInfo.getList()) {
                List priceInfoDetailRespDtoList = priceDetailRespDto.getStandardPriceInfoDetailRespDtoList();
                if (!CollectionUtil.isNotEmpty((Collection)priceInfoDetailRespDtoList)) continue;
                this.logger.info("\u65e5\u5e38\u96f6\u552e\u4ef73 {}: ", (Object)JSON.toJSONString((Object)priceInfoDetailRespDtoList));
                if (CollectionUtils.isEmpty((Collection)priceInfoDetailRespDtoList)) continue;
                for (StandardPriceInfoDetailRespDto respDto : priceInfoDetailRespDtoList) {
                    if (!RETAIL_PRICE.equals(respDto.getPriceTypeId())) continue;
                    BigDecimal curPrice = respDto.getCurPrice();
                    itemReqDto.setItemPrice(curPrice);
                }
            }
        }
    }
}

