/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.base.QueryWrapBuilder;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAddrDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAddrEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderAddrService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleOrderAddrServiceImpl
implements ISaleOrderAddrService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderAddrServiceImpl.class);
    @Resource
    private IDgSaleOrderAddrDomain dgSaleOrderAddrDomain;

    @Override
    public Long addSaleOrderAddr(SaleOrderAddrReqDto addReqDto) {
        DgSaleOrderAddrEo saleOrderAddrEo = new DgSaleOrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleOrderAddrEo);
        this.dgSaleOrderAddrDomain.insert((BaseEo)saleOrderAddrEo);
        return saleOrderAddrEo.getId();
    }

    @Override
    public void modifySaleOrderAddr(SaleOrderAddrReqDto modifyReqDto) {
        DgSaleOrderAddrEo saleOrderAddrEo = new DgSaleOrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleOrderAddrEo);
        AssertUtils.notNull((Object)modifyReqDto.getOrderId(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapBuilder wrapBuilder = new QueryWrapBuilder((BaseEo)saleOrderAddrEo);
        wrapBuilder.eq("order_id", (Object)modifyReqDto.getOrderId()).builder();
        this.dgSaleOrderAddrDomain.updateSelectiveSqlFilter((BaseEo)saleOrderAddrEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrderAddr(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dgSaleOrderAddrDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SaleOrderAddrRespDto queryById(Long id) {
        DgSaleOrderAddrEo saleOrderAddrEo = (DgSaleOrderAddrEo)this.dgSaleOrderAddrDomain.selectByPrimaryKey(id);
        SaleOrderAddrRespDto saleOrderAddrRespDto = new SaleOrderAddrRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderAddrEo, (BaseVo)saleOrderAddrRespDto);
        return saleOrderAddrRespDto;
    }

    @Override
    public PageInfo<SaleOrderAddrRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SaleOrderAddrReqDto saleOrderAddrReqDto = (SaleOrderAddrReqDto)JSON.parseObject((String)filter, SaleOrderAddrReqDto.class);
        DgSaleOrderAddrEo saleOrderAddrEo = new DgSaleOrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)saleOrderAddrReqDto, (BaseEo)saleOrderAddrEo);
        PageInfo eoPageInfo = this.dgSaleOrderAddrDomain.selectPage((BaseEo)saleOrderAddrEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SaleOrderAddrRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void copyOrderAddress(Long oriSaleOrderId, Long childSaleOrderId) {
        AssertUtils.notNull((Object)oriSaleOrderId, (String)"oriSaleOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrderId, (String)"childSaleOrderId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderAddrEo::getOrderId, (Object)oriSaleOrderId);
        DgSaleOrderAddrEo orderAddrEo = (DgSaleOrderAddrEo)this.dgSaleOrderAddrDomain.getMapper().selectOne((Wrapper)queryAddrWrapper);
        DgSaleOrderAddrEo newSaleOrderAddrEo = new DgSaleOrderAddrEo();
        CubeBeanUtils.copyProperties((Object)newSaleOrderAddrEo, (Object)orderAddrEo, (String[])new String[]{"id", "create_time", "update_time"});
        newSaleOrderAddrEo.setOrderId(childSaleOrderId);
        LOGGER.info("[\u62c6\u5355]\u8bbe\u7f6e\u5b50\u8ba2\u5355\u7684\u6536\u8d27\u5730\u5740\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)newSaleOrderAddrEo));
        this.dgSaleOrderAddrDomain.insert((BaseEo)newSaleOrderAddrEo);
    }

    @Override
    public SaleOrderAddrRespDto queryAddressByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderAddrEo::getOrderId, (Object)orderId);
        DgSaleOrderAddrEo orderAddrEo = (DgSaleOrderAddrEo)this.dgSaleOrderAddrDomain.getMapper().selectOne((Wrapper)queryAddrWrapper);
        SaleOrderAddrRespDto saleOrderAddrRespDto = new SaleOrderAddrRespDto();
        DtoHelper.eo2Dto((BaseEo)orderAddrEo, (BaseVo)saleOrderAddrRespDto);
        return saleOrderAddrRespDto;
    }

    @Override
    public DgSaleOrderAddrEo queryEoAddressByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderAddrEo::getOrderId, (Object)orderId);
        DgSaleOrderAddrEo orderAddrEo = (DgSaleOrderAddrEo)this.dgSaleOrderAddrDomain.getMapper().selectOne((Wrapper)queryAddrWrapper);
        return orderAddrEo;
    }

    @Override
    public List<SaleOrderAddrRespDto> queryAddressByOrderIdList(List<Long> orderIdList) {
        AssertUtils.notEmpty(orderIdList, (String)"orderIdList \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderAddrEo::getOrderId, orderIdList);
        List saleOrderAddrEoList = this.dgSaleOrderAddrDomain.getMapper().selectList((Wrapper)queryAddrWrapper);
        ArrayList saleOrderAddrRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderAddrEoList, (Collection)saleOrderAddrRespDtoList, SaleOrderAddrRespDto.class);
        return saleOrderAddrRespDtoList;
    }
}

