/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveredOutResultInfoDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveredOutResultInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryTotalCartonsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GiftEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OriginSaleOrderEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleItemStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemSummaryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.dao.vo.SaleOrderItemSummaryVo;
import com.yunxi.dg.base.center.trade.dao.vo.SaleOrderItermChangeVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleGoodsItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleOrderItemServiceImpl
implements ISaleOrderItemService {
    private static final String EMPTY = "";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgSaleOrderItemDomain dgSaleOrderItemDomain;
    @Resource
    private ICsOutResultOrderQueryApi outResultOrderQueryApi;
    @Resource
    private IDgSaleOrderDomain dgSaleOrderDomain;
    @Resource
    private ICsDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;
    @Resource
    private ICsInventoryExposedQueryApi inventoryExposedQueryApi;
    @Resource
    private ISaleGoodsItemService saleGoodsItemService;

    @Override
    public Long addSaleOrderItem(SaleOrderItemReqDto addReqDto) {
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleOrderItemEo);
        this.dgSaleOrderItemDomain.insert((BaseEo)saleOrderItemEo);
        return saleOrderItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualAddSaleOrderItems(BizSaleOrderReqDto saleOrderReqDto) {
        AssertUtils.notNull((Object)saleOrderReqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList mergeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderReqDto.getItemList())) {
            saleOrderReqDto.getItemList().stream().forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setGift(GiftEnum.NOT_GIFT.getType()));
            mergeList.addAll(saleOrderReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)saleOrderReqDto.getGiftList())) {
            saleOrderReqDto.getGiftList().stream().forEach(saleOrderItemReqDto -> {
                this.checkOrderItem((SaleOrderItemReqDto)saleOrderItemReqDto);
                saleOrderItemReqDto.setGift(GiftEnum.GIFT.getType());
                saleOrderItemReqDto.setDiscountAmount(saleOrderItemReqDto.getItemNum().multiply(saleOrderItemReqDto.getSalePrice()));
                saleOrderItemReqDto.setPayAmount(BigDecimal.ZERO);
            });
            mergeList.addAll(saleOrderReqDto.getGiftList());
        }
        if (CollectionUtils.isNotEmpty((Collection)mergeList)) {
            mergeList.forEach(saleOrderItemReqDto -> {
                this.checkOrderItem((SaleOrderItemReqDto)saleOrderItemReqDto);
                saleOrderItemReqDto.setIsOrigin(OriginSaleOrderEnum.FALSE.getType());
                saleOrderItemReqDto.setOrderId(saleOrderReqDto.getId());
            });
            LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)saleOrderReqDto.getId());
            DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDomain.getMapper().selectOne((Wrapper)queryOrderWrapper);
            BigDecimal addItemCount = mergeList.stream().map(SaleOrderItemReqDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgSaleOrderEo updateOrderEo = new DgSaleOrderEo();
            updateOrderEo.setId(saleOrderEo.getId());
            updateOrderEo.setGoodsTotalNum(addItemCount.add(saleOrderEo.getGoodsTotalNum()));
            this.dgSaleOrderDomain.updateSelective((BaseEo)updateOrderEo);
            Long originOrderId = Optional.ofNullable(saleOrderEo.getOriginOrderId()).orElse(saleOrderEo.getId());
            ArrayList insertBatchEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)mergeList, (Collection)insertBatchEos, DgSaleOrderItemEo.class);
            this.logger.info("[\u624b\u52a8\u6dfb\u52a0\u5546\u54c1]\u6dfb\u52a0\u5546\u54c1\u5217\u8868\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)insertBatchEos));
            SaleOrderItermChangeVo saleOrderItermChangeVo = new SaleOrderItermChangeVo();
            saleOrderItermChangeVo.setSaleOrderId(saleOrderEo.getId());
            saleOrderItermChangeVo.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
            saleOrderItermChangeVo.setOriginOrderId(originOrderId);
            saleOrderItermChangeVo.setSaleOrderItemEos((List)insertBatchEos);
            this.insertBatchOrderItemAndGoodItem(saleOrderItermChangeVo);
        }
    }

    private void checkOrderItem(SaleOrderItemReqDto saleOrderItemReqDto) {
        AssertUtils.notNull((Object)saleOrderItemReqDto.getItemNum(), (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)saleOrderItemReqDto.getSalePrice(), (String)"\u5546\u54c1\u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)saleOrderItemReqDto.getSkuCode(), (String)"skucode\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#modifyOrderItemReqDto.orderId")
    @Transactional(rollbackFor={Exception.class})
    public void manualModifyOrderItem(ModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOriginalOrderGoodsId(), (String)"originalOrderGoodsId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)modifyOrderItemReqDto.getOriginalOrderGoodsId());
        DgSaleOrderItemEo oriOrderItemEo = (DgSaleOrderItemEo)this.dgSaleOrderItemDomain.getMapper().selectOne((Wrapper)queryItemEo);
        AssertUtils.notNull((Object)oriOrderItemEo, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        this.logger.info("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u539f\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)oriOrderItemEo));
        DgSaleOrderItemEo newOrderItemEo = new DgSaleOrderItemEo();
        CubeBeanUtils.copyProperties((Object)newOrderItemEo, (Object)oriOrderItemEo, (String[])new String[0]);
        newOrderItemEo.setItemNum(oriOrderItemEo.getItemNum());
        newOrderItemEo.setIsOrigin(OriginSaleOrderEnum.FALSE.getType());
        newOrderItemEo.setSkuCode(modifyOrderItemReqDto.getSkuCode());
        newOrderItemEo.setSkuName(modifyOrderItemReqDto.getSkuName());
        newOrderItemEo.setItemName(modifyOrderItemReqDto.getItemName());
        newOrderItemEo.setSalePrice(modifyOrderItemReqDto.getSalePrice());
        if (GiftEnum.GIFT.getType().equals(oriOrderItemEo.getGift())) {
            newOrderItemEo.setDiscountAmount(modifyOrderItemReqDto.getSalePrice().multiply(oriOrderItemEo.getItemNum()));
        }
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)modifyOrderItemReqDto.getOrderId());
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDomain.getMapper().selectOne((Wrapper)queryOrderWrapper);
        Long originOrderId = Optional.ofNullable(saleOrderEo.getOriginOrderId()).orElse(saleOrderEo.getId());
        SaleOrderItermChangeVo saleOrderItermChangeVo = new SaleOrderItermChangeVo();
        saleOrderItermChangeVo.setOriginOrderId(originOrderId);
        saleOrderItermChangeVo.setSaleOrderId(saleOrderEo.getId());
        saleOrderItermChangeVo.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        saleOrderItermChangeVo.setSaleOrderItemEos((List)Lists.newArrayList((Object[])new DgSaleOrderItemEo[]{newOrderItemEo}));
        this.insertBatchOrderItemAndGoodItem(saleOrderItermChangeVo);
        this.removeOrderItemAndGoodsItem(modifyOrderItemReqDto.getOriginalOrderGoodsId());
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#modifyOrderItemReqDto.orderId")
    @Transactional(rollbackFor={Exception.class})
    public List<Long> manualModifyOrderItemBySkucode(ModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOrderId(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)modifyOrderItemReqDto.getReplaceSkuCode(), (String)"replaceSkuCode \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getIfGift(), (String)"ifGift \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getSkuCode, (Object)modifyOrderItemReqDto.getReplaceSkuCode())).eq(DgSaleOrderItemEo::getOrderId, (Object)modifyOrderItemReqDto.getOrderId())).eq(DgSaleOrderItemEo::getGift, (Object)(modifyOrderItemReqDto.getIfGift() != false ? GiftEnum.GIFT.getType() : GiftEnum.NOT_GIFT.getType()));
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        if (CollectionUtils.isNotEmpty((Collection)saleOrderItemEos)) {
            saleOrderItemEos.forEach(item -> {
                ModifyOrderItemReqDto changeItemReq = new ModifyOrderItemReqDto();
                CubeBeanUtils.copyProperties((Object)changeItemReq, (Object)modifyOrderItemReqDto, (String[])new String[0]);
                changeItemReq.setOriginalOrderGoodsId(item.getId());
                this.manualModifyOrderItem(changeItemReq);
            });
        } else {
            this.logger.info("[\u901a\u8fc7skucode\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4e0d\u5b58\u5728skucode={}\u7684\u5546\u54c1", (Object)modifyOrderItemReqDto.getOrderId(), (Object)modifyOrderItemReqDto.getReplaceSkuCode());
        }
        List<Long> suitOrderIds = saleOrderItemEos.stream().map(DgSaleOrderItemEo::getOrderId).distinct().collect(Collectors.toList());
        return suitOrderIds;
    }

    @Override
    public void modifySaleOrderItem(SaleOrderItemReqDto modifyReqDto) {
        DgSaleOrderItemEo sale;
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleOrderItemEo);
        if (ObjectUtil.isNotEmpty((Object)saleOrderItemEo.getId()) && ObjectUtil.isNotEmpty((Object)(sale = (DgSaleOrderItemEo)this.dgSaleOrderItemDomain.selectByPrimaryKey(saleOrderItemEo.getId()))) && StringUtils.isNotBlank((CharSequence)sale.getExtension()) && StringUtils.isNotBlank((CharSequence)saleOrderItemEo.getExtension())) {
            Map map = (Map)JSON.parseObject((String)sale.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            Map addMap = (Map)JSON.parseObject((String)saleOrderItemEo.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            map.putAll(addMap);
            saleOrderItemEo.setExtension(JSON.toJSONString((Object)map));
        }
        this.dgSaleOrderItemDomain.updateSelective((BaseEo)saleOrderItemEo);
    }

    @Override
    public int optimisticModifySaleOrderItem(DgSaleOrderItemEo saleOrderItemEo, LambdaQueryWrapper<DgSaleOrderItemEo> updateQueryWrapper, int idealCount, Integer needChangeItemNum, boolean needThrow) {
        this.logger.info("optimisticModifySaleOrderItem\u5165\u53c2saleOrderItemEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderItemEo), JSON.toJSONString(updateQueryWrapper), idealCount, needThrow});
        if (updateQueryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgSaleOrderItemEo)updateQueryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.dgSaleOrderItemDomain.setUpdateSystemFields(saleOrderItemEo);
        int optCount = this.dgSaleOrderItemDomain.getMapper().update((Object)saleOrderItemEo, updateQueryWrapper);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
        modifyGoodsItemRowVo.setQuerySaleOrderId(((DgSaleOrderItemEo)updateQueryWrapper.getEntity()).getOrderId());
        modifyGoodsItemRowVo.setQueryBelongOrderItemId(((DgSaleOrderItemEo)updateQueryWrapper.getEntity()).getId());
        modifyGoodsItemRowVo.setChangeNum(needChangeItemNum);
        modifyGoodsItemRowVo.setStatus(saleOrderItemEo.getStatus());
        modifyGoodsItemRowVo.setRefundStatus(saleOrderItemEo.getRefundStatus());
        this.saleGoodsItemService.modifyGoodsItems(modifyGoodsItemRowVo);
        return optCount;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#saleOrderId")
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrderItem(Long saleOrderId, Long id) {
        AssertUtils.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgSaleOrderItemEo saleOrderItemEo = (DgSaleOrderItemEo)this.dgSaleOrderItemDomain.getMapper().selectOne((Wrapper)queryItemWrapper);
        AssertUtils.notNull((Object)saleOrderItemEo, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        if (OriginSaleOrderEnum.TRUE.getType().equals(saleOrderItemEo.getIsOrigin()) || GiftEnum.NOT_GIFT.getType().equals(saleOrderItemEo.getGift())) {
            this.logger.warn("[\u5220\u9664\u5546\u54c1]\u5f53\u524d\u8ba2\u5355\u5546\u54c1\u5c5e\u4e8e\u539f\u5355\u5546\u54c1\u6216\u8005\u975e\u8d60\u54c1\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u5546\u54c1\u884cid={}", (Object)id);
            throw PcpTradeExceptionCode.REMOVE_GOOD_IEM_FAIL.builderException();
        }
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.queryOrderItemByOrderId(saleOrderId);
        BigDecimal remainTotalItemCount = saleOrderItemRespDtos.stream().map(SaleOrderItemRespDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        DgSaleOrderEo updateOrderEo = new DgSaleOrderEo();
        updateOrderEo.setId(saleOrderId);
        updateOrderEo.setGoodsTotalNum(remainTotalItemCount);
        this.dgSaleOrderDomain.updateSelective((BaseEo)updateOrderEo);
        this.removeOrderItemAndGoodsItem(id);
    }

    @Override
    public SaleOrderItemRespDto queryById(Long id) {
        DgSaleOrderItemEo saleOrderItemEo = (DgSaleOrderItemEo)this.dgSaleOrderItemDomain.selectByPrimaryKey(id);
        SaleOrderItemRespDto saleOrderItemRespDto = new SaleOrderItemRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderItemEo, (BaseVo)saleOrderItemRespDto);
        return saleOrderItemRespDto;
    }

    @Override
    public PageInfo<SaleOrderItemExtRespDto> queryByPage(Long orderId, Integer pageNum, Integer pageSize) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        saleOrderItemEo.setOrderId(orderId);
        saleOrderItemEo.setOrderBy("sku_code");
        PageInfo eoPageInfo = this.dgSaleOrderItemDomain.selectPage((BaseEo)saleOrderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<SaleOrderItemExtRespDto> dtoList = new ArrayList<SaleOrderItemExtRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SaleOrderItemExtRespDto.class);
        LambdaQueryWrapper querySaleOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)querySaleOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)orderId);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDomain.getMapper().selectOne((Wrapper)querySaleOrderWrapper);
        AssertUtils.notNull((Object)saleOrderEo, (String)String.format("orderId=%s\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        this.fillItemInfo(dtoList, saleOrderEo);
        this.logger.info("[\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8d27\u54c1\u4fe1\u606f]\u586b\u5145\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\u540e\u7684\u5546\u54c1\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString(dtoList));
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void fillItemInfo(List<SaleOrderItemExtRespDto> dtoList, DgSaleOrderEo saleOrderEo) {
        RestResponse deliveredOutResultInfoRespDto = this.outResultOrderQueryApi.queryDeliveredInfo(saleOrderEo.getSaleOrderNo());
        CsDeliveredOutResultInfoRespDto outResultInfoRespDto = (CsDeliveredOutResultInfoRespDto)RestResponseHelper.extractData((RestResponse)deliveredOutResultInfoRespDto);
        List deliveredOutResultInfoDetailRespDtoList = outResultInfoRespDto.getCsDeliveredOutResultInfoDetailRespDtoList();
        this.logger.info("[\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8d27\u54c1\u4fe1\u606f]\u8d27\u54c1\u51fa\u5e93\u8be6\u60c5\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)deliveredOutResultInfoDetailRespDtoList));
        Map detailRespDtoMap = Optional.ofNullable(deliveredOutResultInfoDetailRespDtoList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(CsDeliveredOutResultInfoDetailRespDto::getLongCode, Function.identity(), (v1, v2) -> v2));
        List skuCodeList = dtoList.stream().map(SaleOrderItemRespDto::getSkuCode).collect(Collectors.toList());
        List longCodeList = dtoList.stream().map(SaleOrderItemRespDto::getSkuCode).collect(Collectors.toList());
        CsInventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new CsInventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{saleOrderEo.getDefaultLogicalWarehouseCode()}));
        inventoryBasicsQueryReqDto.setLongCodeList(longCodeList);
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        RestResponse commonInventory = this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto);
        List inventoryBasicsQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)commonInventory);
        Map longCodeInventoryCountMap = Optional.ofNullable(inventoryBasicsQueryRespDtos).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(CsInventoryBasicsQueryRespDto::getLongCode, Function.identity(), (v1, v2) -> v2));
        dtoList.forEach(saleOrderItemRespDto -> {
            CsInventoryBasicsQueryRespDto basicsQueryRespDto;
            CsDeliveredOutResultInfoDetailRespDto outResultInfoDetailRespDto = (CsDeliveredOutResultInfoDetailRespDto)detailRespDtoMap.get(saleOrderItemRespDto.getSkuCode());
            if (outResultInfoDetailRespDto != null) {
                saleOrderItemRespDto.setOutItemNum(outResultInfoDetailRespDto.getQuantity());
            }
            if ((basicsQueryRespDto = (CsInventoryBasicsQueryRespDto)longCodeInventoryCountMap.get(saleOrderItemRespDto.getSkuCode())) != null) {
                saleOrderItemRespDto.setAvailableInventory(basicsQueryRespDto.getAvailable());
            }
        });
    }

    @Override
    public SaleOrderItemSummaryRespDto querySummary(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SaleOrderItemSummaryVo saleOrderItemSummaryVo = this.dgSaleOrderItemDomain.querySummary(orderId);
        SaleOrderItemSummaryRespDto saleOrderItemSummaryRespDto = new SaleOrderItemSummaryRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderItemSummaryRespDto, (Object)saleOrderItemSummaryVo, (String[])new String[0]);
        CsDeliveryTotalCartonsRespDto deliveryResultOrderRespDto = this.getDeliveryResultOrderRespDto(orderId);
        this.logger.info("[\u5546\u54c1\u6e05\u5355\u6c47\u603b]\u67e5\u8be2\u5230\u5e93\u5b58\u7684\u603b\u7bb1\u6570\u548c\u62fc\u7bb1\u6570\uff1a{}", (Object)JSON.toJSONString((Object)deliveryResultOrderRespDto));
        saleOrderItemSummaryRespDto.setTotalBoxNum(deliveryResultOrderRespDto.getTotalCartons());
        saleOrderItemSummaryRespDto.setJoinBoxNum(deliveryResultOrderRespDto.getMergeQuantity());
        return saleOrderItemSummaryRespDto;
    }

    @Override
    public void createSplitOrderItem(DgSaleOrderEo oriSaleOrder, DgSaleOrderEo childSaleOrder, List<SplitOrderItemReqDto> goodsList) {
        AssertUtils.notNull((Object)oriSaleOrder, (String)"oriSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrder, (String)"childSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty(goodsList, (String)"goodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.debug("[\u62c6\u5355]\u5f00\u59cb\u62c6\u8ba2\u5355\u5546\u54c1\uff0c\u8bf7\u6c42\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(goodsList));
        LambdaQueryWrapper queryOrderItemWapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)oriSaleOrder.getId());
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWapper);
        AssertUtils.notEmpty((Collection)orderItemEos, (String)String.format("saleOrderId=%s\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728", oriSaleOrder.getId()));
        Map skusMap = orderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Long, BigDecimal> skusItemMap = orderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, DgSaleOrderItemEo::getItemNum));
        goodsList.forEach(splitOrderItemReqDto -> {
            DgSaleOrderItemEo orderItemEo = (DgSaleOrderItemEo)skusMap.get(splitOrderItemReqDto.getOriginalOrderGoodsId());
            if (Objects.isNull(orderItemEo)) {
                this.logger.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08saleOrderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)oriSaleOrder, (Object)splitOrderItemReqDto.getGoodsSku());
                AssertUtils.notNull((Object)orderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            DgSaleOrderItemEo splitOrderitemEo = new DgSaleOrderItemEo();
            CubeBeanUtils.copyProperties((Object)splitOrderitemEo, (Object)orderItemEo, (String[])new String[]{"id"});
            if (orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()).compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355(skucode={})\u5269\u4f59\u5546\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{orderItemEo.getSkuCode(), orderItemEo.getItemNum(), splitOrderItemReqDto.getGoodsNum()});
                throw PcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
            splitOrderitemEo.setItemNum(splitOrderItemReqDto.getGoodsNum());
            orderItemEo.setItemNum(orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()));
            if (splitOrderitemEo.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.info("[\u624b\u52a8\u62c6\u5355]\u5546\u54c1\u6570\u91cf\u4e3a0\u4e0d\u751f\u4ea7\u5546\u54c1\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderItemReqDto));
                return;
            }
            BigDecimal origItemNum = (BigDecimal)skusItemMap.get(splitOrderItemReqDto.getOriginalOrderGoodsId());
            splitOrderitemEo.setOrderId(childSaleOrder.getId());
            splitOrderitemEo.setOriginalOrderItemId(orderItemEo.getId());
            splitOrderitemEo.setLogicalWarehouseId(childSaleOrder.getLogicalWarehouseId());
            splitOrderitemEo.setLogicalWarehouseCode(childSaleOrder.getLogicalWarehouseCode());
            splitOrderitemEo.setLogicalWarehouseName(childSaleOrder.getLogicalWarehouseName());
            splitOrderitemEo.setDeliveryItemBatchNo(splitOrderItemReqDto.getBatch());
            if (orderItemEo.getVolume() != null && orderItemEo.getVolume().compareTo(BigDecimal.ZERO) > 0) {
                splitOrderitemEo.setVolume(orderItemEo.getVolume());
                if (orderItemEo.getItemNum().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal itemVolume = orderItemEo.getVolume().divide(origItemNum, 6, RoundingMode.HALF_UP);
                    this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u524dskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{},\u5355\u4e2a\u5546\u54c1\u4f53\u79ef:{},\u5546\u54c1\u6570\u91cf:{}", new Object[]{orderItemEo.getSkuCode(), orderItemEo.getVolume(), itemVolume, origItemNum});
                    BigDecimal newVolume = itemVolume.multiply(splitOrderItemReqDto.getGoodsNum());
                    splitOrderitemEo.setVolume(newVolume);
                    this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{},\u62c6\u5206\u540e\u6570\u91cf:{}", new Object[]{orderItemEo.getSkuCode(), newVolume, splitOrderItemReqDto.getGoodsNum()});
                }
            }
            if (orderItemEo.getWeight() != null && orderItemEo.getWeight().compareTo(BigDecimal.ZERO) > 0) {
                splitOrderitemEo.setWeight(orderItemEo.getWeight());
                if (orderItemEo.getItemNum().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal itemWeight = orderItemEo.getWeight().divide(origItemNum, 6, RoundingMode.HALF_UP);
                    this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u524dskucode={}\u7684\u91cd\u91cf\u4e3a\uff1a{},\u5355\u4e2a\u5546\u54c1\u91cd\u91cf:{},\u5546\u54c1\u6570\u91cf:{}", new Object[]{orderItemEo.getSkuCode(), orderItemEo.getWeight(), itemWeight, origItemNum});
                    BigDecimal newWeight = itemWeight.multiply(splitOrderItemReqDto.getGoodsNum());
                    splitOrderitemEo.setWeight(newWeight);
                    this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u91cd\u91cf\u4e3a\uff1a{},\u62c6\u5206\u540e\u6570\u91cf:{}", new Object[]{orderItemEo.getSkuCode(), newWeight, splitOrderItemReqDto.getGoodsNum()});
                }
            }
            if (orderItemEo.getLineAmount() != null && orderItemEo.getSalePrice() != null) {
                splitOrderitemEo.setLineAmount(orderItemEo.getSalePrice().multiply(splitOrderItemReqDto.getGoodsNum()));
            }
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal orderTotalAmount = BigDecimal.ZERO;
            splitOrderitemEo.setPayAmount(payAmount);
            splitOrderitemEo.setOrderTotalAmount(orderTotalAmount);
            this.dgSaleOrderItemDomain.insert((BaseEo)splitOrderitemEo);
            this.logger.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5206\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderItemReqDto));
        });
    }

    private void modifyGoodsItemRelation(DgSaleOrderItemEo childSaleOrderItemEo, DgSaleOrderEo childSaleOrder, SplitOrderItemReqDto splitOrderItemReqDto, DgSaleOrderEo oriSaleOrder) {
        ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
        modifyGoodsItemRowVo.setOrderItemId(childSaleOrderItemEo.getId());
        modifyGoodsItemRowVo.setOrderId(childSaleOrder.getId());
        modifyGoodsItemRowVo.setOrderNo(childSaleOrder.getSaleOrderNo());
        modifyGoodsItemRowVo.setChangeNum(Integer.valueOf(childSaleOrderItemEo.getItemNum().intValue()));
        modifyGoodsItemRowVo.setQueryBelongOrderItemId(splitOrderItemReqDto.getOriginalOrderGoodsId());
        modifyGoodsItemRowVo.setQuerySaleOrderId(oriSaleOrder.getId());
        this.saleGoodsItemService.modifyGoodsItemRelation(modifyGoodsItemRowVo);
    }

    @Override
    public void recalculateChildOrderPayAmount(DgSaleOrderEo oldSaleOrder, List<DgSaleOrderEo> childDgSaleOrderEos) {
        LambdaQueryWrapper queryOrderItemWapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)oldSaleOrder.getId());
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWapper);
        Map oriOrderItemMap = orderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List childOrderIds = childDgSaleOrderEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderItemEo::getOrderId, childOrderIds);
        List childOrderItems = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)childOrderItems)) {
            HashSet markOldOrderItemIds = Sets.newHashSet();
            Map<Long, List<DgSaleOrderItemEo>> orderItemGroup = childOrderItems.stream().collect(Collectors.groupingBy(DgSaleOrderItemEo::getOrderId));
            for (Map.Entry<Long, List<DgSaleOrderItemEo>> entry : orderItemGroup.entrySet()) {
                BigDecimal childOrderPayAmount = BigDecimal.ZERO;
                BigDecimal childDiscountAmount = BigDecimal.ZERO;
                for (DgSaleOrderItemEo childOrderItemEo : entry.getValue()) {
                    if (childOrderItemEo.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
                        this.logger.info("\u5546\u54c1\u6570\u91cf\u4e3a0\u4e0d\u8ba1\u7b97\u91d1\u989d,skuCode:{}", (Object)childOrderItemEo.getSkuCode());
                        continue;
                    }
                    DgSaleOrderItemEo oldOrderItemEo = (DgSaleOrderItemEo)oriOrderItemMap.get(childOrderItemEo.getOriginalOrderItemId());
                    AssertUtils.notNull((Object)oldOrderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
                    BigDecimal oldItemPayAmount = oldOrderItemEo.getPayAmount() == null ? BigDecimal.ZERO : oldOrderItemEo.getPayAmount();
                    BigDecimal oldItemAmount = oldItemPayAmount.divide(oldOrderItemEo.getItemNum(), 6, RoundingMode.HALF_UP);
                    BigDecimal discountAmount = Optional.ofNullable(oldOrderItemEo.getDiscountAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal singleDiscountAmount = discountAmount.divide(oldOrderItemEo.getItemNum(), 6, RoundingMode.HALF_UP);
                    BigDecimal easOrderTotalAmount = oldOrderItemEo.getEasOrderTotalAmount() == null ? BigDecimal.ZERO : oldOrderItemEo.getEasOrderTotalAmount();
                    BigDecimal oldEasOrderTotalAmount = easOrderTotalAmount.divide(oldOrderItemEo.getItemNum(), 6, RoundingMode.HALF_UP);
                    BigDecimal easPromotionActivityAmount = oldOrderItemEo.getEasPromotionActivityAmount() == null ? BigDecimal.ZERO : oldOrderItemEo.getEasPromotionActivityAmount();
                    BigDecimal oldEasPromotionActivityAmount = easPromotionActivityAmount.divide(oldOrderItemEo.getItemNum(), 6, RoundingMode.HALF_UP);
                    BigDecimal easSaleRebateAmount = oldOrderItemEo.getEasSaleRebateAmount() == null ? BigDecimal.ZERO : oldOrderItemEo.getEasSaleRebateAmount();
                    BigDecimal oldEasSaleRebateAmount = easSaleRebateAmount.divide(oldOrderItemEo.getItemNum(), 6, RoundingMode.HALF_UP);
                    BigDecimal newPayAmount = null;
                    BigDecimal newDiscountAmount = null;
                    BigDecimal newEasOrderTotalAmount = BigDecimal.ZERO;
                    BigDecimal newEasPromotionActivityAmount = BigDecimal.ZERO;
                    BigDecimal newEasSaleRebateAmount = BigDecimal.ZERO;
                    if (!markOldOrderItemIds.contains(childOrderItemEo.getOriginalOrderItemId())) {
                        newPayAmount = oldItemPayAmount.subtract(oldItemAmount.multiply(oldOrderItemEo.getItemNum().subtract(childOrderItemEo.getItemNum())));
                        newDiscountAmount = discountAmount.subtract(singleDiscountAmount.multiply(oldOrderItemEo.getItemNum().subtract(childOrderItemEo.getItemNum())));
                        newEasOrderTotalAmount = easOrderTotalAmount.subtract(oldEasOrderTotalAmount.multiply(oldOrderItemEo.getItemNum().subtract(childOrderItemEo.getItemNum())));
                        newEasPromotionActivityAmount = easPromotionActivityAmount.subtract(oldEasPromotionActivityAmount.multiply(oldOrderItemEo.getItemNum().subtract(childOrderItemEo.getItemNum())));
                        newEasSaleRebateAmount = easSaleRebateAmount.subtract(oldEasSaleRebateAmount.multiply(oldOrderItemEo.getItemNum().subtract(childOrderItemEo.getItemNum())));
                        markOldOrderItemIds.add(childOrderItemEo.getOriginalOrderItemId());
                    } else {
                        newPayAmount = oldItemAmount.multiply(childOrderItemEo.getItemNum());
                        newDiscountAmount = singleDiscountAmount.multiply(childOrderItemEo.getItemNum());
                        newEasOrderTotalAmount = oldEasOrderTotalAmount.multiply(childOrderItemEo.getItemNum());
                        newEasPromotionActivityAmount = oldEasPromotionActivityAmount.multiply(childOrderItemEo.getItemNum());
                        newEasSaleRebateAmount = oldEasSaleRebateAmount.multiply(childOrderItemEo.getItemNum());
                    }
                    BigDecimal transactionPrice = new BigDecimal(0);
                    if (childOrderItemEo.getItemNum().compareTo(new BigDecimal(0)) > 0) {
                        transactionPrice = newPayAmount.divide(childOrderItemEo.getItemNum(), 6, RoundingMode.HALF_UP);
                    }
                    childOrderPayAmount = childOrderPayAmount.add(newPayAmount);
                    childDiscountAmount = childDiscountAmount.add(newDiscountAmount);
                    childOrderItemEo.setPayAmount(newPayAmount);
                    childOrderItemEo.setDiscountAmount(newDiscountAmount);
                    childOrderItemEo.setTransactionPrice(transactionPrice);
                    childOrderItemEo.setEasOrderTotalAmount(newEasOrderTotalAmount);
                    childOrderItemEo.setEasPromotionActivityAmount(newEasPromotionActivityAmount);
                    childOrderItemEo.setEasSaleRebateAmount(newEasSaleRebateAmount);
                    DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
                    updateItemEo.setId(childOrderItemEo.getId());
                    updateItemEo.setPayAmount(newPayAmount);
                    updateItemEo.setDiscountAmount(newDiscountAmount);
                    updateItemEo.setTransactionPrice(transactionPrice);
                    updateItemEo.setEasOrderTotalAmount(newEasOrderTotalAmount);
                    updateItemEo.setEasPromotionActivityAmount(newEasPromotionActivityAmount);
                    updateItemEo.setEasSaleRebateAmount(newEasSaleRebateAmount);
                    this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
                }
                DgSaleOrderEo updateOrderItemEo = new DgSaleOrderEo();
                updateOrderItemEo.setId(entry.getKey());
                updateOrderItemEo.setPayAmount(childOrderPayAmount);
                updateOrderItemEo.setDiscountAmount(childDiscountAmount);
                this.dgSaleOrderDomain.updateSelective((BaseEo)updateOrderItemEo);
            }
        }
    }

    private CsDeliveryTotalCartonsRespDto getDeliveryResultOrderRespDto(Long orderId) {
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDomain.selectByPrimaryKey(orderId);
        AssertUtils.notNull((Object)saleOrderEo, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        RestResponse totalCartonsRespDtoRestResponse = this.deliveryResultOrderQueryApi.queryTotalCartons(saleOrderEo.getSaleOrderNo());
        CsDeliveryTotalCartonsRespDto deliveryTotalCartonsRespDto = (CsDeliveryTotalCartonsRespDto)RestResponseHelper.extractData((RestResponse)totalCartonsRespDtoRestResponse);
        return deliveryTotalCartonsRespDto;
    }

    @Override
    public void insertBatchItemEo(SaleOrderItermChangeVo saleOrderItermChangeVo) {
        AssertUtils.notEmpty((Collection)saleOrderItermChangeVo.getSaleOrderItemEos(), (String)"\u8ba2\u5355\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.dgSaleOrderItemDomain.insertBatch(saleOrderItermChangeVo.getSaleOrderItemEos());
        this.saleGoodsItemService.saveGoodsItems(saleOrderItermChangeVo);
    }

    @Override
    public List<SaleOrderItemRespDto> queryOrderItemByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List list = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleOrderItemRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)list, (Collection)saleOrderItemRespDtos, SaleOrderItemRespDto.class);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgSaleOrderItemEo> queryEoOrderItemByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List list = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        return list;
    }

    @Override
    public List<DgSaleOrderItemEo> queryEoOrderItemByOrderIds(List<Long> orderIds) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(orderIds), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderItemEo::getOrderId, orderIds);
        List list = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        return list;
    }

    @Override
    public List<SaleOrderItemRespDto> queryOrderItemByOrderItemIds(Long orderId, List<Long> orderItemIds) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(orderItemIds, (String)"orderItemIds \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId)).in(BaseEo::getId, orderItemIds);
        List list = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleOrderItemRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)list, (Collection)saleOrderItemRespDtos, SaleOrderItemRespDto.class);
        return saleOrderItemRespDtos;
    }

    public void removeOrderItemAndGoodsItem(Long saleOrderItemId) {
        DgSaleOrderItemEo removeEo = new DgSaleOrderItemEo();
        removeEo.setId(saleOrderItemId);
        this.dgSaleOrderItemDomain.logicDelete((BaseEo)removeEo);
        ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
        modifyGoodsItemRowVo.setQueryBelongOrderItemId(saleOrderItemId);
        this.saleGoodsItemService.removeOrderItem(modifyGoodsItemRowVo);
    }

    public void insertBatchOrderItemAndGoodItem(SaleOrderItermChangeVo saleOrderItermChangeVo) {
        AssertUtils.notEmpty((Collection)saleOrderItermChangeVo.getSaleOrderItemEos(), (String)"\u8ba2\u5355\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        saleOrderItermChangeVo.getSaleOrderItemEos().forEach(saleOrderItemEo -> saleOrderItemEo.setId(null));
        this.dgSaleOrderItemDomain.insertBatch(saleOrderItermChangeVo.getSaleOrderItemEos());
        this.saleGoodsItemService.saveGoodsItems(saleOrderItermChangeVo);
    }

    @Override
    public List<SaleOrderItemRespDto> queryNormalItems(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderId)).eq(DgSaleOrderItemEo::getStatus, (Object)SaleItemStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isNotEmpty(skuCodeList)) {
            queryOrderItemWrapper.in(DgSaleOrderItemEo::getSkuCode, skuCodeList);
        }
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderItemEos, (Collection)resultList, SaleOrderItemRespDto.class);
        return resultList;
    }

    @Override
    public List<SaleOrderItemRespDto> queryNormalItemsByOrderIds(List<Long> orderIdList) {
        AssertUtils.notEmpty(orderIdList, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderItemEo::getOrderId, orderIdList)).eq(DgSaleOrderItemEo::getStatus, (Object)SaleItemStatusEnum.NORMAL.getCode());
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderItemEos, (Collection)resultList, SaleOrderItemRespDto.class);
        return resultList;
    }

    @Override
    public void modifyOrderItemAmount(List<SaleOrderItemReqDto> saleOrderItemReqDtos) {
        AssertUtils.notEmpty(saleOrderItemReqDtos, (String)"saleOrderItemReqDtos \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList saleOrderItemEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(saleOrderItemReqDtos, (Collection)saleOrderItemEos, DgSaleOrderItemEo.class);
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)saleOrderItemEo);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#saleOrderId")
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrderItemBatchNo(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderId);
        List itemEoList = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)itemEoList, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        for (DgSaleOrderItemEo itemEo : itemEoList) {
            if (StringUtils.isEmpty((CharSequence)itemEo.getDeliveryItemBatchNo())) continue;
            DgSaleOrderItemEo updateOrderItemEo = new DgSaleOrderItemEo();
            updateOrderItemEo.setId(itemEo.getId());
            updateOrderItemEo.setDeliveryItemBatchNo(EMPTY);
            updateOrderItemEo.setBatchNo(EMPTY);
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateOrderItemEo);
        }
    }
}

