/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.proxy.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.ClueTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.source.dto.extend.OrderAddrReqDto;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemReqDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultReqDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.source.proxy.option.IOrderOptApiProxy;
import com.yunxi.dg.base.center.trade.action.IDgPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.proxy.IDgSourceApiService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgSourceApiServiceImpl
implements IDgSourceApiService {
    private static final Logger log = LoggerFactory.getLogger(DgSourceApiServiceImpl.class);
    @Resource
    private IOrderOptApiProxy orderOptApi;
    @Resource
    private ISourceRecordDomain sourceRecordService;
    @Resource
    private IDgPerformOrderOptAction performOrderOptAction;
    @Value(value="${oms.source.split.tagCode:TAG202209010066}")
    private String splitTagCode;

    @Override
    public SourceOrderResultRespDto searchSource(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList, DgPerformOrderAddrDto saleOrderAddrRespDto) {
        log.info("[\u5bfb\u6e90]\u5f00\u59cb\u5bfb\u6e90");
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        SourceOrderResultReqDto sourceOrderResultReqDto = new SourceOrderResultReqDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultReqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setId(null);
        sourceOrderResultReqDto.setLinkOrderNo(saleOrderRespDto.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(saleOrderRespDto.getOrderType());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(saleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkOrderChannelCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelId());
        sourceOrderResultReqDto.setLinkOrderCustomerId(saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerId());
        sourceOrderResultReqDto.setLinkOrderCustomerName(saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerName());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(saleOrderRespDto.getDefaultLogicalWarehouseId());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrderRespDto.getDefaultLogicalWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(saleOrderRespDto.getDefaultLogicalWarehouseName());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(saleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkOrderChannelName(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelName());
        sourceOrderResultReqDto.setSgSourceCanSplit(saleOrderRespDto.getAllowSplitFlag());
        sourceOrderResultReqDto.setSgType(ClueTypeEnum.WAREHOUSE.getCode());
        sourceOrderResultReqDto.setLinkShopId(saleOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        sourceOrderResultReqDto.setShipmentEnterpriseCode(saleOrderRespDto.getShipmentEnterpriseCode());
        OrderAddrReqDto orderAddrReqDto = new OrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)saleOrderAddrRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrReqDto(orderAddrReqDto);
        sourceOrderResultReqDto.setLinkOrderSnapshot(JSON.toJSONString((Object)saleOrderRespDto));
        List orderItemReqDtoList = saleOrderItemRespDtoList.stream().map(saleOrderItemExtRespDto -> {
            OrderItemReqDto orderItemReqDto = new OrderItemReqDto();
            CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
            orderItemReqDto.setLinkOrderItemId(saleOrderItemExtRespDto.getId());
            orderItemReqDto.setItemSkuCode(saleOrderItemExtRespDto.getSkuCode());
            orderItemReqDto.setItemBatchNo(saleOrderItemExtRespDto.getBatchNo());
            return orderItemReqDto;
        }).collect(Collectors.toList());
        sourceOrderResultReqDto.setOrderItemReqDtoList(orderItemReqDtoList);
        log.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
        RestResponse sourceOrderResultRespDtoRestResp = this.orderOptApi.addSourceOrder(sourceOrderResultReqDto);
        SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)sourceOrderResultRespDtoRestResp);
        log.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        return sourceOrderResultRespDto;
    }

    private void temporaryDemand(SourceOrderResultRespDto sourceOrderResultRespDto, DgPerformOrderRespDto saleOrderRespDto) {
        try {
            if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceOrderResultRespDto.getSgStatus()) && "\u62c6\u5355\u6570\u91cf\u8d85\u8fc7\u7b56\u7565\u914d\u7f6e".equals(sourceOrderResultRespDto.getSgFailResultDesc())) {
                DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
                orderTagRecordReqDto.setOrderId(saleOrderRespDto.getId());
                orderTagRecordReqDto.setTagCode(this.splitTagCode);
                this.performOrderOptAction.manualAddTag(saleOrderRespDto, orderTagRecordReqDto);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public SourceOrderResultRespDto shippingSearchSource(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList, DgPerformOrderAddrDto saleOrderAddrRespDto) {
        log.info("[\u7269\u6d41\u5bfb\u6e90]\u5f00\u59cb\u7269\u6d41\u5bfb\u6e90");
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        SourceOrderResultReqDto sourceOrderResultReqDto = new SourceOrderResultReqDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultReqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setId(null);
        sourceOrderResultReqDto.setLinkOrderNo(saleOrderRespDto.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(saleOrderRespDto.getOrderType());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(saleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkOrderChannelCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelId());
        sourceOrderResultReqDto.setLinkOrderCustomerId(saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerId());
        sourceOrderResultReqDto.setLinkOrderCustomerName(saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerName());
        if (StringUtils.isNotEmpty((CharSequence)saleOrderRespDto.getLogicalWarehouseCode())) {
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(saleOrderRespDto.getLogicalWarehouseId());
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(saleOrderRespDto.getLogicalWarehouseName());
        } else {
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrderRespDto.getDeliveryLogicalWarehouseCode());
        }
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(saleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkOrderChannelName(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelName());
        sourceOrderResultReqDto.setSgSourceCanSplit(saleOrderRespDto.getAllowSplitFlag());
        sourceOrderResultReqDto.setSgType(ClueTypeEnum.SHIPMENT.getCode());
        sourceOrderResultReqDto.setLinkShopId(saleOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        OrderAddrReqDto orderAddrReqDto = new OrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)saleOrderAddrRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrReqDto(orderAddrReqDto);
        sourceOrderResultReqDto.setLinkOrderSnapshot(JSON.toJSONString((Object)saleOrderRespDto));
        sourceOrderResultReqDto.setMerchantReceivableAmount(saleOrderRespDto.getMerchantReceivableAmount());
        sourceOrderResultReqDto.setMerchantOriginReceivableAmount(saleOrderRespDto.getMerchantOriginReceivableAmount());
        List orderItemReqDtoList = saleOrderItemRespDtoList.stream().map(saleOrderItemExtRespDto -> {
            OrderItemReqDto orderItemReqDto = new OrderItemReqDto();
            CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
            orderItemReqDto.setLinkOrderItemId(saleOrderItemExtRespDto.getId());
            orderItemReqDto.setItemSkuCode(saleOrderItemExtRespDto.getSkuCode());
            orderItemReqDto.setItemBatchNo(saleOrderItemExtRespDto.getBatchNo());
            orderItemReqDto.setItemBackCategoryOneCode(saleOrderItemExtRespDto.getItemBackCategoryOneCode());
            orderItemReqDto.setItemBackCategoryTwoCode(saleOrderItemExtRespDto.getItemBackCategoryTwoCode());
            orderItemReqDto.setItemBackCategoryThirdCode(saleOrderItemExtRespDto.getItemBackCategoryThirdCode());
            orderItemReqDto.setItemBackCategoryFourthCode(saleOrderItemExtRespDto.getItemBackCategoryFourthCode());
            return orderItemReqDto;
        }).collect(Collectors.toList());
        sourceOrderResultReqDto.setOrderItemReqDtoList(orderItemReqDtoList);
        log.info("[\u7269\u6d41\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u7269\u6d41\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
        RestResponse sourceOrderResultRespDtoRestResp = this.orderOptApi.addSourceOrder(sourceOrderResultReqDto);
        SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)sourceOrderResultRespDtoRestResp);
        log.info("[\u7269\u6d41\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u7269\u6d41\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        return sourceOrderResultRespDto;
    }
}

