/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.guard.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.SourceOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.SourceRecordDto;
import com.yunxi.dg.base.center.trade.guard.IDgSourceGuard;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgSourceGuardImpl
implements IDgSourceGuard {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgSourceGuardImpl.class);
    @Resource
    private ISourceRecordDomain sourceRecordService;
    @Resource
    private ISourceOrderItemDomain sourceOrderItemService;

    @Override
    public Boolean checkSourceSuccess(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u5bfb\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordDto sourceRecordRespDto = this.sourceRecordService.querySourceRecordBySgOrderNo(sgOrderNo);
        if (sourceRecordRespDto != null && SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceRecordRespDto.getSgStatus())) {
            LOGGER.info("[\u5b88\u536b\u5224\u65ad\u662f\u5426\u5bfb\u6e90\u6210\u529f]\u5bfb\u6e90\u6210\u529f");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkSourcePartSuccess(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u5bfb\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordDto sourceRecordRespDto = this.sourceRecordService.querySourceRecordBySgOrderNo(sgOrderNo);
        List sourceOrderItemRespDtos = this.sourceOrderItemService.querySourceItemBySgOrderNo(sgOrderNo);
        if (sourceRecordRespDto != null && SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceRecordRespDto.getSgStatus()) && CollectionUtils.isNotEmpty((Collection)sourceOrderItemRespDtos)) {
            LOGGER.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u7ed3\u679c]\u90e8\u5206\u5bfb\u6e90\u6210\u529f");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkSourceAllFail(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u5bfb\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordDto sourceRecordRespDto = this.sourceRecordService.querySourceRecordBySgOrderNo(sgOrderNo);
        List sourceOrderItemRespDtos = this.sourceOrderItemService.querySourceItemBySgOrderNo(sgOrderNo);
        if (sourceRecordRespDto != null && SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceRecordRespDto.getSgStatus()) && sourceOrderItemRespDtos.size() == 0) {
            LOGGER.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u7ed3\u679c]\u6574\u5355\u5bfb\u6e90\u5931\u8d25");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkNeedSplitBySourceResult(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u5bfb\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordDto sourceRecordRespDto = this.sourceRecordService.querySourceRecordBySgOrderNo(sgOrderNo);
        LOGGER.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u662f\u5426\u9700\u8981\u62c6\u5355]\u5bfb\u6e90\u5355\u53f7\uff08{}\uff09,\u5bfb\u6e90\u7ed3\u679c\u4e3a\uff1a{}", (Object)sgOrderNo, (Object)JSON.toJSONString((Object)sourceRecordRespDto));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceRecordRespDto.getSgStatus())) {
            List orderItemResultRespDtoList = this.sourceOrderItemService.querySourceItemBySgOrderNo(sgOrderNo);
            AssertUtils.notEmpty((Collection)orderItemResultRespDtoList, (String)"\u5bfb\u6e90\u7ed3\u679c\u5b58\u5728\u5f02\u5e38");
            Map<String, List<SourceOrderItemDto>> orderItemResultMap = orderItemResultRespDtoList.stream().collect(Collectors.groupingBy(SourceOrderItemDto::getSgWarehouseCode));
            if (orderItemResultMap.size() > 1) {
                LOGGER.info("[\u5b88\u536b\u5224\u65ad\u5bfb\u6e90\u662f\u5426\u9700\u8981\u62c6\u5355]\u8ba2\u5355({})\u5bfb\u6e90\u7ed3\u679c\u6709\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u9700\u8981\u8fdb\u884c\u62c6\u5355\u5904\u7406", (Object)sourceRecordRespDto.getOrderNo());
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

