/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.StrategyOptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.StrategyOptLogRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyOptLogDomain;
import com.yunxi.dg.base.center.trade.eo.StrategyOptLogEo;
import com.yunxi.dg.base.center.trade.service.tc.IStrategyOptLogService;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StrategyOptLogServiceImpl
implements IStrategyOptLogService {
    @Resource
    private IDgStrategyOptLogDomain strategyOptLogDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addStrategyOptLog(StrategyOptLogReqDto addReqDto) {
        StrategyOptLogEo StrategyOptLogEo2 = new StrategyOptLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)StrategyOptLogEo2);
        if (StringUtils.isEmpty((CharSequence)StrategyOptLogEo2.getOptPerson())) {
            StrategyOptLogEo2.setOptPerson("system");
        }
        this.strategyOptLogDomain.insert((BaseEo)StrategyOptLogEo2);
        return StrategyOptLogEo2.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddOrderLogByOptResult(OrderOperationTypeEnum orderOperationTypeEnum, Long strategyId, List<String> optResultList) {
        ArrayList addList = Lists.newArrayList();
        for (String optResult : optResultList) {
            StrategyOptLogEo saleOrderOptLogEo = new StrategyOptLogEo();
            saleOrderOptLogEo.setStrategyId(strategyId);
            saleOrderOptLogEo.setOptTime(new Date());
            String optPerson = StringUtils.isNotBlank((CharSequence)ServiceContext.getContext().getRequestUserCode()) ? ServiceContext.getContext().getRequestUserCode() : "system";
            saleOrderOptLogEo.setOptPerson(optPerson);
            saleOrderOptLogEo.setOptType(orderOperationTypeEnum.getDesc());
            saleOrderOptLogEo.setOptContent(optResult);
            addList.add(saleOrderOptLogEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.strategyOptLogDomain.insertBatch((List)addList);
        }
    }

    @Override
    public void modifyStrategyOptLog(StrategyOptLogReqDto modifyReqDto) {
        StrategyOptLogEo StrategyOptLogEo2 = new StrategyOptLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)StrategyOptLogEo2);
        this.strategyOptLogDomain.updateSelective((BaseEo)StrategyOptLogEo2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyOptLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.strategyOptLogDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StrategyOptLogRespDto queryById(Long id) {
        StrategyOptLogEo StrategyOptLogEo2 = (StrategyOptLogEo)this.strategyOptLogDomain.selectByPrimaryKey(id);
        StrategyOptLogRespDto StrategyOptLogRespDto2 = new StrategyOptLogRespDto();
        DtoHelper.eo2Dto((BaseEo)StrategyOptLogEo2, (BaseVo)StrategyOptLogRespDto2);
        return StrategyOptLogRespDto2;
    }

    @Override
    public PageInfo<StrategyOptLogRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StrategyOptLogReqDto StrategyOptLogReqDto2 = (StrategyOptLogReqDto)JSON.parseObject((String)filter, StrategyOptLogReqDto.class);
        StrategyOptLogEo StrategyOptLogEo2 = new StrategyOptLogEo();
        DtoHelper.dto2Eo((BaseVo)StrategyOptLogReqDto2, (BaseEo)StrategyOptLogEo2);
        StrategyOptLogEo2.setOrderByDesc("id");
        PageInfo eoPageInfo = this.strategyOptLogDomain.selectPage((BaseEo)StrategyOptLogEo2, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StrategyOptLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

