/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.handler.impl;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBatchMergeOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.execute.DgB2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BSaleStatemachineHandle;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgB2BSaleStatemachineHandleImpl
implements IDgB2BSaleStatemachineHandle {
    @Resource
    private DgB2BOrderStatemachineExecutor dgB2BOrderStatemachineExecutor;

    private String chooseBizModel(String bizModel) {
        return DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode();
    }

    @Override
    public RestResponse<Long> createSaleOrder(String bizModel, DgBizPerformOrderReqDto addReqDto) {
        return Optional.ofNullable(this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), null, addReqDto, (Object)DgB2BOrderMachineEvents.CREATE_ORDER).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> auditPass(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.AUDIT_PASS);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> auditNoPass(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.AUDIT_NO_PASS);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> copyOrder(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.COPY_ORDER);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> checkOrder(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.CHECK_ORDER);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyAddress(String bizModel, Long orderId, DgPerformOrderAddrReqDto reqDto) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, reqDto, (Object)DgB2BOrderMachineEvents.MODIFY_ADDRESS);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrderRemark(String bizModel, Long saleOrderId, String remark) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, remark, (Object)DgB2BOrderMachineEvents.MODIFY_ORDER_REMARK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelOrder(String bizModel, Long orderId, String cancelReason) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, cancelReason, (Object)DgB2BOrderMachineEvents.CANCEL_ORDER);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> invalidOrder(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.INVALID_ORDER);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> resetOrder(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.RESET);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> statusLock(String bizModel, Long saleOrderId, String desc) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2BOrderMachineEvents.STATUS_LOCK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> statusUnLock(String bizModel, Long saleOrderId, String desc) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgB2BOrderMachineEvents.STATUS_UNLOCK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> addOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> addrReqDtos) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, addrReqDtos, (Object)DgB2BOrderMachineEvents.MANUAL_ADD_ORDER_TAG);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> removeReqDtos) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, removeReqDtos, (Object)DgB2BOrderMachineEvents.MANUAL_REMOVE_ORDER_TAG);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> splitOrder(String bizModel, Long orderId, DgSplitOrderReqDto reqDto) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, reqDto, (Object)DgB2BOrderMachineEvents.SPLIT_ORDER);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> splitOrderBySku(String bizModel, Long orderId, String splitSku) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, splitSku, (Object)DgB2BOrderMachineEvents.BATCH_SPLIT_ORDER);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> splitOrderByAppointBatch(String bizModel, Long orderId, DgSplitOrderReqDto reqDto) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, reqDto, (Object)DgB2BOrderMachineEvents.SPLIT_ORDER_BY_APPOINT_BATCH);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> arrangeWarehouse(String bizModel, Long saleOrderId, DgArrangeWarehouseReqDto reqDto) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, reqDto, (Object)DgB2BOrderMachineEvents.ARRANGE_WAREHOUSE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> manualPick(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.MANUAL_PICK).getLastActionResultSubRestResponse(Boolean.class)).orElse(new RestResponse());
    }

    @Override
    public RestResponse<Void> cancelPick(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.CANCEL_PICK).getLastActionResultSubRestResponse(Void.class)).orElse(new RestResponse());
    }

    @Override
    public RestResponse<Void> unlock(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.UNLOCK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> continueDeliver(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.RE_APPOINT);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelAppoint(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.CANCEL_APPOINT);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> confirmReceiptGoods(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.CONFIRM_RECEIVE_GOODS).getFirstActionResultSubRestResponse(Boolean.class)).orElse(new RestResponse());
    }

    @Override
    public RestResponse<Void> completed(String bizModel, Long orderId) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.COMPLETED);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> batchMerge(String bizModel, Long orderId, DgBatchMergeOrderReqDto reqDto) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.BATCH_MERGE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> outDeliveryResult(String bizModel, Long orderId, DgOutDeliveryResultReqDto resultReqDto) {
        this.dgB2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), orderId, null, (Object)DgB2BOrderMachineEvents.OUT_DELIVERY_RESULT);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> retryExecuteEvent(Long eventRecordId) throws Exception {
        return Optional.ofNullable(this.dgB2BOrderStatemachineExecutor.executeStatemachineByEventRecordId(eventRecordId).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }
}

