/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2b.order.scheduled;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.service.IDgAutoAuditOrderService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cis.statemachine.oms.b2b.auto.scheduled.enable"}, havingValue="true")
@Component
public class DgB2BAutoStrategyScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgB2BAutoStrategyScheduled.class);
    @Resource
    private IDgAutoAuditOrderService autoAuditOrderService;

    @Scheduled(cron="${scheduled.b2b.auto.audit:0 0/5 * * * ? }")
    public void autoB2BOrderAudit() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355\u81ea\u52a8\u7b56\u7565-\u81ea\u52a8\u6267\u884c\u4efb\u52a1!");
        try {
            this.autoAuditOrderService.scanOrderHitPoolTask(DgCisStrategyOrderTypeEnum.ORDER_REVIEW);
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355\u81ea\u52a8\u7b56\u7565-\u81ea\u52a8\u6267\u884c\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355\u81ea\u52a8\u7b56\u7565-\u81ea\u52a8\u6267\u884c\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.b2b.auto.check.pool:0 0/5 * * * ? }")
    public void autoB2BOrderCheck() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u786e\u8ba4\u7b56\u7565\u7f13\u51b2\u6c60\u4efb\u52a1");
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u786e\u8ba4\u7b56\u7565\u7f13\u51b2\u6c60\u5b9a\u65f6\u5668\u542f\u52a8");
        try {
            this.autoAuditOrderService.scanOrderHitPoolTask(DgCisStrategyOrderTypeEnum.ORDER_CONFIRM);
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u786e\u8ba4\u7b56\u7565\u7f13\u51b2\u6c60\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u786e\u8ba4\u7b56\u7565\u7f13\u51b2\u6c60\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.b2b.auto.pick.pool:0 0/5 * * * ? }")
    public void autoB2BOrderPick() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u7f13\u51b2\u6c60\u4efb\u52a1");
        try {
            this.autoAuditOrderService.scanOrderHitPoolTask(DgCisStrategyOrderTypeEnum.AUTOMATIC_ALLOCATION);
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.b2b.auto.receiveGoods.pool:0 0/5 * * * ? }")
    public void autoB2BOrderAppoint() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u4ed3\u5e93\u4e0b\u53d1\u7b56\u7565\u7f13\u51b2\u6c60\u4efb\u52a1");
        try {
            this.autoAuditOrderService.scanOrderHitPoolTask(DgCisStrategyOrderTypeEnum.AUTOMATIC_DELIVERY);
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u4ed3\u5e93\u4e0b\u53d1\u7b56\u7565\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]B2B\u8ba2\u5355-\u81ea\u52a8\u4ed3\u5e93\u4e0b\u53d1\u7b56\u7565\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }
}

