/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils.oss;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BizOssUtil {
    private static final Logger log = LoggerFactory.getLogger(BizOssUtil.class);
    @Value(value="${biz.oss.host.public:}")
    private String ossPublicHost;
    @Value(value="${biz.oss.host.internal:}")
    private String ossInternalHost;
    @Value(value="${huieryun.ossregistryvo.cdnHost:}")
    private String cdnHost;

    public OutputStream get(String fileUrl) {
        return this.getOutputStreamByUrl(fileUrl);
    }

    private OutputStream getOutputStreamByUrl(String fileUrl) {
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new BizException("\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        HttpURLConnection connection = null;
        try {
            URL url = new URL(fileUrl);
            connection = this.createHttpConnection(url, "GET", null);
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)connection.getInputStream(), (OutputStream)outputStream);
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            log.error("error get stream from url : ", (Throwable)e);
            throw new BizException(e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public InputStream getInStreamByUrl(String fileUrl) {
        byte[] bytes = this.getByteArrayByUrl(fileUrl);
        return new ByteArrayInputStream(bytes);
    }

    public byte[] getByteArrayByUrl(String fileUrl) {
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new BizException("\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        HttpURLConnection connection = null;
        try {
            URL endpointUrl = new URL(fileUrl);
            connection = this.createHttpConnection(endpointUrl, "GET", null);
            InputStream inputStream = connection.getInputStream();
            byte[] byteArray = new byte[connection.getContentLength()];
            IOUtils.readFully((InputStream)inputStream, (byte[])byteArray);
            byte[] byArray = byteArray;
            return byArray;
        }
        catch (Exception e) {
            log.error("error get stream from url : ", (Throwable)e);
            throw new BizException(e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public HttpURLConnection createHttpConnection(URL endpointUrl, String httpMethod, Map<String, String> headers) {
        try {
            HttpURLConnection connection = (HttpURLConnection)endpointUrl.openConnection();
            connection.setRequestMethod(httpMethod);
            if (headers != null) {
                for (String headerKey : headers.keySet()) {
                    connection.setRequestProperty(headerKey, headers.get(headerKey));
                }
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            log.error("error get stream from url : ", (Throwable)e);
            throw new RuntimeException("Cannot create connection. " + e.getMessage(), e);
        }
    }

    public String replaceHost(String fileUrl) {
        fileUrl = StringUtils.replace((String)fileUrl, (String)"https", (String)"http");
        return StringUtils.replace((String)fileUrl, (String)this.ossPublicHost, (String)this.ossInternalHost);
    }

    public String replaceCdnHost(String fileUrl) {
        if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
            return StringUtils.replace((String)fileUrl, (String)this.ossPublicHost, (String)this.cdnHost);
        }
        return fileUrl;
    }

    public String parseExtProperty(String key, Map<String, String> map) {
        String value = null;
        if (StringUtils.isNotBlank((CharSequence)key) && MapUtils.isNotEmpty(map)) {
            value = map.get(key);
        }
        return value;
    }
}

