/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.components.optlog.collect;

import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.commons.vo.DgMessageVo;
import com.yunxi.dg.base.components.optlog.core.callback.AbstractOperationChainCallBack;
import com.yunxi.dg.base.components.optlog.core.callback.OperationCallbackMapper;
import com.yunxi.dg.base.components.optlog.core.vo.OperationChainSimpleCallbackVo;
import com.yunxi.dg.base.components.optlog.domain.entity.IOptOperationLogDomain;
import com.yunxi.dg.base.components.optlog.dto.optlog.OptOperationLogDtoExtension;
import com.yunxi.dg.base.components.optlog.eo.OptOperationLogEo;
import com.yunxi.dg.base.framework.core.mq.producer.IDgCommonsMqService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultOptLogCollector
extends AbstractOperationChainCallBack {
    private static final Logger log = LoggerFactory.getLogger(DefaultOptLogCollector.class);
    @Value(value="${dg.components.settings.optlog.collector.type:}")
    private String collectorType;
    @Value(value="${dg.components.settings.optlog.collector.mq.topic:DG_OPT_LOG_TOPIC}")
    private String collectorMqTopic;
    @Value(value="${dg.components.settings.optlog.collector.mq.tag:DG_OPT_LOG_TAG}")
    private String collectorMqTag;
    @Resource
    private IOptOperationLogDomain<OptOperationLogEo> optOperationLogDomain;
    @Resource
    private IDgCommonsMqService dgCommonsMqService;

    public DefaultOptLogCollector(OperationCallbackMapper operationCallbackMapper) {
        super(operationCallbackMapper);
        log.info("DefaultOptLogCollector\u9ed8\u8ba4\u65e5\u5fd7\u56de\u8c03\u6536\u96c6\u5668\u52a0\u8f7d\u5b8c\u6210");
    }

    public void saveOperationChainSimpleCallbackVo(List<OperationChainSimpleCallbackVo> operationChainSimpleCallbackVoList) {
        if (StringUtils.isBlank((CharSequence)this.collectorType)) {
            this.optOperationLogDomain.insertBatch(this.exchangeOptOperationLogEo(operationChainSimpleCallbackVoList));
        } else if ("mq".equals(this.collectorType)) {
            DgMessageVo dgMessageVo = new DgMessageVo(operationChainSimpleCallbackVoList);
            this.dgCommonsMqService.sendSingleMessage(this.collectorMqTopic, this.collectorMqTag, dgMessageVo);
        }
    }

    private List<OptOperationLogEo> exchangeOptOperationLogEo(List<OperationChainSimpleCallbackVo> operationChainSimpleCallbackVoList) {
        return Optional.ofNullable(operationChainSimpleCallbackVoList).map(list -> list.stream().map(operationChainSimpleCallbackVo -> {
            OptOperationLogEo optOperationLogEo = new OptOperationLogEo();
            optOperationLogEo.setOptContent(operationChainSimpleCallbackVo.getOptContent());
            optOperationLogEo.setOptDetails(operationChainSimpleCallbackVo.getOptDetails());
            optOperationLogEo.setOptCorrelationId(operationChainSimpleCallbackVo.getOptCorrelationId());
            optOperationLogEo.setOptEntry(operationChainSimpleCallbackVo.getOptEntry());
            optOperationLogEo.setOptDetailsCode(operationChainSimpleCallbackVo.getOptDetailsCode());
            optOperationLogEo.setOptEntryCode(operationChainSimpleCallbackVo.getOptEntryCode());
            optOperationLogEo.setOptLinkCode(operationChainSimpleCallbackVo.getOptLinkCode());
            optOperationLogEo.setOptLinkType(operationChainSimpleCallbackVo.getOptLinkType());
            optOperationLogEo.setOptPerson(operationChainSimpleCallbackVo.getOptPerson());
            optOperationLogEo.setOptResult(operationChainSimpleCallbackVo.getOptResult());
            optOperationLogEo.setOptTime(operationChainSimpleCallbackVo.getOptTime());
            optOperationLogEo.setOptTraceId(operationChainSimpleCallbackVo.getOptTraceId());
            optOperationLogEo.setOptRequestId(operationChainSimpleCallbackVo.getOptRequestId());
            if (StringUtils.isNotBlank((CharSequence)operationChainSimpleCallbackVo.getOptMethodRunData())) {
                OptOperationLogDtoExtension optOperationLogDtoExtension = new OptOperationLogDtoExtension();
                optOperationLogDtoExtension.setOptMethodRunData(operationChainSimpleCallbackVo.getOptMethodRunData());
                optOperationLogEo.setExtension(JSON.toJSONString((Object)optOperationLogDtoExtension));
            }
            return optOperationLogEo;
        }).collect(Collectors.toList())).orElseGet(() -> null);
    }
}

