/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.components.optlog.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.MethodSaveAndRetryUtils;
import com.yunxi.dg.base.components.optlog.api.optlog.IDgOptLogQueryApi;
import com.yunxi.dg.base.components.optlog.core.around.OperationChainAround;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.components.optlog.core.vo.OperationTriggerVo;
import com.yunxi.dg.base.components.optlog.domain.entity.IOptOperationLogDomain;
import com.yunxi.dg.base.components.optlog.dto.optlog.MethodDefineDto;
import com.yunxi.dg.base.components.optlog.dto.optlog.OptOperationLogDto;
import com.yunxi.dg.base.components.optlog.dto.optlog.OptOperationLogDtoExtension;
import com.yunxi.dg.base.components.optlog.eo.OptOperationLogEo;
import io.swagger.annotations.Api;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u901a\u7528\u7ec4\u4ef6:\u8c03\u7528\u94fe\u64cd\u4f5c\u65e5\u5fd7\u63a5\u53e3\u670d\u52a1"})
public class DgOptLogController
implements IDgOptLogQueryApi {
    private static final Logger log = LoggerFactory.getLogger(DgOptLogController.class);
    @Resource
    private IOptOperationLogDomain<OptOperationLogEo> optOperationLogDomain;

    public RestResponse<PageInfo<OptOperationLogDto>> queryOptLogPage(String optLinkType, String optLinkCode, Integer pageSize, Integer pageNum) {
        return this.optOperationLogDomain.queryOptLogPage(optLinkType, optLinkCode, pageSize, pageNum);
    }

    public RestResponse<Object> retryOperationById(Long operationLogId) {
        OptOperationLogEo optOperationLogEo = (OptOperationLogEo)this.optOperationLogDomain.selectByPrimaryKey(operationLogId);
        if (StringUtils.isBlank((CharSequence)optOperationLogEo.getExtension())) {
            return new RestResponse("-1000", "\u64cd\u4f5c\u65e5\u5fd7\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a");
        }
        OptOperationLogDtoExtension operationLogDtoExtension = (OptOperationLogDtoExtension)JSONObject.parseObject((String)optOperationLogEo.getExtension(), OptOperationLogDtoExtension.class);
        if (StringUtils.isBlank((CharSequence)operationLogDtoExtension.getOptMethodRunData())) {
            return new RestResponse("-1000", "\u64cd\u4f5c\u65e5\u5fd7\u65b9\u6cd5\u8fd0\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        MethodDefineDto methodDefineDto = (MethodDefineDto)JSONObject.parseObject((String)operationLogDtoExtension.getOptMethodRunData(), MethodDefineDto.class);
        Object result = null;
        try {
            Class<?> beanClass = Class.forName(methodDefineDto.getDoMethodClassName());
            Object bean = SpringBeanUtil.getBean(beanClass);
            Method method = this.getBeanMethodByTransactionNode(beanClass, methodDefineDto.getMethodName(), bean);
            Object[] objects = MethodSaveAndRetryUtils.extractMethodParams4Json((String)JSON.toJSONString((Object)methodDefineDto.getDoMethodParams()), (Method)method);
            method.setAccessible(true);
            log.info("\u3010retryOperationById\u3011\u5f00\u59cb\u91cd\u8bd5\u6267\u884c\u65b9\u6cd5\uff1a" + beanClass + "." + method.getName());
            OptUtil.aroundOpt((OperationTriggerVo)OperationTriggerVo.builder().operationChainEntry("com.yunxi.dg.base.components.optlog.rest.DgOptLogController#retryOperationById").triggeredChainLinkCode(optOperationLogEo.getId().toString()).triggeredChainLinkType(optOperationLogEo.getId() + "_retryOperationById").triggeredEventCode(optOperationLogEo.getId().toString()).triggeredEvent("ID\u4e3a'" + optOperationLogEo.getId() + "'\u7684\u64cd\u4f5c\u8bb0\u5f55\u91cd\u8bd5").stepModel(OperationChainAround.STEP_MODEL_2).build(), () -> null);
            try {
                result = method.invoke(bean, objects);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            log.info("\u3010retryOperationById\u3011\u91cd\u8bd5\u6267\u884c\u65b9\u6cd5\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException("\u3010retryOperationById\u3011\u91cd\u8bd5\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        return new RestResponse(result);
    }

    private Method getBeanMethodByTransactionNode(Class<?> beanClass, String methodName, Object bean) {
        Method[] methods = beanClass.getDeclaredMethods();
        Method targetMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod == null) {
            throw new BusinessRuntimeException(beanClass.getName() + "\u83b7\u53d6\u4e0d\u5230\u65b9\u6cd5" + methodName + "(\u6682\u4e0d\u652f\u6301\u65b9\u6cd5\u91cd\u8f7d)\uff0c\u8bf7\u68c0\u67e5");
        }
        return targetMethod;
    }
}

