/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.components.optlog.core.starter;

import com.yunxi.dg.base.components.optlog.core.callback.DefaultOperationCallbackMapper;
import com.yunxi.dg.base.components.optlog.core.callback.OperationCallbackMapper;
import com.yunxi.dg.base.components.optlog.core.callback.change.OperationChainDataCallback;
import com.yunxi.dg.base.components.optlog.core.callback.change.OperationChangeInfoCallback;
import com.yunxi.dg.base.components.optlog.core.rpc.fegin.interceptor.OptLogFeignClientInterceptor;
import com.yunxi.dg.base.components.optlog.core.starter.OptLogWebMvcConfigurer;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties
public class OptLogAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OptLogAutoConfiguration.class);

    @Bean
    public OptLogWebMvcConfigurer optLogWebMvcConfigurer() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/swagger-resources/**");
        urls.add("/swagger-resources");
        urls.add("/webjars/springfox-swagger-ui/**");
        urls.add("/webjars/springfox-swagger-ui/*.*");
        urls.add("/swagger-ui.html");
        urls.add("/swagger-ui/*.*");
        urls.add("/v2/api-docs");
        urls.add("/favicon.ico");
        urls.add("/xapi.html");
        urls.add("/xapi/**");
        log.info("optLogWebMvcConfigurer\u8f7d\u5165");
        return new OptLogWebMvcConfigurer().setExcludePathPatterns(urls);
    }

    @Bean
    @ConditionalOnClass(value={RequestInterceptor.class})
    public OptLogFeignClientInterceptor optLogFeignClientInterceptor() {
        log.info("optLogFeignClientInterceptor\u8f7d\u5165");
        return new OptLogFeignClientInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={OperationCallbackMapper.class})
    public OperationCallbackMapper operationCallbackMapper(List<OperationChangeInfoCallback<?>> operationChangeInfoCallbackList, List<OperationChainDataCallback> operationChainDataCallbackList) {
        log.info("defaultOperationCallbackMapper\u8f7d\u5165");
        return new DefaultOperationCallbackMapper(operationChangeInfoCallbackList, operationChainDataCallbackList);
    }
}

