/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.core.support;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import icu.mhb.mybatisplus.plugln.annotations.TableAlias;
import icu.mhb.mybatisplus.plugln.entity.As;
import icu.mhb.mybatisplus.plugln.entity.ColumnsBuilder;
import icu.mhb.mybatisplus.plugln.enums.SqlExcerpt;
import icu.mhb.mybatisplus.plugln.tookit.ClassUtils;
import icu.mhb.mybatisplus.plugln.tookit.TableAliasCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;

public abstract class SupportJoinLambdaWrapper<T, Children extends SupportJoinLambdaWrapper<T, Children>>
extends AbstractWrapper<T, SFunction<T, ?>, Children> {
    protected SharedString sqlSelect = SharedString.emptyString();
    private Map<Class<?>, Map<String, ColumnCache>> columnMap = new HashMap();
    private boolean initColumnMap = false;

    protected String columnsToString(SFunction<T, ?> ... columns) {
        return this.columnsToString(true, columns);
    }

    protected String columnsToString(boolean onlyColumn, SFunction<T, ?> ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString((SFunction<T, ?>)i, onlyColumn)).collect(Collectors.joining(","));
    }

    protected String columnToString(SFunction<T, ?> column) {
        return this.columnToString(column, true);
    }

    protected String columnToString(SFunction<T, ?> column, boolean onlyColumn) {
        String columnToString = this.getColumn(LambdaUtils.resolve(column), onlyColumn);
        if (StringUtils.isNotBlank((CharSequence)columnToString)) {
            return this.getAliasAndField(columnToString);
        }
        return columnToString;
    }

    public final Children selectAll() {
        Class<?> clz = this.getEntityOrMasterClass();
        Assert.notNull(clz, (String)"Can't get the current parser class", (Object[])new Object[0]);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clz);
        String keySqlSelect = tableInfo.getKeySqlSelect();
        String sqlSelect = tableInfo.getFieldList().stream().filter(TableFieldInfo::isSelect).map(TableFieldInfo::getSqlSelect).map(this::getAliasAndField).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)keySqlSelect)) {
            sqlSelect = sqlSelect + "," + this.getAliasAndField(keySqlSelect);
        }
        this.sqlSelect.setStringValue(sqlSelect);
        return (Children)((Object)((SupportJoinLambdaWrapper)this.typedThis));
    }

    public final Children selectAll(Collection<SFunction<T, ?>> excludeColumn) {
        Class<?> clz = this.getEntityOrMasterClass();
        Assert.notNull(clz, (String)"Can't get the current parser class", (Object[])new Object[0]);
        List excludeList = excludeColumn.stream().map(i -> this.columnToString((SFunction<T, ?>)i, true)).collect(Collectors.toList());
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clz);
        String sqlSelect = tableInfo.getFieldList().stream().filter(TableFieldInfo::isSelect).map(TableFieldInfo::getSqlSelect).map(this::getAliasAndField).filter(str -> !excludeList.contains(str)).collect(Collectors.joining(","));
        this.sqlSelect.setStringValue(sqlSelect);
        return (Children)((Object)((SupportJoinLambdaWrapper)this.typedThis));
    }

    protected String getAlias(Class<?> clz) {
        if (clz == null) {
            clz = this.getEntityOrMasterClass();
        }
        Assert.notNull(clz, (String)"Can't get the current parser class", (Object[])new Object[0]);
        Class<?> finalClz = clz = this.getTableClass(clz);
        return TableAliasCache.getOrSet(clz, key -> {
            String alias;
            TableAlias tableAlias = finalClz.getAnnotation(TableAlias.class);
            if (tableAlias == null) {
                TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)finalClz);
                alias = tableInfo.getTableName();
            } else {
                alias = tableAlias.value();
            }
            return alias;
        });
    }

    protected String getAlias() {
        return this.getAlias(null);
    }

    protected String getAliasAndField(String fieldName) {
        String alias = this.getAlias();
        return alias + "." + fieldName;
    }

    public final Children selectAs(Consumer<ColumnsBuilder<T>> consumer) {
        ColumnsBuilder columnsBuilder = new ColumnsBuilder();
        consumer.accept(columnsBuilder);
        this.selectAs(columnsBuilder.getColumnsBuilderList());
        return (Children)((Object)((SupportJoinLambdaWrapper)this.typedThis));
    }

    public final Children selectAs(List<As<T>> columns) {
        if (CollectionUtils.isNotEmpty(columns)) {
            ArrayList<String> columnsStringList = new ArrayList<String>();
            for (As<T> as : columns) {
                String column = as.getColumnStr().toString();
                column = as.getColumn() != null ? this.columnToString(as.getColumn()) : StringUtils.quotaMark((Object)column);
                if (StringUtils.isNotBlank((CharSequence)as.getAlias())) {
                    column = String.format(SqlExcerpt.AS.getSql(), column, as.getAlias());
                }
                columnsStringList.add(column);
            }
            this.sqlSelect.setStringValue(String.join((CharSequence)",", columnsStringList));
        }
        return (Children)((Object)((SupportJoinLambdaWrapper)this.typedThis));
    }

    public final Children selectAs(SFunction<T, ?> column, String alias) {
        return this.selectAs(Collections.singletonList(new As<T>(column, alias)));
    }

    protected String getColumn(SerializedLambda lambda, boolean onlyColumn) throws MybatisPlusException {
        String fieldName = PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
        Class<?> aClass = this.getTableClass(lambda.getInstantiatedType());
        this.columnMap.computeIfAbsent(aClass, key -> LambdaUtils.getColumnMap((Class)aClass));
        Assert.notNull(this.columnMap.get(aClass), (String)"can not find lambda cache for this entity [%s]", (Object[])new Object[]{aClass.getName()});
        ColumnCache columnCache = this.columnMap.get(aClass).get(LambdaUtils.formatKey((String)fieldName));
        Assert.notNull((Object)columnCache, (String)"can not find lambda cache for this property [%s] of entity [%s]", (Object[])new Object[]{fieldName, aClass.getName()});
        return onlyColumn ? columnCache.getColumn() : columnCache.getColumnSelect();
    }

    protected Class<?> getTableClass(Class<?> clz) {
        return ClassUtils.getTableClass(clz);
    }

    protected Class<?> getEntityOrMasterClass() {
        Class aClass = this.getEntityClass();
        if (null != aClass) {
            return this.getTableClass(aClass);
        }
        return null;
    }

    protected void initNeed() {
        super.initNeed();
        Class<?> entityClass = this.getEntityOrMasterClass();
        if (entityClass != null) {
            this.columnMap.put(entityClass, LambdaUtils.getColumnMap(entityClass));
            this.initColumnMap = true;
        }
    }
}

