/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.runtime.BaseDomainAbility;
import io.github.dddplus.runtime.registry.InternalIndexer;
import io.github.dddplus.runtime.registry.StepDef;
import io.github.dddplus.step.IDomainStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;

public final class DDD {
    private DDD() {
    }

    @NotNull
    public static <T extends BaseDomainAbility> T findAbility(@NotNull Class<? extends T> domainAbilityClazz) {
        return InternalIndexer.findDomainAbility(domainAbilityClazz);
    }

    @NotNull
    public static <Step extends IDomainStep> List<Step> findSteps(@NotNull String activityCode, @NotNull List<String> stepCodeList) {
        List<StepDef> stepDefs = InternalIndexer.findDomainSteps(activityCode, stepCodeList);
        ArrayList<IDomainStep> result = new ArrayList<IDomainStep>(stepDefs.size());
        for (StepDef stepDef : stepDefs) {
            result.add(stepDef.getStepBean());
        }
        return result;
    }

    public static <Step extends IDomainStep> Step getStep(@NotNull String activityCode, @NotNull String stepCode) {
        List<Step> steps = DDD.findSteps(activityCode, Arrays.asList(stepCode));
        if (steps.size() == 1) {
            return (Step)((IDomainStep)steps.get(0));
        }
        return null;
    }
}

