/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.model.IDomainModel;
import io.github.dddplus.runtime.DDD;
import io.github.dddplus.step.IDomainStep;
import io.github.dddplus.step.IReviseStepsException;
import io.github.dddplus.step.IRevokableDomainStep;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

public abstract class StepsExecTemplate<Step extends IDomainStep, Model extends IDomainModel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StepsExecTemplate.class);
    private static final List<String> emptyRevisedSteps = Collections.emptyList();
    private static final int MAX_STEP_REVISIONS = 100;

    protected void beforeStep(Step step, Model model) {
    }

    protected void afterStep(Step step, Model model) {
    }

    public final void execute(String activityCode, List<String> stepCodes, Model model) {
        if (stepCodes == null || stepCodes.isEmpty()) {
            log.warn("Empty steps of activity:{} on {}", (Object)activityCode, model);
            return;
        }
        Stack<IRevokableDomainStep> executedSteps = new Stack<IRevokableDomainStep>();
        int stepRevisions = 0;
        while (++stepRevisions < 100 && !(stepCodes = this.executeSteps(activityCode, stepCodes, executedSteps, model)).isEmpty()) {
            log.info("revised steps:{}", stepCodes);
        }
        if (stepRevisions == 100) {
            log.error("Steps revision seem to encounter dead loop, abort after {} model:{}", (Object)stepRevisions, model);
            throw new RuntimeException("Seems steps dead loop, abort after 100");
        }
    }

    private List<String> executeSteps(String activityCode, List<String> stepCodes, Stack<IRevokableDomainStep> executedSteps, Model model) {
        List<IDomainStep> steps = DDD.findSteps(activityCode, stepCodes);
        try {
            for (IDomainStep step : steps) {
                this.beforeStep(step, model);
                step.execute(model);
                this.afterStep(step, model);
                if (!(step instanceof IRevokableDomainStep)) continue;
                executedSteps.push((IRevokableDomainStep)step);
            }
        }
        catch (Exception cause) {
            if (cause instanceof IReviseStepsException) {
                return ((IReviseStepsException)cause).subsequentSteps();
            }
            if (!executedSteps.empty() && cause instanceof RuntimeException) {
                if (cause.getClass() == this.getStepExType()) {
                    this.rollbackExecutedSteps(model, (RuntimeException)cause, executedSteps);
                } else {
                    log.debug("will not rollback, {} thrown", (Object)cause.getClass().getCanonicalName());
                }
            }
            throw cause;
        }
        return emptyRevisedSteps;
    }

    private Class getStepExType() {
        ResolvableType stepsExecType = ResolvableType.forClass(this.getClass());
        ResolvableType templateType = stepsExecType.getSuperType();
        while (templateType.getGenerics().length == 0) {
            templateType = templateType.getSuperType();
        }
        ResolvableType stepType = templateType.getGeneric(new int[]{0});
        for (ResolvableType stepInterfaceType : stepType.getInterfaces()) {
            if (!IDomainStep.class.isAssignableFrom(stepInterfaceType.resolve())) continue;
            return stepInterfaceType.getGeneric(new int[]{1}).resolve();
        }
        log.error("Cannot tell Step.Ex type for {}", this.getClass());
        return null;
    }

    private void rollbackExecutedSteps(Model model, RuntimeException cause, Stack<IRevokableDomainStep> executedSteps) {
        while (!executedSteps.isEmpty()) {
            IRevokableDomainStep executedStep = executedSteps.pop();
            try {
                executedStep.rollback(model, cause);
            }
            catch (Throwable ignored) {
                log.error("step:{} rollback err ignored, model:{}", new Object[]{executedStep.stepCode(), model, ignored});
            }
        }
    }
}

