/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.runtime.registry.BootstrapException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;

final class CoreAopUtils {
    private CoreAopUtils() {
    }

    static <T extends Annotation> T getAnnotation(Object bean, Class<T> annotationClazz) {
        T annotation = bean.getClass().getAnnotation(annotationClazz);
        if (annotation == null && AopUtils.isAopProxy((Object)bean)) {
            Class clz = AopUtils.getTargetClass((Object)bean);
            annotation = clz.getAnnotation(annotationClazz);
        }
        return annotation;
    }

    static Type getGenericSuperclass(Object bean) {
        Type type = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean).getGenericSuperclass() : bean.getClass().getGenericSuperclass();
        return type;
    }

    static Object getTarget(Object bean) throws BootstrapException {
        if (!AopUtils.isAopProxy((Object)bean)) {
            return bean;
        }
        if (AopUtils.isCglibProxy((Object)bean)) {
            try {
                Field h = bean.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                h.setAccessible(true);
                Object dynamicAdvisedInterceptor = h.get(bean);
                Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
                advised.setAccessible(true);
                return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw BootstrapException.ofMessage(e.getMessage());
            }
        }
        throw BootstrapException.ofMessage("Unable to handle the AOP proxy!");
    }
}

